/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.SubstanceIngredient;
import org.hl7.fhir.SubstanceInstance;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Substance", propOrder={"type", "description", "instance", "ingredient"})
public class Substance
extends DomainResource
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected CodeableConcept type;
    protected String description;
    protected SubstanceInstance instance;
    protected List<SubstanceIngredient> ingredient;

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public SubstanceInstance getInstance() {
        return this.instance;
    }

    public void setInstance(SubstanceInstance value) {
        this.instance = value;
    }

    public List<SubstanceIngredient> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<SubstanceIngredient>();
        }
        return this.ingredient;
    }

    public Substance withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Substance withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public Substance withInstance(SubstanceInstance value) {
        this.setInstance(value);
        return this;
    }

    public Substance withIngredient(SubstanceIngredient ... values) {
        if (values != null) {
            for (SubstanceIngredient value : values) {
                this.getIngredient().add(value);
            }
        }
        return this;
    }

    public Substance withIngredient(Collection<SubstanceIngredient> values) {
        if (values != null) {
            this.getIngredient().addAll(values);
        }
        return this;
    }

    @Override
    public Substance withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Substance withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Substance withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Substance withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Substance withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Substance withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Substance withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Substance withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Substance withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Substance withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Substance withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<SubstanceIngredient> rhsIngredient;
        if (!(object instanceof Substance)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Substance that = (Substance)object;
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription)) {
            return false;
        }
        SubstanceInstance lhsInstance = this.getInstance();
        SubstanceInstance rhsInstance = that.getInstance();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"instance", (Object)lhsInstance), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"instance", (Object)rhsInstance), (Object)lhsInstance, (Object)rhsInstance)) {
            return false;
        }
        List<SubstanceIngredient> lhsIngredient = this.ingredient != null && !this.ingredient.isEmpty() ? this.getIngredient() : null;
        List<SubstanceIngredient> list = rhsIngredient = that.ingredient != null && !that.ingredient.isEmpty() ? that.getIngredient() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"ingredient", lhsIngredient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"ingredient", rhsIngredient), lhsIngredient, rhsIngredient);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription);
        SubstanceInstance theInstance = this.getInstance();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"instance", (Object)theInstance), currentHashCode, (Object)theInstance);
        List<SubstanceIngredient> theIngredient = this.ingredient != null && !this.ingredient.isEmpty() ? this.getIngredient() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"ingredient", theIngredient), currentHashCode, theIngredient);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription);
        SubstanceInstance theInstance = this.getInstance();
        strategy.appendField(locator, (Object)this, "instance", buffer, (Object)theInstance);
        List<SubstanceIngredient> theIngredient = this.ingredient != null && !this.ingredient.isEmpty() ? this.getIngredient() : null;
        strategy.appendField(locator, (Object)this, "ingredient", buffer, theIngredient);
        return buffer;
    }
}

