/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SupplyDispense;
import org.hl7.fhir.SupplyStatus;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Supply", propOrder={"kind", "identifier", "status", "orderedItem", "patient", "dispense"})
public class Supply
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected CodeableConcept kind;
    protected Identifier identifier;
    protected SupplyStatus status;
    protected Reference orderedItem;
    protected Reference patient;
    protected List<SupplyDispense> dispense;

    public CodeableConcept getKind() {
        return this.kind;
    }

    public void setKind(CodeableConcept value) {
        this.kind = value;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public SupplyStatus getStatus() {
        return this.status;
    }

    public void setStatus(SupplyStatus value) {
        this.status = value;
    }

    public Reference getOrderedItem() {
        return this.orderedItem;
    }

    public void setOrderedItem(Reference value) {
        this.orderedItem = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public List<SupplyDispense> getDispense() {
        if (this.dispense == null) {
            this.dispense = new ArrayList<SupplyDispense>();
        }
        return this.dispense;
    }

    public Supply withKind(CodeableConcept value) {
        this.setKind(value);
        return this;
    }

    public Supply withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public Supply withStatus(SupplyStatus value) {
        this.setStatus(value);
        return this;
    }

    public Supply withOrderedItem(Reference value) {
        this.setOrderedItem(value);
        return this;
    }

    public Supply withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public Supply withDispense(SupplyDispense ... values) {
        if (values != null) {
            for (SupplyDispense value : values) {
                this.getDispense().add(value);
            }
        }
        return this;
    }

    public Supply withDispense(Collection<SupplyDispense> values) {
        if (values != null) {
            this.getDispense().addAll(values);
        }
        return this;
    }

    @Override
    public Supply withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Supply withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Supply withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Supply withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Supply withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Supply withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Supply withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Supply withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Supply withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Supply withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Supply withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<SupplyDispense> rhsDispense;
        if (!(object instanceof Supply)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Supply that = (Supply)object;
        CodeableConcept lhsKind = this.getKind();
        CodeableConcept rhsKind = that.getKind();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"kind", (Object)lhsKind), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"kind", (Object)rhsKind), (Object)lhsKind, (Object)rhsKind)) {
            return false;
        }
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        SupplyStatus lhsStatus = this.getStatus();
        SupplyStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        Reference lhsOrderedItem = this.getOrderedItem();
        Reference rhsOrderedItem = that.getOrderedItem();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"orderedItem", (Object)lhsOrderedItem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"orderedItem", (Object)rhsOrderedItem), (Object)lhsOrderedItem, (Object)rhsOrderedItem)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        List<SupplyDispense> lhsDispense = this.dispense != null && !this.dispense.isEmpty() ? this.getDispense() : null;
        List<SupplyDispense> list = rhsDispense = that.dispense != null && !that.dispense.isEmpty() ? that.getDispense() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dispense", lhsDispense), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dispense", rhsDispense), lhsDispense, rhsDispense);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theKind = this.getKind();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"kind", (Object)theKind), currentHashCode, (Object)theKind);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        SupplyStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        Reference theOrderedItem = this.getOrderedItem();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"orderedItem", (Object)theOrderedItem), currentHashCode, (Object)theOrderedItem);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        List<SupplyDispense> theDispense = this.dispense != null && !this.dispense.isEmpty() ? this.getDispense() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dispense", theDispense), currentHashCode, theDispense);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theKind = this.getKind();
        strategy.appendField(locator, (Object)this, "kind", buffer, (Object)theKind);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        SupplyStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        Reference theOrderedItem = this.getOrderedItem();
        strategy.appendField(locator, (Object)this, "orderedItem", buffer, (Object)theOrderedItem);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        List<SupplyDispense> theDispense = this.dispense != null && !this.dispense.isEmpty() ? this.getDispense() : null;
        strategy.appendField(locator, (Object)this, "dispense", buffer, theDispense);
        return buffer;
    }
}

