/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Period;
import org.hl7.fhir.Quantity;
import org.hl7.fhir.Reference;
import org.hl7.fhir.SupplyDispenseStatus;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Supply.Dispense", propOrder={"identifier", "status", "type", "quantity", "suppliedItem", "supplier", "whenPrepared", "whenHandedOver", "destination", "receiver"})
public class SupplyDispense
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected Identifier identifier;
    protected SupplyDispenseStatus status;
    protected CodeableConcept type;
    protected Quantity quantity;
    protected Reference suppliedItem;
    protected Reference supplier;
    protected Period whenPrepared;
    protected DateTime whenHandedOver;
    protected Reference destination;
    protected List<Reference> receiver;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public SupplyDispenseStatus getStatus() {
        return this.status;
    }

    public void setStatus(SupplyDispenseStatus value) {
        this.status = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Quantity value) {
        this.quantity = value;
    }

    public Reference getSuppliedItem() {
        return this.suppliedItem;
    }

    public void setSuppliedItem(Reference value) {
        this.suppliedItem = value;
    }

    public Reference getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Reference value) {
        this.supplier = value;
    }

    public Period getWhenPrepared() {
        return this.whenPrepared;
    }

    public void setWhenPrepared(Period value) {
        this.whenPrepared = value;
    }

    public DateTime getWhenHandedOver() {
        return this.whenHandedOver;
    }

    public void setWhenHandedOver(DateTime value) {
        this.whenHandedOver = value;
    }

    public Reference getDestination() {
        return this.destination;
    }

    public void setDestination(Reference value) {
        this.destination = value;
    }

    public List<Reference> getReceiver() {
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        return this.receiver;
    }

    public SupplyDispense withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public SupplyDispense withStatus(SupplyDispenseStatus value) {
        this.setStatus(value);
        return this;
    }

    public SupplyDispense withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public SupplyDispense withQuantity(Quantity value) {
        this.setQuantity(value);
        return this;
    }

    public SupplyDispense withSuppliedItem(Reference value) {
        this.setSuppliedItem(value);
        return this;
    }

    public SupplyDispense withSupplier(Reference value) {
        this.setSupplier(value);
        return this;
    }

    public SupplyDispense withWhenPrepared(Period value) {
        this.setWhenPrepared(value);
        return this;
    }

    public SupplyDispense withWhenHandedOver(DateTime value) {
        this.setWhenHandedOver(value);
        return this;
    }

    public SupplyDispense withDestination(Reference value) {
        this.setDestination(value);
        return this;
    }

    public SupplyDispense withReceiver(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getReceiver().add(value);
            }
        }
        return this;
    }

    public SupplyDispense withReceiver(Collection<Reference> values) {
        if (values != null) {
            this.getReceiver().addAll(values);
        }
        return this;
    }

    @Override
    public SupplyDispense withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public SupplyDispense withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public SupplyDispense withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public SupplyDispense withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public SupplyDispense withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsReceiver;
        if (!(object instanceof SupplyDispense)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        SupplyDispense that = (SupplyDispense)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        SupplyDispenseStatus lhsStatus = this.getStatus();
        SupplyDispenseStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        Quantity lhsQuantity = this.getQuantity();
        Quantity rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"quantity", (Object)lhsQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"quantity", (Object)rhsQuantity), (Object)lhsQuantity, (Object)rhsQuantity)) {
            return false;
        }
        Reference lhsSuppliedItem = this.getSuppliedItem();
        Reference rhsSuppliedItem = that.getSuppliedItem();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"suppliedItem", (Object)lhsSuppliedItem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"suppliedItem", (Object)rhsSuppliedItem), (Object)lhsSuppliedItem, (Object)rhsSuppliedItem)) {
            return false;
        }
        Reference lhsSupplier = this.getSupplier();
        Reference rhsSupplier = that.getSupplier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"supplier", (Object)lhsSupplier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"supplier", (Object)rhsSupplier), (Object)lhsSupplier, (Object)rhsSupplier)) {
            return false;
        }
        Period lhsWhenPrepared = this.getWhenPrepared();
        Period rhsWhenPrepared = that.getWhenPrepared();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"whenPrepared", (Object)lhsWhenPrepared), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"whenPrepared", (Object)rhsWhenPrepared), (Object)lhsWhenPrepared, (Object)rhsWhenPrepared)) {
            return false;
        }
        DateTime lhsWhenHandedOver = this.getWhenHandedOver();
        DateTime rhsWhenHandedOver = that.getWhenHandedOver();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"whenHandedOver", (Object)lhsWhenHandedOver), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"whenHandedOver", (Object)rhsWhenHandedOver), (Object)lhsWhenHandedOver, (Object)rhsWhenHandedOver)) {
            return false;
        }
        Reference lhsDestination = this.getDestination();
        Reference rhsDestination = that.getDestination();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"destination", (Object)lhsDestination), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"destination", (Object)rhsDestination), (Object)lhsDestination, (Object)rhsDestination)) {
            return false;
        }
        List<Reference> lhsReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        List<Reference> list = rhsReceiver = that.receiver != null && !that.receiver.isEmpty() ? that.getReceiver() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"receiver", lhsReceiver), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"receiver", rhsReceiver), lhsReceiver, rhsReceiver);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        SupplyDispenseStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"type", (Object)theType), currentHashCode, (Object)theType);
        Quantity theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"quantity", (Object)theQuantity), currentHashCode, (Object)theQuantity);
        Reference theSuppliedItem = this.getSuppliedItem();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"suppliedItem", (Object)theSuppliedItem), currentHashCode, (Object)theSuppliedItem);
        Reference theSupplier = this.getSupplier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"supplier", (Object)theSupplier), currentHashCode, (Object)theSupplier);
        Period theWhenPrepared = this.getWhenPrepared();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"whenPrepared", (Object)theWhenPrepared), currentHashCode, (Object)theWhenPrepared);
        DateTime theWhenHandedOver = this.getWhenHandedOver();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"whenHandedOver", (Object)theWhenHandedOver), currentHashCode, (Object)theWhenHandedOver);
        Reference theDestination = this.getDestination();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"destination", (Object)theDestination), currentHashCode, (Object)theDestination);
        List<Reference> theReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"receiver", theReceiver), currentHashCode, theReceiver);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        SupplyDispenseStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        Quantity theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, (Object)theQuantity);
        Reference theSuppliedItem = this.getSuppliedItem();
        strategy.appendField(locator, (Object)this, "suppliedItem", buffer, (Object)theSuppliedItem);
        Reference theSupplier = this.getSupplier();
        strategy.appendField(locator, (Object)this, "supplier", buffer, (Object)theSupplier);
        Period theWhenPrepared = this.getWhenPrepared();
        strategy.appendField(locator, (Object)this, "whenPrepared", buffer, (Object)theWhenPrepared);
        DateTime theWhenHandedOver = this.getWhenHandedOver();
        strategy.appendField(locator, (Object)this, "whenHandedOver", buffer, (Object)theWhenHandedOver);
        Reference theDestination = this.getDestination();
        strategy.appendField(locator, (Object)this, "destination", buffer, (Object)theDestination);
        List<Reference> theReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        strategy.appendField(locator, (Object)this, "receiver", buffer, theReceiver);
        return buffer;
    }
}

