/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Extension;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.hl7.fhir.ValueSetConcept;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ValueSet.Define", propOrder={"system", "version", "caseSensitive", "concept"})
public class ValueSetDefine
extends BackboneElement
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected Uri system;
    protected String version;
    protected Boolean caseSensitive;
    protected List<ValueSetConcept> concept;

    public Uri getSystem() {
        return this.system;
    }

    public void setSystem(Uri value) {
        this.system = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(Boolean value) {
        this.caseSensitive = value;
    }

    public List<ValueSetConcept> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<ValueSetConcept>();
        }
        return this.concept;
    }

    public ValueSetDefine withSystem(Uri value) {
        this.setSystem(value);
        return this;
    }

    public ValueSetDefine withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public ValueSetDefine withCaseSensitive(Boolean value) {
        this.setCaseSensitive(value);
        return this;
    }

    public ValueSetDefine withConcept(ValueSetConcept ... values) {
        if (values != null) {
            for (ValueSetConcept value : values) {
                this.getConcept().add(value);
            }
        }
        return this;
    }

    public ValueSetDefine withConcept(Collection<ValueSetConcept> values) {
        if (values != null) {
            this.getConcept().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetDefine withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ValueSetDefine withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetDefine withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ValueSetDefine withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetDefine withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ValueSetConcept> rhsConcept;
        if (!(object instanceof ValueSetDefine)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ValueSetDefine that = (ValueSetDefine)object;
        Uri lhsSystem = this.getSystem();
        Uri rhsSystem = that.getSystem();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"system", (Object)lhsSystem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"system", (Object)rhsSystem), (Object)lhsSystem, (Object)rhsSystem)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion)) {
            return false;
        }
        Boolean lhsCaseSensitive = this.getCaseSensitive();
        Boolean rhsCaseSensitive = that.getCaseSensitive();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"caseSensitive", (Object)lhsCaseSensitive), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"caseSensitive", (Object)rhsCaseSensitive), (Object)lhsCaseSensitive, (Object)rhsCaseSensitive)) {
            return false;
        }
        List<ValueSetConcept> lhsConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        List<ValueSetConcept> list = rhsConcept = that.concept != null && !that.concept.isEmpty() ? that.getConcept() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"concept", lhsConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"concept", rhsConcept), lhsConcept, rhsConcept);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theSystem = this.getSystem();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"system", (Object)theSystem), currentHashCode, (Object)theSystem);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"version", (Object)theVersion), currentHashCode, (Object)theVersion);
        Boolean theCaseSensitive = this.getCaseSensitive();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"caseSensitive", (Object)theCaseSensitive), currentHashCode, (Object)theCaseSensitive);
        List<ValueSetConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"concept", theConcept), currentHashCode, theConcept);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theSystem = this.getSystem();
        strategy.appendField(locator, (Object)this, "system", buffer, (Object)theSystem);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion);
        Boolean theCaseSensitive = this.getCaseSensitive();
        strategy.appendField(locator, (Object)this, "caseSensitive", buffer, (Object)theCaseSensitive);
        List<ValueSetConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        strategy.appendField(locator, (Object)this, "concept", buffer, theConcept);
        return buffer;
    }
}

