/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DocumentReferenceRelated;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DocumentReference.Context", propOrder={"encounter", "event", "period", "facilityType", "practiceSetting", "sourcePatientInfo", "related"})
public class DocumentReferenceContext
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected Reference encounter;
    protected List<CodeableConcept> event;
    protected Period period;
    protected CodeableConcept facilityType;
    protected CodeableConcept practiceSetting;
    protected Reference sourcePatientInfo;
    protected List<DocumentReferenceRelated> related;

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public List<CodeableConcept> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<CodeableConcept>();
        }
        return this.event;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public CodeableConcept getFacilityType() {
        return this.facilityType;
    }

    public void setFacilityType(CodeableConcept value) {
        this.facilityType = value;
    }

    public CodeableConcept getPracticeSetting() {
        return this.practiceSetting;
    }

    public void setPracticeSetting(CodeableConcept value) {
        this.practiceSetting = value;
    }

    public Reference getSourcePatientInfo() {
        return this.sourcePatientInfo;
    }

    public void setSourcePatientInfo(Reference value) {
        this.sourcePatientInfo = value;
    }

    public List<DocumentReferenceRelated> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<DocumentReferenceRelated>();
        }
        return this.related;
    }

    public DocumentReferenceContext withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public DocumentReferenceContext withEvent(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getEvent().add(value);
            }
        }
        return this;
    }

    public DocumentReferenceContext withEvent(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getEvent().addAll(values);
        }
        return this;
    }

    public DocumentReferenceContext withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    public DocumentReferenceContext withFacilityType(CodeableConcept value) {
        this.setFacilityType(value);
        return this;
    }

    public DocumentReferenceContext withPracticeSetting(CodeableConcept value) {
        this.setPracticeSetting(value);
        return this;
    }

    public DocumentReferenceContext withSourcePatientInfo(Reference value) {
        this.setSourcePatientInfo(value);
        return this;
    }

    public DocumentReferenceContext withRelated(DocumentReferenceRelated ... values) {
        if (values != null) {
            for (DocumentReferenceRelated value : values) {
                this.getRelated().add(value);
            }
        }
        return this;
    }

    public DocumentReferenceContext withRelated(Collection<DocumentReferenceRelated> values) {
        if (values != null) {
            this.getRelated().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentReferenceContext withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DocumentReferenceContext withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentReferenceContext withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DocumentReferenceContext withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentReferenceContext withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<DocumentReferenceRelated> rhsRelated;
        List<CodeableConcept> rhsEvent;
        if (!(object instanceof DocumentReferenceContext)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DocumentReferenceContext that = (DocumentReferenceContext)object;
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        List<CodeableConcept> lhsEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        List<CodeableConcept> list = rhsEvent = that.event != null && !that.event.isEmpty() ? that.getEvent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"event", lhsEvent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"event", rhsEvent), lhsEvent, rhsEvent)) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"period", (Object)lhsPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"period", (Object)rhsPeriod), (Object)lhsPeriod, (Object)rhsPeriod)) {
            return false;
        }
        CodeableConcept lhsFacilityType = this.getFacilityType();
        CodeableConcept rhsFacilityType = that.getFacilityType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"facilityType", (Object)lhsFacilityType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"facilityType", (Object)rhsFacilityType), (Object)lhsFacilityType, (Object)rhsFacilityType)) {
            return false;
        }
        CodeableConcept lhsPracticeSetting = this.getPracticeSetting();
        CodeableConcept rhsPracticeSetting = that.getPracticeSetting();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"practiceSetting", (Object)lhsPracticeSetting), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"practiceSetting", (Object)rhsPracticeSetting), (Object)lhsPracticeSetting, (Object)rhsPracticeSetting)) {
            return false;
        }
        Reference lhsSourcePatientInfo = this.getSourcePatientInfo();
        Reference rhsSourcePatientInfo = that.getSourcePatientInfo();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"sourcePatientInfo", (Object)lhsSourcePatientInfo), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"sourcePatientInfo", (Object)rhsSourcePatientInfo), (Object)lhsSourcePatientInfo, (Object)rhsSourcePatientInfo)) {
            return false;
        }
        List<DocumentReferenceRelated> lhsRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        List<DocumentReferenceRelated> list2 = rhsRelated = that.related != null && !that.related.isEmpty() ? that.getRelated() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"related", lhsRelated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"related", rhsRelated), lhsRelated, rhsRelated);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        List<CodeableConcept> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"event", theEvent), currentHashCode, theEvent);
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"period", (Object)thePeriod), currentHashCode, (Object)thePeriod);
        CodeableConcept theFacilityType = this.getFacilityType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"facilityType", (Object)theFacilityType), currentHashCode, (Object)theFacilityType);
        CodeableConcept thePracticeSetting = this.getPracticeSetting();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"practiceSetting", (Object)thePracticeSetting), currentHashCode, (Object)thePracticeSetting);
        Reference theSourcePatientInfo = this.getSourcePatientInfo();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"sourcePatientInfo", (Object)theSourcePatientInfo), currentHashCode, (Object)theSourcePatientInfo);
        List<DocumentReferenceRelated> theRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"related", theRelated), currentHashCode, theRelated);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        List<CodeableConcept> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        strategy.appendField(locator, (Object)this, "event", buffer, theEvent);
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, (Object)thePeriod);
        CodeableConcept theFacilityType = this.getFacilityType();
        strategy.appendField(locator, (Object)this, "facilityType", buffer, (Object)theFacilityType);
        CodeableConcept thePracticeSetting = this.getPracticeSetting();
        strategy.appendField(locator, (Object)this, "practiceSetting", buffer, (Object)thePracticeSetting);
        Reference theSourcePatientInfo = this.getSourcePatientInfo();
        strategy.appendField(locator, (Object)this, "sourcePatientInfo", buffer, (Object)theSourcePatientInfo);
        List<DocumentReferenceRelated> theRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        strategy.appendField(locator, (Object)this, "related", buffer, theRelated);
        return buffer;
    }
}

