/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.ImagingExcerptStudy;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Oid;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ImagingExcerpt", propOrder={"uid", "patient", "authoringTime", "author", "title", "description", "study"})
public class ImagingExcerpt
extends DomainResource
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected Oid uid;
    @XmlElement(required=true)
    protected Reference patient;
    protected DateTime authoringTime;
    protected Reference author;
    @XmlElement(required=true)
    protected CodeableConcept title;
    protected String description;
    @XmlElement(required=true)
    protected List<ImagingExcerptStudy> study;

    public Oid getUid() {
        return this.uid;
    }

    public void setUid(Oid value) {
        this.uid = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public DateTime getAuthoringTime() {
        return this.authoringTime;
    }

    public void setAuthoringTime(DateTime value) {
        this.authoringTime = value;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public void setAuthor(Reference value) {
        this.author = value;
    }

    public CodeableConcept getTitle() {
        return this.title;
    }

    public void setTitle(CodeableConcept value) {
        this.title = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<ImagingExcerptStudy> getStudy() {
        if (this.study == null) {
            this.study = new ArrayList<ImagingExcerptStudy>();
        }
        return this.study;
    }

    public ImagingExcerpt withUid(Oid value) {
        this.setUid(value);
        return this;
    }

    public ImagingExcerpt withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public ImagingExcerpt withAuthoringTime(DateTime value) {
        this.setAuthoringTime(value);
        return this;
    }

    public ImagingExcerpt withAuthor(Reference value) {
        this.setAuthor(value);
        return this;
    }

    public ImagingExcerpt withTitle(CodeableConcept value) {
        this.setTitle(value);
        return this;
    }

    public ImagingExcerpt withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ImagingExcerpt withStudy(ImagingExcerptStudy ... values) {
        if (values != null) {
            for (ImagingExcerptStudy value : values) {
                this.getStudy().add(value);
            }
        }
        return this;
    }

    public ImagingExcerpt withStudy(Collection<ImagingExcerptStudy> values) {
        if (values != null) {
            this.getStudy().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingExcerpt withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ImagingExcerpt withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingExcerpt withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingExcerpt withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingExcerpt withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingExcerpt withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingExcerpt withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingExcerpt withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ImagingExcerpt withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ImagingExcerpt withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ImagingExcerpt withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ImagingExcerptStudy> rhsStudy;
        if (!(object instanceof ImagingExcerpt)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ImagingExcerpt that = (ImagingExcerpt)object;
        Oid lhsUid = this.getUid();
        Oid rhsUid = that.getUid();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"uid", (Object)lhsUid), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"uid", (Object)rhsUid), (Object)lhsUid, (Object)rhsUid)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        DateTime lhsAuthoringTime = this.getAuthoringTime();
        DateTime rhsAuthoringTime = that.getAuthoringTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"authoringTime", (Object)lhsAuthoringTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"authoringTime", (Object)rhsAuthoringTime), (Object)lhsAuthoringTime, (Object)rhsAuthoringTime)) {
            return false;
        }
        Reference lhsAuthor = this.getAuthor();
        Reference rhsAuthor = that.getAuthor();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"author", (Object)lhsAuthor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"author", (Object)rhsAuthor), (Object)lhsAuthor, (Object)rhsAuthor)) {
            return false;
        }
        CodeableConcept lhsTitle = this.getTitle();
        CodeableConcept rhsTitle = that.getTitle();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"title", (Object)lhsTitle), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"title", (Object)rhsTitle), (Object)lhsTitle, (Object)rhsTitle)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription)) {
            return false;
        }
        List<ImagingExcerptStudy> lhsStudy = this.study != null && !this.study.isEmpty() ? this.getStudy() : null;
        List<ImagingExcerptStudy> list = rhsStudy = that.study != null && !that.study.isEmpty() ? that.getStudy() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"study", lhsStudy), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"study", rhsStudy), lhsStudy, rhsStudy);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Oid theUid = this.getUid();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"uid", (Object)theUid), currentHashCode, (Object)theUid);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        DateTime theAuthoringTime = this.getAuthoringTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"authoringTime", (Object)theAuthoringTime), currentHashCode, (Object)theAuthoringTime);
        Reference theAuthor = this.getAuthor();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"author", (Object)theAuthor), currentHashCode, (Object)theAuthor);
        CodeableConcept theTitle = this.getTitle();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"title", (Object)theTitle), currentHashCode, (Object)theTitle);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription);
        List<ImagingExcerptStudy> theStudy = this.study != null && !this.study.isEmpty() ? this.getStudy() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"study", theStudy), currentHashCode, theStudy);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Oid theUid = this.getUid();
        strategy.appendField(locator, (Object)this, "uid", buffer, (Object)theUid);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        DateTime theAuthoringTime = this.getAuthoringTime();
        strategy.appendField(locator, (Object)this, "authoringTime", buffer, (Object)theAuthoringTime);
        Reference theAuthor = this.getAuthor();
        strategy.appendField(locator, (Object)this, "author", buffer, (Object)theAuthor);
        CodeableConcept theTitle = this.getTitle();
        strategy.appendField(locator, (Object)this, "title", buffer, (Object)theTitle);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription);
        List<ImagingExcerptStudy> theStudy = this.study != null && !this.study.isEmpty() ? this.getStudy() : null;
        strategy.appendField(locator, (Object)this, "study", buffer, theStudy);
        return buffer;
    }
}

