/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Attachment;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DiagnosticReportImage;
import org.hl7.fhir.DiagnosticReportStatus;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DiagnosticReport", propOrder={"identifier", "status", "category", "code", "subject", "encounter", "effectiveDateTime", "effectivePeriod", "issued", "performer", "request", "specimen", "result", "imagingStudy", "image", "conclusion", "codedDiagnosis", "presentedForm"})
public class DiagnosticReport
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected DiagnosticReportStatus status;
    protected CodeableConcept category;
    @XmlElement(required=true)
    protected CodeableConcept code;
    @XmlElement(required=true)
    protected Reference subject;
    protected Reference encounter;
    protected DateTime effectiveDateTime;
    protected Period effectivePeriod;
    @XmlElement(required=true)
    protected Instant issued;
    @XmlElement(required=true)
    protected Reference performer;
    protected List<Reference> request;
    protected List<Reference> specimen;
    protected List<Reference> result;
    protected List<Reference> imagingStudy;
    protected List<DiagnosticReportImage> image;
    protected String conclusion;
    protected List<CodeableConcept> codedDiagnosis;
    protected List<Attachment> presentedForm;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DiagnosticReportStatus getStatus() {
        return this.status;
    }

    public void setStatus(DiagnosticReportStatus value) {
        this.status = value;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public void setCategory(CodeableConcept value) {
        this.category = value;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public DateTime getEffectiveDateTime() {
        return this.effectiveDateTime;
    }

    public void setEffectiveDateTime(DateTime value) {
        this.effectiveDateTime = value;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public void setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
    }

    public Instant getIssued() {
        return this.issued;
    }

    public void setIssued(Instant value) {
        this.issued = value;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public void setPerformer(Reference value) {
        this.performer = value;
    }

    public List<Reference> getRequest() {
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        return this.request;
    }

    public List<Reference> getSpecimen() {
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        return this.specimen;
    }

    public List<Reference> getResult() {
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        return this.result;
    }

    public List<Reference> getImagingStudy() {
        if (this.imagingStudy == null) {
            this.imagingStudy = new ArrayList<Reference>();
        }
        return this.imagingStudy;
    }

    public List<DiagnosticReportImage> getImage() {
        if (this.image == null) {
            this.image = new ArrayList<DiagnosticReportImage>();
        }
        return this.image;
    }

    public String getConclusion() {
        return this.conclusion;
    }

    public void setConclusion(String value) {
        this.conclusion = value;
    }

    public List<CodeableConcept> getCodedDiagnosis() {
        if (this.codedDiagnosis == null) {
            this.codedDiagnosis = new ArrayList<CodeableConcept>();
        }
        return this.codedDiagnosis;
    }

    public List<Attachment> getPresentedForm() {
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        return this.presentedForm;
    }

    public DiagnosticReport withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withStatus(DiagnosticReportStatus value) {
        this.setStatus(value);
        return this;
    }

    public DiagnosticReport withCategory(CodeableConcept value) {
        this.setCategory(value);
        return this;
    }

    public DiagnosticReport withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public DiagnosticReport withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public DiagnosticReport withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public DiagnosticReport withEffectiveDateTime(DateTime value) {
        this.setEffectiveDateTime(value);
        return this;
    }

    public DiagnosticReport withEffectivePeriod(Period value) {
        this.setEffectivePeriod(value);
        return this;
    }

    public DiagnosticReport withIssued(Instant value) {
        this.setIssued(value);
        return this;
    }

    public DiagnosticReport withPerformer(Reference value) {
        this.setPerformer(value);
        return this;
    }

    public DiagnosticReport withRequest(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getRequest().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withRequest(Collection<Reference> values) {
        if (values != null) {
            this.getRequest().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withSpecimen(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSpecimen().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withSpecimen(Collection<Reference> values) {
        if (values != null) {
            this.getSpecimen().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withResult(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getResult().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withResult(Collection<Reference> values) {
        if (values != null) {
            this.getResult().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withImagingStudy(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getImagingStudy().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withImagingStudy(Collection<Reference> values) {
        if (values != null) {
            this.getImagingStudy().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withImage(DiagnosticReportImage ... values) {
        if (values != null) {
            for (DiagnosticReportImage value : values) {
                this.getImage().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withImage(Collection<DiagnosticReportImage> values) {
        if (values != null) {
            this.getImage().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withConclusion(String value) {
        this.setConclusion(value);
        return this;
    }

    public DiagnosticReport withCodedDiagnosis(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getCodedDiagnosis().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withCodedDiagnosis(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getCodedDiagnosis().addAll(values);
        }
        return this;
    }

    public DiagnosticReport withPresentedForm(Attachment ... values) {
        if (values != null) {
            for (Attachment value : values) {
                this.getPresentedForm().add(value);
            }
        }
        return this;
    }

    public DiagnosticReport withPresentedForm(Collection<Attachment> values) {
        if (values != null) {
            this.getPresentedForm().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticReport withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public DiagnosticReport withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public DiagnosticReport withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticReport withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DiagnosticReport withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticReport withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DiagnosticReport withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticReport withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public DiagnosticReport withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public DiagnosticReport withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public DiagnosticReport withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Attachment> rhsPresentedForm;
        List<CodeableConcept> rhsCodedDiagnosis;
        List<DiagnosticReportImage> rhsImage;
        List<Reference> rhsImagingStudy;
        List<Reference> rhsResult;
        List<Reference> rhsSpecimen;
        List<Reference> rhsRequest;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof DiagnosticReport)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DiagnosticReport that = (DiagnosticReport)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        DiagnosticReportStatus lhsStatus = this.getStatus();
        DiagnosticReportStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        CodeableConcept lhsCategory = this.getCategory();
        CodeableConcept rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"category", (Object)lhsCategory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"category", (Object)rhsCategory), (Object)lhsCategory, (Object)rhsCategory)) {
            return false;
        }
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        DateTime lhsEffectiveDateTime = this.getEffectiveDateTime();
        DateTime rhsEffectiveDateTime = that.getEffectiveDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"effectiveDateTime", (Object)lhsEffectiveDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"effectiveDateTime", (Object)rhsEffectiveDateTime), (Object)lhsEffectiveDateTime, (Object)rhsEffectiveDateTime)) {
            return false;
        }
        Period lhsEffectivePeriod = this.getEffectivePeriod();
        Period rhsEffectivePeriod = that.getEffectivePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"effectivePeriod", (Object)lhsEffectivePeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"effectivePeriod", (Object)rhsEffectivePeriod), (Object)lhsEffectivePeriod, (Object)rhsEffectivePeriod)) {
            return false;
        }
        Instant lhsIssued = this.getIssued();
        Instant rhsIssued = that.getIssued();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"issued", (Object)lhsIssued), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"issued", (Object)rhsIssued), (Object)lhsIssued, (Object)rhsIssued)) {
            return false;
        }
        Reference lhsPerformer = this.getPerformer();
        Reference rhsPerformer = that.getPerformer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"performer", (Object)lhsPerformer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"performer", (Object)rhsPerformer), (Object)lhsPerformer, (Object)rhsPerformer)) {
            return false;
        }
        List<Reference> lhsRequest = this.request != null && !this.request.isEmpty() ? this.getRequest() : null;
        List<Reference> list2 = rhsRequest = that.request != null && !that.request.isEmpty() ? that.getRequest() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"request", lhsRequest), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"request", rhsRequest), lhsRequest, rhsRequest)) {
            return false;
        }
        List<Reference> lhsSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        List<Reference> list3 = rhsSpecimen = that.specimen != null && !that.specimen.isEmpty() ? that.getSpecimen() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"specimen", lhsSpecimen), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"specimen", rhsSpecimen), lhsSpecimen, rhsSpecimen)) {
            return false;
        }
        List<Reference> lhsResult = this.result != null && !this.result.isEmpty() ? this.getResult() : null;
        List<Reference> list4 = rhsResult = that.result != null && !that.result.isEmpty() ? that.getResult() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"result", lhsResult), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"result", rhsResult), lhsResult, rhsResult)) {
            return false;
        }
        List<Reference> lhsImagingStudy = this.imagingStudy != null && !this.imagingStudy.isEmpty() ? this.getImagingStudy() : null;
        List<Reference> list5 = rhsImagingStudy = that.imagingStudy != null && !that.imagingStudy.isEmpty() ? that.getImagingStudy() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"imagingStudy", lhsImagingStudy), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"imagingStudy", rhsImagingStudy), lhsImagingStudy, rhsImagingStudy)) {
            return false;
        }
        List<DiagnosticReportImage> lhsImage = this.image != null && !this.image.isEmpty() ? this.getImage() : null;
        List<DiagnosticReportImage> list6 = rhsImage = that.image != null && !that.image.isEmpty() ? that.getImage() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"image", lhsImage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"image", rhsImage), lhsImage, rhsImage)) {
            return false;
        }
        String lhsConclusion = this.getConclusion();
        String rhsConclusion = that.getConclusion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"conclusion", (Object)lhsConclusion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"conclusion", (Object)rhsConclusion), (Object)lhsConclusion, (Object)rhsConclusion)) {
            return false;
        }
        List<CodeableConcept> lhsCodedDiagnosis = this.codedDiagnosis != null && !this.codedDiagnosis.isEmpty() ? this.getCodedDiagnosis() : null;
        List<CodeableConcept> list7 = rhsCodedDiagnosis = that.codedDiagnosis != null && !that.codedDiagnosis.isEmpty() ? that.getCodedDiagnosis() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"codedDiagnosis", lhsCodedDiagnosis), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"codedDiagnosis", rhsCodedDiagnosis), lhsCodedDiagnosis, rhsCodedDiagnosis)) {
            return false;
        }
        List<Attachment> lhsPresentedForm = this.presentedForm != null && !this.presentedForm.isEmpty() ? this.getPresentedForm() : null;
        List<Attachment> list8 = rhsPresentedForm = that.presentedForm != null && !that.presentedForm.isEmpty() ? that.getPresentedForm() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"presentedForm", lhsPresentedForm), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"presentedForm", rhsPresentedForm), lhsPresentedForm, rhsPresentedForm);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        DiagnosticReportStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        CodeableConcept theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"category", (Object)theCategory), currentHashCode, (Object)theCategory);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        DateTime theEffectiveDateTime = this.getEffectiveDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"effectiveDateTime", (Object)theEffectiveDateTime), currentHashCode, (Object)theEffectiveDateTime);
        Period theEffectivePeriod = this.getEffectivePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"effectivePeriod", (Object)theEffectivePeriod), currentHashCode, (Object)theEffectivePeriod);
        Instant theIssued = this.getIssued();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"issued", (Object)theIssued), currentHashCode, (Object)theIssued);
        Reference thePerformer = this.getPerformer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"performer", (Object)thePerformer), currentHashCode, (Object)thePerformer);
        List<Reference> theRequest = this.request != null && !this.request.isEmpty() ? this.getRequest() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"request", theRequest), currentHashCode, theRequest);
        List<Reference> theSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"specimen", theSpecimen), currentHashCode, theSpecimen);
        List<Reference> theResult = this.result != null && !this.result.isEmpty() ? this.getResult() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"result", theResult), currentHashCode, theResult);
        List<Reference> theImagingStudy = this.imagingStudy != null && !this.imagingStudy.isEmpty() ? this.getImagingStudy() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"imagingStudy", theImagingStudy), currentHashCode, theImagingStudy);
        List<DiagnosticReportImage> theImage = this.image != null && !this.image.isEmpty() ? this.getImage() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"image", theImage), currentHashCode, theImage);
        String theConclusion = this.getConclusion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"conclusion", (Object)theConclusion), currentHashCode, (Object)theConclusion);
        List<CodeableConcept> theCodedDiagnosis = this.codedDiagnosis != null && !this.codedDiagnosis.isEmpty() ? this.getCodedDiagnosis() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"codedDiagnosis", theCodedDiagnosis), currentHashCode, theCodedDiagnosis);
        List<Attachment> thePresentedForm = this.presentedForm != null && !this.presentedForm.isEmpty() ? this.getPresentedForm() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"presentedForm", thePresentedForm), currentHashCode, thePresentedForm);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        DiagnosticReportStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        CodeableConcept theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, (Object)theCategory);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        DateTime theEffectiveDateTime = this.getEffectiveDateTime();
        strategy.appendField(locator, (Object)this, "effectiveDateTime", buffer, (Object)theEffectiveDateTime);
        Period theEffectivePeriod = this.getEffectivePeriod();
        strategy.appendField(locator, (Object)this, "effectivePeriod", buffer, (Object)theEffectivePeriod);
        Instant theIssued = this.getIssued();
        strategy.appendField(locator, (Object)this, "issued", buffer, (Object)theIssued);
        Reference thePerformer = this.getPerformer();
        strategy.appendField(locator, (Object)this, "performer", buffer, (Object)thePerformer);
        List<Reference> theRequest = this.request != null && !this.request.isEmpty() ? this.getRequest() : null;
        strategy.appendField(locator, (Object)this, "request", buffer, theRequest);
        List<Reference> theSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        strategy.appendField(locator, (Object)this, "specimen", buffer, theSpecimen);
        List<Reference> theResult = this.result != null && !this.result.isEmpty() ? this.getResult() : null;
        strategy.appendField(locator, (Object)this, "result", buffer, theResult);
        List<Reference> theImagingStudy = this.imagingStudy != null && !this.imagingStudy.isEmpty() ? this.getImagingStudy() : null;
        strategy.appendField(locator, (Object)this, "imagingStudy", buffer, theImagingStudy);
        List<DiagnosticReportImage> theImage = this.image != null && !this.image.isEmpty() ? this.getImage() : null;
        strategy.appendField(locator, (Object)this, "image", buffer, theImage);
        String theConclusion = this.getConclusion();
        strategy.appendField(locator, (Object)this, "conclusion", buffer, (Object)theConclusion);
        List<CodeableConcept> theCodedDiagnosis = this.codedDiagnosis != null && !this.codedDiagnosis.isEmpty() ? this.getCodedDiagnosis() : null;
        strategy.appendField(locator, (Object)this, "codedDiagnosis", buffer, theCodedDiagnosis);
        List<Attachment> thePresentedForm = this.presentedForm != null && !this.presentedForm.isEmpty() ? this.getPresentedForm() : null;
        strategy.appendField(locator, (Object)this, "presentedForm", buffer, thePresentedForm);
        return buffer;
    }
}

