/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MedicationDispenseDosageInstruction;
import org.hl7.fhir.MedicationDispenseStatus;
import org.hl7.fhir.MedicationDispenseSubstitution;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SimpleQuantity;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationDispense", propOrder={"identifier", "status", "medicationCodeableConcept", "medicationReference", "patient", "dispenser", "authorizingPrescription", "type", "quantity", "daysSupply", "whenPrepared", "whenHandedOver", "destination", "receiver", "note", "dosageInstruction", "substitution"})
public class MedicationDispense
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Identifier identifier;
    protected MedicationDispenseStatus status;
    protected CodeableConcept medicationCodeableConcept;
    protected Reference medicationReference;
    protected Reference patient;
    protected Reference dispenser;
    protected List<Reference> authorizingPrescription;
    protected CodeableConcept type;
    protected SimpleQuantity quantity;
    protected SimpleQuantity daysSupply;
    protected DateTime whenPrepared;
    protected DateTime whenHandedOver;
    protected Reference destination;
    protected List<Reference> receiver;
    protected List<Annotation> note;
    protected List<MedicationDispenseDosageInstruction> dosageInstruction;
    protected MedicationDispenseSubstitution substitution;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public MedicationDispenseStatus getStatus() {
        return this.status;
    }

    public void setStatus(MedicationDispenseStatus value) {
        this.status = value;
    }

    public CodeableConcept getMedicationCodeableConcept() {
        return this.medicationCodeableConcept;
    }

    public void setMedicationCodeableConcept(CodeableConcept value) {
        this.medicationCodeableConcept = value;
    }

    public Reference getMedicationReference() {
        return this.medicationReference;
    }

    public void setMedicationReference(Reference value) {
        this.medicationReference = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getDispenser() {
        return this.dispenser;
    }

    public void setDispenser(Reference value) {
        this.dispenser = value;
    }

    public List<Reference> getAuthorizingPrescription() {
        if (this.authorizingPrescription == null) {
            this.authorizingPrescription = new ArrayList<Reference>();
        }
        return this.authorizingPrescription;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public SimpleQuantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(SimpleQuantity value) {
        this.quantity = value;
    }

    public SimpleQuantity getDaysSupply() {
        return this.daysSupply;
    }

    public void setDaysSupply(SimpleQuantity value) {
        this.daysSupply = value;
    }

    public DateTime getWhenPrepared() {
        return this.whenPrepared;
    }

    public void setWhenPrepared(DateTime value) {
        this.whenPrepared = value;
    }

    public DateTime getWhenHandedOver() {
        return this.whenHandedOver;
    }

    public void setWhenHandedOver(DateTime value) {
        this.whenHandedOver = value;
    }

    public Reference getDestination() {
        return this.destination;
    }

    public void setDestination(Reference value) {
        this.destination = value;
    }

    public List<Reference> getReceiver() {
        if (this.receiver == null) {
            this.receiver = new ArrayList<Reference>();
        }
        return this.receiver;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public List<MedicationDispenseDosageInstruction> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<MedicationDispenseDosageInstruction>();
        }
        return this.dosageInstruction;
    }

    public MedicationDispenseSubstitution getSubstitution() {
        return this.substitution;
    }

    public void setSubstitution(MedicationDispenseSubstitution value) {
        this.substitution = value;
    }

    public MedicationDispense withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public MedicationDispense withStatus(MedicationDispenseStatus value) {
        this.setStatus(value);
        return this;
    }

    public MedicationDispense withMedicationCodeableConcept(CodeableConcept value) {
        this.setMedicationCodeableConcept(value);
        return this;
    }

    public MedicationDispense withMedicationReference(Reference value) {
        this.setMedicationReference(value);
        return this;
    }

    public MedicationDispense withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public MedicationDispense withDispenser(Reference value) {
        this.setDispenser(value);
        return this;
    }

    public MedicationDispense withAuthorizingPrescription(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAuthorizingPrescription().add(value);
            }
        }
        return this;
    }

    public MedicationDispense withAuthorizingPrescription(Collection<Reference> values) {
        if (values != null) {
            this.getAuthorizingPrescription().addAll(values);
        }
        return this;
    }

    public MedicationDispense withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public MedicationDispense withQuantity(SimpleQuantity value) {
        this.setQuantity(value);
        return this;
    }

    public MedicationDispense withDaysSupply(SimpleQuantity value) {
        this.setDaysSupply(value);
        return this;
    }

    public MedicationDispense withWhenPrepared(DateTime value) {
        this.setWhenPrepared(value);
        return this;
    }

    public MedicationDispense withWhenHandedOver(DateTime value) {
        this.setWhenHandedOver(value);
        return this;
    }

    public MedicationDispense withDestination(Reference value) {
        this.setDestination(value);
        return this;
    }

    public MedicationDispense withReceiver(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getReceiver().add(value);
            }
        }
        return this;
    }

    public MedicationDispense withReceiver(Collection<Reference> values) {
        if (values != null) {
            this.getReceiver().addAll(values);
        }
        return this;
    }

    public MedicationDispense withNote(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public MedicationDispense withNote(Collection<Annotation> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    public MedicationDispense withDosageInstruction(MedicationDispenseDosageInstruction ... values) {
        if (values != null) {
            for (MedicationDispenseDosageInstruction value : values) {
                this.getDosageInstruction().add(value);
            }
        }
        return this;
    }

    public MedicationDispense withDosageInstruction(Collection<MedicationDispenseDosageInstruction> values) {
        if (values != null) {
            this.getDosageInstruction().addAll(values);
        }
        return this;
    }

    public MedicationDispense withSubstitution(MedicationDispenseSubstitution value) {
        this.setSubstitution(value);
        return this;
    }

    @Override
    public MedicationDispense withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MedicationDispense withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationDispense withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationDispense withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationDispense withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationDispense withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationDispense withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationDispense withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MedicationDispense withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MedicationDispense withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MedicationDispense withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<MedicationDispenseDosageInstruction> rhsDosageInstruction;
        List<Annotation> rhsNote;
        List<Reference> rhsReceiver;
        List<Reference> rhsAuthorizingPrescription;
        if (!(object instanceof MedicationDispense)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationDispense that = (MedicationDispense)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        MedicationDispenseStatus lhsStatus = this.getStatus();
        MedicationDispenseStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        CodeableConcept lhsMedicationCodeableConcept = this.getMedicationCodeableConcept();
        CodeableConcept rhsMedicationCodeableConcept = that.getMedicationCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"medicationCodeableConcept", (Object)lhsMedicationCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"medicationCodeableConcept", (Object)rhsMedicationCodeableConcept), (Object)lhsMedicationCodeableConcept, (Object)rhsMedicationCodeableConcept)) {
            return false;
        }
        Reference lhsMedicationReference = this.getMedicationReference();
        Reference rhsMedicationReference = that.getMedicationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"medicationReference", (Object)lhsMedicationReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"medicationReference", (Object)rhsMedicationReference), (Object)lhsMedicationReference, (Object)rhsMedicationReference)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        Reference lhsDispenser = this.getDispenser();
        Reference rhsDispenser = that.getDispenser();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dispenser", (Object)lhsDispenser), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dispenser", (Object)rhsDispenser), (Object)lhsDispenser, (Object)rhsDispenser)) {
            return false;
        }
        List<Reference> lhsAuthorizingPrescription = this.authorizingPrescription != null && !this.authorizingPrescription.isEmpty() ? this.getAuthorizingPrescription() : null;
        List<Reference> list = rhsAuthorizingPrescription = that.authorizingPrescription != null && !that.authorizingPrescription.isEmpty() ? that.getAuthorizingPrescription() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"authorizingPrescription", lhsAuthorizingPrescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"authorizingPrescription", rhsAuthorizingPrescription), lhsAuthorizingPrescription, rhsAuthorizingPrescription)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        SimpleQuantity lhsQuantity = this.getQuantity();
        SimpleQuantity rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"quantity", (Object)lhsQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"quantity", (Object)rhsQuantity), (Object)lhsQuantity, (Object)rhsQuantity)) {
            return false;
        }
        SimpleQuantity lhsDaysSupply = this.getDaysSupply();
        SimpleQuantity rhsDaysSupply = that.getDaysSupply();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"daysSupply", (Object)lhsDaysSupply), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"daysSupply", (Object)rhsDaysSupply), (Object)lhsDaysSupply, (Object)rhsDaysSupply)) {
            return false;
        }
        DateTime lhsWhenPrepared = this.getWhenPrepared();
        DateTime rhsWhenPrepared = that.getWhenPrepared();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"whenPrepared", (Object)lhsWhenPrepared), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"whenPrepared", (Object)rhsWhenPrepared), (Object)lhsWhenPrepared, (Object)rhsWhenPrepared)) {
            return false;
        }
        DateTime lhsWhenHandedOver = this.getWhenHandedOver();
        DateTime rhsWhenHandedOver = that.getWhenHandedOver();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"whenHandedOver", (Object)lhsWhenHandedOver), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"whenHandedOver", (Object)rhsWhenHandedOver), (Object)lhsWhenHandedOver, (Object)rhsWhenHandedOver)) {
            return false;
        }
        Reference lhsDestination = this.getDestination();
        Reference rhsDestination = that.getDestination();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"destination", (Object)lhsDestination), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"destination", (Object)rhsDestination), (Object)lhsDestination, (Object)rhsDestination)) {
            return false;
        }
        List<Reference> lhsReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        List<Reference> list2 = rhsReceiver = that.receiver != null && !that.receiver.isEmpty() ? that.getReceiver() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"receiver", lhsReceiver), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"receiver", rhsReceiver), lhsReceiver, rhsReceiver)) {
            return false;
        }
        List<Annotation> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<Annotation> list3 = rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"note", lhsNote), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"note", rhsNote), lhsNote, rhsNote)) {
            return false;
        }
        List<MedicationDispenseDosageInstruction> lhsDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        List<MedicationDispenseDosageInstruction> list4 = rhsDosageInstruction = that.dosageInstruction != null && !that.dosageInstruction.isEmpty() ? that.getDosageInstruction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dosageInstruction", lhsDosageInstruction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dosageInstruction", rhsDosageInstruction), lhsDosageInstruction, rhsDosageInstruction)) {
            return false;
        }
        MedicationDispenseSubstitution lhsSubstitution = this.getSubstitution();
        MedicationDispenseSubstitution rhsSubstitution = that.getSubstitution();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"substitution", (Object)lhsSubstitution), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"substitution", (Object)rhsSubstitution), (Object)lhsSubstitution, (Object)rhsSubstitution);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        MedicationDispenseStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"medicationCodeableConcept", (Object)theMedicationCodeableConcept), currentHashCode, (Object)theMedicationCodeableConcept);
        Reference theMedicationReference = this.getMedicationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"medicationReference", (Object)theMedicationReference), currentHashCode, (Object)theMedicationReference);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        Reference theDispenser = this.getDispenser();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dispenser", (Object)theDispenser), currentHashCode, (Object)theDispenser);
        List<Reference> theAuthorizingPrescription = this.authorizingPrescription != null && !this.authorizingPrescription.isEmpty() ? this.getAuthorizingPrescription() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"authorizingPrescription", theAuthorizingPrescription), currentHashCode, theAuthorizingPrescription);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"type", (Object)theType), currentHashCode, (Object)theType);
        SimpleQuantity theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"quantity", (Object)theQuantity), currentHashCode, (Object)theQuantity);
        SimpleQuantity theDaysSupply = this.getDaysSupply();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"daysSupply", (Object)theDaysSupply), currentHashCode, (Object)theDaysSupply);
        DateTime theWhenPrepared = this.getWhenPrepared();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"whenPrepared", (Object)theWhenPrepared), currentHashCode, (Object)theWhenPrepared);
        DateTime theWhenHandedOver = this.getWhenHandedOver();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"whenHandedOver", (Object)theWhenHandedOver), currentHashCode, (Object)theWhenHandedOver);
        Reference theDestination = this.getDestination();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"destination", (Object)theDestination), currentHashCode, (Object)theDestination);
        List<Reference> theReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"receiver", theReceiver), currentHashCode, theReceiver);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"note", theNote), currentHashCode, theNote);
        List<MedicationDispenseDosageInstruction> theDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dosageInstruction", theDosageInstruction), currentHashCode, theDosageInstruction);
        MedicationDispenseSubstitution theSubstitution = this.getSubstitution();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"substitution", (Object)theSubstitution), currentHashCode, (Object)theSubstitution);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        MedicationDispenseStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        strategy.appendField(locator, (Object)this, "medicationCodeableConcept", buffer, (Object)theMedicationCodeableConcept);
        Reference theMedicationReference = this.getMedicationReference();
        strategy.appendField(locator, (Object)this, "medicationReference", buffer, (Object)theMedicationReference);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        Reference theDispenser = this.getDispenser();
        strategy.appendField(locator, (Object)this, "dispenser", buffer, (Object)theDispenser);
        List<Reference> theAuthorizingPrescription = this.authorizingPrescription != null && !this.authorizingPrescription.isEmpty() ? this.getAuthorizingPrescription() : null;
        strategy.appendField(locator, (Object)this, "authorizingPrescription", buffer, theAuthorizingPrescription);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        SimpleQuantity theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, (Object)theQuantity);
        SimpleQuantity theDaysSupply = this.getDaysSupply();
        strategy.appendField(locator, (Object)this, "daysSupply", buffer, (Object)theDaysSupply);
        DateTime theWhenPrepared = this.getWhenPrepared();
        strategy.appendField(locator, (Object)this, "whenPrepared", buffer, (Object)theWhenPrepared);
        DateTime theWhenHandedOver = this.getWhenHandedOver();
        strategy.appendField(locator, (Object)this, "whenHandedOver", buffer, (Object)theWhenHandedOver);
        Reference theDestination = this.getDestination();
        strategy.appendField(locator, (Object)this, "destination", buffer, (Object)theDestination);
        List<Reference> theReceiver = this.receiver != null && !this.receiver.isEmpty() ? this.getReceiver() : null;
        strategy.appendField(locator, (Object)this, "receiver", buffer, theReceiver);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote);
        List<MedicationDispenseDosageInstruction> theDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        strategy.appendField(locator, (Object)this, "dosageInstruction", buffer, theDosageInstruction);
        MedicationDispenseSubstitution theSubstitution = this.getSubstitution();
        strategy.appendField(locator, (Object)this, "substitution", buffer, (Object)theSubstitution);
        return buffer;
    }
}

