/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Decimal;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MeasureReportPopulation;
import org.hl7.fhir.MeasureReportStratifier;
import org.hl7.fhir.MeasureReportSupplementalData;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MeasureReport.Group", propOrder={"identifier", "population", "measureScore", "stratifier", "supplementalData"})
public class MeasureReportGroup
extends BackboneElement
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected Identifier identifier;
    protected List<MeasureReportPopulation> population;
    protected Decimal measureScore;
    protected List<MeasureReportStratifier> stratifier;
    protected List<MeasureReportSupplementalData> supplementalData;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public List<MeasureReportPopulation> getPopulation() {
        if (this.population == null) {
            this.population = new ArrayList<MeasureReportPopulation>();
        }
        return this.population;
    }

    public Decimal getMeasureScore() {
        return this.measureScore;
    }

    public void setMeasureScore(Decimal value) {
        this.measureScore = value;
    }

    public List<MeasureReportStratifier> getStratifier() {
        if (this.stratifier == null) {
            this.stratifier = new ArrayList<MeasureReportStratifier>();
        }
        return this.stratifier;
    }

    public List<MeasureReportSupplementalData> getSupplementalData() {
        if (this.supplementalData == null) {
            this.supplementalData = new ArrayList<MeasureReportSupplementalData>();
        }
        return this.supplementalData;
    }

    public MeasureReportGroup withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public MeasureReportGroup withPopulation(MeasureReportPopulation ... values) {
        if (values != null) {
            for (MeasureReportPopulation value : values) {
                this.getPopulation().add(value);
            }
        }
        return this;
    }

    public MeasureReportGroup withPopulation(Collection<MeasureReportPopulation> values) {
        if (values != null) {
            this.getPopulation().addAll(values);
        }
        return this;
    }

    public MeasureReportGroup withMeasureScore(Decimal value) {
        this.setMeasureScore(value);
        return this;
    }

    public MeasureReportGroup withStratifier(MeasureReportStratifier ... values) {
        if (values != null) {
            for (MeasureReportStratifier value : values) {
                this.getStratifier().add(value);
            }
        }
        return this;
    }

    public MeasureReportGroup withStratifier(Collection<MeasureReportStratifier> values) {
        if (values != null) {
            this.getStratifier().addAll(values);
        }
        return this;
    }

    public MeasureReportGroup withSupplementalData(MeasureReportSupplementalData ... values) {
        if (values != null) {
            for (MeasureReportSupplementalData value : values) {
                this.getSupplementalData().add(value);
            }
        }
        return this;
    }

    public MeasureReportGroup withSupplementalData(Collection<MeasureReportSupplementalData> values) {
        if (values != null) {
            this.getSupplementalData().addAll(values);
        }
        return this;
    }

    @Override
    public MeasureReportGroup withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MeasureReportGroup withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MeasureReportGroup withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MeasureReportGroup withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MeasureReportGroup withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<MeasureReportSupplementalData> rhsSupplementalData;
        List<MeasureReportStratifier> rhsStratifier;
        List<MeasureReportPopulation> rhsPopulation;
        if (!(object instanceof MeasureReportGroup)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MeasureReportGroup that = (MeasureReportGroup)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        List<MeasureReportPopulation> lhsPopulation = this.population != null && !this.population.isEmpty() ? this.getPopulation() : null;
        List<MeasureReportPopulation> list = rhsPopulation = that.population != null && !that.population.isEmpty() ? that.getPopulation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"population", lhsPopulation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"population", rhsPopulation), lhsPopulation, rhsPopulation)) {
            return false;
        }
        Decimal lhsMeasureScore = this.getMeasureScore();
        Decimal rhsMeasureScore = that.getMeasureScore();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"measureScore", (Object)lhsMeasureScore), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"measureScore", (Object)rhsMeasureScore), (Object)lhsMeasureScore, (Object)rhsMeasureScore)) {
            return false;
        }
        List<MeasureReportStratifier> lhsStratifier = this.stratifier != null && !this.stratifier.isEmpty() ? this.getStratifier() : null;
        List<MeasureReportStratifier> list2 = rhsStratifier = that.stratifier != null && !that.stratifier.isEmpty() ? that.getStratifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"stratifier", lhsStratifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"stratifier", rhsStratifier), lhsStratifier, rhsStratifier)) {
            return false;
        }
        List<MeasureReportSupplementalData> lhsSupplementalData = this.supplementalData != null && !this.supplementalData.isEmpty() ? this.getSupplementalData() : null;
        List<MeasureReportSupplementalData> list3 = rhsSupplementalData = that.supplementalData != null && !that.supplementalData.isEmpty() ? that.getSupplementalData() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"supplementalData", lhsSupplementalData), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"supplementalData", rhsSupplementalData), lhsSupplementalData, rhsSupplementalData);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        List<MeasureReportPopulation> thePopulation = this.population != null && !this.population.isEmpty() ? this.getPopulation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"population", thePopulation), currentHashCode, thePopulation);
        Decimal theMeasureScore = this.getMeasureScore();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"measureScore", (Object)theMeasureScore), currentHashCode, (Object)theMeasureScore);
        List<MeasureReportStratifier> theStratifier = this.stratifier != null && !this.stratifier.isEmpty() ? this.getStratifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"stratifier", theStratifier), currentHashCode, theStratifier);
        List<MeasureReportSupplementalData> theSupplementalData = this.supplementalData != null && !this.supplementalData.isEmpty() ? this.getSupplementalData() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"supplementalData", theSupplementalData), currentHashCode, theSupplementalData);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        List<MeasureReportPopulation> thePopulation = this.population != null && !this.population.isEmpty() ? this.getPopulation() : null;
        strategy.appendField(locator, (Object)this, "population", buffer, thePopulation);
        Decimal theMeasureScore = this.getMeasureScore();
        strategy.appendField(locator, (Object)this, "measureScore", buffer, (Object)theMeasureScore);
        List<MeasureReportStratifier> theStratifier = this.stratifier != null && !this.stratifier.isEmpty() ? this.getStratifier() : null;
        strategy.appendField(locator, (Object)this, "stratifier", buffer, theStratifier);
        List<MeasureReportSupplementalData> theSupplementalData = this.supplementalData != null && !this.supplementalData.isEmpty() ? this.getSupplementalData() : null;
        strategy.appendField(locator, (Object)this, "supplementalData", buffer, theSupplementalData);
        return buffer;
    }
}

