/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.MedicationContent;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Medication.Package", propOrder={"container", "content"})
public class MedicationPackage
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected CodeableConcept container;
    protected List<MedicationContent> content;

    public CodeableConcept getContainer() {
        return this.container;
    }

    public void setContainer(CodeableConcept value) {
        this.container = value;
    }

    public List<MedicationContent> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<MedicationContent>();
        }
        return this.content;
    }

    public MedicationPackage withContainer(CodeableConcept value) {
        this.setContainer(value);
        return this;
    }

    public MedicationPackage withContent(MedicationContent ... values) {
        if (values != null) {
            for (MedicationContent value : values) {
                this.getContent().add(value);
            }
        }
        return this;
    }

    public MedicationPackage withContent(Collection<MedicationContent> values) {
        if (values != null) {
            this.getContent().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationPackage withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationPackage withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationPackage withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationPackage withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationPackage withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<MedicationContent> rhsContent;
        if (!(object instanceof MedicationPackage)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationPackage that = (MedicationPackage)object;
        CodeableConcept lhsContainer = this.getContainer();
        CodeableConcept rhsContainer = that.getContainer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"container", (Object)lhsContainer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"container", (Object)rhsContainer), (Object)lhsContainer, (Object)rhsContainer)) {
            return false;
        }
        List<MedicationContent> lhsContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        List<MedicationContent> list = rhsContent = that.content != null && !that.content.isEmpty() ? that.getContent() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"content", lhsContent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"content", rhsContent), lhsContent, rhsContent);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theContainer = this.getContainer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"container", (Object)theContainer), currentHashCode, (Object)theContainer);
        List<MedicationContent> theContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"content", theContent), currentHashCode, theContent);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theContainer = this.getContainer();
        strategy.appendField(locator, (Object)this, "container", buffer, (Object)theContainer);
        List<MedicationContent> theContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        strategy.appendField(locator, (Object)this, "content", buffer, theContent);
        return buffer;
    }
}

