/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.MedicationBatch;
import org.hl7.fhir.MedicationIngredient;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Medication.Product", propOrder={"form", "ingredient", "batch"})
public class MedicationProduct
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected CodeableConcept form;
    protected List<MedicationIngredient> ingredient;
    protected List<MedicationBatch> batch;

    public CodeableConcept getForm() {
        return this.form;
    }

    public void setForm(CodeableConcept value) {
        this.form = value;
    }

    public List<MedicationIngredient> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationIngredient>();
        }
        return this.ingredient;
    }

    public List<MedicationBatch> getBatch() {
        if (this.batch == null) {
            this.batch = new ArrayList<MedicationBatch>();
        }
        return this.batch;
    }

    public MedicationProduct withForm(CodeableConcept value) {
        this.setForm(value);
        return this;
    }

    public MedicationProduct withIngredient(MedicationIngredient ... values) {
        if (values != null) {
            for (MedicationIngredient value : values) {
                this.getIngredient().add(value);
            }
        }
        return this;
    }

    public MedicationProduct withIngredient(Collection<MedicationIngredient> values) {
        if (values != null) {
            this.getIngredient().addAll(values);
        }
        return this;
    }

    public MedicationProduct withBatch(MedicationBatch ... values) {
        if (values != null) {
            for (MedicationBatch value : values) {
                this.getBatch().add(value);
            }
        }
        return this;
    }

    public MedicationProduct withBatch(Collection<MedicationBatch> values) {
        if (values != null) {
            this.getBatch().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationProduct withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationProduct withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationProduct withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationProduct withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationProduct withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<MedicationBatch> rhsBatch;
        List<MedicationIngredient> rhsIngredient;
        if (!(object instanceof MedicationProduct)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationProduct that = (MedicationProduct)object;
        CodeableConcept lhsForm = this.getForm();
        CodeableConcept rhsForm = that.getForm();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"form", (Object)lhsForm), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"form", (Object)rhsForm), (Object)lhsForm, (Object)rhsForm)) {
            return false;
        }
        List<MedicationIngredient> lhsIngredient = this.ingredient != null && !this.ingredient.isEmpty() ? this.getIngredient() : null;
        List<MedicationIngredient> list = rhsIngredient = that.ingredient != null && !that.ingredient.isEmpty() ? that.getIngredient() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"ingredient", lhsIngredient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"ingredient", rhsIngredient), lhsIngredient, rhsIngredient)) {
            return false;
        }
        List<MedicationBatch> lhsBatch = this.batch != null && !this.batch.isEmpty() ? this.getBatch() : null;
        List<MedicationBatch> list2 = rhsBatch = that.batch != null && !that.batch.isEmpty() ? that.getBatch() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"batch", lhsBatch), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"batch", rhsBatch), lhsBatch, rhsBatch);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theForm = this.getForm();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"form", (Object)theForm), currentHashCode, (Object)theForm);
        List<MedicationIngredient> theIngredient = this.ingredient != null && !this.ingredient.isEmpty() ? this.getIngredient() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"ingredient", theIngredient), currentHashCode, theIngredient);
        List<MedicationBatch> theBatch = this.batch != null && !this.batch.isEmpty() ? this.getBatch() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"batch", theBatch), currentHashCode, theBatch);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theForm = this.getForm();
        strategy.appendField(locator, (Object)this, "form", buffer, (Object)theForm);
        List<MedicationIngredient> theIngredient = this.ingredient != null && !this.ingredient.isEmpty() ? this.getIngredient() : null;
        strategy.appendField(locator, (Object)this, "ingredient", buffer, theIngredient);
        List<MedicationBatch> theBatch = this.batch != null && !this.batch.isEmpty() ? this.getBatch() : null;
        strategy.appendField(locator, (Object)this, "batch", buffer, theBatch);
        return buffer;
    }
}

