/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SlotStatus;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Slot", propOrder={"identifier", "serviceCategory", "serviceType", "specialty", "appointmentType", "schedule", "status", "start", "end", "overbooked", "comment"})
public class Slot
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    protected CodeableConcept serviceCategory;
    protected List<CodeableConcept> serviceType;
    protected List<CodeableConcept> specialty;
    protected CodeableConcept appointmentType;
    @XmlElement(required=true)
    protected Reference schedule;
    @XmlElement(required=true)
    protected SlotStatus status;
    @XmlElement(required=true)
    protected Instant start;
    @XmlElement(required=true)
    protected Instant end;
    protected Boolean overbooked;
    protected String comment;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CodeableConcept getServiceCategory() {
        return this.serviceCategory;
    }

    public void setServiceCategory(CodeableConcept value) {
        this.serviceCategory = value;
    }

    public List<CodeableConcept> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        return this.serviceType;
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public CodeableConcept getAppointmentType() {
        return this.appointmentType;
    }

    public void setAppointmentType(CodeableConcept value) {
        this.appointmentType = value;
    }

    public Reference getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Reference value) {
        this.schedule = value;
    }

    public SlotStatus getStatus() {
        return this.status;
    }

    public void setStatus(SlotStatus value) {
        this.status = value;
    }

    public Instant getStart() {
        return this.start;
    }

    public void setStart(Instant value) {
        this.start = value;
    }

    public Instant getEnd() {
        return this.end;
    }

    public void setEnd(Instant value) {
        this.end = value;
    }

    public Boolean getOverbooked() {
        return this.overbooked;
    }

    public void setOverbooked(Boolean value) {
        this.overbooked = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public Slot withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Slot withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Slot withServiceCategory(CodeableConcept value) {
        this.setServiceCategory(value);
        return this;
    }

    public Slot withServiceType(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getServiceType().add(value);
            }
        }
        return this;
    }

    public Slot withServiceType(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getServiceType().addAll(values);
        }
        return this;
    }

    public Slot withSpecialty(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSpecialty().add(value);
            }
        }
        return this;
    }

    public Slot withSpecialty(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSpecialty().addAll(values);
        }
        return this;
    }

    public Slot withAppointmentType(CodeableConcept value) {
        this.setAppointmentType(value);
        return this;
    }

    public Slot withSchedule(Reference value) {
        this.setSchedule(value);
        return this;
    }

    public Slot withStatus(SlotStatus value) {
        this.setStatus(value);
        return this;
    }

    public Slot withStart(Instant value) {
        this.setStart(value);
        return this;
    }

    public Slot withEnd(Instant value) {
        this.setEnd(value);
        return this;
    }

    public Slot withOverbooked(Boolean value) {
        this.setOverbooked(value);
        return this;
    }

    public Slot withComment(String value) {
        this.setComment(value);
        return this;
    }

    @Override
    public Slot withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Slot withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Slot withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Slot withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Slot withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Slot withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Slot withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Slot withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Slot withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Slot withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Slot withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<CodeableConcept> rhsSpecialty;
        List<CodeableConcept> rhsServiceType;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof Slot)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Slot that = (Slot)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        CodeableConcept lhsServiceCategory = this.getServiceCategory();
        CodeableConcept rhsServiceCategory = that.getServiceCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"serviceCategory", (Object)lhsServiceCategory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"serviceCategory", (Object)rhsServiceCategory), (Object)lhsServiceCategory, (Object)rhsServiceCategory)) {
            return false;
        }
        List<CodeableConcept> lhsServiceType = this.serviceType != null && !this.serviceType.isEmpty() ? this.getServiceType() : null;
        List<CodeableConcept> list2 = rhsServiceType = that.serviceType != null && !that.serviceType.isEmpty() ? that.getServiceType() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"serviceType", lhsServiceType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"serviceType", rhsServiceType), lhsServiceType, rhsServiceType)) {
            return false;
        }
        List<CodeableConcept> lhsSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        List<CodeableConcept> list3 = rhsSpecialty = that.specialty != null && !that.specialty.isEmpty() ? that.getSpecialty() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"specialty", lhsSpecialty), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"specialty", rhsSpecialty), lhsSpecialty, rhsSpecialty)) {
            return false;
        }
        CodeableConcept lhsAppointmentType = this.getAppointmentType();
        CodeableConcept rhsAppointmentType = that.getAppointmentType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"appointmentType", (Object)lhsAppointmentType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"appointmentType", (Object)rhsAppointmentType), (Object)lhsAppointmentType, (Object)rhsAppointmentType)) {
            return false;
        }
        Reference lhsSchedule = this.getSchedule();
        Reference rhsSchedule = that.getSchedule();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"schedule", (Object)lhsSchedule), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"schedule", (Object)rhsSchedule), (Object)lhsSchedule, (Object)rhsSchedule)) {
            return false;
        }
        SlotStatus lhsStatus = this.getStatus();
        SlotStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        Instant lhsStart = this.getStart();
        Instant rhsStart = that.getStart();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"start", (Object)lhsStart), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"start", (Object)rhsStart), (Object)lhsStart, (Object)rhsStart)) {
            return false;
        }
        Instant lhsEnd = this.getEnd();
        Instant rhsEnd = that.getEnd();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"end", (Object)lhsEnd), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"end", (Object)rhsEnd), (Object)lhsEnd, (Object)rhsEnd)) {
            return false;
        }
        Boolean lhsOverbooked = this.getOverbooked();
        Boolean rhsOverbooked = that.getOverbooked();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"overbooked", (Object)lhsOverbooked), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"overbooked", (Object)rhsOverbooked), (Object)lhsOverbooked, (Object)rhsOverbooked)) {
            return false;
        }
        String lhsComment = this.getComment();
        String rhsComment = that.getComment();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"comment", (Object)lhsComment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"comment", (Object)rhsComment), (Object)lhsComment, (Object)rhsComment);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        CodeableConcept theServiceCategory = this.getServiceCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"serviceCategory", (Object)theServiceCategory), currentHashCode, (Object)theServiceCategory);
        List<CodeableConcept> theServiceType = this.serviceType != null && !this.serviceType.isEmpty() ? this.getServiceType() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"serviceType", theServiceType), currentHashCode, theServiceType);
        List<CodeableConcept> theSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"specialty", theSpecialty), currentHashCode, theSpecialty);
        CodeableConcept theAppointmentType = this.getAppointmentType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"appointmentType", (Object)theAppointmentType), currentHashCode, (Object)theAppointmentType);
        Reference theSchedule = this.getSchedule();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"schedule", (Object)theSchedule), currentHashCode, (Object)theSchedule);
        SlotStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        Instant theStart = this.getStart();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"start", (Object)theStart), currentHashCode, (Object)theStart);
        Instant theEnd = this.getEnd();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"end", (Object)theEnd), currentHashCode, (Object)theEnd);
        Boolean theOverbooked = this.getOverbooked();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"overbooked", (Object)theOverbooked), currentHashCode, (Object)theOverbooked);
        String theComment = this.getComment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"comment", (Object)theComment), currentHashCode, (Object)theComment);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        CodeableConcept theServiceCategory = this.getServiceCategory();
        strategy.appendField(locator, (Object)this, "serviceCategory", buffer, (Object)theServiceCategory);
        List<CodeableConcept> theServiceType = this.serviceType != null && !this.serviceType.isEmpty() ? this.getServiceType() : null;
        strategy.appendField(locator, (Object)this, "serviceType", buffer, theServiceType);
        List<CodeableConcept> theSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        strategy.appendField(locator, (Object)this, "specialty", buffer, theSpecialty);
        CodeableConcept theAppointmentType = this.getAppointmentType();
        strategy.appendField(locator, (Object)this, "appointmentType", buffer, (Object)theAppointmentType);
        Reference theSchedule = this.getSchedule();
        strategy.appendField(locator, (Object)this, "schedule", buffer, (Object)theSchedule);
        SlotStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        Instant theStart = this.getStart();
        strategy.appendField(locator, (Object)this, "start", buffer, (Object)theStart);
        Instant theEnd = this.getEnd();
        strategy.appendField(locator, (Object)this, "end", buffer, (Object)theEnd);
        Boolean theOverbooked = this.getOverbooked();
        strategy.appendField(locator, (Object)this, "overbooked", buffer, (Object)theOverbooked);
        String theComment = this.getComment();
        strategy.appendField(locator, (Object)this, "comment", buffer, (Object)theComment);
        return buffer;
    }
}

