/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DiagnosticOrderEvent;
import org.hl7.fhir.DiagnosticOrderItem;
import org.hl7.fhir.DiagnosticOrderPriority;
import org.hl7.fhir.DiagnosticOrderStatus;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DiagnosticOrder", propOrder={"identifier", "status", "priority", "subject", "encounter", "orderer", "reason", "supportingInformation", "specimen", "event", "item", "note"})
public class DiagnosticOrder
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    protected DiagnosticOrderStatus status;
    protected DiagnosticOrderPriority priority;
    @XmlElement(required=true)
    protected Reference subject;
    protected Reference encounter;
    protected Reference orderer;
    protected List<CodeableConcept> reason;
    protected List<Reference> supportingInformation;
    protected List<Reference> specimen;
    protected List<DiagnosticOrderEvent> event;
    protected List<DiagnosticOrderItem> item;
    protected List<Annotation> note;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DiagnosticOrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(DiagnosticOrderStatus value) {
        this.status = value;
    }

    public DiagnosticOrderPriority getPriority() {
        return this.priority;
    }

    public void setPriority(DiagnosticOrderPriority value) {
        this.priority = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public Reference getOrderer() {
        return this.orderer;
    }

    public void setOrderer(Reference value) {
        this.orderer = value;
    }

    public List<CodeableConcept> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        return this.reason;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public List<Reference> getSpecimen() {
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        return this.specimen;
    }

    public List<DiagnosticOrderEvent> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<DiagnosticOrderEvent>();
        }
        return this.event;
    }

    public List<DiagnosticOrderItem> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<DiagnosticOrderItem>();
        }
        return this.item;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public DiagnosticOrder withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public DiagnosticOrder withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public DiagnosticOrder withStatus(DiagnosticOrderStatus value) {
        this.setStatus(value);
        return this;
    }

    public DiagnosticOrder withPriority(DiagnosticOrderPriority value) {
        this.setPriority(value);
        return this;
    }

    public DiagnosticOrder withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public DiagnosticOrder withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public DiagnosticOrder withOrderer(Reference value) {
        this.setOrderer(value);
        return this;
    }

    public DiagnosticOrder withReason(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReason().add(value);
            }
        }
        return this;
    }

    public DiagnosticOrder withReason(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReason().addAll(values);
        }
        return this;
    }

    public DiagnosticOrder withSupportingInformation(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSupportingInformation().add(value);
            }
        }
        return this;
    }

    public DiagnosticOrder withSupportingInformation(Collection<Reference> values) {
        if (values != null) {
            this.getSupportingInformation().addAll(values);
        }
        return this;
    }

    public DiagnosticOrder withSpecimen(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSpecimen().add(value);
            }
        }
        return this;
    }

    public DiagnosticOrder withSpecimen(Collection<Reference> values) {
        if (values != null) {
            this.getSpecimen().addAll(values);
        }
        return this;
    }

    public DiagnosticOrder withEvent(DiagnosticOrderEvent ... values) {
        if (values != null) {
            for (DiagnosticOrderEvent value : values) {
                this.getEvent().add(value);
            }
        }
        return this;
    }

    public DiagnosticOrder withEvent(Collection<DiagnosticOrderEvent> values) {
        if (values != null) {
            this.getEvent().addAll(values);
        }
        return this;
    }

    public DiagnosticOrder withItem(DiagnosticOrderItem ... values) {
        if (values != null) {
            for (DiagnosticOrderItem value : values) {
                this.getItem().add(value);
            }
        }
        return this;
    }

    public DiagnosticOrder withItem(Collection<DiagnosticOrderItem> values) {
        if (values != null) {
            this.getItem().addAll(values);
        }
        return this;
    }

    public DiagnosticOrder withNote(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public DiagnosticOrder withNote(Collection<Annotation> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticOrder withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public DiagnosticOrder withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public DiagnosticOrder withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticOrder withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DiagnosticOrder withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticOrder withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DiagnosticOrder withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticOrder withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public DiagnosticOrder withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public DiagnosticOrder withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public DiagnosticOrder withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Annotation> rhsNote;
        List<DiagnosticOrderItem> rhsItem;
        List<DiagnosticOrderEvent> rhsEvent;
        List<Reference> rhsSpecimen;
        List<Reference> rhsSupportingInformation;
        List<CodeableConcept> rhsReason;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof DiagnosticOrder)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DiagnosticOrder that = (DiagnosticOrder)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        DiagnosticOrderStatus lhsStatus = this.getStatus();
        DiagnosticOrderStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        DiagnosticOrderPriority lhsPriority = this.getPriority();
        DiagnosticOrderPriority rhsPriority = that.getPriority();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"priority", (Object)lhsPriority), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"priority", (Object)rhsPriority), (Object)lhsPriority, (Object)rhsPriority)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        Reference lhsOrderer = this.getOrderer();
        Reference rhsOrderer = that.getOrderer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"orderer", (Object)lhsOrderer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"orderer", (Object)rhsOrderer), (Object)lhsOrderer, (Object)rhsOrderer)) {
            return false;
        }
        List<CodeableConcept> lhsReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        List<CodeableConcept> list2 = rhsReason = that.reason != null && !that.reason.isEmpty() ? that.getReason() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reason", lhsReason), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reason", rhsReason), lhsReason, rhsReason)) {
            return false;
        }
        List<Reference> lhsSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        List<Reference> list3 = rhsSupportingInformation = that.supportingInformation != null && !that.supportingInformation.isEmpty() ? that.getSupportingInformation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"supportingInformation", lhsSupportingInformation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"supportingInformation", rhsSupportingInformation), lhsSupportingInformation, rhsSupportingInformation)) {
            return false;
        }
        List<Reference> lhsSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        List<Reference> list4 = rhsSpecimen = that.specimen != null && !that.specimen.isEmpty() ? that.getSpecimen() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"specimen", lhsSpecimen), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"specimen", rhsSpecimen), lhsSpecimen, rhsSpecimen)) {
            return false;
        }
        List<DiagnosticOrderEvent> lhsEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        List<DiagnosticOrderEvent> list5 = rhsEvent = that.event != null && !that.event.isEmpty() ? that.getEvent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"event", lhsEvent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"event", rhsEvent), lhsEvent, rhsEvent)) {
            return false;
        }
        List<DiagnosticOrderItem> lhsItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        List<DiagnosticOrderItem> list6 = rhsItem = that.item != null && !that.item.isEmpty() ? that.getItem() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"item", lhsItem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"item", rhsItem), lhsItem, rhsItem)) {
            return false;
        }
        List<Annotation> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<Annotation> list7 = rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"note", lhsNote), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"note", rhsNote), lhsNote, rhsNote);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        DiagnosticOrderStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        DiagnosticOrderPriority thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"priority", (Object)thePriority), currentHashCode, (Object)thePriority);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        Reference theOrderer = this.getOrderer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"orderer", (Object)theOrderer), currentHashCode, (Object)theOrderer);
        List<CodeableConcept> theReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reason", theReason), currentHashCode, theReason);
        List<Reference> theSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"supportingInformation", theSupportingInformation), currentHashCode, theSupportingInformation);
        List<Reference> theSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"specimen", theSpecimen), currentHashCode, theSpecimen);
        List<DiagnosticOrderEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"event", theEvent), currentHashCode, theEvent);
        List<DiagnosticOrderItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"item", theItem), currentHashCode, theItem);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"note", theNote), currentHashCode, theNote);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        DiagnosticOrderStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        DiagnosticOrderPriority thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, (Object)thePriority);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        Reference theOrderer = this.getOrderer();
        strategy.appendField(locator, (Object)this, "orderer", buffer, (Object)theOrderer);
        List<CodeableConcept> theReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        strategy.appendField(locator, (Object)this, "reason", buffer, theReason);
        List<Reference> theSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        strategy.appendField(locator, (Object)this, "supportingInformation", buffer, theSupportingInformation);
        List<Reference> theSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        strategy.appendField(locator, (Object)this, "specimen", buffer, theSpecimen);
        List<DiagnosticOrderEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        strategy.appendField(locator, (Object)this, "event", buffer, theEvent);
        List<DiagnosticOrderItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        strategy.appendField(locator, (Object)this, "item", buffer, theItem);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote);
        return buffer;
    }
}

