/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Duration;
import org.hl7.fhir.EncounterClass;
import org.hl7.fhir.EncounterHospitalization;
import org.hl7.fhir.EncounterLocation;
import org.hl7.fhir.EncounterParticipant;
import org.hl7.fhir.EncounterState;
import org.hl7.fhir.EncounterStatusHistory;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Encounter", propOrder={"identifier", "status", "statusHistory", "clazz", "type", "priority", "patient", "episodeOfCare", "incomingReferral", "participant", "appointment", "period", "length", "reason", "indication", "hospitalization", "location", "serviceProvider", "partOf"})
public class Encounter
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected EncounterState status;
    protected List<EncounterStatusHistory> statusHistory;
    @XmlElement(name="class")
    protected EncounterClass clazz;
    protected List<CodeableConcept> type;
    protected CodeableConcept priority;
    protected Reference patient;
    protected List<Reference> episodeOfCare;
    protected List<Reference> incomingReferral;
    protected List<EncounterParticipant> participant;
    protected Reference appointment;
    protected Period period;
    protected Duration length;
    protected List<CodeableConcept> reason;
    protected List<Reference> indication;
    protected EncounterHospitalization hospitalization;
    protected List<EncounterLocation> location;
    protected Reference serviceProvider;
    protected Reference partOf;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public EncounterState getStatus() {
        return this.status;
    }

    public void setStatus(EncounterState value) {
        this.status = value;
    }

    public List<EncounterStatusHistory> getStatusHistory() {
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<EncounterStatusHistory>();
        }
        return this.statusHistory;
    }

    public EncounterClass getClazz() {
        return this.clazz;
    }

    public void setClazz(EncounterClass value) {
        this.clazz = value;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public CodeableConcept getPriority() {
        return this.priority;
    }

    public void setPriority(CodeableConcept value) {
        this.priority = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public List<Reference> getEpisodeOfCare() {
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        return this.episodeOfCare;
    }

    public List<Reference> getIncomingReferral() {
        if (this.incomingReferral == null) {
            this.incomingReferral = new ArrayList<Reference>();
        }
        return this.incomingReferral;
    }

    public List<EncounterParticipant> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipant>();
        }
        return this.participant;
    }

    public Reference getAppointment() {
        return this.appointment;
    }

    public void setAppointment(Reference value) {
        this.appointment = value;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public Duration getLength() {
        return this.length;
    }

    public void setLength(Duration value) {
        this.length = value;
    }

    public List<CodeableConcept> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        return this.reason;
    }

    public List<Reference> getIndication() {
        if (this.indication == null) {
            this.indication = new ArrayList<Reference>();
        }
        return this.indication;
    }

    public EncounterHospitalization getHospitalization() {
        return this.hospitalization;
    }

    public void setHospitalization(EncounterHospitalization value) {
        this.hospitalization = value;
    }

    public List<EncounterLocation> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocation>();
        }
        return this.location;
    }

    public Reference getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(Reference value) {
        this.serviceProvider = value;
    }

    public Reference getPartOf() {
        return this.partOf;
    }

    public void setPartOf(Reference value) {
        this.partOf = value;
    }

    public Encounter withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Encounter withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Encounter withStatus(EncounterState value) {
        this.setStatus(value);
        return this;
    }

    public Encounter withStatusHistory(EncounterStatusHistory ... values) {
        if (values != null) {
            for (EncounterStatusHistory value : values) {
                this.getStatusHistory().add(value);
            }
        }
        return this;
    }

    public Encounter withStatusHistory(Collection<EncounterStatusHistory> values) {
        if (values != null) {
            this.getStatusHistory().addAll(values);
        }
        return this;
    }

    public Encounter withClazz(EncounterClass value) {
        this.setClazz(value);
        return this;
    }

    public Encounter withType(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getType().add(value);
            }
        }
        return this;
    }

    public Encounter withType(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getType().addAll(values);
        }
        return this;
    }

    public Encounter withPriority(CodeableConcept value) {
        this.setPriority(value);
        return this;
    }

    public Encounter withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public Encounter withEpisodeOfCare(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getEpisodeOfCare().add(value);
            }
        }
        return this;
    }

    public Encounter withEpisodeOfCare(Collection<Reference> values) {
        if (values != null) {
            this.getEpisodeOfCare().addAll(values);
        }
        return this;
    }

    public Encounter withIncomingReferral(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getIncomingReferral().add(value);
            }
        }
        return this;
    }

    public Encounter withIncomingReferral(Collection<Reference> values) {
        if (values != null) {
            this.getIncomingReferral().addAll(values);
        }
        return this;
    }

    public Encounter withParticipant(EncounterParticipant ... values) {
        if (values != null) {
            for (EncounterParticipant value : values) {
                this.getParticipant().add(value);
            }
        }
        return this;
    }

    public Encounter withParticipant(Collection<EncounterParticipant> values) {
        if (values != null) {
            this.getParticipant().addAll(values);
        }
        return this;
    }

    public Encounter withAppointment(Reference value) {
        this.setAppointment(value);
        return this;
    }

    public Encounter withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    public Encounter withLength(Duration value) {
        this.setLength(value);
        return this;
    }

    public Encounter withReason(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReason().add(value);
            }
        }
        return this;
    }

    public Encounter withReason(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReason().addAll(values);
        }
        return this;
    }

    public Encounter withIndication(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getIndication().add(value);
            }
        }
        return this;
    }

    public Encounter withIndication(Collection<Reference> values) {
        if (values != null) {
            this.getIndication().addAll(values);
        }
        return this;
    }

    public Encounter withHospitalization(EncounterHospitalization value) {
        this.setHospitalization(value);
        return this;
    }

    public Encounter withLocation(EncounterLocation ... values) {
        if (values != null) {
            for (EncounterLocation value : values) {
                this.getLocation().add(value);
            }
        }
        return this;
    }

    public Encounter withLocation(Collection<EncounterLocation> values) {
        if (values != null) {
            this.getLocation().addAll(values);
        }
        return this;
    }

    public Encounter withServiceProvider(Reference value) {
        this.setServiceProvider(value);
        return this;
    }

    public Encounter withPartOf(Reference value) {
        this.setPartOf(value);
        return this;
    }

    @Override
    public Encounter withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Encounter withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Encounter withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Encounter withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Encounter withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Encounter withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Encounter withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Encounter withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Encounter withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Encounter withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Encounter withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<EncounterLocation> rhsLocation;
        List<Reference> rhsIndication;
        List<CodeableConcept> rhsReason;
        List<EncounterParticipant> rhsParticipant;
        List<Reference> rhsIncomingReferral;
        List<Reference> rhsEpisodeOfCare;
        List<CodeableConcept> rhsType;
        List<EncounterStatusHistory> rhsStatusHistory;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof Encounter)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Encounter that = (Encounter)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        EncounterState lhsStatus = this.getStatus();
        EncounterState rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        List<EncounterStatusHistory> lhsStatusHistory = this.statusHistory != null && !this.statusHistory.isEmpty() ? this.getStatusHistory() : null;
        List<EncounterStatusHistory> list2 = rhsStatusHistory = that.statusHistory != null && !that.statusHistory.isEmpty() ? that.getStatusHistory() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"statusHistory", lhsStatusHistory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"statusHistory", rhsStatusHistory), lhsStatusHistory, rhsStatusHistory)) {
            return false;
        }
        EncounterClass lhsClazz = this.getClazz();
        EncounterClass rhsClazz = that.getClazz();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"clazz", (Object)lhsClazz), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"clazz", (Object)rhsClazz), (Object)lhsClazz, (Object)rhsClazz)) {
            return false;
        }
        List<CodeableConcept> lhsType = this.type != null && !this.type.isEmpty() ? this.getType() : null;
        List<CodeableConcept> list3 = rhsType = that.type != null && !that.type.isEmpty() ? that.getType() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"type", lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"type", rhsType), lhsType, rhsType)) {
            return false;
        }
        CodeableConcept lhsPriority = this.getPriority();
        CodeableConcept rhsPriority = that.getPriority();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"priority", (Object)lhsPriority), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"priority", (Object)rhsPriority), (Object)lhsPriority, (Object)rhsPriority)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        List<Reference> lhsEpisodeOfCare = this.episodeOfCare != null && !this.episodeOfCare.isEmpty() ? this.getEpisodeOfCare() : null;
        List<Reference> list4 = rhsEpisodeOfCare = that.episodeOfCare != null && !that.episodeOfCare.isEmpty() ? that.getEpisodeOfCare() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"episodeOfCare", lhsEpisodeOfCare), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"episodeOfCare", rhsEpisodeOfCare), lhsEpisodeOfCare, rhsEpisodeOfCare)) {
            return false;
        }
        List<Reference> lhsIncomingReferral = this.incomingReferral != null && !this.incomingReferral.isEmpty() ? this.getIncomingReferral() : null;
        List<Reference> list5 = rhsIncomingReferral = that.incomingReferral != null && !that.incomingReferral.isEmpty() ? that.getIncomingReferral() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"incomingReferral", lhsIncomingReferral), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"incomingReferral", rhsIncomingReferral), lhsIncomingReferral, rhsIncomingReferral)) {
            return false;
        }
        List<EncounterParticipant> lhsParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        List<EncounterParticipant> list6 = rhsParticipant = that.participant != null && !that.participant.isEmpty() ? that.getParticipant() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"participant", lhsParticipant), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"participant", rhsParticipant), lhsParticipant, rhsParticipant)) {
            return false;
        }
        Reference lhsAppointment = this.getAppointment();
        Reference rhsAppointment = that.getAppointment();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"appointment", (Object)lhsAppointment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"appointment", (Object)rhsAppointment), (Object)lhsAppointment, (Object)rhsAppointment)) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"period", (Object)lhsPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"period", (Object)rhsPeriod), (Object)lhsPeriod, (Object)rhsPeriod)) {
            return false;
        }
        Duration lhsLength = this.getLength();
        Duration rhsLength = that.getLength();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"length", (Object)lhsLength), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"length", (Object)rhsLength), (Object)lhsLength, (Object)rhsLength)) {
            return false;
        }
        List<CodeableConcept> lhsReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        List<CodeableConcept> list7 = rhsReason = that.reason != null && !that.reason.isEmpty() ? that.getReason() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reason", lhsReason), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reason", rhsReason), lhsReason, rhsReason)) {
            return false;
        }
        List<Reference> lhsIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        List<Reference> list8 = rhsIndication = that.indication != null && !that.indication.isEmpty() ? that.getIndication() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"indication", lhsIndication), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"indication", rhsIndication), lhsIndication, rhsIndication)) {
            return false;
        }
        EncounterHospitalization lhsHospitalization = this.getHospitalization();
        EncounterHospitalization rhsHospitalization = that.getHospitalization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"hospitalization", (Object)lhsHospitalization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"hospitalization", (Object)rhsHospitalization), (Object)lhsHospitalization, (Object)rhsHospitalization)) {
            return false;
        }
        List<EncounterLocation> lhsLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        List<EncounterLocation> list9 = rhsLocation = that.location != null && !that.location.isEmpty() ? that.getLocation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"location", lhsLocation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"location", rhsLocation), lhsLocation, rhsLocation)) {
            return false;
        }
        Reference lhsServiceProvider = this.getServiceProvider();
        Reference rhsServiceProvider = that.getServiceProvider();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"serviceProvider", (Object)lhsServiceProvider), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"serviceProvider", (Object)rhsServiceProvider), (Object)lhsServiceProvider, (Object)rhsServiceProvider)) {
            return false;
        }
        Reference lhsPartOf = this.getPartOf();
        Reference rhsPartOf = that.getPartOf();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"partOf", (Object)lhsPartOf), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"partOf", (Object)rhsPartOf), (Object)lhsPartOf, (Object)rhsPartOf);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        EncounterState theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        List<EncounterStatusHistory> theStatusHistory = this.statusHistory != null && !this.statusHistory.isEmpty() ? this.getStatusHistory() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"statusHistory", theStatusHistory), currentHashCode, theStatusHistory);
        EncounterClass theClazz = this.getClazz();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"clazz", (Object)theClazz), currentHashCode, (Object)theClazz);
        List<CodeableConcept> theType = this.type != null && !this.type.isEmpty() ? this.getType() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"type", theType), currentHashCode, theType);
        CodeableConcept thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"priority", (Object)thePriority), currentHashCode, (Object)thePriority);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        List<Reference> theEpisodeOfCare = this.episodeOfCare != null && !this.episodeOfCare.isEmpty() ? this.getEpisodeOfCare() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"episodeOfCare", theEpisodeOfCare), currentHashCode, theEpisodeOfCare);
        List<Reference> theIncomingReferral = this.incomingReferral != null && !this.incomingReferral.isEmpty() ? this.getIncomingReferral() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"incomingReferral", theIncomingReferral), currentHashCode, theIncomingReferral);
        List<EncounterParticipant> theParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"participant", theParticipant), currentHashCode, theParticipant);
        Reference theAppointment = this.getAppointment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"appointment", (Object)theAppointment), currentHashCode, (Object)theAppointment);
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"period", (Object)thePeriod), currentHashCode, (Object)thePeriod);
        Duration theLength = this.getLength();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"length", (Object)theLength), currentHashCode, (Object)theLength);
        List<CodeableConcept> theReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reason", theReason), currentHashCode, theReason);
        List<Reference> theIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"indication", theIndication), currentHashCode, theIndication);
        EncounterHospitalization theHospitalization = this.getHospitalization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"hospitalization", (Object)theHospitalization), currentHashCode, (Object)theHospitalization);
        List<EncounterLocation> theLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"location", theLocation), currentHashCode, theLocation);
        Reference theServiceProvider = this.getServiceProvider();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"serviceProvider", (Object)theServiceProvider), currentHashCode, (Object)theServiceProvider);
        Reference thePartOf = this.getPartOf();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"partOf", (Object)thePartOf), currentHashCode, (Object)thePartOf);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        EncounterState theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        List<EncounterStatusHistory> theStatusHistory = this.statusHistory != null && !this.statusHistory.isEmpty() ? this.getStatusHistory() : null;
        strategy.appendField(locator, (Object)this, "statusHistory", buffer, theStatusHistory);
        EncounterClass theClazz = this.getClazz();
        strategy.appendField(locator, (Object)this, "clazz", buffer, (Object)theClazz);
        List<CodeableConcept> theType = this.type != null && !this.type.isEmpty() ? this.getType() : null;
        strategy.appendField(locator, (Object)this, "type", buffer, theType);
        CodeableConcept thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, (Object)thePriority);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        List<Reference> theEpisodeOfCare = this.episodeOfCare != null && !this.episodeOfCare.isEmpty() ? this.getEpisodeOfCare() : null;
        strategy.appendField(locator, (Object)this, "episodeOfCare", buffer, theEpisodeOfCare);
        List<Reference> theIncomingReferral = this.incomingReferral != null && !this.incomingReferral.isEmpty() ? this.getIncomingReferral() : null;
        strategy.appendField(locator, (Object)this, "incomingReferral", buffer, theIncomingReferral);
        List<EncounterParticipant> theParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        strategy.appendField(locator, (Object)this, "participant", buffer, theParticipant);
        Reference theAppointment = this.getAppointment();
        strategy.appendField(locator, (Object)this, "appointment", buffer, (Object)theAppointment);
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, (Object)thePeriod);
        Duration theLength = this.getLength();
        strategy.appendField(locator, (Object)this, "length", buffer, (Object)theLength);
        List<CodeableConcept> theReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        strategy.appendField(locator, (Object)this, "reason", buffer, theReason);
        List<Reference> theIndication = this.indication != null && !this.indication.isEmpty() ? this.getIndication() : null;
        strategy.appendField(locator, (Object)this, "indication", buffer, theIndication);
        EncounterHospitalization theHospitalization = this.getHospitalization();
        strategy.appendField(locator, (Object)this, "hospitalization", buffer, (Object)theHospitalization);
        List<EncounterLocation> theLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        strategy.appendField(locator, (Object)this, "location", buffer, theLocation);
        Reference theServiceProvider = this.getServiceProvider();
        strategy.appendField(locator, (Object)this, "serviceProvider", buffer, (Object)theServiceProvider);
        Reference thePartOf = this.getPartOf();
        strategy.appendField(locator, (Object)this, "partOf", buffer, (Object)thePartOf);
        return buffer;
    }
}

