/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeSystemConcept;
import org.hl7.fhir.CodeSystemContact;
import org.hl7.fhir.CodeSystemContentMode;
import org.hl7.fhir.CodeSystemFilter;
import org.hl7.fhir.CodeSystemProperty;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.UnsignedInt;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CodeSystem", propOrder={"url", "identifier", "version", "name", "status", "experimental", "publisher", "contact", "date", "description", "useContext", "requirements", "copyright", "caseSensitive", "valueSet", "compositional", "versionNeeded", "content", "count", "filter", "property", "concept"})
public class CodeSystem
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Uri url;
    protected Identifier identifier;
    protected String version;
    protected String name;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected String publisher;
    protected List<CodeSystemContact> contact;
    protected DateTime date;
    protected String description;
    protected List<CodeableConcept> useContext;
    protected String requirements;
    protected String copyright;
    protected Boolean caseSensitive;
    protected Uri valueSet;
    protected Boolean compositional;
    protected Boolean versionNeeded;
    @XmlElement(required=true)
    protected CodeSystemContentMode content;
    protected UnsignedInt count;
    protected List<CodeSystemFilter> filter;
    protected List<CodeSystemProperty> property;
    protected List<CodeSystemConcept> concept;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<CodeSystemContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<CodeSystemContact>();
        }
        return this.contact;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(Boolean value) {
        this.caseSensitive = value;
    }

    public Uri getValueSet() {
        return this.valueSet;
    }

    public void setValueSet(Uri value) {
        this.valueSet = value;
    }

    public Boolean getCompositional() {
        return this.compositional;
    }

    public void setCompositional(Boolean value) {
        this.compositional = value;
    }

    public Boolean getVersionNeeded() {
        return this.versionNeeded;
    }

    public void setVersionNeeded(Boolean value) {
        this.versionNeeded = value;
    }

    public CodeSystemContentMode getContent() {
        return this.content;
    }

    public void setContent(CodeSystemContentMode value) {
        this.content = value;
    }

    public UnsignedInt getCount() {
        return this.count;
    }

    public void setCount(UnsignedInt value) {
        this.count = value;
    }

    public List<CodeSystemFilter> getFilter() {
        if (this.filter == null) {
            this.filter = new ArrayList<CodeSystemFilter>();
        }
        return this.filter;
    }

    public List<CodeSystemProperty> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<CodeSystemProperty>();
        }
        return this.property;
    }

    public List<CodeSystemConcept> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<CodeSystemConcept>();
        }
        return this.concept;
    }

    public CodeSystem withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public CodeSystem withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public CodeSystem withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public CodeSystem withName(String value) {
        this.setName(value);
        return this;
    }

    public CodeSystem withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public CodeSystem withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public CodeSystem withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public CodeSystem withContact(CodeSystemContact ... values) {
        if (values != null) {
            for (CodeSystemContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public CodeSystem withContact(Collection<CodeSystemContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public CodeSystem withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public CodeSystem withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public CodeSystem withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public CodeSystem withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public CodeSystem withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public CodeSystem withCopyright(String value) {
        this.setCopyright(value);
        return this;
    }

    public CodeSystem withCaseSensitive(Boolean value) {
        this.setCaseSensitive(value);
        return this;
    }

    public CodeSystem withValueSet(Uri value) {
        this.setValueSet(value);
        return this;
    }

    public CodeSystem withCompositional(Boolean value) {
        this.setCompositional(value);
        return this;
    }

    public CodeSystem withVersionNeeded(Boolean value) {
        this.setVersionNeeded(value);
        return this;
    }

    public CodeSystem withContent(CodeSystemContentMode value) {
        this.setContent(value);
        return this;
    }

    public CodeSystem withCount(UnsignedInt value) {
        this.setCount(value);
        return this;
    }

    public CodeSystem withFilter(CodeSystemFilter ... values) {
        if (values != null) {
            for (CodeSystemFilter value : values) {
                this.getFilter().add(value);
            }
        }
        return this;
    }

    public CodeSystem withFilter(Collection<CodeSystemFilter> values) {
        if (values != null) {
            this.getFilter().addAll(values);
        }
        return this;
    }

    public CodeSystem withProperty(CodeSystemProperty ... values) {
        if (values != null) {
            for (CodeSystemProperty value : values) {
                this.getProperty().add(value);
            }
        }
        return this;
    }

    public CodeSystem withProperty(Collection<CodeSystemProperty> values) {
        if (values != null) {
            this.getProperty().addAll(values);
        }
        return this;
    }

    public CodeSystem withConcept(CodeSystemConcept ... values) {
        if (values != null) {
            for (CodeSystemConcept value : values) {
                this.getConcept().add(value);
            }
        }
        return this;
    }

    public CodeSystem withConcept(Collection<CodeSystemConcept> values) {
        if (values != null) {
            this.getConcept().addAll(values);
        }
        return this;
    }

    @Override
    public CodeSystem withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public CodeSystem withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public CodeSystem withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public CodeSystem withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CodeSystem withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CodeSystem withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CodeSystem withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CodeSystem withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public CodeSystem withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public CodeSystem withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public CodeSystem withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<CodeSystemConcept> rhsConcept;
        List<CodeSystemProperty> rhsProperty;
        List<CodeSystemFilter> rhsFilter;
        List<CodeableConcept> rhsUseContext;
        List<CodeSystemContact> rhsContact;
        if (!(object instanceof CodeSystem)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        CodeSystem that = (CodeSystem)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"url", (Object)lhsUrl), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"url", (Object)rhsUrl), (Object)lhsUrl, (Object)rhsUrl)) {
            return false;
        }
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"experimental", (Object)lhsExperimental), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"experimental", (Object)rhsExperimental), (Object)lhsExperimental, (Object)rhsExperimental)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"publisher", (Object)lhsPublisher), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"publisher", (Object)rhsPublisher), (Object)lhsPublisher, (Object)rhsPublisher)) {
            return false;
        }
        List<CodeSystemContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<CodeSystemContact> list = rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contact", lhsContact), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contact", rhsContact), lhsContact, rhsContact)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription)) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> list2 = rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"useContext", rhsUseContext), lhsUseContext, rhsUseContext)) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requirements", (Object)lhsRequirements), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requirements", (Object)rhsRequirements), (Object)lhsRequirements, (Object)rhsRequirements)) {
            return false;
        }
        String lhsCopyright = this.getCopyright();
        String rhsCopyright = that.getCopyright();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"copyright", (Object)lhsCopyright), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"copyright", (Object)rhsCopyright), (Object)lhsCopyright, (Object)rhsCopyright)) {
            return false;
        }
        Boolean lhsCaseSensitive = this.getCaseSensitive();
        Boolean rhsCaseSensitive = that.getCaseSensitive();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"caseSensitive", (Object)lhsCaseSensitive), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"caseSensitive", (Object)rhsCaseSensitive), (Object)lhsCaseSensitive, (Object)rhsCaseSensitive)) {
            return false;
        }
        Uri lhsValueSet = this.getValueSet();
        Uri rhsValueSet = that.getValueSet();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueSet", (Object)lhsValueSet), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueSet", (Object)rhsValueSet), (Object)lhsValueSet, (Object)rhsValueSet)) {
            return false;
        }
        Boolean lhsCompositional = this.getCompositional();
        Boolean rhsCompositional = that.getCompositional();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"compositional", (Object)lhsCompositional), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"compositional", (Object)rhsCompositional), (Object)lhsCompositional, (Object)rhsCompositional)) {
            return false;
        }
        Boolean lhsVersionNeeded = this.getVersionNeeded();
        Boolean rhsVersionNeeded = that.getVersionNeeded();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"versionNeeded", (Object)lhsVersionNeeded), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"versionNeeded", (Object)rhsVersionNeeded), (Object)lhsVersionNeeded, (Object)rhsVersionNeeded)) {
            return false;
        }
        CodeSystemContentMode lhsContent = this.getContent();
        CodeSystemContentMode rhsContent = that.getContent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"content", (Object)lhsContent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"content", (Object)rhsContent), (Object)lhsContent, (Object)rhsContent)) {
            return false;
        }
        UnsignedInt lhsCount = this.getCount();
        UnsignedInt rhsCount = that.getCount();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"count", (Object)lhsCount), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"count", (Object)rhsCount), (Object)lhsCount, (Object)rhsCount)) {
            return false;
        }
        List<CodeSystemFilter> lhsFilter = this.filter != null && !this.filter.isEmpty() ? this.getFilter() : null;
        List<CodeSystemFilter> list3 = rhsFilter = that.filter != null && !that.filter.isEmpty() ? that.getFilter() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"filter", lhsFilter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"filter", rhsFilter), lhsFilter, rhsFilter)) {
            return false;
        }
        List<CodeSystemProperty> lhsProperty = this.property != null && !this.property.isEmpty() ? this.getProperty() : null;
        List<CodeSystemProperty> list4 = rhsProperty = that.property != null && !that.property.isEmpty() ? that.getProperty() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"property", lhsProperty), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"property", rhsProperty), lhsProperty, rhsProperty)) {
            return false;
        }
        List<CodeSystemConcept> lhsConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        List<CodeSystemConcept> list5 = rhsConcept = that.concept != null && !that.concept.isEmpty() ? that.getConcept() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"concept", lhsConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"concept", rhsConcept), lhsConcept, rhsConcept);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"url", (Object)theUrl), currentHashCode, (Object)theUrl);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"version", (Object)theVersion), currentHashCode, (Object)theVersion);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"experimental", (Object)theExperimental), currentHashCode, (Object)theExperimental);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"publisher", (Object)thePublisher), currentHashCode, (Object)thePublisher);
        List<CodeSystemContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contact", theContact), currentHashCode, theContact);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"useContext", theUseContext), currentHashCode, theUseContext);
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requirements", (Object)theRequirements), currentHashCode, (Object)theRequirements);
        String theCopyright = this.getCopyright();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"copyright", (Object)theCopyright), currentHashCode, (Object)theCopyright);
        Boolean theCaseSensitive = this.getCaseSensitive();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"caseSensitive", (Object)theCaseSensitive), currentHashCode, (Object)theCaseSensitive);
        Uri theValueSet = this.getValueSet();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueSet", (Object)theValueSet), currentHashCode, (Object)theValueSet);
        Boolean theCompositional = this.getCompositional();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"compositional", (Object)theCompositional), currentHashCode, (Object)theCompositional);
        Boolean theVersionNeeded = this.getVersionNeeded();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"versionNeeded", (Object)theVersionNeeded), currentHashCode, (Object)theVersionNeeded);
        CodeSystemContentMode theContent = this.getContent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"content", (Object)theContent), currentHashCode, (Object)theContent);
        UnsignedInt theCount = this.getCount();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"count", (Object)theCount), currentHashCode, (Object)theCount);
        List<CodeSystemFilter> theFilter = this.filter != null && !this.filter.isEmpty() ? this.getFilter() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"filter", theFilter), currentHashCode, theFilter);
        List<CodeSystemProperty> theProperty = this.property != null && !this.property.isEmpty() ? this.getProperty() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"property", theProperty), currentHashCode, theProperty);
        List<CodeSystemConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"concept", theConcept), currentHashCode, theConcept);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, (Object)theUrl);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, (Object)theExperimental);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, (Object)thePublisher);
        List<CodeSystemContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext);
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, (Object)theRequirements);
        String theCopyright = this.getCopyright();
        strategy.appendField(locator, (Object)this, "copyright", buffer, (Object)theCopyright);
        Boolean theCaseSensitive = this.getCaseSensitive();
        strategy.appendField(locator, (Object)this, "caseSensitive", buffer, (Object)theCaseSensitive);
        Uri theValueSet = this.getValueSet();
        strategy.appendField(locator, (Object)this, "valueSet", buffer, (Object)theValueSet);
        Boolean theCompositional = this.getCompositional();
        strategy.appendField(locator, (Object)this, "compositional", buffer, (Object)theCompositional);
        Boolean theVersionNeeded = this.getVersionNeeded();
        strategy.appendField(locator, (Object)this, "versionNeeded", buffer, (Object)theVersionNeeded);
        CodeSystemContentMode theContent = this.getContent();
        strategy.appendField(locator, (Object)this, "content", buffer, (Object)theContent);
        UnsignedInt theCount = this.getCount();
        strategy.appendField(locator, (Object)this, "count", buffer, (Object)theCount);
        List<CodeSystemFilter> theFilter = this.filter != null && !this.filter.isEmpty() ? this.getFilter() : null;
        strategy.appendField(locator, (Object)this, "filter", buffer, theFilter);
        List<CodeSystemProperty> theProperty = this.property != null && !this.property.isEmpty() ? this.getProperty() : null;
        strategy.appendField(locator, (Object)this, "property", buffer, theProperty);
        List<CodeSystemConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        strategy.appendField(locator, (Object)this, "concept", buffer, theConcept);
        return buffer;
    }
}

