/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.CompositionAttester;
import org.hl7.fhir.CompositionEvent;
import org.hl7.fhir.CompositionSection;
import org.hl7.fhir.CompositionStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Composition", propOrder={"identifier", "date", "type", "clazz", "title", "status", "confidentiality", "subject", "author", "attester", "custodian", "event", "encounter", "section"})
public class Composition
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Identifier identifier;
    @XmlElement(required=true)
    protected DateTime date;
    @XmlElement(required=true)
    protected CodeableConcept type;
    @XmlElement(name="class")
    protected CodeableConcept clazz;
    @XmlElement(required=true)
    protected String title;
    @XmlElement(required=true)
    protected CompositionStatus status;
    protected Code confidentiality;
    @XmlElement(required=true)
    protected Reference subject;
    @XmlElement(required=true)
    protected List<Reference> author;
    protected List<CompositionAttester> attester;
    protected Reference custodian;
    protected List<CompositionEvent> event;
    protected Reference encounter;
    protected List<CompositionSection> section;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public CodeableConcept getClazz() {
        return this.clazz;
    }

    public void setClazz(CodeableConcept value) {
        this.clazz = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public CompositionStatus getStatus() {
        return this.status;
    }

    public void setStatus(CompositionStatus value) {
        this.status = value;
    }

    public Code getConfidentiality() {
        return this.confidentiality;
    }

    public void setConfidentiality(Code value) {
        this.confidentiality = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public List<CompositionAttester> getAttester() {
        if (this.attester == null) {
            this.attester = new ArrayList<CompositionAttester>();
        }
        return this.attester;
    }

    public Reference getCustodian() {
        return this.custodian;
    }

    public void setCustodian(Reference value) {
        this.custodian = value;
    }

    public List<CompositionEvent> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<CompositionEvent>();
        }
        return this.event;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public List<CompositionSection> getSection() {
        if (this.section == null) {
            this.section = new ArrayList<CompositionSection>();
        }
        return this.section;
    }

    public Composition withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public Composition withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public Composition withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Composition withClazz(CodeableConcept value) {
        this.setClazz(value);
        return this;
    }

    public Composition withTitle(String value) {
        this.setTitle(value);
        return this;
    }

    public Composition withStatus(CompositionStatus value) {
        this.setStatus(value);
        return this;
    }

    public Composition withConfidentiality(Code value) {
        this.setConfidentiality(value);
        return this;
    }

    public Composition withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public Composition withAuthor(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAuthor().add(value);
            }
        }
        return this;
    }

    public Composition withAuthor(Collection<Reference> values) {
        if (values != null) {
            this.getAuthor().addAll(values);
        }
        return this;
    }

    public Composition withAttester(CompositionAttester ... values) {
        if (values != null) {
            for (CompositionAttester value : values) {
                this.getAttester().add(value);
            }
        }
        return this;
    }

    public Composition withAttester(Collection<CompositionAttester> values) {
        if (values != null) {
            this.getAttester().addAll(values);
        }
        return this;
    }

    public Composition withCustodian(Reference value) {
        this.setCustodian(value);
        return this;
    }

    public Composition withEvent(CompositionEvent ... values) {
        if (values != null) {
            for (CompositionEvent value : values) {
                this.getEvent().add(value);
            }
        }
        return this;
    }

    public Composition withEvent(Collection<CompositionEvent> values) {
        if (values != null) {
            this.getEvent().addAll(values);
        }
        return this;
    }

    public Composition withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public Composition withSection(CompositionSection ... values) {
        if (values != null) {
            for (CompositionSection value : values) {
                this.getSection().add(value);
            }
        }
        return this;
    }

    public Composition withSection(Collection<CompositionSection> values) {
        if (values != null) {
            this.getSection().addAll(values);
        }
        return this;
    }

    @Override
    public Composition withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Composition withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Composition withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Composition withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Composition withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Composition withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Composition withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Composition withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Composition withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Composition withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Composition withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<CompositionSection> rhsSection;
        List<CompositionEvent> rhsEvent;
        List<CompositionAttester> rhsAttester;
        List<Reference> rhsAuthor;
        if (!(object instanceof Composition)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Composition that = (Composition)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        CodeableConcept lhsClazz = this.getClazz();
        CodeableConcept rhsClazz = that.getClazz();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"clazz", (Object)lhsClazz), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"clazz", (Object)rhsClazz), (Object)lhsClazz, (Object)rhsClazz)) {
            return false;
        }
        String lhsTitle = this.getTitle();
        String rhsTitle = that.getTitle();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"title", (Object)lhsTitle), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"title", (Object)rhsTitle), (Object)lhsTitle, (Object)rhsTitle)) {
            return false;
        }
        CompositionStatus lhsStatus = this.getStatus();
        CompositionStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        Code lhsConfidentiality = this.getConfidentiality();
        Code rhsConfidentiality = that.getConfidentiality();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"confidentiality", (Object)lhsConfidentiality), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"confidentiality", (Object)rhsConfidentiality), (Object)lhsConfidentiality, (Object)rhsConfidentiality)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject)) {
            return false;
        }
        List<Reference> lhsAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        List<Reference> list = rhsAuthor = that.author != null && !that.author.isEmpty() ? that.getAuthor() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"author", lhsAuthor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"author", rhsAuthor), lhsAuthor, rhsAuthor)) {
            return false;
        }
        List<CompositionAttester> lhsAttester = this.attester != null && !this.attester.isEmpty() ? this.getAttester() : null;
        List<CompositionAttester> list2 = rhsAttester = that.attester != null && !that.attester.isEmpty() ? that.getAttester() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"attester", lhsAttester), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"attester", rhsAttester), lhsAttester, rhsAttester)) {
            return false;
        }
        Reference lhsCustodian = this.getCustodian();
        Reference rhsCustodian = that.getCustodian();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"custodian", (Object)lhsCustodian), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"custodian", (Object)rhsCustodian), (Object)lhsCustodian, (Object)rhsCustodian)) {
            return false;
        }
        List<CompositionEvent> lhsEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        List<CompositionEvent> list3 = rhsEvent = that.event != null && !that.event.isEmpty() ? that.getEvent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"event", lhsEvent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"event", rhsEvent), lhsEvent, rhsEvent)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        List<CompositionSection> lhsSection = this.section != null && !this.section.isEmpty() ? this.getSection() : null;
        List<CompositionSection> list4 = rhsSection = that.section != null && !that.section.isEmpty() ? that.getSection() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"section", lhsSection), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"section", rhsSection), lhsSection, rhsSection);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        CodeableConcept theClazz = this.getClazz();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"clazz", (Object)theClazz), currentHashCode, (Object)theClazz);
        String theTitle = this.getTitle();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"title", (Object)theTitle), currentHashCode, (Object)theTitle);
        CompositionStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        Code theConfidentiality = this.getConfidentiality();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"confidentiality", (Object)theConfidentiality), currentHashCode, (Object)theConfidentiality);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"author", theAuthor), currentHashCode, theAuthor);
        List<CompositionAttester> theAttester = this.attester != null && !this.attester.isEmpty() ? this.getAttester() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"attester", theAttester), currentHashCode, theAttester);
        Reference theCustodian = this.getCustodian();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"custodian", (Object)theCustodian), currentHashCode, (Object)theCustodian);
        List<CompositionEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"event", theEvent), currentHashCode, theEvent);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        List<CompositionSection> theSection = this.section != null && !this.section.isEmpty() ? this.getSection() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"section", theSection), currentHashCode, theSection);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        CodeableConcept theClazz = this.getClazz();
        strategy.appendField(locator, (Object)this, "clazz", buffer, (Object)theClazz);
        String theTitle = this.getTitle();
        strategy.appendField(locator, (Object)this, "title", buffer, (Object)theTitle);
        CompositionStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        Code theConfidentiality = this.getConfidentiality();
        strategy.appendField(locator, (Object)this, "confidentiality", buffer, (Object)theConfidentiality);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        strategy.appendField(locator, (Object)this, "author", buffer, theAuthor);
        List<CompositionAttester> theAttester = this.attester != null && !this.attester.isEmpty() ? this.getAttester() : null;
        strategy.appendField(locator, (Object)this, "attester", buffer, theAttester);
        Reference theCustodian = this.getCustodian();
        strategy.appendField(locator, (Object)this, "custodian", buffer, (Object)theCustodian);
        List<CompositionEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        strategy.appendField(locator, (Object)this, "event", buffer, theEvent);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        List<CompositionSection> theSection = this.section != null && !this.section.isEmpty() ? this.getSection() : null;
        strategy.appendField(locator, (Object)this, "section", buffer, theSection);
        return buffer;
    }
}

