/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MedicationOrderDispenseRequest;
import org.hl7.fhir.MedicationOrderDosageInstruction;
import org.hl7.fhir.MedicationOrderStatus;
import org.hl7.fhir.MedicationOrderSubstitution;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationOrder", propOrder={"identifier", "status", "medicationCodeableConcept", "medicationReference", "patient", "encounter", "dateWritten", "prescriber", "reasonCode", "reasonReference", "dateEnded", "reasonEnded", "note", "dosageInstruction", "dispenseRequest", "substitution", "priorPrescription"})
public class MedicationOrder
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    protected MedicationOrderStatus status;
    protected CodeableConcept medicationCodeableConcept;
    protected Reference medicationReference;
    protected Reference patient;
    protected Reference encounter;
    protected DateTime dateWritten;
    protected Reference prescriber;
    protected List<CodeableConcept> reasonCode;
    protected List<Reference> reasonReference;
    protected DateTime dateEnded;
    protected CodeableConcept reasonEnded;
    protected List<Annotation> note;
    protected List<MedicationOrderDosageInstruction> dosageInstruction;
    protected MedicationOrderDispenseRequest dispenseRequest;
    protected MedicationOrderSubstitution substitution;
    protected Reference priorPrescription;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationOrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(MedicationOrderStatus value) {
        this.status = value;
    }

    public CodeableConcept getMedicationCodeableConcept() {
        return this.medicationCodeableConcept;
    }

    public void setMedicationCodeableConcept(CodeableConcept value) {
        this.medicationCodeableConcept = value;
    }

    public Reference getMedicationReference() {
        return this.medicationReference;
    }

    public void setMedicationReference(Reference value) {
        this.medicationReference = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public DateTime getDateWritten() {
        return this.dateWritten;
    }

    public void setDateWritten(DateTime value) {
        this.dateWritten = value;
    }

    public Reference getPrescriber() {
        return this.prescriber;
    }

    public void setPrescriber(Reference value) {
        this.prescriber = value;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public DateTime getDateEnded() {
        return this.dateEnded;
    }

    public void setDateEnded(DateTime value) {
        this.dateEnded = value;
    }

    public CodeableConcept getReasonEnded() {
        return this.reasonEnded;
    }

    public void setReasonEnded(CodeableConcept value) {
        this.reasonEnded = value;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public List<MedicationOrderDosageInstruction> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<MedicationOrderDosageInstruction>();
        }
        return this.dosageInstruction;
    }

    public MedicationOrderDispenseRequest getDispenseRequest() {
        return this.dispenseRequest;
    }

    public void setDispenseRequest(MedicationOrderDispenseRequest value) {
        this.dispenseRequest = value;
    }

    public MedicationOrderSubstitution getSubstitution() {
        return this.substitution;
    }

    public void setSubstitution(MedicationOrderSubstitution value) {
        this.substitution = value;
    }

    public Reference getPriorPrescription() {
        return this.priorPrescription;
    }

    public void setPriorPrescription(Reference value) {
        this.priorPrescription = value;
    }

    public MedicationOrder withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public MedicationOrder withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public MedicationOrder withStatus(MedicationOrderStatus value) {
        this.setStatus(value);
        return this;
    }

    public MedicationOrder withMedicationCodeableConcept(CodeableConcept value) {
        this.setMedicationCodeableConcept(value);
        return this;
    }

    public MedicationOrder withMedicationReference(Reference value) {
        this.setMedicationReference(value);
        return this;
    }

    public MedicationOrder withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public MedicationOrder withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public MedicationOrder withDateWritten(DateTime value) {
        this.setDateWritten(value);
        return this;
    }

    public MedicationOrder withPrescriber(Reference value) {
        this.setPrescriber(value);
        return this;
    }

    public MedicationOrder withReasonCode(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReasonCode().add(value);
            }
        }
        return this;
    }

    public MedicationOrder withReasonCode(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReasonCode().addAll(values);
        }
        return this;
    }

    public MedicationOrder withReasonReference(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getReasonReference().add(value);
            }
        }
        return this;
    }

    public MedicationOrder withReasonReference(Collection<Reference> values) {
        if (values != null) {
            this.getReasonReference().addAll(values);
        }
        return this;
    }

    public MedicationOrder withDateEnded(DateTime value) {
        this.setDateEnded(value);
        return this;
    }

    public MedicationOrder withReasonEnded(CodeableConcept value) {
        this.setReasonEnded(value);
        return this;
    }

    public MedicationOrder withNote(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public MedicationOrder withNote(Collection<Annotation> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    public MedicationOrder withDosageInstruction(MedicationOrderDosageInstruction ... values) {
        if (values != null) {
            for (MedicationOrderDosageInstruction value : values) {
                this.getDosageInstruction().add(value);
            }
        }
        return this;
    }

    public MedicationOrder withDosageInstruction(Collection<MedicationOrderDosageInstruction> values) {
        if (values != null) {
            this.getDosageInstruction().addAll(values);
        }
        return this;
    }

    public MedicationOrder withDispenseRequest(MedicationOrderDispenseRequest value) {
        this.setDispenseRequest(value);
        return this;
    }

    public MedicationOrder withSubstitution(MedicationOrderSubstitution value) {
        this.setSubstitution(value);
        return this;
    }

    public MedicationOrder withPriorPrescription(Reference value) {
        this.setPriorPrescription(value);
        return this;
    }

    @Override
    public MedicationOrder withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MedicationOrder withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationOrder withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationOrder withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationOrder withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationOrder withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationOrder withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationOrder withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MedicationOrder withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MedicationOrder withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MedicationOrder withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<MedicationOrderDosageInstruction> rhsDosageInstruction;
        List<Annotation> rhsNote;
        List<Reference> rhsReasonReference;
        List<CodeableConcept> rhsReasonCode;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof MedicationOrder)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationOrder that = (MedicationOrder)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        MedicationOrderStatus lhsStatus = this.getStatus();
        MedicationOrderStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        CodeableConcept lhsMedicationCodeableConcept = this.getMedicationCodeableConcept();
        CodeableConcept rhsMedicationCodeableConcept = that.getMedicationCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"medicationCodeableConcept", (Object)lhsMedicationCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"medicationCodeableConcept", (Object)rhsMedicationCodeableConcept), (Object)lhsMedicationCodeableConcept, (Object)rhsMedicationCodeableConcept)) {
            return false;
        }
        Reference lhsMedicationReference = this.getMedicationReference();
        Reference rhsMedicationReference = that.getMedicationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"medicationReference", (Object)lhsMedicationReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"medicationReference", (Object)rhsMedicationReference), (Object)lhsMedicationReference, (Object)rhsMedicationReference)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter)) {
            return false;
        }
        DateTime lhsDateWritten = this.getDateWritten();
        DateTime rhsDateWritten = that.getDateWritten();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dateWritten", (Object)lhsDateWritten), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dateWritten", (Object)rhsDateWritten), (Object)lhsDateWritten, (Object)rhsDateWritten)) {
            return false;
        }
        Reference lhsPrescriber = this.getPrescriber();
        Reference rhsPrescriber = that.getPrescriber();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"prescriber", (Object)lhsPrescriber), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"prescriber", (Object)rhsPrescriber), (Object)lhsPrescriber, (Object)rhsPrescriber)) {
            return false;
        }
        List<CodeableConcept> lhsReasonCode = this.reasonCode != null && !this.reasonCode.isEmpty() ? this.getReasonCode() : null;
        List<CodeableConcept> list2 = rhsReasonCode = that.reasonCode != null && !that.reasonCode.isEmpty() ? that.getReasonCode() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reasonCode", lhsReasonCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reasonCode", rhsReasonCode), lhsReasonCode, rhsReasonCode)) {
            return false;
        }
        List<Reference> lhsReasonReference = this.reasonReference != null && !this.reasonReference.isEmpty() ? this.getReasonReference() : null;
        List<Reference> list3 = rhsReasonReference = that.reasonReference != null && !that.reasonReference.isEmpty() ? that.getReasonReference() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reasonReference", lhsReasonReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reasonReference", rhsReasonReference), lhsReasonReference, rhsReasonReference)) {
            return false;
        }
        DateTime lhsDateEnded = this.getDateEnded();
        DateTime rhsDateEnded = that.getDateEnded();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dateEnded", (Object)lhsDateEnded), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dateEnded", (Object)rhsDateEnded), (Object)lhsDateEnded, (Object)rhsDateEnded)) {
            return false;
        }
        CodeableConcept lhsReasonEnded = this.getReasonEnded();
        CodeableConcept rhsReasonEnded = that.getReasonEnded();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reasonEnded", (Object)lhsReasonEnded), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reasonEnded", (Object)rhsReasonEnded), (Object)lhsReasonEnded, (Object)rhsReasonEnded)) {
            return false;
        }
        List<Annotation> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<Annotation> list4 = rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"note", lhsNote), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"note", rhsNote), lhsNote, rhsNote)) {
            return false;
        }
        List<MedicationOrderDosageInstruction> lhsDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        List<MedicationOrderDosageInstruction> list5 = rhsDosageInstruction = that.dosageInstruction != null && !that.dosageInstruction.isEmpty() ? that.getDosageInstruction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dosageInstruction", lhsDosageInstruction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dosageInstruction", rhsDosageInstruction), lhsDosageInstruction, rhsDosageInstruction)) {
            return false;
        }
        MedicationOrderDispenseRequest lhsDispenseRequest = this.getDispenseRequest();
        MedicationOrderDispenseRequest rhsDispenseRequest = that.getDispenseRequest();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dispenseRequest", (Object)lhsDispenseRequest), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dispenseRequest", (Object)rhsDispenseRequest), (Object)lhsDispenseRequest, (Object)rhsDispenseRequest)) {
            return false;
        }
        MedicationOrderSubstitution lhsSubstitution = this.getSubstitution();
        MedicationOrderSubstitution rhsSubstitution = that.getSubstitution();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"substitution", (Object)lhsSubstitution), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"substitution", (Object)rhsSubstitution), (Object)lhsSubstitution, (Object)rhsSubstitution)) {
            return false;
        }
        Reference lhsPriorPrescription = this.getPriorPrescription();
        Reference rhsPriorPrescription = that.getPriorPrescription();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"priorPrescription", (Object)lhsPriorPrescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"priorPrescription", (Object)rhsPriorPrescription), (Object)lhsPriorPrescription, (Object)rhsPriorPrescription);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        MedicationOrderStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"medicationCodeableConcept", (Object)theMedicationCodeableConcept), currentHashCode, (Object)theMedicationCodeableConcept);
        Reference theMedicationReference = this.getMedicationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"medicationReference", (Object)theMedicationReference), currentHashCode, (Object)theMedicationReference);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter);
        DateTime theDateWritten = this.getDateWritten();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dateWritten", (Object)theDateWritten), currentHashCode, (Object)theDateWritten);
        Reference thePrescriber = this.getPrescriber();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"prescriber", (Object)thePrescriber), currentHashCode, (Object)thePrescriber);
        List<CodeableConcept> theReasonCode = this.reasonCode != null && !this.reasonCode.isEmpty() ? this.getReasonCode() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reasonCode", theReasonCode), currentHashCode, theReasonCode);
        List<Reference> theReasonReference = this.reasonReference != null && !this.reasonReference.isEmpty() ? this.getReasonReference() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reasonReference", theReasonReference), currentHashCode, theReasonReference);
        DateTime theDateEnded = this.getDateEnded();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dateEnded", (Object)theDateEnded), currentHashCode, (Object)theDateEnded);
        CodeableConcept theReasonEnded = this.getReasonEnded();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reasonEnded", (Object)theReasonEnded), currentHashCode, (Object)theReasonEnded);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"note", theNote), currentHashCode, theNote);
        List<MedicationOrderDosageInstruction> theDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dosageInstruction", theDosageInstruction), currentHashCode, theDosageInstruction);
        MedicationOrderDispenseRequest theDispenseRequest = this.getDispenseRequest();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dispenseRequest", (Object)theDispenseRequest), currentHashCode, (Object)theDispenseRequest);
        MedicationOrderSubstitution theSubstitution = this.getSubstitution();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"substitution", (Object)theSubstitution), currentHashCode, (Object)theSubstitution);
        Reference thePriorPrescription = this.getPriorPrescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"priorPrescription", (Object)thePriorPrescription), currentHashCode, (Object)thePriorPrescription);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        MedicationOrderStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        strategy.appendField(locator, (Object)this, "medicationCodeableConcept", buffer, (Object)theMedicationCodeableConcept);
        Reference theMedicationReference = this.getMedicationReference();
        strategy.appendField(locator, (Object)this, "medicationReference", buffer, (Object)theMedicationReference);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter);
        DateTime theDateWritten = this.getDateWritten();
        strategy.appendField(locator, (Object)this, "dateWritten", buffer, (Object)theDateWritten);
        Reference thePrescriber = this.getPrescriber();
        strategy.appendField(locator, (Object)this, "prescriber", buffer, (Object)thePrescriber);
        List<CodeableConcept> theReasonCode = this.reasonCode != null && !this.reasonCode.isEmpty() ? this.getReasonCode() : null;
        strategy.appendField(locator, (Object)this, "reasonCode", buffer, theReasonCode);
        List<Reference> theReasonReference = this.reasonReference != null && !this.reasonReference.isEmpty() ? this.getReasonReference() : null;
        strategy.appendField(locator, (Object)this, "reasonReference", buffer, theReasonReference);
        DateTime theDateEnded = this.getDateEnded();
        strategy.appendField(locator, (Object)this, "dateEnded", buffer, (Object)theDateEnded);
        CodeableConcept theReasonEnded = this.getReasonEnded();
        strategy.appendField(locator, (Object)this, "reasonEnded", buffer, (Object)theReasonEnded);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote);
        List<MedicationOrderDosageInstruction> theDosageInstruction = this.dosageInstruction != null && !this.dosageInstruction.isEmpty() ? this.getDosageInstruction() : null;
        strategy.appendField(locator, (Object)this, "dosageInstruction", buffer, theDosageInstruction);
        MedicationOrderDispenseRequest theDispenseRequest = this.getDispenseRequest();
        strategy.appendField(locator, (Object)this, "dispenseRequest", buffer, (Object)theDispenseRequest);
        MedicationOrderSubstitution theSubstitution = this.getSubstitution();
        strategy.appendField(locator, (Object)this, "substitution", buffer, (Object)theSubstitution);
        Reference thePriorPrescription = this.getPriorPrescription();
        strategy.appendField(locator, (Object)this, "priorPrescription", buffer, (Object)thePriorPrescription);
        return buffer;
    }
}

