/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SupplyRequestStatus;
import org.hl7.fhir.SupplyRequestWhen;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SupplyRequest", propOrder={"patient", "source", "date", "identifier", "status", "kind", "orderedItem", "supplier", "reasonCodeableConcept", "reasonReference", "when"})
public class SupplyRequest
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Reference patient;
    protected Reference source;
    protected DateTime date;
    protected Identifier identifier;
    protected SupplyRequestStatus status;
    protected CodeableConcept kind;
    protected Reference orderedItem;
    protected List<Reference> supplier;
    protected CodeableConcept reasonCodeableConcept;
    protected Reference reasonReference;
    protected SupplyRequestWhen when;

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getSource() {
        return this.source;
    }

    public void setSource(Reference value) {
        this.source = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public SupplyRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(SupplyRequestStatus value) {
        this.status = value;
    }

    public CodeableConcept getKind() {
        return this.kind;
    }

    public void setKind(CodeableConcept value) {
        this.kind = value;
    }

    public Reference getOrderedItem() {
        return this.orderedItem;
    }

    public void setOrderedItem(Reference value) {
        this.orderedItem = value;
    }

    public List<Reference> getSupplier() {
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        return this.supplier;
    }

    public CodeableConcept getReasonCodeableConcept() {
        return this.reasonCodeableConcept;
    }

    public void setReasonCodeableConcept(CodeableConcept value) {
        this.reasonCodeableConcept = value;
    }

    public Reference getReasonReference() {
        return this.reasonReference;
    }

    public void setReasonReference(Reference value) {
        this.reasonReference = value;
    }

    public SupplyRequestWhen getWhen() {
        return this.when;
    }

    public void setWhen(SupplyRequestWhen value) {
        this.when = value;
    }

    public SupplyRequest withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public SupplyRequest withSource(Reference value) {
        this.setSource(value);
        return this;
    }

    public SupplyRequest withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public SupplyRequest withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public SupplyRequest withStatus(SupplyRequestStatus value) {
        this.setStatus(value);
        return this;
    }

    public SupplyRequest withKind(CodeableConcept value) {
        this.setKind(value);
        return this;
    }

    public SupplyRequest withOrderedItem(Reference value) {
        this.setOrderedItem(value);
        return this;
    }

    public SupplyRequest withSupplier(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSupplier().add(value);
            }
        }
        return this;
    }

    public SupplyRequest withSupplier(Collection<Reference> values) {
        if (values != null) {
            this.getSupplier().addAll(values);
        }
        return this;
    }

    public SupplyRequest withReasonCodeableConcept(CodeableConcept value) {
        this.setReasonCodeableConcept(value);
        return this;
    }

    public SupplyRequest withReasonReference(Reference value) {
        this.setReasonReference(value);
        return this;
    }

    public SupplyRequest withWhen(SupplyRequestWhen value) {
        this.setWhen(value);
        return this;
    }

    @Override
    public SupplyRequest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public SupplyRequest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public SupplyRequest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public SupplyRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public SupplyRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public SupplyRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public SupplyRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public SupplyRequest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public SupplyRequest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public SupplyRequest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public SupplyRequest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsSupplier;
        if (!(object instanceof SupplyRequest)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        SupplyRequest that = (SupplyRequest)object;
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        Reference lhsSource = this.getSource();
        Reference rhsSource = that.getSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"source", (Object)lhsSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"source", (Object)rhsSource), (Object)lhsSource, (Object)rhsSource)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate)) {
            return false;
        }
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        SupplyRequestStatus lhsStatus = this.getStatus();
        SupplyRequestStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        CodeableConcept lhsKind = this.getKind();
        CodeableConcept rhsKind = that.getKind();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"kind", (Object)lhsKind), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"kind", (Object)rhsKind), (Object)lhsKind, (Object)rhsKind)) {
            return false;
        }
        Reference lhsOrderedItem = this.getOrderedItem();
        Reference rhsOrderedItem = that.getOrderedItem();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"orderedItem", (Object)lhsOrderedItem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"orderedItem", (Object)rhsOrderedItem), (Object)lhsOrderedItem, (Object)rhsOrderedItem)) {
            return false;
        }
        List<Reference> lhsSupplier = this.supplier != null && !this.supplier.isEmpty() ? this.getSupplier() : null;
        List<Reference> list = rhsSupplier = that.supplier != null && !that.supplier.isEmpty() ? that.getSupplier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"supplier", lhsSupplier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"supplier", rhsSupplier), lhsSupplier, rhsSupplier)) {
            return false;
        }
        CodeableConcept lhsReasonCodeableConcept = this.getReasonCodeableConcept();
        CodeableConcept rhsReasonCodeableConcept = that.getReasonCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reasonCodeableConcept", (Object)lhsReasonCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reasonCodeableConcept", (Object)rhsReasonCodeableConcept), (Object)lhsReasonCodeableConcept, (Object)rhsReasonCodeableConcept)) {
            return false;
        }
        Reference lhsReasonReference = this.getReasonReference();
        Reference rhsReasonReference = that.getReasonReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reasonReference", (Object)lhsReasonReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reasonReference", (Object)rhsReasonReference), (Object)lhsReasonReference, (Object)rhsReasonReference)) {
            return false;
        }
        SupplyRequestWhen lhsWhen = this.getWhen();
        SupplyRequestWhen rhsWhen = that.getWhen();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"when", (Object)lhsWhen), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"when", (Object)rhsWhen), (Object)lhsWhen, (Object)rhsWhen);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        Reference theSource = this.getSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"source", (Object)theSource), currentHashCode, (Object)theSource);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"date", (Object)theDate), currentHashCode, (Object)theDate);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        SupplyRequestStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        CodeableConcept theKind = this.getKind();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"kind", (Object)theKind), currentHashCode, (Object)theKind);
        Reference theOrderedItem = this.getOrderedItem();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"orderedItem", (Object)theOrderedItem), currentHashCode, (Object)theOrderedItem);
        List<Reference> theSupplier = this.supplier != null && !this.supplier.isEmpty() ? this.getSupplier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"supplier", theSupplier), currentHashCode, theSupplier);
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reasonCodeableConcept", (Object)theReasonCodeableConcept), currentHashCode, (Object)theReasonCodeableConcept);
        Reference theReasonReference = this.getReasonReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reasonReference", (Object)theReasonReference), currentHashCode, (Object)theReasonReference);
        SupplyRequestWhen theWhen = this.getWhen();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"when", (Object)theWhen), currentHashCode, (Object)theWhen);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        Reference theSource = this.getSource();
        strategy.appendField(locator, (Object)this, "source", buffer, (Object)theSource);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        SupplyRequestStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        CodeableConcept theKind = this.getKind();
        strategy.appendField(locator, (Object)this, "kind", buffer, (Object)theKind);
        Reference theOrderedItem = this.getOrderedItem();
        strategy.appendField(locator, (Object)this, "orderedItem", buffer, (Object)theOrderedItem);
        List<Reference> theSupplier = this.supplier != null && !this.supplier.isEmpty() ? this.getSupplier() : null;
        strategy.appendField(locator, (Object)this, "supplier", buffer, theSupplier);
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        strategy.appendField(locator, (Object)this, "reasonCodeableConcept", buffer, (Object)theReasonCodeableConcept);
        Reference theReasonReference = this.getReasonReference();
        strategy.appendField(locator, (Object)this, "reasonReference", buffer, (Object)theReasonReference);
        SupplyRequestWhen theWhen = this.getWhen();
        strategy.appendField(locator, (Object)this, "when", buffer, (Object)theWhen);
        return buffer;
    }
}

