/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Integer;
import org.hl7.fhir.Uri;
import org.hl7.fhir.ValueSetContains;
import org.hl7.fhir.ValueSetParameter;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ValueSet.Expansion", propOrder={"identifier", "timestamp", "total", "offset", "parameter", "contains"})
public class ValueSetExpansion
extends BackboneElement
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected Uri identifier;
    @XmlElement(required=true)
    protected DateTime timestamp;
    protected Integer total;
    protected Integer offset;
    protected List<ValueSetParameter> parameter;
    protected List<ValueSetContains> contains;

    public Uri getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Uri value) {
        this.identifier = value;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(DateTime value) {
        this.timestamp = value;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer value) {
        this.total = value;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer value) {
        this.offset = value;
    }

    public List<ValueSetParameter> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<ValueSetParameter>();
        }
        return this.parameter;
    }

    public List<ValueSetContains> getContains() {
        if (this.contains == null) {
            this.contains = new ArrayList<ValueSetContains>();
        }
        return this.contains;
    }

    public ValueSetExpansion withIdentifier(Uri value) {
        this.setIdentifier(value);
        return this;
    }

    public ValueSetExpansion withTimestamp(DateTime value) {
        this.setTimestamp(value);
        return this;
    }

    public ValueSetExpansion withTotal(Integer value) {
        this.setTotal(value);
        return this;
    }

    public ValueSetExpansion withOffset(Integer value) {
        this.setOffset(value);
        return this;
    }

    public ValueSetExpansion withParameter(ValueSetParameter ... values) {
        if (values != null) {
            for (ValueSetParameter value : values) {
                this.getParameter().add(value);
            }
        }
        return this;
    }

    public ValueSetExpansion withParameter(Collection<ValueSetParameter> values) {
        if (values != null) {
            this.getParameter().addAll(values);
        }
        return this;
    }

    public ValueSetExpansion withContains(ValueSetContains ... values) {
        if (values != null) {
            for (ValueSetContains value : values) {
                this.getContains().add(value);
            }
        }
        return this;
    }

    public ValueSetExpansion withContains(Collection<ValueSetContains> values) {
        if (values != null) {
            this.getContains().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetExpansion withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ValueSetExpansion withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetExpansion withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ValueSetExpansion withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetExpansion withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ValueSetContains> rhsContains;
        List<ValueSetParameter> rhsParameter;
        if (!(object instanceof ValueSetExpansion)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ValueSetExpansion that = (ValueSetExpansion)object;
        Uri lhsIdentifier = this.getIdentifier();
        Uri rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier)) {
            return false;
        }
        DateTime lhsTimestamp = this.getTimestamp();
        DateTime rhsTimestamp = that.getTimestamp();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"timestamp", (Object)lhsTimestamp), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"timestamp", (Object)rhsTimestamp), (Object)lhsTimestamp, (Object)rhsTimestamp)) {
            return false;
        }
        Integer lhsTotal = this.getTotal();
        Integer rhsTotal = that.getTotal();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"total", (Object)lhsTotal), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"total", (Object)rhsTotal), (Object)lhsTotal, (Object)rhsTotal)) {
            return false;
        }
        Integer lhsOffset = this.getOffset();
        Integer rhsOffset = that.getOffset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"offset", (Object)lhsOffset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"offset", (Object)rhsOffset), (Object)lhsOffset, (Object)rhsOffset)) {
            return false;
        }
        List<ValueSetParameter> lhsParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        List<ValueSetParameter> list = rhsParameter = that.parameter != null && !that.parameter.isEmpty() ? that.getParameter() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"parameter", lhsParameter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"parameter", rhsParameter), lhsParameter, rhsParameter)) {
            return false;
        }
        List<ValueSetContains> lhsContains = this.contains != null && !this.contains.isEmpty() ? this.getContains() : null;
        List<ValueSetContains> list2 = rhsContains = that.contains != null && !that.contains.isEmpty() ? that.getContains() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"contains", lhsContains), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"contains", rhsContains), lhsContains, rhsContains);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier);
        DateTime theTimestamp = this.getTimestamp();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"timestamp", (Object)theTimestamp), currentHashCode, (Object)theTimestamp);
        Integer theTotal = this.getTotal();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"total", (Object)theTotal), currentHashCode, (Object)theTotal);
        Integer theOffset = this.getOffset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"offset", (Object)theOffset), currentHashCode, (Object)theOffset);
        List<ValueSetParameter> theParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"parameter", theParameter), currentHashCode, theParameter);
        List<ValueSetContains> theContains = this.contains != null && !this.contains.isEmpty() ? this.getContains() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"contains", theContains), currentHashCode, theContains);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier);
        DateTime theTimestamp = this.getTimestamp();
        strategy.appendField(locator, (Object)this, "timestamp", buffer, (Object)theTimestamp);
        Integer theTotal = this.getTotal();
        strategy.appendField(locator, (Object)this, "total", buffer, (Object)theTotal);
        Integer theOffset = this.getOffset();
        strategy.appendField(locator, (Object)this, "offset", buffer, (Object)theOffset);
        List<ValueSetParameter> theParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        strategy.appendField(locator, (Object)this, "parameter", buffer, theParameter);
        List<ValueSetContains> theContains = this.contains != null && !this.contains.isEmpty() ? this.getContains() : null;
        strategy.appendField(locator, (Object)this, "contains", buffer, theContains);
        return buffer;
    }
}

