/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Condition.Stage", propOrder={"summary", "assessment"})
public class ConditionStage
extends BackboneElement
implements Equals,
HashCode,
ToString {
    protected CodeableConcept summary;
    protected List<Reference> assessment;

    public CodeableConcept getSummary() {
        return this.summary;
    }

    public void setSummary(CodeableConcept value) {
        this.summary = value;
    }

    public List<Reference> getAssessment() {
        if (this.assessment == null) {
            this.assessment = new ArrayList<Reference>();
        }
        return this.assessment;
    }

    public ConditionStage withSummary(CodeableConcept value) {
        this.setSummary(value);
        return this;
    }

    public ConditionStage withAssessment(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAssessment().add(value);
            }
        }
        return this;
    }

    public ConditionStage withAssessment(Collection<Reference> values) {
        if (values != null) {
            this.getAssessment().addAll(values);
        }
        return this;
    }

    @Override
    public ConditionStage withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConditionStage withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConditionStage withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConditionStage withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConditionStage withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsAssessment;
        if (!(object instanceof ConditionStage)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ConditionStage that = (ConditionStage)object;
        CodeableConcept lhsSummary = this.getSummary();
        CodeableConcept rhsSummary = that.getSummary();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"summary", (Object)lhsSummary), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"summary", (Object)rhsSummary), (Object)lhsSummary, (Object)rhsSummary)) {
            return false;
        }
        List<Reference> lhsAssessment = this.assessment != null && !this.assessment.isEmpty() ? this.getAssessment() : null;
        List<Reference> list = rhsAssessment = that.assessment != null && !that.assessment.isEmpty() ? that.getAssessment() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"assessment", lhsAssessment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"assessment", rhsAssessment), lhsAssessment, rhsAssessment);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theSummary = this.getSummary();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"summary", (Object)theSummary), currentHashCode, (Object)theSummary);
        List<Reference> theAssessment = this.assessment != null && !this.assessment.isEmpty() ? this.getAssessment() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"assessment", theAssessment), currentHashCode, theAssessment);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theSummary = this.getSummary();
        strategy.appendField(locator, (Object)this, "summary", buffer, (Object)theSummary);
        List<Reference> theAssessment = this.assessment != null && !this.assessment.isEmpty() ? this.getAssessment() : null;
        strategy.appendField(locator, (Object)this, "assessment", buffer, theAssessment);
        return buffer;
    }
}

