/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.OrderStatus;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OrderResponse", propOrder={"identifier", "request", "date", "who", "orderStatus", "description", "fulfillment"})
public class OrderResponse
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected Reference request;
    protected DateTime date;
    protected Reference who;
    @XmlElement(required=true)
    protected OrderStatus orderStatus;
    protected String description;
    protected List<Reference> fulfillment;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getRequest() {
        return this.request;
    }

    public void setRequest(Reference value) {
        this.request = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public Reference getWho() {
        return this.who;
    }

    public void setWho(Reference value) {
        this.who = value;
    }

    public OrderStatus getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(OrderStatus value) {
        this.orderStatus = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<Reference> getFulfillment() {
        if (this.fulfillment == null) {
            this.fulfillment = new ArrayList<Reference>();
        }
        return this.fulfillment;
    }

    public OrderResponse withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public OrderResponse withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public OrderResponse withRequest(Reference value) {
        this.setRequest(value);
        return this;
    }

    public OrderResponse withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public OrderResponse withWho(Reference value) {
        this.setWho(value);
        return this;
    }

    public OrderResponse withOrderStatus(OrderStatus value) {
        this.setOrderStatus(value);
        return this;
    }

    public OrderResponse withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public OrderResponse withFulfillment(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getFulfillment().add(value);
            }
        }
        return this;
    }

    public OrderResponse withFulfillment(Collection<Reference> values) {
        if (values != null) {
            this.getFulfillment().addAll(values);
        }
        return this;
    }

    @Override
    public OrderResponse withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public OrderResponse withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public OrderResponse withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public OrderResponse withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public OrderResponse withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public OrderResponse withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public OrderResponse withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public OrderResponse withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public OrderResponse withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public OrderResponse withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public OrderResponse withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsFulfillment;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof OrderResponse)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        OrderResponse that = (OrderResponse)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        Reference lhsRequest = this.getRequest();
        Reference rhsRequest = that.getRequest();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"request", (Object)lhsRequest), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"request", (Object)rhsRequest), (Object)lhsRequest, (Object)rhsRequest)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate)) {
            return false;
        }
        Reference lhsWho = this.getWho();
        Reference rhsWho = that.getWho();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"who", (Object)lhsWho), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"who", (Object)rhsWho), (Object)lhsWho, (Object)rhsWho)) {
            return false;
        }
        OrderStatus lhsOrderStatus = this.getOrderStatus();
        OrderStatus rhsOrderStatus = that.getOrderStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"orderStatus", (Object)lhsOrderStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"orderStatus", (Object)rhsOrderStatus), (Object)lhsOrderStatus, (Object)rhsOrderStatus)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription)) {
            return false;
        }
        List<Reference> lhsFulfillment = this.fulfillment != null && !this.fulfillment.isEmpty() ? this.getFulfillment() : null;
        List<Reference> list2 = rhsFulfillment = that.fulfillment != null && !that.fulfillment.isEmpty() ? that.getFulfillment() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"fulfillment", lhsFulfillment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"fulfillment", rhsFulfillment), lhsFulfillment, rhsFulfillment);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        Reference theRequest = this.getRequest();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"request", (Object)theRequest), currentHashCode, (Object)theRequest);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate);
        Reference theWho = this.getWho();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"who", (Object)theWho), currentHashCode, (Object)theWho);
        OrderStatus theOrderStatus = this.getOrderStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"orderStatus", (Object)theOrderStatus), currentHashCode, (Object)theOrderStatus);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription);
        List<Reference> theFulfillment = this.fulfillment != null && !this.fulfillment.isEmpty() ? this.getFulfillment() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"fulfillment", theFulfillment), currentHashCode, theFulfillment);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        Reference theRequest = this.getRequest();
        strategy.appendField(locator, (Object)this, "request", buffer, (Object)theRequest);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate);
        Reference theWho = this.getWho();
        strategy.appendField(locator, (Object)this, "who", buffer, (Object)theWho);
        OrderStatus theOrderStatus = this.getOrderStatus();
        strategy.appendField(locator, (Object)this, "orderStatus", buffer, (Object)theOrderStatus);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription);
        List<Reference> theFulfillment = this.fulfillment != null && !this.fulfillment.isEmpty() ? this.getFulfillment() : null;
        strategy.appendField(locator, (Object)this, "fulfillment", buffer, theFulfillment);
        return buffer;
    }
}

