/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Age;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConditionEvidence;
import org.hl7.fhir.ConditionStage;
import org.hl7.fhir.ConditionVerificationStatus;
import org.hl7.fhir.Date;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Range;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Condition", propOrder={"identifier", "patient", "encounter", "asserter", "dateRecorded", "code", "category", "clinicalStatus", "verificationStatus", "severity", "onsetDateTime", "onsetQuantity", "onsetPeriod", "onsetRange", "onsetString", "abatementDateTime", "abatementQuantity", "abatementBoolean", "abatementPeriod", "abatementRange", "abatementString", "stage", "evidence", "bodySite", "notes"})
public class Condition
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected Reference patient;
    protected Reference encounter;
    protected Reference asserter;
    protected Date dateRecorded;
    @XmlElement(required=true)
    protected CodeableConcept code;
    protected CodeableConcept category;
    protected Code clinicalStatus;
    @XmlElement(required=true)
    protected ConditionVerificationStatus verificationStatus;
    protected CodeableConcept severity;
    protected DateTime onsetDateTime;
    protected Age onsetQuantity;
    protected Period onsetPeriod;
    protected Range onsetRange;
    protected String onsetString;
    protected DateTime abatementDateTime;
    protected Age abatementQuantity;
    protected Boolean abatementBoolean;
    protected Period abatementPeriod;
    protected Range abatementRange;
    protected String abatementString;
    protected ConditionStage stage;
    protected List<ConditionEvidence> evidence;
    protected List<CodeableConcept> bodySite;
    protected String notes;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public Reference getAsserter() {
        return this.asserter;
    }

    public void setAsserter(Reference value) {
        this.asserter = value;
    }

    public Date getDateRecorded() {
        return this.dateRecorded;
    }

    public void setDateRecorded(Date value) {
        this.dateRecorded = value;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public void setCategory(CodeableConcept value) {
        this.category = value;
    }

    public Code getClinicalStatus() {
        return this.clinicalStatus;
    }

    public void setClinicalStatus(Code value) {
        this.clinicalStatus = value;
    }

    public ConditionVerificationStatus getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(ConditionVerificationStatus value) {
        this.verificationStatus = value;
    }

    public CodeableConcept getSeverity() {
        return this.severity;
    }

    public void setSeverity(CodeableConcept value) {
        this.severity = value;
    }

    public DateTime getOnsetDateTime() {
        return this.onsetDateTime;
    }

    public void setOnsetDateTime(DateTime value) {
        this.onsetDateTime = value;
    }

    public Age getOnsetQuantity() {
        return this.onsetQuantity;
    }

    public void setOnsetQuantity(Age value) {
        this.onsetQuantity = value;
    }

    public Period getOnsetPeriod() {
        return this.onsetPeriod;
    }

    public void setOnsetPeriod(Period value) {
        this.onsetPeriod = value;
    }

    public Range getOnsetRange() {
        return this.onsetRange;
    }

    public void setOnsetRange(Range value) {
        this.onsetRange = value;
    }

    public String getOnsetString() {
        return this.onsetString;
    }

    public void setOnsetString(String value) {
        this.onsetString = value;
    }

    public DateTime getAbatementDateTime() {
        return this.abatementDateTime;
    }

    public void setAbatementDateTime(DateTime value) {
        this.abatementDateTime = value;
    }

    public Age getAbatementQuantity() {
        return this.abatementQuantity;
    }

    public void setAbatementQuantity(Age value) {
        this.abatementQuantity = value;
    }

    public Boolean getAbatementBoolean() {
        return this.abatementBoolean;
    }

    public void setAbatementBoolean(Boolean value) {
        this.abatementBoolean = value;
    }

    public Period getAbatementPeriod() {
        return this.abatementPeriod;
    }

    public void setAbatementPeriod(Period value) {
        this.abatementPeriod = value;
    }

    public Range getAbatementRange() {
        return this.abatementRange;
    }

    public void setAbatementRange(Range value) {
        this.abatementRange = value;
    }

    public String getAbatementString() {
        return this.abatementString;
    }

    public void setAbatementString(String value) {
        this.abatementString = value;
    }

    public ConditionStage getStage() {
        return this.stage;
    }

    public void setStage(ConditionStage value) {
        this.stage = value;
    }

    public List<ConditionEvidence> getEvidence() {
        if (this.evidence == null) {
            this.evidence = new ArrayList<ConditionEvidence>();
        }
        return this.evidence;
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String value) {
        this.notes = value;
    }

    public Condition withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Condition withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Condition withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public Condition withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public Condition withAsserter(Reference value) {
        this.setAsserter(value);
        return this;
    }

    public Condition withDateRecorded(Date value) {
        this.setDateRecorded(value);
        return this;
    }

    public Condition withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public Condition withCategory(CodeableConcept value) {
        this.setCategory(value);
        return this;
    }

    public Condition withClinicalStatus(Code value) {
        this.setClinicalStatus(value);
        return this;
    }

    public Condition withVerificationStatus(ConditionVerificationStatus value) {
        this.setVerificationStatus(value);
        return this;
    }

    public Condition withSeverity(CodeableConcept value) {
        this.setSeverity(value);
        return this;
    }

    public Condition withOnsetDateTime(DateTime value) {
        this.setOnsetDateTime(value);
        return this;
    }

    public Condition withOnsetQuantity(Age value) {
        this.setOnsetQuantity(value);
        return this;
    }

    public Condition withOnsetPeriod(Period value) {
        this.setOnsetPeriod(value);
        return this;
    }

    public Condition withOnsetRange(Range value) {
        this.setOnsetRange(value);
        return this;
    }

    public Condition withOnsetString(String value) {
        this.setOnsetString(value);
        return this;
    }

    public Condition withAbatementDateTime(DateTime value) {
        this.setAbatementDateTime(value);
        return this;
    }

    public Condition withAbatementQuantity(Age value) {
        this.setAbatementQuantity(value);
        return this;
    }

    public Condition withAbatementBoolean(Boolean value) {
        this.setAbatementBoolean(value);
        return this;
    }

    public Condition withAbatementPeriod(Period value) {
        this.setAbatementPeriod(value);
        return this;
    }

    public Condition withAbatementRange(Range value) {
        this.setAbatementRange(value);
        return this;
    }

    public Condition withAbatementString(String value) {
        this.setAbatementString(value);
        return this;
    }

    public Condition withStage(ConditionStage value) {
        this.setStage(value);
        return this;
    }

    public Condition withEvidence(ConditionEvidence ... values) {
        if (values != null) {
            for (ConditionEvidence value : values) {
                this.getEvidence().add(value);
            }
        }
        return this;
    }

    public Condition withEvidence(Collection<ConditionEvidence> values) {
        if (values != null) {
            this.getEvidence().addAll(values);
        }
        return this;
    }

    public Condition withBodySite(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getBodySite().add(value);
            }
        }
        return this;
    }

    public Condition withBodySite(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getBodySite().addAll(values);
        }
        return this;
    }

    public Condition withNotes(String value) {
        this.setNotes(value);
        return this;
    }

    @Override
    public Condition withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Condition withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Condition withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Condition withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Condition withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Condition withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Condition withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Condition withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Condition withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Condition withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Condition withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Condition that = (Condition)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        Reference lhsAsserter = this.getAsserter();
        Reference rhsAsserter = that.getAsserter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"asserter", (Object)lhsAsserter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"asserter", (Object)rhsAsserter), (Object)lhsAsserter, (Object)rhsAsserter, this.asserter != null, that.asserter != null)) {
            return false;
        }
        Date lhsDateRecorded = this.getDateRecorded();
        Date rhsDateRecorded = that.getDateRecorded();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dateRecorded", (Object)lhsDateRecorded), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dateRecorded", (Object)rhsDateRecorded), (Object)lhsDateRecorded, (Object)rhsDateRecorded, this.dateRecorded != null, that.dateRecorded != null)) {
            return false;
        }
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        CodeableConcept lhsCategory = this.getCategory();
        CodeableConcept rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"category", (Object)lhsCategory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"category", (Object)rhsCategory), (Object)lhsCategory, (Object)rhsCategory, this.category != null, that.category != null)) {
            return false;
        }
        Code lhsClinicalStatus = this.getClinicalStatus();
        Code rhsClinicalStatus = that.getClinicalStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"clinicalStatus", (Object)lhsClinicalStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"clinicalStatus", (Object)rhsClinicalStatus), (Object)lhsClinicalStatus, (Object)rhsClinicalStatus, this.clinicalStatus != null, that.clinicalStatus != null)) {
            return false;
        }
        ConditionVerificationStatus lhsVerificationStatus = this.getVerificationStatus();
        ConditionVerificationStatus rhsVerificationStatus = that.getVerificationStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"verificationStatus", (Object)lhsVerificationStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"verificationStatus", (Object)rhsVerificationStatus), (Object)lhsVerificationStatus, (Object)rhsVerificationStatus, this.verificationStatus != null, that.verificationStatus != null)) {
            return false;
        }
        CodeableConcept lhsSeverity = this.getSeverity();
        CodeableConcept rhsSeverity = that.getSeverity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"severity", (Object)lhsSeverity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"severity", (Object)rhsSeverity), (Object)lhsSeverity, (Object)rhsSeverity, this.severity != null, that.severity != null)) {
            return false;
        }
        DateTime lhsOnsetDateTime = this.getOnsetDateTime();
        DateTime rhsOnsetDateTime = that.getOnsetDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"onsetDateTime", (Object)lhsOnsetDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"onsetDateTime", (Object)rhsOnsetDateTime), (Object)lhsOnsetDateTime, (Object)rhsOnsetDateTime, this.onsetDateTime != null, that.onsetDateTime != null)) {
            return false;
        }
        Age lhsOnsetQuantity = this.getOnsetQuantity();
        Age rhsOnsetQuantity = that.getOnsetQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"onsetQuantity", (Object)lhsOnsetQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"onsetQuantity", (Object)rhsOnsetQuantity), (Object)lhsOnsetQuantity, (Object)rhsOnsetQuantity, this.onsetQuantity != null, that.onsetQuantity != null)) {
            return false;
        }
        Period lhsOnsetPeriod = this.getOnsetPeriod();
        Period rhsOnsetPeriod = that.getOnsetPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"onsetPeriod", (Object)lhsOnsetPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"onsetPeriod", (Object)rhsOnsetPeriod), (Object)lhsOnsetPeriod, (Object)rhsOnsetPeriod, this.onsetPeriod != null, that.onsetPeriod != null)) {
            return false;
        }
        Range lhsOnsetRange = this.getOnsetRange();
        Range rhsOnsetRange = that.getOnsetRange();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"onsetRange", (Object)lhsOnsetRange), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"onsetRange", (Object)rhsOnsetRange), (Object)lhsOnsetRange, (Object)rhsOnsetRange, this.onsetRange != null, that.onsetRange != null)) {
            return false;
        }
        String lhsOnsetString = this.getOnsetString();
        String rhsOnsetString = that.getOnsetString();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"onsetString", (Object)lhsOnsetString), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"onsetString", (Object)rhsOnsetString), (Object)lhsOnsetString, (Object)rhsOnsetString, this.onsetString != null, that.onsetString != null)) {
            return false;
        }
        DateTime lhsAbatementDateTime = this.getAbatementDateTime();
        DateTime rhsAbatementDateTime = that.getAbatementDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementDateTime", (Object)lhsAbatementDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementDateTime", (Object)rhsAbatementDateTime), (Object)lhsAbatementDateTime, (Object)rhsAbatementDateTime, this.abatementDateTime != null, that.abatementDateTime != null)) {
            return false;
        }
        Age lhsAbatementQuantity = this.getAbatementQuantity();
        Age rhsAbatementQuantity = that.getAbatementQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementQuantity", (Object)lhsAbatementQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementQuantity", (Object)rhsAbatementQuantity), (Object)lhsAbatementQuantity, (Object)rhsAbatementQuantity, this.abatementQuantity != null, that.abatementQuantity != null)) {
            return false;
        }
        Boolean lhsAbatementBoolean = this.getAbatementBoolean();
        Boolean rhsAbatementBoolean = that.getAbatementBoolean();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementBoolean", (Object)lhsAbatementBoolean), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementBoolean", (Object)rhsAbatementBoolean), (Object)lhsAbatementBoolean, (Object)rhsAbatementBoolean, this.abatementBoolean != null, that.abatementBoolean != null)) {
            return false;
        }
        Period lhsAbatementPeriod = this.getAbatementPeriod();
        Period rhsAbatementPeriod = that.getAbatementPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementPeriod", (Object)lhsAbatementPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementPeriod", (Object)rhsAbatementPeriod), (Object)lhsAbatementPeriod, (Object)rhsAbatementPeriod, this.abatementPeriod != null, that.abatementPeriod != null)) {
            return false;
        }
        Range lhsAbatementRange = this.getAbatementRange();
        Range rhsAbatementRange = that.getAbatementRange();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementRange", (Object)lhsAbatementRange), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementRange", (Object)rhsAbatementRange), (Object)lhsAbatementRange, (Object)rhsAbatementRange, this.abatementRange != null, that.abatementRange != null)) {
            return false;
        }
        String lhsAbatementString = this.getAbatementString();
        String rhsAbatementString = that.getAbatementString();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"abatementString", (Object)lhsAbatementString), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"abatementString", (Object)rhsAbatementString), (Object)lhsAbatementString, (Object)rhsAbatementString, this.abatementString != null, that.abatementString != null)) {
            return false;
        }
        ConditionStage lhsStage = this.getStage();
        ConditionStage rhsStage = that.getStage();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"stage", (Object)lhsStage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"stage", (Object)rhsStage), (Object)lhsStage, (Object)rhsStage, this.stage != null, that.stage != null)) {
            return false;
        }
        List<ConditionEvidence> lhsEvidence = this.evidence != null && !this.evidence.isEmpty() ? this.getEvidence() : null;
        List<ConditionEvidence> rhsEvidence = that.evidence != null && !that.evidence.isEmpty() ? that.getEvidence() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"evidence", lhsEvidence), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"evidence", rhsEvidence), lhsEvidence, rhsEvidence, this.evidence != null && !this.evidence.isEmpty(), that.evidence != null && !that.evidence.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        List<CodeableConcept> rhsBodySite = that.bodySite != null && !that.bodySite.isEmpty() ? that.getBodySite() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"bodySite", lhsBodySite), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"bodySite", rhsBodySite), lhsBodySite, rhsBodySite, this.bodySite != null && !this.bodySite.isEmpty(), that.bodySite != null && !that.bodySite.isEmpty())) {
            return false;
        }
        String lhsNotes = this.getNotes();
        String rhsNotes = that.getNotes();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"notes", (Object)lhsNotes), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"notes", (Object)rhsNotes), (Object)lhsNotes, (Object)rhsNotes, this.notes != null, that.notes != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient, this.patient != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter, this.encounter != null);
        Reference theAsserter = this.getAsserter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"asserter", (Object)theAsserter), currentHashCode, (Object)theAsserter, this.asserter != null);
        Date theDateRecorded = this.getDateRecorded();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dateRecorded", (Object)theDateRecorded), currentHashCode, (Object)theDateRecorded, this.dateRecorded != null);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode, this.code != null);
        CodeableConcept theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"category", (Object)theCategory), currentHashCode, (Object)theCategory, this.category != null);
        Code theClinicalStatus = this.getClinicalStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"clinicalStatus", (Object)theClinicalStatus), currentHashCode, (Object)theClinicalStatus, this.clinicalStatus != null);
        ConditionVerificationStatus theVerificationStatus = this.getVerificationStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"verificationStatus", (Object)theVerificationStatus), currentHashCode, (Object)theVerificationStatus, this.verificationStatus != null);
        CodeableConcept theSeverity = this.getSeverity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"severity", (Object)theSeverity), currentHashCode, (Object)theSeverity, this.severity != null);
        DateTime theOnsetDateTime = this.getOnsetDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"onsetDateTime", (Object)theOnsetDateTime), currentHashCode, (Object)theOnsetDateTime, this.onsetDateTime != null);
        Age theOnsetQuantity = this.getOnsetQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"onsetQuantity", (Object)theOnsetQuantity), currentHashCode, (Object)theOnsetQuantity, this.onsetQuantity != null);
        Period theOnsetPeriod = this.getOnsetPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"onsetPeriod", (Object)theOnsetPeriod), currentHashCode, (Object)theOnsetPeriod, this.onsetPeriod != null);
        Range theOnsetRange = this.getOnsetRange();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"onsetRange", (Object)theOnsetRange), currentHashCode, (Object)theOnsetRange, this.onsetRange != null);
        String theOnsetString = this.getOnsetString();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"onsetString", (Object)theOnsetString), currentHashCode, (Object)theOnsetString, this.onsetString != null);
        DateTime theAbatementDateTime = this.getAbatementDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementDateTime", (Object)theAbatementDateTime), currentHashCode, (Object)theAbatementDateTime, this.abatementDateTime != null);
        Age theAbatementQuantity = this.getAbatementQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementQuantity", (Object)theAbatementQuantity), currentHashCode, (Object)theAbatementQuantity, this.abatementQuantity != null);
        Boolean theAbatementBoolean = this.getAbatementBoolean();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementBoolean", (Object)theAbatementBoolean), currentHashCode, (Object)theAbatementBoolean, this.abatementBoolean != null);
        Period theAbatementPeriod = this.getAbatementPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementPeriod", (Object)theAbatementPeriod), currentHashCode, (Object)theAbatementPeriod, this.abatementPeriod != null);
        Range theAbatementRange = this.getAbatementRange();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementRange", (Object)theAbatementRange), currentHashCode, (Object)theAbatementRange, this.abatementRange != null);
        String theAbatementString = this.getAbatementString();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"abatementString", (Object)theAbatementString), currentHashCode, (Object)theAbatementString, this.abatementString != null);
        ConditionStage theStage = this.getStage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"stage", (Object)theStage), currentHashCode, (Object)theStage, this.stage != null);
        List<ConditionEvidence> theEvidence = this.evidence != null && !this.evidence.isEmpty() ? this.getEvidence() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"evidence", theEvidence), currentHashCode, theEvidence, this.evidence != null && !this.evidence.isEmpty());
        List<CodeableConcept> theBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"bodySite", theBodySite), currentHashCode, theBodySite, this.bodySite != null && !this.bodySite.isEmpty());
        String theNotes = this.getNotes();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"notes", (Object)theNotes), currentHashCode, (Object)theNotes, this.notes != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient, this.patient != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter, this.encounter != null);
        Reference theAsserter = this.getAsserter();
        strategy.appendField(locator, (Object)this, "asserter", buffer, (Object)theAsserter, this.asserter != null);
        Date theDateRecorded = this.getDateRecorded();
        strategy.appendField(locator, (Object)this, "dateRecorded", buffer, (Object)theDateRecorded, this.dateRecorded != null);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode, this.code != null);
        CodeableConcept theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, (Object)theCategory, this.category != null);
        Code theClinicalStatus = this.getClinicalStatus();
        strategy.appendField(locator, (Object)this, "clinicalStatus", buffer, (Object)theClinicalStatus, this.clinicalStatus != null);
        ConditionVerificationStatus theVerificationStatus = this.getVerificationStatus();
        strategy.appendField(locator, (Object)this, "verificationStatus", buffer, (Object)theVerificationStatus, this.verificationStatus != null);
        CodeableConcept theSeverity = this.getSeverity();
        strategy.appendField(locator, (Object)this, "severity", buffer, (Object)theSeverity, this.severity != null);
        DateTime theOnsetDateTime = this.getOnsetDateTime();
        strategy.appendField(locator, (Object)this, "onsetDateTime", buffer, (Object)theOnsetDateTime, this.onsetDateTime != null);
        Age theOnsetQuantity = this.getOnsetQuantity();
        strategy.appendField(locator, (Object)this, "onsetQuantity", buffer, (Object)theOnsetQuantity, this.onsetQuantity != null);
        Period theOnsetPeriod = this.getOnsetPeriod();
        strategy.appendField(locator, (Object)this, "onsetPeriod", buffer, (Object)theOnsetPeriod, this.onsetPeriod != null);
        Range theOnsetRange = this.getOnsetRange();
        strategy.appendField(locator, (Object)this, "onsetRange", buffer, (Object)theOnsetRange, this.onsetRange != null);
        String theOnsetString = this.getOnsetString();
        strategy.appendField(locator, (Object)this, "onsetString", buffer, (Object)theOnsetString, this.onsetString != null);
        DateTime theAbatementDateTime = this.getAbatementDateTime();
        strategy.appendField(locator, (Object)this, "abatementDateTime", buffer, (Object)theAbatementDateTime, this.abatementDateTime != null);
        Age theAbatementQuantity = this.getAbatementQuantity();
        strategy.appendField(locator, (Object)this, "abatementQuantity", buffer, (Object)theAbatementQuantity, this.abatementQuantity != null);
        Boolean theAbatementBoolean = this.getAbatementBoolean();
        strategy.appendField(locator, (Object)this, "abatementBoolean", buffer, (Object)theAbatementBoolean, this.abatementBoolean != null);
        Period theAbatementPeriod = this.getAbatementPeriod();
        strategy.appendField(locator, (Object)this, "abatementPeriod", buffer, (Object)theAbatementPeriod, this.abatementPeriod != null);
        Range theAbatementRange = this.getAbatementRange();
        strategy.appendField(locator, (Object)this, "abatementRange", buffer, (Object)theAbatementRange, this.abatementRange != null);
        String theAbatementString = this.getAbatementString();
        strategy.appendField(locator, (Object)this, "abatementString", buffer, (Object)theAbatementString, this.abatementString != null);
        ConditionStage theStage = this.getStage();
        strategy.appendField(locator, (Object)this, "stage", buffer, (Object)theStage, this.stage != null);
        List<ConditionEvidence> theEvidence = this.evidence != null && !this.evidence.isEmpty() ? this.getEvidence() : null;
        strategy.appendField(locator, (Object)this, "evidence", buffer, theEvidence, this.evidence != null && !this.evidence.isEmpty());
        List<CodeableConcept> theBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        strategy.appendField(locator, (Object)this, "bodySite", buffer, theBodySite, this.bodySite != null && !this.bodySite.isEmpty());
        String theNotes = this.getNotes();
        strategy.appendField(locator, (Object)this, "notes", buffer, (Object)theNotes, this.notes != null);
        return buffer;
    }
}

