/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.ActionDefinition;
import org.hl7.fhir.Code;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.ModuleMetadata;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.TriggerDefinition;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DecisionSupportRule", propOrder={"moduleMetadata", "library", "trigger", "condition", "action"})
public class DecisionSupportRule
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected ModuleMetadata moduleMetadata;
    protected List<Reference> library;
    protected List<TriggerDefinition> trigger;
    protected String condition;
    protected List<ActionDefinition> action;

    public ModuleMetadata getModuleMetadata() {
        return this.moduleMetadata;
    }

    public void setModuleMetadata(ModuleMetadata value) {
        this.moduleMetadata = value;
    }

    public List<Reference> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        return this.library;
    }

    public List<TriggerDefinition> getTrigger() {
        if (this.trigger == null) {
            this.trigger = new ArrayList<TriggerDefinition>();
        }
        return this.trigger;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String value) {
        this.condition = value;
    }

    public List<ActionDefinition> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        return this.action;
    }

    public DecisionSupportRule withModuleMetadata(ModuleMetadata value) {
        this.setModuleMetadata(value);
        return this;
    }

    public DecisionSupportRule withLibrary(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getLibrary().add(value);
            }
        }
        return this;
    }

    public DecisionSupportRule withLibrary(Collection<Reference> values) {
        if (values != null) {
            this.getLibrary().addAll(values);
        }
        return this;
    }

    public DecisionSupportRule withTrigger(TriggerDefinition ... values) {
        if (values != null) {
            for (TriggerDefinition value : values) {
                this.getTrigger().add(value);
            }
        }
        return this;
    }

    public DecisionSupportRule withTrigger(Collection<TriggerDefinition> values) {
        if (values != null) {
            this.getTrigger().addAll(values);
        }
        return this;
    }

    public DecisionSupportRule withCondition(String value) {
        this.setCondition(value);
        return this;
    }

    public DecisionSupportRule withAction(ActionDefinition ... values) {
        if (values != null) {
            for (ActionDefinition value : values) {
                this.getAction().add(value);
            }
        }
        return this;
    }

    public DecisionSupportRule withAction(Collection<ActionDefinition> values) {
        if (values != null) {
            this.getAction().addAll(values);
        }
        return this;
    }

    @Override
    public DecisionSupportRule withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public DecisionSupportRule withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public DecisionSupportRule withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public DecisionSupportRule withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DecisionSupportRule withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DecisionSupportRule withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DecisionSupportRule withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DecisionSupportRule withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public DecisionSupportRule withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public DecisionSupportRule withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public DecisionSupportRule withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<ActionDefinition> rhsAction;
        List<TriggerDefinition> rhsTrigger;
        List<Reference> rhsLibrary;
        if (!(object instanceof DecisionSupportRule)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DecisionSupportRule that = (DecisionSupportRule)object;
        ModuleMetadata lhsModuleMetadata = this.getModuleMetadata();
        ModuleMetadata rhsModuleMetadata = that.getModuleMetadata();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"moduleMetadata", (Object)lhsModuleMetadata), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"moduleMetadata", (Object)rhsModuleMetadata), (Object)lhsModuleMetadata, (Object)rhsModuleMetadata)) {
            return false;
        }
        List<Reference> lhsLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        List<Reference> list = rhsLibrary = that.library != null && !that.library.isEmpty() ? that.getLibrary() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"library", lhsLibrary), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"library", rhsLibrary), lhsLibrary, rhsLibrary)) {
            return false;
        }
        List<TriggerDefinition> lhsTrigger = this.trigger != null && !this.trigger.isEmpty() ? this.getTrigger() : null;
        List<TriggerDefinition> list2 = rhsTrigger = that.trigger != null && !that.trigger.isEmpty() ? that.getTrigger() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"trigger", lhsTrigger), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"trigger", rhsTrigger), lhsTrigger, rhsTrigger)) {
            return false;
        }
        String lhsCondition = this.getCondition();
        String rhsCondition = that.getCondition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"condition", (Object)lhsCondition), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"condition", (Object)rhsCondition), (Object)lhsCondition, (Object)rhsCondition)) {
            return false;
        }
        List<ActionDefinition> lhsAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        List<ActionDefinition> list3 = rhsAction = that.action != null && !that.action.isEmpty() ? that.getAction() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"action", lhsAction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"action", rhsAction), lhsAction, rhsAction);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        ModuleMetadata theModuleMetadata = this.getModuleMetadata();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"moduleMetadata", (Object)theModuleMetadata), currentHashCode, (Object)theModuleMetadata);
        List<Reference> theLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"library", theLibrary), currentHashCode, theLibrary);
        List<TriggerDefinition> theTrigger = this.trigger != null && !this.trigger.isEmpty() ? this.getTrigger() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"trigger", theTrigger), currentHashCode, theTrigger);
        String theCondition = this.getCondition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"condition", (Object)theCondition), currentHashCode, (Object)theCondition);
        List<ActionDefinition> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"action", theAction), currentHashCode, theAction);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        ModuleMetadata theModuleMetadata = this.getModuleMetadata();
        strategy.appendField(locator, (Object)this, "moduleMetadata", buffer, (Object)theModuleMetadata);
        List<Reference> theLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        strategy.appendField(locator, (Object)this, "library", buffer, theLibrary);
        List<TriggerDefinition> theTrigger = this.trigger != null && !this.trigger.isEmpty() ? this.getTrigger() : null;
        strategy.appendField(locator, (Object)this, "trigger", buffer, theTrigger);
        String theCondition = this.getCondition();
        strategy.appendField(locator, (Object)this, "condition", buffer, (Object)theCondition);
        List<ActionDefinition> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        strategy.appendField(locator, (Object)this, "action", buffer, theAction);
        return buffer;
    }
}

