/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.PositiveInt;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Coverage", propOrder={"issuerIdentifier", "issuerReference", "bin", "period", "type", "planholderIdentifier", "planholderReference", "beneficiaryIdentifier", "beneficiaryReference", "relationship", "identifier", "group", "plan", "subPlan", "dependent", "sequence", "exception", "school", "network", "contract"})
public class Coverage
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected Identifier issuerIdentifier;
    protected Reference issuerReference;
    protected String bin;
    protected Period period;
    protected Coding type;
    protected Identifier planholderIdentifier;
    protected Reference planholderReference;
    protected Identifier beneficiaryIdentifier;
    protected Reference beneficiaryReference;
    @XmlElement(required=true)
    protected Coding relationship;
    protected List<Identifier> identifier;
    protected String group;
    protected String plan;
    protected String subPlan;
    protected PositiveInt dependent;
    protected PositiveInt sequence;
    protected List<Coding> exception;
    protected String school;
    protected String network;
    protected List<Reference> contract;

    public Identifier getIssuerIdentifier() {
        return this.issuerIdentifier;
    }

    public void setIssuerIdentifier(Identifier value) {
        this.issuerIdentifier = value;
    }

    public Reference getIssuerReference() {
        return this.issuerReference;
    }

    public void setIssuerReference(Reference value) {
        this.issuerReference = value;
    }

    public String getBin() {
        return this.bin;
    }

    public void setBin(String value) {
        this.bin = value;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public Coding getType() {
        return this.type;
    }

    public void setType(Coding value) {
        this.type = value;
    }

    public Identifier getPlanholderIdentifier() {
        return this.planholderIdentifier;
    }

    public void setPlanholderIdentifier(Identifier value) {
        this.planholderIdentifier = value;
    }

    public Reference getPlanholderReference() {
        return this.planholderReference;
    }

    public void setPlanholderReference(Reference value) {
        this.planholderReference = value;
    }

    public Identifier getBeneficiaryIdentifier() {
        return this.beneficiaryIdentifier;
    }

    public void setBeneficiaryIdentifier(Identifier value) {
        this.beneficiaryIdentifier = value;
    }

    public Reference getBeneficiaryReference() {
        return this.beneficiaryReference;
    }

    public void setBeneficiaryReference(Reference value) {
        this.beneficiaryReference = value;
    }

    public Coding getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Coding value) {
        this.relationship = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String value) {
        this.group = value;
    }

    public String getPlan() {
        return this.plan;
    }

    public void setPlan(String value) {
        this.plan = value;
    }

    public String getSubPlan() {
        return this.subPlan;
    }

    public void setSubPlan(String value) {
        this.subPlan = value;
    }

    public PositiveInt getDependent() {
        return this.dependent;
    }

    public void setDependent(PositiveInt value) {
        this.dependent = value;
    }

    public PositiveInt getSequence() {
        return this.sequence;
    }

    public void setSequence(PositiveInt value) {
        this.sequence = value;
    }

    public List<Coding> getException() {
        if (this.exception == null) {
            this.exception = new ArrayList<Coding>();
        }
        return this.exception;
    }

    public String getSchool() {
        return this.school;
    }

    public void setSchool(String value) {
        this.school = value;
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String value) {
        this.network = value;
    }

    public List<Reference> getContract() {
        if (this.contract == null) {
            this.contract = new ArrayList<Reference>();
        }
        return this.contract;
    }

    public Coverage withIssuerIdentifier(Identifier value) {
        this.setIssuerIdentifier(value);
        return this;
    }

    public Coverage withIssuerReference(Reference value) {
        this.setIssuerReference(value);
        return this;
    }

    public Coverage withBin(String value) {
        this.setBin(value);
        return this;
    }

    public Coverage withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    public Coverage withType(Coding value) {
        this.setType(value);
        return this;
    }

    public Coverage withPlanholderIdentifier(Identifier value) {
        this.setPlanholderIdentifier(value);
        return this;
    }

    public Coverage withPlanholderReference(Reference value) {
        this.setPlanholderReference(value);
        return this;
    }

    public Coverage withBeneficiaryIdentifier(Identifier value) {
        this.setBeneficiaryIdentifier(value);
        return this;
    }

    public Coverage withBeneficiaryReference(Reference value) {
        this.setBeneficiaryReference(value);
        return this;
    }

    public Coverage withRelationship(Coding value) {
        this.setRelationship(value);
        return this;
    }

    public Coverage withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Coverage withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Coverage withGroup(String value) {
        this.setGroup(value);
        return this;
    }

    public Coverage withPlan(String value) {
        this.setPlan(value);
        return this;
    }

    public Coverage withSubPlan(String value) {
        this.setSubPlan(value);
        return this;
    }

    public Coverage withDependent(PositiveInt value) {
        this.setDependent(value);
        return this;
    }

    public Coverage withSequence(PositiveInt value) {
        this.setSequence(value);
        return this;
    }

    public Coverage withException(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getException().add(value);
            }
        }
        return this;
    }

    public Coverage withException(Collection<Coding> values) {
        if (values != null) {
            this.getException().addAll(values);
        }
        return this;
    }

    public Coverage withSchool(String value) {
        this.setSchool(value);
        return this;
    }

    public Coverage withNetwork(String value) {
        this.setNetwork(value);
        return this;
    }

    public Coverage withContract(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getContract().add(value);
            }
        }
        return this;
    }

    public Coverage withContract(Collection<Reference> values) {
        if (values != null) {
            this.getContract().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Coverage withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Coverage withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Coverage withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Coverage withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Coverage withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Coverage withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Coverage withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Coverage withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsContract;
        List<Coding> rhsException;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof Coverage)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Coverage that = (Coverage)object;
        Identifier lhsIssuerIdentifier = this.getIssuerIdentifier();
        Identifier rhsIssuerIdentifier = that.getIssuerIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"issuerIdentifier", (Object)lhsIssuerIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"issuerIdentifier", (Object)rhsIssuerIdentifier), (Object)lhsIssuerIdentifier, (Object)rhsIssuerIdentifier)) {
            return false;
        }
        Reference lhsIssuerReference = this.getIssuerReference();
        Reference rhsIssuerReference = that.getIssuerReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"issuerReference", (Object)lhsIssuerReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"issuerReference", (Object)rhsIssuerReference), (Object)lhsIssuerReference, (Object)rhsIssuerReference)) {
            return false;
        }
        String lhsBin = this.getBin();
        String rhsBin = that.getBin();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"bin", (Object)lhsBin), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"bin", (Object)rhsBin), (Object)lhsBin, (Object)rhsBin)) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"period", (Object)lhsPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"period", (Object)rhsPeriod), (Object)lhsPeriod, (Object)rhsPeriod)) {
            return false;
        }
        Coding lhsType = this.getType();
        Coding rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType)) {
            return false;
        }
        Identifier lhsPlanholderIdentifier = this.getPlanholderIdentifier();
        Identifier rhsPlanholderIdentifier = that.getPlanholderIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"planholderIdentifier", (Object)lhsPlanholderIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"planholderIdentifier", (Object)rhsPlanholderIdentifier), (Object)lhsPlanholderIdentifier, (Object)rhsPlanholderIdentifier)) {
            return false;
        }
        Reference lhsPlanholderReference = this.getPlanholderReference();
        Reference rhsPlanholderReference = that.getPlanholderReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"planholderReference", (Object)lhsPlanholderReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"planholderReference", (Object)rhsPlanholderReference), (Object)lhsPlanholderReference, (Object)rhsPlanholderReference)) {
            return false;
        }
        Identifier lhsBeneficiaryIdentifier = this.getBeneficiaryIdentifier();
        Identifier rhsBeneficiaryIdentifier = that.getBeneficiaryIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"beneficiaryIdentifier", (Object)lhsBeneficiaryIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"beneficiaryIdentifier", (Object)rhsBeneficiaryIdentifier), (Object)lhsBeneficiaryIdentifier, (Object)rhsBeneficiaryIdentifier)) {
            return false;
        }
        Reference lhsBeneficiaryReference = this.getBeneficiaryReference();
        Reference rhsBeneficiaryReference = that.getBeneficiaryReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"beneficiaryReference", (Object)lhsBeneficiaryReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"beneficiaryReference", (Object)rhsBeneficiaryReference), (Object)lhsBeneficiaryReference, (Object)rhsBeneficiaryReference)) {
            return false;
        }
        Coding lhsRelationship = this.getRelationship();
        Coding rhsRelationship = that.getRelationship();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"relationship", (Object)lhsRelationship), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"relationship", (Object)rhsRelationship), (Object)lhsRelationship, (Object)rhsRelationship)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        String lhsGroup = this.getGroup();
        String rhsGroup = that.getGroup();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"group", (Object)lhsGroup), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"group", (Object)rhsGroup), (Object)lhsGroup, (Object)rhsGroup)) {
            return false;
        }
        String lhsPlan = this.getPlan();
        String rhsPlan = that.getPlan();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"plan", (Object)lhsPlan), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"plan", (Object)rhsPlan), (Object)lhsPlan, (Object)rhsPlan)) {
            return false;
        }
        String lhsSubPlan = this.getSubPlan();
        String rhsSubPlan = that.getSubPlan();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subPlan", (Object)lhsSubPlan), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subPlan", (Object)rhsSubPlan), (Object)lhsSubPlan, (Object)rhsSubPlan)) {
            return false;
        }
        PositiveInt lhsDependent = this.getDependent();
        PositiveInt rhsDependent = that.getDependent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dependent", (Object)lhsDependent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dependent", (Object)rhsDependent), (Object)lhsDependent, (Object)rhsDependent)) {
            return false;
        }
        PositiveInt lhsSequence = this.getSequence();
        PositiveInt rhsSequence = that.getSequence();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"sequence", (Object)lhsSequence), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"sequence", (Object)rhsSequence), (Object)lhsSequence, (Object)rhsSequence)) {
            return false;
        }
        List<Coding> lhsException = this.exception != null && !this.exception.isEmpty() ? this.getException() : null;
        List<Coding> list2 = rhsException = that.exception != null && !that.exception.isEmpty() ? that.getException() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"exception", lhsException), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"exception", rhsException), lhsException, rhsException)) {
            return false;
        }
        String lhsSchool = this.getSchool();
        String rhsSchool = that.getSchool();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"school", (Object)lhsSchool), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"school", (Object)rhsSchool), (Object)lhsSchool, (Object)rhsSchool)) {
            return false;
        }
        String lhsNetwork = this.getNetwork();
        String rhsNetwork = that.getNetwork();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"network", (Object)lhsNetwork), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"network", (Object)rhsNetwork), (Object)lhsNetwork, (Object)rhsNetwork)) {
            return false;
        }
        List<Reference> lhsContract = this.contract != null && !this.contract.isEmpty() ? this.getContract() : null;
        List<Reference> list3 = rhsContract = that.contract != null && !that.contract.isEmpty() ? that.getContract() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contract", lhsContract), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contract", rhsContract), lhsContract, rhsContract);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIssuerIdentifier = this.getIssuerIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"issuerIdentifier", (Object)theIssuerIdentifier), currentHashCode, (Object)theIssuerIdentifier);
        Reference theIssuerReference = this.getIssuerReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"issuerReference", (Object)theIssuerReference), currentHashCode, (Object)theIssuerReference);
        String theBin = this.getBin();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"bin", (Object)theBin), currentHashCode, (Object)theBin);
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"period", (Object)thePeriod), currentHashCode, (Object)thePeriod);
        Coding theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType);
        Identifier thePlanholderIdentifier = this.getPlanholderIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"planholderIdentifier", (Object)thePlanholderIdentifier), currentHashCode, (Object)thePlanholderIdentifier);
        Reference thePlanholderReference = this.getPlanholderReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"planholderReference", (Object)thePlanholderReference), currentHashCode, (Object)thePlanholderReference);
        Identifier theBeneficiaryIdentifier = this.getBeneficiaryIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"beneficiaryIdentifier", (Object)theBeneficiaryIdentifier), currentHashCode, (Object)theBeneficiaryIdentifier);
        Reference theBeneficiaryReference = this.getBeneficiaryReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"beneficiaryReference", (Object)theBeneficiaryReference), currentHashCode, (Object)theBeneficiaryReference);
        Coding theRelationship = this.getRelationship();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"relationship", (Object)theRelationship), currentHashCode, (Object)theRelationship);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        String theGroup = this.getGroup();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"group", (Object)theGroup), currentHashCode, (Object)theGroup);
        String thePlan = this.getPlan();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"plan", (Object)thePlan), currentHashCode, (Object)thePlan);
        String theSubPlan = this.getSubPlan();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subPlan", (Object)theSubPlan), currentHashCode, (Object)theSubPlan);
        PositiveInt theDependent = this.getDependent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dependent", (Object)theDependent), currentHashCode, (Object)theDependent);
        PositiveInt theSequence = this.getSequence();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"sequence", (Object)theSequence), currentHashCode, (Object)theSequence);
        List<Coding> theException = this.exception != null && !this.exception.isEmpty() ? this.getException() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"exception", theException), currentHashCode, theException);
        String theSchool = this.getSchool();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"school", (Object)theSchool), currentHashCode, (Object)theSchool);
        String theNetwork = this.getNetwork();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"network", (Object)theNetwork), currentHashCode, (Object)theNetwork);
        List<Reference> theContract = this.contract != null && !this.contract.isEmpty() ? this.getContract() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contract", theContract), currentHashCode, theContract);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIssuerIdentifier = this.getIssuerIdentifier();
        strategy.appendField(locator, (Object)this, "issuerIdentifier", buffer, (Object)theIssuerIdentifier);
        Reference theIssuerReference = this.getIssuerReference();
        strategy.appendField(locator, (Object)this, "issuerReference", buffer, (Object)theIssuerReference);
        String theBin = this.getBin();
        strategy.appendField(locator, (Object)this, "bin", buffer, (Object)theBin);
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, (Object)thePeriod);
        Coding theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType);
        Identifier thePlanholderIdentifier = this.getPlanholderIdentifier();
        strategy.appendField(locator, (Object)this, "planholderIdentifier", buffer, (Object)thePlanholderIdentifier);
        Reference thePlanholderReference = this.getPlanholderReference();
        strategy.appendField(locator, (Object)this, "planholderReference", buffer, (Object)thePlanholderReference);
        Identifier theBeneficiaryIdentifier = this.getBeneficiaryIdentifier();
        strategy.appendField(locator, (Object)this, "beneficiaryIdentifier", buffer, (Object)theBeneficiaryIdentifier);
        Reference theBeneficiaryReference = this.getBeneficiaryReference();
        strategy.appendField(locator, (Object)this, "beneficiaryReference", buffer, (Object)theBeneficiaryReference);
        Coding theRelationship = this.getRelationship();
        strategy.appendField(locator, (Object)this, "relationship", buffer, (Object)theRelationship);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        String theGroup = this.getGroup();
        strategy.appendField(locator, (Object)this, "group", buffer, (Object)theGroup);
        String thePlan = this.getPlan();
        strategy.appendField(locator, (Object)this, "plan", buffer, (Object)thePlan);
        String theSubPlan = this.getSubPlan();
        strategy.appendField(locator, (Object)this, "subPlan", buffer, (Object)theSubPlan);
        PositiveInt theDependent = this.getDependent();
        strategy.appendField(locator, (Object)this, "dependent", buffer, (Object)theDependent);
        PositiveInt theSequence = this.getSequence();
        strategy.appendField(locator, (Object)this, "sequence", buffer, (Object)theSequence);
        List<Coding> theException = this.exception != null && !this.exception.isEmpty() ? this.getException() : null;
        strategy.appendField(locator, (Object)this, "exception", buffer, theException);
        String theSchool = this.getSchool();
        strategy.appendField(locator, (Object)this, "school", buffer, (Object)theSchool);
        String theNetwork = this.getNetwork();
        strategy.appendField(locator, (Object)this, "network", buffer, (Object)theNetwork);
        List<Reference> theContract = this.contract != null && !this.contract.isEmpty() ? this.getContract() : null;
        strategy.appendField(locator, (Object)this, "contract", buffer, theContract);
        return buffer;
    }
}

