/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.Extension;
import org.hl7.fhir.ImmunizationRecommendationDateCriterion;
import org.hl7.fhir.ImmunizationRecommendationProtocol;
import org.hl7.fhir.PositiveInt;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ImmunizationRecommendation.Recommendation", propOrder={"date", "vaccineCode", "doseNumber", "forecastStatus", "dateCriterion", "protocol", "supportingImmunization", "supportingPatientInformation"})
public class ImmunizationRecommendationRecommendation
extends BackboneElement
implements Equals,
HashCode,
ToString {
    @XmlElement(required=true)
    protected DateTime date;
    @XmlElement(required=true)
    protected CodeableConcept vaccineCode;
    protected PositiveInt doseNumber;
    @XmlElement(required=true)
    protected CodeableConcept forecastStatus;
    protected List<ImmunizationRecommendationDateCriterion> dateCriterion;
    protected ImmunizationRecommendationProtocol protocol;
    protected List<Reference> supportingImmunization;
    protected List<Reference> supportingPatientInformation;

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public CodeableConcept getVaccineCode() {
        return this.vaccineCode;
    }

    public void setVaccineCode(CodeableConcept value) {
        this.vaccineCode = value;
    }

    public PositiveInt getDoseNumber() {
        return this.doseNumber;
    }

    public void setDoseNumber(PositiveInt value) {
        this.doseNumber = value;
    }

    public CodeableConcept getForecastStatus() {
        return this.forecastStatus;
    }

    public void setForecastStatus(CodeableConcept value) {
        this.forecastStatus = value;
    }

    public List<ImmunizationRecommendationDateCriterion> getDateCriterion() {
        if (this.dateCriterion == null) {
            this.dateCriterion = new ArrayList<ImmunizationRecommendationDateCriterion>();
        }
        return this.dateCriterion;
    }

    public ImmunizationRecommendationProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ImmunizationRecommendationProtocol value) {
        this.protocol = value;
    }

    public List<Reference> getSupportingImmunization() {
        if (this.supportingImmunization == null) {
            this.supportingImmunization = new ArrayList<Reference>();
        }
        return this.supportingImmunization;
    }

    public List<Reference> getSupportingPatientInformation() {
        if (this.supportingPatientInformation == null) {
            this.supportingPatientInformation = new ArrayList<Reference>();
        }
        return this.supportingPatientInformation;
    }

    public ImmunizationRecommendationRecommendation withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public ImmunizationRecommendationRecommendation withVaccineCode(CodeableConcept value) {
        this.setVaccineCode(value);
        return this;
    }

    public ImmunizationRecommendationRecommendation withDoseNumber(PositiveInt value) {
        this.setDoseNumber(value);
        return this;
    }

    public ImmunizationRecommendationRecommendation withForecastStatus(CodeableConcept value) {
        this.setForecastStatus(value);
        return this;
    }

    public ImmunizationRecommendationRecommendation withDateCriterion(ImmunizationRecommendationDateCriterion ... values) {
        if (values != null) {
            for (ImmunizationRecommendationDateCriterion value : values) {
                this.getDateCriterion().add(value);
            }
        }
        return this;
    }

    public ImmunizationRecommendationRecommendation withDateCriterion(Collection<ImmunizationRecommendationDateCriterion> values) {
        if (values != null) {
            this.getDateCriterion().addAll(values);
        }
        return this;
    }

    public ImmunizationRecommendationRecommendation withProtocol(ImmunizationRecommendationProtocol value) {
        this.setProtocol(value);
        return this;
    }

    public ImmunizationRecommendationRecommendation withSupportingImmunization(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSupportingImmunization().add(value);
            }
        }
        return this;
    }

    public ImmunizationRecommendationRecommendation withSupportingImmunization(Collection<Reference> values) {
        if (values != null) {
            this.getSupportingImmunization().addAll(values);
        }
        return this;
    }

    public ImmunizationRecommendationRecommendation withSupportingPatientInformation(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSupportingPatientInformation().add(value);
            }
        }
        return this;
    }

    public ImmunizationRecommendationRecommendation withSupportingPatientInformation(Collection<Reference> values) {
        if (values != null) {
            this.getSupportingPatientInformation().addAll(values);
        }
        return this;
    }

    @Override
    public ImmunizationRecommendationRecommendation withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImmunizationRecommendationRecommendation withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImmunizationRecommendationRecommendation withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImmunizationRecommendationRecommendation withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImmunizationRecommendationRecommendation withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<Reference> rhsSupportingPatientInformation;
        List<Reference> rhsSupportingImmunization;
        List<ImmunizationRecommendationDateCriterion> rhsDateCriterion;
        if (!(object instanceof ImmunizationRecommendationRecommendation)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ImmunizationRecommendationRecommendation that = (ImmunizationRecommendationRecommendation)object;
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate)) {
            return false;
        }
        CodeableConcept lhsVaccineCode = this.getVaccineCode();
        CodeableConcept rhsVaccineCode = that.getVaccineCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"vaccineCode", (Object)lhsVaccineCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"vaccineCode", (Object)rhsVaccineCode), (Object)lhsVaccineCode, (Object)rhsVaccineCode)) {
            return false;
        }
        PositiveInt lhsDoseNumber = this.getDoseNumber();
        PositiveInt rhsDoseNumber = that.getDoseNumber();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"doseNumber", (Object)lhsDoseNumber), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"doseNumber", (Object)rhsDoseNumber), (Object)lhsDoseNumber, (Object)rhsDoseNumber)) {
            return false;
        }
        CodeableConcept lhsForecastStatus = this.getForecastStatus();
        CodeableConcept rhsForecastStatus = that.getForecastStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"forecastStatus", (Object)lhsForecastStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"forecastStatus", (Object)rhsForecastStatus), (Object)lhsForecastStatus, (Object)rhsForecastStatus)) {
            return false;
        }
        List<ImmunizationRecommendationDateCriterion> lhsDateCriterion = this.dateCriterion != null && !this.dateCriterion.isEmpty() ? this.getDateCriterion() : null;
        List<ImmunizationRecommendationDateCriterion> list = rhsDateCriterion = that.dateCriterion != null && !that.dateCriterion.isEmpty() ? that.getDateCriterion() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dateCriterion", lhsDateCriterion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dateCriterion", rhsDateCriterion), lhsDateCriterion, rhsDateCriterion)) {
            return false;
        }
        ImmunizationRecommendationProtocol lhsProtocol = this.getProtocol();
        ImmunizationRecommendationProtocol rhsProtocol = that.getProtocol();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"protocol", (Object)lhsProtocol), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"protocol", (Object)rhsProtocol), (Object)lhsProtocol, (Object)rhsProtocol)) {
            return false;
        }
        List<Reference> lhsSupportingImmunization = this.supportingImmunization != null && !this.supportingImmunization.isEmpty() ? this.getSupportingImmunization() : null;
        List<Reference> list2 = rhsSupportingImmunization = that.supportingImmunization != null && !that.supportingImmunization.isEmpty() ? that.getSupportingImmunization() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"supportingImmunization", lhsSupportingImmunization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"supportingImmunization", rhsSupportingImmunization), lhsSupportingImmunization, rhsSupportingImmunization)) {
            return false;
        }
        List<Reference> lhsSupportingPatientInformation = this.supportingPatientInformation != null && !this.supportingPatientInformation.isEmpty() ? this.getSupportingPatientInformation() : null;
        List<Reference> list3 = rhsSupportingPatientInformation = that.supportingPatientInformation != null && !that.supportingPatientInformation.isEmpty() ? that.getSupportingPatientInformation() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"supportingPatientInformation", lhsSupportingPatientInformation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"supportingPatientInformation", rhsSupportingPatientInformation), lhsSupportingPatientInformation, rhsSupportingPatientInformation);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"date", (Object)theDate), currentHashCode, (Object)theDate);
        CodeableConcept theVaccineCode = this.getVaccineCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"vaccineCode", (Object)theVaccineCode), currentHashCode, (Object)theVaccineCode);
        PositiveInt theDoseNumber = this.getDoseNumber();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"doseNumber", (Object)theDoseNumber), currentHashCode, (Object)theDoseNumber);
        CodeableConcept theForecastStatus = this.getForecastStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"forecastStatus", (Object)theForecastStatus), currentHashCode, (Object)theForecastStatus);
        List<ImmunizationRecommendationDateCriterion> theDateCriterion = this.dateCriterion != null && !this.dateCriterion.isEmpty() ? this.getDateCriterion() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dateCriterion", theDateCriterion), currentHashCode, theDateCriterion);
        ImmunizationRecommendationProtocol theProtocol = this.getProtocol();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"protocol", (Object)theProtocol), currentHashCode, (Object)theProtocol);
        List<Reference> theSupportingImmunization = this.supportingImmunization != null && !this.supportingImmunization.isEmpty() ? this.getSupportingImmunization() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"supportingImmunization", theSupportingImmunization), currentHashCode, theSupportingImmunization);
        List<Reference> theSupportingPatientInformation = this.supportingPatientInformation != null && !this.supportingPatientInformation.isEmpty() ? this.getSupportingPatientInformation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"supportingPatientInformation", theSupportingPatientInformation), currentHashCode, theSupportingPatientInformation);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate);
        CodeableConcept theVaccineCode = this.getVaccineCode();
        strategy.appendField(locator, (Object)this, "vaccineCode", buffer, (Object)theVaccineCode);
        PositiveInt theDoseNumber = this.getDoseNumber();
        strategy.appendField(locator, (Object)this, "doseNumber", buffer, (Object)theDoseNumber);
        CodeableConcept theForecastStatus = this.getForecastStatus();
        strategy.appendField(locator, (Object)this, "forecastStatus", buffer, (Object)theForecastStatus);
        List<ImmunizationRecommendationDateCriterion> theDateCriterion = this.dateCriterion != null && !this.dateCriterion.isEmpty() ? this.getDateCriterion() : null;
        strategy.appendField(locator, (Object)this, "dateCriterion", buffer, theDateCriterion);
        ImmunizationRecommendationProtocol theProtocol = this.getProtocol();
        strategy.appendField(locator, (Object)this, "protocol", buffer, (Object)theProtocol);
        List<Reference> theSupportingImmunization = this.supportingImmunization != null && !this.supportingImmunization.isEmpty() ? this.getSupportingImmunization() : null;
        strategy.appendField(locator, (Object)this, "supportingImmunization", buffer, theSupportingImmunization);
        List<Reference> theSupportingPatientInformation = this.supportingPatientInformation != null && !this.supportingPatientInformation.isEmpty() ? this.getSupportingPatientInformation() : null;
        strategy.appendField(locator, (Object)this, "supportingPatientInformation", buffer, theSupportingPatientInformation);
        return buffer;
    }
}

