/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.MedicationStatementDosage;
import org.hl7.fhir.MedicationStatementStatus;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MedicationStatement", propOrder={"identifier", "status", "medicationCodeableConcept", "medicationReference", "patient", "effectiveDateTime", "effectivePeriod", "informationSource", "supportingInformation", "dateAsserted", "wasNotTaken", "reasonNotTaken", "reasonForUseCodeableConcept", "reasonForUseReference", "note", "dosage"})
public class MedicationStatement
extends DomainResource
implements Equals,
HashCode,
ToString {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected MedicationStatementStatus status;
    protected CodeableConcept medicationCodeableConcept;
    protected Reference medicationReference;
    @XmlElement(required=true)
    protected Reference patient;
    protected DateTime effectiveDateTime;
    protected Period effectivePeriod;
    protected Reference informationSource;
    protected List<Reference> supportingInformation;
    protected DateTime dateAsserted;
    protected Boolean wasNotTaken;
    protected List<CodeableConcept> reasonNotTaken;
    protected CodeableConcept reasonForUseCodeableConcept;
    protected Reference reasonForUseReference;
    protected List<Annotation> note;
    protected List<MedicationStatementDosage> dosage;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicationStatementStatus getStatus() {
        return this.status;
    }

    public void setStatus(MedicationStatementStatus value) {
        this.status = value;
    }

    public CodeableConcept getMedicationCodeableConcept() {
        return this.medicationCodeableConcept;
    }

    public void setMedicationCodeableConcept(CodeableConcept value) {
        this.medicationCodeableConcept = value;
    }

    public Reference getMedicationReference() {
        return this.medicationReference;
    }

    public void setMedicationReference(Reference value) {
        this.medicationReference = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public DateTime getEffectiveDateTime() {
        return this.effectiveDateTime;
    }

    public void setEffectiveDateTime(DateTime value) {
        this.effectiveDateTime = value;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public void setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
    }

    public Reference getInformationSource() {
        return this.informationSource;
    }

    public void setInformationSource(Reference value) {
        this.informationSource = value;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public DateTime getDateAsserted() {
        return this.dateAsserted;
    }

    public void setDateAsserted(DateTime value) {
        this.dateAsserted = value;
    }

    public Boolean getWasNotTaken() {
        return this.wasNotTaken;
    }

    public void setWasNotTaken(Boolean value) {
        this.wasNotTaken = value;
    }

    public List<CodeableConcept> getReasonNotTaken() {
        if (this.reasonNotTaken == null) {
            this.reasonNotTaken = new ArrayList<CodeableConcept>();
        }
        return this.reasonNotTaken;
    }

    public CodeableConcept getReasonForUseCodeableConcept() {
        return this.reasonForUseCodeableConcept;
    }

    public void setReasonForUseCodeableConcept(CodeableConcept value) {
        this.reasonForUseCodeableConcept = value;
    }

    public Reference getReasonForUseReference() {
        return this.reasonForUseReference;
    }

    public void setReasonForUseReference(Reference value) {
        this.reasonForUseReference = value;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public List<MedicationStatementDosage> getDosage() {
        if (this.dosage == null) {
            this.dosage = new ArrayList<MedicationStatementDosage>();
        }
        return this.dosage;
    }

    public MedicationStatement withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public MedicationStatement withStatus(MedicationStatementStatus value) {
        this.setStatus(value);
        return this;
    }

    public MedicationStatement withMedicationCodeableConcept(CodeableConcept value) {
        this.setMedicationCodeableConcept(value);
        return this;
    }

    public MedicationStatement withMedicationReference(Reference value) {
        this.setMedicationReference(value);
        return this;
    }

    public MedicationStatement withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public MedicationStatement withEffectiveDateTime(DateTime value) {
        this.setEffectiveDateTime(value);
        return this;
    }

    public MedicationStatement withEffectivePeriod(Period value) {
        this.setEffectivePeriod(value);
        return this;
    }

    public MedicationStatement withInformationSource(Reference value) {
        this.setInformationSource(value);
        return this;
    }

    public MedicationStatement withSupportingInformation(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSupportingInformation().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withSupportingInformation(Collection<Reference> values) {
        if (values != null) {
            this.getSupportingInformation().addAll(values);
        }
        return this;
    }

    public MedicationStatement withDateAsserted(DateTime value) {
        this.setDateAsserted(value);
        return this;
    }

    public MedicationStatement withWasNotTaken(Boolean value) {
        this.setWasNotTaken(value);
        return this;
    }

    public MedicationStatement withReasonNotTaken(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReasonNotTaken().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withReasonNotTaken(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReasonNotTaken().addAll(values);
        }
        return this;
    }

    public MedicationStatement withReasonForUseCodeableConcept(CodeableConcept value) {
        this.setReasonForUseCodeableConcept(value);
        return this;
    }

    public MedicationStatement withReasonForUseReference(Reference value) {
        this.setReasonForUseReference(value);
        return this;
    }

    public MedicationStatement withNote(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withNote(Collection<Annotation> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    public MedicationStatement withDosage(MedicationStatementDosage ... values) {
        if (values != null) {
            for (MedicationStatementDosage value : values) {
                this.getDosage().add(value);
            }
        }
        return this;
    }

    public MedicationStatement withDosage(Collection<MedicationStatementDosage> values) {
        if (values != null) {
            this.getDosage().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MedicationStatement withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationStatement withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationStatement withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationStatement withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationStatement withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MedicationStatement withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MedicationStatement withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MedicationStatement withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        List<MedicationStatementDosage> rhsDosage;
        List<Annotation> rhsNote;
        List<CodeableConcept> rhsReasonNotTaken;
        List<Reference> rhsSupportingInformation;
        List<Identifier> rhsIdentifier;
        if (!(object instanceof MedicationStatement)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationStatement that = (MedicationStatement)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> list = rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier)) {
            return false;
        }
        MedicationStatementStatus lhsStatus = this.getStatus();
        MedicationStatementStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus)) {
            return false;
        }
        CodeableConcept lhsMedicationCodeableConcept = this.getMedicationCodeableConcept();
        CodeableConcept rhsMedicationCodeableConcept = that.getMedicationCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"medicationCodeableConcept", (Object)lhsMedicationCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"medicationCodeableConcept", (Object)rhsMedicationCodeableConcept), (Object)lhsMedicationCodeableConcept, (Object)rhsMedicationCodeableConcept)) {
            return false;
        }
        Reference lhsMedicationReference = this.getMedicationReference();
        Reference rhsMedicationReference = that.getMedicationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"medicationReference", (Object)lhsMedicationReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"medicationReference", (Object)rhsMedicationReference), (Object)lhsMedicationReference, (Object)rhsMedicationReference)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient)) {
            return false;
        }
        DateTime lhsEffectiveDateTime = this.getEffectiveDateTime();
        DateTime rhsEffectiveDateTime = that.getEffectiveDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"effectiveDateTime", (Object)lhsEffectiveDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"effectiveDateTime", (Object)rhsEffectiveDateTime), (Object)lhsEffectiveDateTime, (Object)rhsEffectiveDateTime)) {
            return false;
        }
        Period lhsEffectivePeriod = this.getEffectivePeriod();
        Period rhsEffectivePeriod = that.getEffectivePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"effectivePeriod", (Object)lhsEffectivePeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"effectivePeriod", (Object)rhsEffectivePeriod), (Object)lhsEffectivePeriod, (Object)rhsEffectivePeriod)) {
            return false;
        }
        Reference lhsInformationSource = this.getInformationSource();
        Reference rhsInformationSource = that.getInformationSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"informationSource", (Object)lhsInformationSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"informationSource", (Object)rhsInformationSource), (Object)lhsInformationSource, (Object)rhsInformationSource)) {
            return false;
        }
        List<Reference> lhsSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        List<Reference> list2 = rhsSupportingInformation = that.supportingInformation != null && !that.supportingInformation.isEmpty() ? that.getSupportingInformation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"supportingInformation", lhsSupportingInformation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"supportingInformation", rhsSupportingInformation), lhsSupportingInformation, rhsSupportingInformation)) {
            return false;
        }
        DateTime lhsDateAsserted = this.getDateAsserted();
        DateTime rhsDateAsserted = that.getDateAsserted();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dateAsserted", (Object)lhsDateAsserted), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dateAsserted", (Object)rhsDateAsserted), (Object)lhsDateAsserted, (Object)rhsDateAsserted)) {
            return false;
        }
        Boolean lhsWasNotTaken = this.getWasNotTaken();
        Boolean rhsWasNotTaken = that.getWasNotTaken();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"wasNotTaken", (Object)lhsWasNotTaken), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"wasNotTaken", (Object)rhsWasNotTaken), (Object)lhsWasNotTaken, (Object)rhsWasNotTaken)) {
            return false;
        }
        List<CodeableConcept> lhsReasonNotTaken = this.reasonNotTaken != null && !this.reasonNotTaken.isEmpty() ? this.getReasonNotTaken() : null;
        List<CodeableConcept> list3 = rhsReasonNotTaken = that.reasonNotTaken != null && !that.reasonNotTaken.isEmpty() ? that.getReasonNotTaken() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reasonNotTaken", lhsReasonNotTaken), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reasonNotTaken", rhsReasonNotTaken), lhsReasonNotTaken, rhsReasonNotTaken)) {
            return false;
        }
        CodeableConcept lhsReasonForUseCodeableConcept = this.getReasonForUseCodeableConcept();
        CodeableConcept rhsReasonForUseCodeableConcept = that.getReasonForUseCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reasonForUseCodeableConcept", (Object)lhsReasonForUseCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reasonForUseCodeableConcept", (Object)rhsReasonForUseCodeableConcept), (Object)lhsReasonForUseCodeableConcept, (Object)rhsReasonForUseCodeableConcept)) {
            return false;
        }
        Reference lhsReasonForUseReference = this.getReasonForUseReference();
        Reference rhsReasonForUseReference = that.getReasonForUseReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reasonForUseReference", (Object)lhsReasonForUseReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reasonForUseReference", (Object)rhsReasonForUseReference), (Object)lhsReasonForUseReference, (Object)rhsReasonForUseReference)) {
            return false;
        }
        List<Annotation> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<Annotation> list4 = rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"note", lhsNote), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"note", rhsNote), lhsNote, rhsNote)) {
            return false;
        }
        List<MedicationStatementDosage> lhsDosage = this.dosage != null && !this.dosage.isEmpty() ? this.getDosage() : null;
        List<MedicationStatementDosage> list5 = rhsDosage = that.dosage != null && !that.dosage.isEmpty() ? that.getDosage() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dosage", lhsDosage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dosage", rhsDosage), lhsDosage, rhsDosage);
    }

    @Override
    public boolean equals(Object object) {
        EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", theIdentifier), currentHashCode, theIdentifier);
        MedicationStatementStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"medicationCodeableConcept", (Object)theMedicationCodeableConcept), currentHashCode, (Object)theMedicationCodeableConcept);
        Reference theMedicationReference = this.getMedicationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"medicationReference", (Object)theMedicationReference), currentHashCode, (Object)theMedicationReference);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient);
        DateTime theEffectiveDateTime = this.getEffectiveDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"effectiveDateTime", (Object)theEffectiveDateTime), currentHashCode, (Object)theEffectiveDateTime);
        Period theEffectivePeriod = this.getEffectivePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"effectivePeriod", (Object)theEffectivePeriod), currentHashCode, (Object)theEffectivePeriod);
        Reference theInformationSource = this.getInformationSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"informationSource", (Object)theInformationSource), currentHashCode, (Object)theInformationSource);
        List<Reference> theSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"supportingInformation", theSupportingInformation), currentHashCode, theSupportingInformation);
        DateTime theDateAsserted = this.getDateAsserted();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dateAsserted", (Object)theDateAsserted), currentHashCode, (Object)theDateAsserted);
        Boolean theWasNotTaken = this.getWasNotTaken();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"wasNotTaken", (Object)theWasNotTaken), currentHashCode, (Object)theWasNotTaken);
        List<CodeableConcept> theReasonNotTaken = this.reasonNotTaken != null && !this.reasonNotTaken.isEmpty() ? this.getReasonNotTaken() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reasonNotTaken", theReasonNotTaken), currentHashCode, theReasonNotTaken);
        CodeableConcept theReasonForUseCodeableConcept = this.getReasonForUseCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reasonForUseCodeableConcept", (Object)theReasonForUseCodeableConcept), currentHashCode, (Object)theReasonForUseCodeableConcept);
        Reference theReasonForUseReference = this.getReasonForUseReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reasonForUseReference", (Object)theReasonForUseReference), currentHashCode, (Object)theReasonForUseReference);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"note", theNote), currentHashCode, theNote);
        List<MedicationStatementDosage> theDosage = this.dosage != null && !this.dosage.isEmpty() ? this.getDosage() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dosage", theDosage), currentHashCode, theDosage);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier);
        MedicationStatementStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus);
        CodeableConcept theMedicationCodeableConcept = this.getMedicationCodeableConcept();
        strategy.appendField(locator, (Object)this, "medicationCodeableConcept", buffer, (Object)theMedicationCodeableConcept);
        Reference theMedicationReference = this.getMedicationReference();
        strategy.appendField(locator, (Object)this, "medicationReference", buffer, (Object)theMedicationReference);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient);
        DateTime theEffectiveDateTime = this.getEffectiveDateTime();
        strategy.appendField(locator, (Object)this, "effectiveDateTime", buffer, (Object)theEffectiveDateTime);
        Period theEffectivePeriod = this.getEffectivePeriod();
        strategy.appendField(locator, (Object)this, "effectivePeriod", buffer, (Object)theEffectivePeriod);
        Reference theInformationSource = this.getInformationSource();
        strategy.appendField(locator, (Object)this, "informationSource", buffer, (Object)theInformationSource);
        List<Reference> theSupportingInformation = this.supportingInformation != null && !this.supportingInformation.isEmpty() ? this.getSupportingInformation() : null;
        strategy.appendField(locator, (Object)this, "supportingInformation", buffer, theSupportingInformation);
        DateTime theDateAsserted = this.getDateAsserted();
        strategy.appendField(locator, (Object)this, "dateAsserted", buffer, (Object)theDateAsserted);
        Boolean theWasNotTaken = this.getWasNotTaken();
        strategy.appendField(locator, (Object)this, "wasNotTaken", buffer, (Object)theWasNotTaken);
        List<CodeableConcept> theReasonNotTaken = this.reasonNotTaken != null && !this.reasonNotTaken.isEmpty() ? this.getReasonNotTaken() : null;
        strategy.appendField(locator, (Object)this, "reasonNotTaken", buffer, theReasonNotTaken);
        CodeableConcept theReasonForUseCodeableConcept = this.getReasonForUseCodeableConcept();
        strategy.appendField(locator, (Object)this, "reasonForUseCodeableConcept", buffer, (Object)theReasonForUseCodeableConcept);
        Reference theReasonForUseReference = this.getReasonForUseReference();
        strategy.appendField(locator, (Object)this, "reasonForUseReference", buffer, (Object)theReasonForUseReference);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote);
        List<MedicationStatementDosage> theDosage = this.dosage != null && !this.dosage.isEmpty() ? this.getDosage() : null;
        strategy.appendField(locator, (Object)this, "dosage", buffer, theDosage);
        return buffer;
    }
}

