/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.ClaimSubDetail;
import org.hl7.fhir.Coding;
import org.hl7.fhir.Decimal;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Money;
import org.hl7.fhir.PositiveInt;
import org.hl7.fhir.Reference;
import org.hl7.fhir.SimpleQuantity;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Claim.Detail", propOrder={"sequence", "type", "service", "programCode", "quantity", "unitPrice", "factor", "points", "net", "udi", "subDetail"})
public class ClaimDetail
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected PositiveInt sequence;
    @XmlElement(required=true)
    protected Coding type;
    @XmlElement(required=true)
    protected Coding service;
    protected List<Coding> programCode;
    protected SimpleQuantity quantity;
    protected Money unitPrice;
    protected Decimal factor;
    protected Decimal points;
    protected Money net;
    protected List<Reference> udi;
    protected List<ClaimSubDetail> subDetail;

    public PositiveInt getSequence() {
        return this.sequence;
    }

    public void setSequence(PositiveInt value) {
        this.sequence = value;
    }

    public Coding getType() {
        return this.type;
    }

    public void setType(Coding value) {
        this.type = value;
    }

    public Coding getService() {
        return this.service;
    }

    public void setService(Coding value) {
        this.service = value;
    }

    public List<Coding> getProgramCode() {
        if (this.programCode == null) {
            this.programCode = new ArrayList<Coding>();
        }
        return this.programCode;
    }

    public SimpleQuantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(SimpleQuantity value) {
        this.quantity = value;
    }

    public Money getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Money value) {
        this.unitPrice = value;
    }

    public Decimal getFactor() {
        return this.factor;
    }

    public void setFactor(Decimal value) {
        this.factor = value;
    }

    public Decimal getPoints() {
        return this.points;
    }

    public void setPoints(Decimal value) {
        this.points = value;
    }

    public Money getNet() {
        return this.net;
    }

    public void setNet(Money value) {
        this.net = value;
    }

    public List<Reference> getUdi() {
        if (this.udi == null) {
            this.udi = new ArrayList<Reference>();
        }
        return this.udi;
    }

    public List<ClaimSubDetail> getSubDetail() {
        if (this.subDetail == null) {
            this.subDetail = new ArrayList<ClaimSubDetail>();
        }
        return this.subDetail;
    }

    public ClaimDetail withSequence(PositiveInt value) {
        this.setSequence(value);
        return this;
    }

    public ClaimDetail withType(Coding value) {
        this.setType(value);
        return this;
    }

    public ClaimDetail withService(Coding value) {
        this.setService(value);
        return this;
    }

    public ClaimDetail withProgramCode(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getProgramCode().add(value);
            }
        }
        return this;
    }

    public ClaimDetail withProgramCode(Collection<Coding> values) {
        if (values != null) {
            this.getProgramCode().addAll(values);
        }
        return this;
    }

    public ClaimDetail withQuantity(SimpleQuantity value) {
        this.setQuantity(value);
        return this;
    }

    public ClaimDetail withUnitPrice(Money value) {
        this.setUnitPrice(value);
        return this;
    }

    public ClaimDetail withFactor(Decimal value) {
        this.setFactor(value);
        return this;
    }

    public ClaimDetail withPoints(Decimal value) {
        this.setPoints(value);
        return this;
    }

    public ClaimDetail withNet(Money value) {
        this.setNet(value);
        return this;
    }

    public ClaimDetail withUdi(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getUdi().add(value);
            }
        }
        return this;
    }

    public ClaimDetail withUdi(Collection<Reference> values) {
        if (values != null) {
            this.getUdi().addAll(values);
        }
        return this;
    }

    public ClaimDetail withSubDetail(ClaimSubDetail ... values) {
        if (values != null) {
            for (ClaimSubDetail value : values) {
                this.getSubDetail().add(value);
            }
        }
        return this;
    }

    public ClaimDetail withSubDetail(Collection<ClaimSubDetail> values) {
        if (values != null) {
            this.getSubDetail().addAll(values);
        }
        return this;
    }

    @Override
    public ClaimDetail withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ClaimDetail withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ClaimDetail withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ClaimDetail withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ClaimDetail withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ClaimDetail that = (ClaimDetail)object;
        PositiveInt lhsSequence = this.getSequence();
        PositiveInt rhsSequence = that.getSequence();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"sequence", (Object)lhsSequence), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"sequence", (Object)rhsSequence), (Object)lhsSequence, (Object)rhsSequence, this.sequence != null, that.sequence != null)) {
            return false;
        }
        Coding lhsType = this.getType();
        Coding rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        Coding lhsService = this.getService();
        Coding rhsService = that.getService();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"service", (Object)lhsService), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"service", (Object)rhsService), (Object)lhsService, (Object)rhsService, this.service != null, that.service != null)) {
            return false;
        }
        List<Coding> lhsProgramCode = this.programCode != null && !this.programCode.isEmpty() ? this.getProgramCode() : null;
        List<Coding> rhsProgramCode = that.programCode != null && !that.programCode.isEmpty() ? that.getProgramCode() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"programCode", lhsProgramCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"programCode", rhsProgramCode), lhsProgramCode, rhsProgramCode, this.programCode != null && !this.programCode.isEmpty(), that.programCode != null && !that.programCode.isEmpty())) {
            return false;
        }
        SimpleQuantity lhsQuantity = this.getQuantity();
        SimpleQuantity rhsQuantity = that.getQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"quantity", (Object)lhsQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"quantity", (Object)rhsQuantity), (Object)lhsQuantity, (Object)rhsQuantity, this.quantity != null, that.quantity != null)) {
            return false;
        }
        Money lhsUnitPrice = this.getUnitPrice();
        Money rhsUnitPrice = that.getUnitPrice();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"unitPrice", (Object)lhsUnitPrice), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"unitPrice", (Object)rhsUnitPrice), (Object)lhsUnitPrice, (Object)rhsUnitPrice, this.unitPrice != null, that.unitPrice != null)) {
            return false;
        }
        Decimal lhsFactor = this.getFactor();
        Decimal rhsFactor = that.getFactor();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"factor", (Object)lhsFactor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"factor", (Object)rhsFactor), (Object)lhsFactor, (Object)rhsFactor, this.factor != null, that.factor != null)) {
            return false;
        }
        Decimal lhsPoints = this.getPoints();
        Decimal rhsPoints = that.getPoints();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"points", (Object)lhsPoints), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"points", (Object)rhsPoints), (Object)lhsPoints, (Object)rhsPoints, this.points != null, that.points != null)) {
            return false;
        }
        Money lhsNet = this.getNet();
        Money rhsNet = that.getNet();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"net", (Object)lhsNet), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"net", (Object)rhsNet), (Object)lhsNet, (Object)rhsNet, this.net != null, that.net != null)) {
            return false;
        }
        List<Reference> lhsUdi = this.udi != null && !this.udi.isEmpty() ? this.getUdi() : null;
        List<Reference> rhsUdi = that.udi != null && !that.udi.isEmpty() ? that.getUdi() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"udi", lhsUdi), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"udi", rhsUdi), lhsUdi, rhsUdi, this.udi != null && !this.udi.isEmpty(), that.udi != null && !that.udi.isEmpty())) {
            return false;
        }
        List<ClaimSubDetail> lhsSubDetail = this.subDetail != null && !this.subDetail.isEmpty() ? this.getSubDetail() : null;
        List<ClaimSubDetail> rhsSubDetail = that.subDetail != null && !that.subDetail.isEmpty() ? that.getSubDetail() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"subDetail", lhsSubDetail), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"subDetail", rhsSubDetail), lhsSubDetail, rhsSubDetail, this.subDetail != null && !this.subDetail.isEmpty(), that.subDetail != null && !that.subDetail.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        PositiveInt theSequence = this.getSequence();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"sequence", (Object)theSequence), currentHashCode, (Object)theSequence, this.sequence != null);
        Coding theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        Coding theService = this.getService();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"service", (Object)theService), currentHashCode, (Object)theService, this.service != null);
        List<Coding> theProgramCode = this.programCode != null && !this.programCode.isEmpty() ? this.getProgramCode() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"programCode", theProgramCode), currentHashCode, theProgramCode, this.programCode != null && !this.programCode.isEmpty());
        SimpleQuantity theQuantity = this.getQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"quantity", (Object)theQuantity), currentHashCode, (Object)theQuantity, this.quantity != null);
        Money theUnitPrice = this.getUnitPrice();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"unitPrice", (Object)theUnitPrice), currentHashCode, (Object)theUnitPrice, this.unitPrice != null);
        Decimal theFactor = this.getFactor();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"factor", (Object)theFactor), currentHashCode, (Object)theFactor, this.factor != null);
        Decimal thePoints = this.getPoints();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"points", (Object)thePoints), currentHashCode, (Object)thePoints, this.points != null);
        Money theNet = this.getNet();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"net", (Object)theNet), currentHashCode, (Object)theNet, this.net != null);
        List<Reference> theUdi = this.udi != null && !this.udi.isEmpty() ? this.getUdi() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"udi", theUdi), currentHashCode, theUdi, this.udi != null && !this.udi.isEmpty());
        List<ClaimSubDetail> theSubDetail = this.subDetail != null && !this.subDetail.isEmpty() ? this.getSubDetail() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"subDetail", theSubDetail), currentHashCode, theSubDetail, this.subDetail != null && !this.subDetail.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        PositiveInt theSequence = this.getSequence();
        strategy.appendField(locator, (Object)this, "sequence", buffer, (Object)theSequence, this.sequence != null);
        Coding theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        Coding theService = this.getService();
        strategy.appendField(locator, (Object)this, "service", buffer, (Object)theService, this.service != null);
        List<Coding> theProgramCode = this.programCode != null && !this.programCode.isEmpty() ? this.getProgramCode() : null;
        strategy.appendField(locator, (Object)this, "programCode", buffer, theProgramCode, this.programCode != null && !this.programCode.isEmpty());
        SimpleQuantity theQuantity = this.getQuantity();
        strategy.appendField(locator, (Object)this, "quantity", buffer, (Object)theQuantity, this.quantity != null);
        Money theUnitPrice = this.getUnitPrice();
        strategy.appendField(locator, (Object)this, "unitPrice", buffer, (Object)theUnitPrice, this.unitPrice != null);
        Decimal theFactor = this.getFactor();
        strategy.appendField(locator, (Object)this, "factor", buffer, (Object)theFactor, this.factor != null);
        Decimal thePoints = this.getPoints();
        strategy.appendField(locator, (Object)this, "points", buffer, (Object)thePoints, this.points != null);
        Money theNet = this.getNet();
        strategy.appendField(locator, (Object)this, "net", buffer, (Object)theNet, this.net != null);
        List<Reference> theUdi = this.udi != null && !this.udi.isEmpty() ? this.getUdi() : null;
        strategy.appendField(locator, (Object)this, "udi", buffer, theUdi, this.udi != null && !this.udi.isEmpty());
        List<ClaimSubDetail> theSubDetail = this.subDetail != null && !this.subDetail.isEmpty() ? this.getSubDetail() : null;
        strategy.appendField(locator, (Object)this, "subDetail", buffer, theSubDetail, this.subDetail != null && !this.subDetail.isEmpty());
        return buffer;
    }
}

