/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Attachment;
import org.hl7.fhir.Code;
import org.hl7.fhir.DataRequirement;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.LibraryCodeSystem;
import org.hl7.fhir.LibraryLibrary;
import org.hl7.fhir.LibraryModel;
import org.hl7.fhir.LibraryValueSet;
import org.hl7.fhir.Meta;
import org.hl7.fhir.ModuleMetadata;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ParameterDefinition;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Library", propOrder={"moduleMetadata", "model", "library", "codeSystem", "valueSet", "parameter", "dataRequirement", "document"})
public class Library
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected ModuleMetadata moduleMetadata;
    protected List<LibraryModel> model;
    protected List<LibraryLibrary> library;
    protected List<LibraryCodeSystem> codeSystem;
    protected List<LibraryValueSet> valueSet;
    protected List<ParameterDefinition> parameter;
    protected List<DataRequirement> dataRequirement;
    @XmlElement(required=true)
    protected Attachment document;

    public ModuleMetadata getModuleMetadata() {
        return this.moduleMetadata;
    }

    public void setModuleMetadata(ModuleMetadata value) {
        this.moduleMetadata = value;
    }

    public List<LibraryModel> getModel() {
        if (this.model == null) {
            this.model = new ArrayList<LibraryModel>();
        }
        return this.model;
    }

    public List<LibraryLibrary> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<LibraryLibrary>();
        }
        return this.library;
    }

    public List<LibraryCodeSystem> getCodeSystem() {
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<LibraryCodeSystem>();
        }
        return this.codeSystem;
    }

    public List<LibraryValueSet> getValueSet() {
        if (this.valueSet == null) {
            this.valueSet = new ArrayList<LibraryValueSet>();
        }
        return this.valueSet;
    }

    public List<ParameterDefinition> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParameterDefinition>();
        }
        return this.parameter;
    }

    public List<DataRequirement> getDataRequirement() {
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        return this.dataRequirement;
    }

    public Attachment getDocument() {
        return this.document;
    }

    public void setDocument(Attachment value) {
        this.document = value;
    }

    public Library withModuleMetadata(ModuleMetadata value) {
        this.setModuleMetadata(value);
        return this;
    }

    public Library withModel(LibraryModel ... values) {
        if (values != null) {
            for (LibraryModel value : values) {
                this.getModel().add(value);
            }
        }
        return this;
    }

    public Library withModel(Collection<LibraryModel> values) {
        if (values != null) {
            this.getModel().addAll(values);
        }
        return this;
    }

    public Library withLibrary(LibraryLibrary ... values) {
        if (values != null) {
            for (LibraryLibrary value : values) {
                this.getLibrary().add(value);
            }
        }
        return this;
    }

    public Library withLibrary(Collection<LibraryLibrary> values) {
        if (values != null) {
            this.getLibrary().addAll(values);
        }
        return this;
    }

    public Library withCodeSystem(LibraryCodeSystem ... values) {
        if (values != null) {
            for (LibraryCodeSystem value : values) {
                this.getCodeSystem().add(value);
            }
        }
        return this;
    }

    public Library withCodeSystem(Collection<LibraryCodeSystem> values) {
        if (values != null) {
            this.getCodeSystem().addAll(values);
        }
        return this;
    }

    public Library withValueSet(LibraryValueSet ... values) {
        if (values != null) {
            for (LibraryValueSet value : values) {
                this.getValueSet().add(value);
            }
        }
        return this;
    }

    public Library withValueSet(Collection<LibraryValueSet> values) {
        if (values != null) {
            this.getValueSet().addAll(values);
        }
        return this;
    }

    public Library withParameter(ParameterDefinition ... values) {
        if (values != null) {
            for (ParameterDefinition value : values) {
                this.getParameter().add(value);
            }
        }
        return this;
    }

    public Library withParameter(Collection<ParameterDefinition> values) {
        if (values != null) {
            this.getParameter().addAll(values);
        }
        return this;
    }

    public Library withDataRequirement(DataRequirement ... values) {
        if (values != null) {
            for (DataRequirement value : values) {
                this.getDataRequirement().add(value);
            }
        }
        return this;
    }

    public Library withDataRequirement(Collection<DataRequirement> values) {
        if (values != null) {
            this.getDataRequirement().addAll(values);
        }
        return this;
    }

    public Library withDocument(Attachment value) {
        this.setDocument(value);
        return this;
    }

    @Override
    public Library withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Library withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Library withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Library withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Library withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Library withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Library withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Library withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Library withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Library withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Library withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Library that = (Library)object;
        ModuleMetadata lhsModuleMetadata = this.getModuleMetadata();
        ModuleMetadata rhsModuleMetadata = that.getModuleMetadata();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"moduleMetadata", (Object)lhsModuleMetadata), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"moduleMetadata", (Object)rhsModuleMetadata), (Object)lhsModuleMetadata, (Object)rhsModuleMetadata, this.moduleMetadata != null, that.moduleMetadata != null)) {
            return false;
        }
        List<LibraryModel> lhsModel = this.model != null && !this.model.isEmpty() ? this.getModel() : null;
        List<LibraryModel> rhsModel = that.model != null && !that.model.isEmpty() ? that.getModel() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"model", lhsModel), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"model", rhsModel), lhsModel, rhsModel, this.model != null && !this.model.isEmpty(), that.model != null && !that.model.isEmpty())) {
            return false;
        }
        List<LibraryLibrary> lhsLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        List<LibraryLibrary> rhsLibrary = that.library != null && !that.library.isEmpty() ? that.getLibrary() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"library", lhsLibrary), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"library", rhsLibrary), lhsLibrary, rhsLibrary, this.library != null && !this.library.isEmpty(), that.library != null && !that.library.isEmpty())) {
            return false;
        }
        List<LibraryCodeSystem> lhsCodeSystem = this.codeSystem != null && !this.codeSystem.isEmpty() ? this.getCodeSystem() : null;
        List<LibraryCodeSystem> rhsCodeSystem = that.codeSystem != null && !that.codeSystem.isEmpty() ? that.getCodeSystem() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"codeSystem", lhsCodeSystem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"codeSystem", rhsCodeSystem), lhsCodeSystem, rhsCodeSystem, this.codeSystem != null && !this.codeSystem.isEmpty(), that.codeSystem != null && !that.codeSystem.isEmpty())) {
            return false;
        }
        List<LibraryValueSet> lhsValueSet = this.valueSet != null && !this.valueSet.isEmpty() ? this.getValueSet() : null;
        List<LibraryValueSet> rhsValueSet = that.valueSet != null && !that.valueSet.isEmpty() ? that.getValueSet() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"valueSet", lhsValueSet), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"valueSet", rhsValueSet), lhsValueSet, rhsValueSet, this.valueSet != null && !this.valueSet.isEmpty(), that.valueSet != null && !that.valueSet.isEmpty())) {
            return false;
        }
        List<ParameterDefinition> lhsParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        List<ParameterDefinition> rhsParameter = that.parameter != null && !that.parameter.isEmpty() ? that.getParameter() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"parameter", lhsParameter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"parameter", rhsParameter), lhsParameter, rhsParameter, this.parameter != null && !this.parameter.isEmpty(), that.parameter != null && !that.parameter.isEmpty())) {
            return false;
        }
        List<DataRequirement> lhsDataRequirement = this.dataRequirement != null && !this.dataRequirement.isEmpty() ? this.getDataRequirement() : null;
        List<DataRequirement> rhsDataRequirement = that.dataRequirement != null && !that.dataRequirement.isEmpty() ? that.getDataRequirement() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dataRequirement", lhsDataRequirement), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dataRequirement", rhsDataRequirement), lhsDataRequirement, rhsDataRequirement, this.dataRequirement != null && !this.dataRequirement.isEmpty(), that.dataRequirement != null && !that.dataRequirement.isEmpty())) {
            return false;
        }
        Attachment lhsDocument = this.getDocument();
        Attachment rhsDocument = that.getDocument();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"document", (Object)lhsDocument), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"document", (Object)rhsDocument), (Object)lhsDocument, (Object)rhsDocument, this.document != null, that.document != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        ModuleMetadata theModuleMetadata = this.getModuleMetadata();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"moduleMetadata", (Object)theModuleMetadata), currentHashCode, (Object)theModuleMetadata, this.moduleMetadata != null);
        List<LibraryModel> theModel = this.model != null && !this.model.isEmpty() ? this.getModel() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"model", theModel), currentHashCode, theModel, this.model != null && !this.model.isEmpty());
        List<LibraryLibrary> theLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"library", theLibrary), currentHashCode, theLibrary, this.library != null && !this.library.isEmpty());
        List<LibraryCodeSystem> theCodeSystem = this.codeSystem != null && !this.codeSystem.isEmpty() ? this.getCodeSystem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"codeSystem", theCodeSystem), currentHashCode, theCodeSystem, this.codeSystem != null && !this.codeSystem.isEmpty());
        List<LibraryValueSet> theValueSet = this.valueSet != null && !this.valueSet.isEmpty() ? this.getValueSet() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"valueSet", theValueSet), currentHashCode, theValueSet, this.valueSet != null && !this.valueSet.isEmpty());
        List<ParameterDefinition> theParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"parameter", theParameter), currentHashCode, theParameter, this.parameter != null && !this.parameter.isEmpty());
        List<DataRequirement> theDataRequirement = this.dataRequirement != null && !this.dataRequirement.isEmpty() ? this.getDataRequirement() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dataRequirement", theDataRequirement), currentHashCode, theDataRequirement, this.dataRequirement != null && !this.dataRequirement.isEmpty());
        Attachment theDocument = this.getDocument();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"document", (Object)theDocument), currentHashCode, (Object)theDocument, this.document != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        ModuleMetadata theModuleMetadata = this.getModuleMetadata();
        strategy.appendField(locator, (Object)this, "moduleMetadata", buffer, (Object)theModuleMetadata, this.moduleMetadata != null);
        List<LibraryModel> theModel = this.model != null && !this.model.isEmpty() ? this.getModel() : null;
        strategy.appendField(locator, (Object)this, "model", buffer, theModel, this.model != null && !this.model.isEmpty());
        List<LibraryLibrary> theLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        strategy.appendField(locator, (Object)this, "library", buffer, theLibrary, this.library != null && !this.library.isEmpty());
        List<LibraryCodeSystem> theCodeSystem = this.codeSystem != null && !this.codeSystem.isEmpty() ? this.getCodeSystem() : null;
        strategy.appendField(locator, (Object)this, "codeSystem", buffer, theCodeSystem, this.codeSystem != null && !this.codeSystem.isEmpty());
        List<LibraryValueSet> theValueSet = this.valueSet != null && !this.valueSet.isEmpty() ? this.getValueSet() : null;
        strategy.appendField(locator, (Object)this, "valueSet", buffer, theValueSet, this.valueSet != null && !this.valueSet.isEmpty());
        List<ParameterDefinition> theParameter = this.parameter != null && !this.parameter.isEmpty() ? this.getParameter() : null;
        strategy.appendField(locator, (Object)this, "parameter", buffer, theParameter, this.parameter != null && !this.parameter.isEmpty());
        List<DataRequirement> theDataRequirement = this.dataRequirement != null && !this.dataRequirement.isEmpty() ? this.getDataRequirement() : null;
        strategy.appendField(locator, (Object)this, "dataRequirement", buffer, theDataRequirement, this.dataRequirement != null && !this.dataRequirement.isEmpty());
        Attachment theDocument = this.getDocument();
        strategy.appendField(locator, (Object)this, "document", buffer, (Object)theDocument, this.document != null);
        return buffer;
    }
}

