/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Markdown;
import org.hl7.fhir.MeasureGroup;
import org.hl7.fhir.MeasureScoring;
import org.hl7.fhir.MeasureSupplementalData;
import org.hl7.fhir.MeasureType;
import org.hl7.fhir.Meta;
import org.hl7.fhir.ModuleMetadata;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Measure", propOrder={"moduleMetadata", "library", "disclaimer", "scoring", "type", "riskAdjustment", "rateAggregation", "rationale", "clinicalRecommendationStatement", "improvementNotation", "definition", "guidance", "set", "group", "supplementalData"})
public class Measure
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected ModuleMetadata moduleMetadata;
    protected List<Reference> library;
    protected Markdown disclaimer;
    protected MeasureScoring scoring;
    protected List<MeasureType> type;
    protected String riskAdjustment;
    protected String rateAggregation;
    protected Markdown rationale;
    protected Markdown clinicalRecommendationStatement;
    protected String improvementNotation;
    protected Markdown definition;
    protected Markdown guidance;
    protected String set;
    protected List<MeasureGroup> group;
    protected List<MeasureSupplementalData> supplementalData;

    public ModuleMetadata getModuleMetadata() {
        return this.moduleMetadata;
    }

    public void setModuleMetadata(ModuleMetadata value) {
        this.moduleMetadata = value;
    }

    public List<Reference> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        return this.library;
    }

    public Markdown getDisclaimer() {
        return this.disclaimer;
    }

    public void setDisclaimer(Markdown value) {
        this.disclaimer = value;
    }

    public MeasureScoring getScoring() {
        return this.scoring;
    }

    public void setScoring(MeasureScoring value) {
        this.scoring = value;
    }

    public List<MeasureType> getType() {
        if (this.type == null) {
            this.type = new ArrayList<MeasureType>();
        }
        return this.type;
    }

    public String getRiskAdjustment() {
        return this.riskAdjustment;
    }

    public void setRiskAdjustment(String value) {
        this.riskAdjustment = value;
    }

    public String getRateAggregation() {
        return this.rateAggregation;
    }

    public void setRateAggregation(String value) {
        this.rateAggregation = value;
    }

    public Markdown getRationale() {
        return this.rationale;
    }

    public void setRationale(Markdown value) {
        this.rationale = value;
    }

    public Markdown getClinicalRecommendationStatement() {
        return this.clinicalRecommendationStatement;
    }

    public void setClinicalRecommendationStatement(Markdown value) {
        this.clinicalRecommendationStatement = value;
    }

    public String getImprovementNotation() {
        return this.improvementNotation;
    }

    public void setImprovementNotation(String value) {
        this.improvementNotation = value;
    }

    public Markdown getDefinition() {
        return this.definition;
    }

    public void setDefinition(Markdown value) {
        this.definition = value;
    }

    public Markdown getGuidance() {
        return this.guidance;
    }

    public void setGuidance(Markdown value) {
        this.guidance = value;
    }

    public String getSet() {
        return this.set;
    }

    public void setSet(String value) {
        this.set = value;
    }

    public List<MeasureGroup> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<MeasureGroup>();
        }
        return this.group;
    }

    public List<MeasureSupplementalData> getSupplementalData() {
        if (this.supplementalData == null) {
            this.supplementalData = new ArrayList<MeasureSupplementalData>();
        }
        return this.supplementalData;
    }

    public Measure withModuleMetadata(ModuleMetadata value) {
        this.setModuleMetadata(value);
        return this;
    }

    public Measure withLibrary(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getLibrary().add(value);
            }
        }
        return this;
    }

    public Measure withLibrary(Collection<Reference> values) {
        if (values != null) {
            this.getLibrary().addAll(values);
        }
        return this;
    }

    public Measure withDisclaimer(Markdown value) {
        this.setDisclaimer(value);
        return this;
    }

    public Measure withScoring(MeasureScoring value) {
        this.setScoring(value);
        return this;
    }

    public Measure withType(MeasureType ... values) {
        if (values != null) {
            for (MeasureType value : values) {
                this.getType().add(value);
            }
        }
        return this;
    }

    public Measure withType(Collection<MeasureType> values) {
        if (values != null) {
            this.getType().addAll(values);
        }
        return this;
    }

    public Measure withRiskAdjustment(String value) {
        this.setRiskAdjustment(value);
        return this;
    }

    public Measure withRateAggregation(String value) {
        this.setRateAggregation(value);
        return this;
    }

    public Measure withRationale(Markdown value) {
        this.setRationale(value);
        return this;
    }

    public Measure withClinicalRecommendationStatement(Markdown value) {
        this.setClinicalRecommendationStatement(value);
        return this;
    }

    public Measure withImprovementNotation(String value) {
        this.setImprovementNotation(value);
        return this;
    }

    public Measure withDefinition(Markdown value) {
        this.setDefinition(value);
        return this;
    }

    public Measure withGuidance(Markdown value) {
        this.setGuidance(value);
        return this;
    }

    public Measure withSet(String value) {
        this.setSet(value);
        return this;
    }

    public Measure withGroup(MeasureGroup ... values) {
        if (values != null) {
            for (MeasureGroup value : values) {
                this.getGroup().add(value);
            }
        }
        return this;
    }

    public Measure withGroup(Collection<MeasureGroup> values) {
        if (values != null) {
            this.getGroup().addAll(values);
        }
        return this;
    }

    public Measure withSupplementalData(MeasureSupplementalData ... values) {
        if (values != null) {
            for (MeasureSupplementalData value : values) {
                this.getSupplementalData().add(value);
            }
        }
        return this;
    }

    public Measure withSupplementalData(Collection<MeasureSupplementalData> values) {
        if (values != null) {
            this.getSupplementalData().addAll(values);
        }
        return this;
    }

    @Override
    public Measure withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Measure withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Measure withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Measure withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Measure withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Measure withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Measure withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Measure withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Measure withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Measure withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Measure withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Measure that = (Measure)object;
        ModuleMetadata lhsModuleMetadata = this.getModuleMetadata();
        ModuleMetadata rhsModuleMetadata = that.getModuleMetadata();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"moduleMetadata", (Object)lhsModuleMetadata), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"moduleMetadata", (Object)rhsModuleMetadata), (Object)lhsModuleMetadata, (Object)rhsModuleMetadata, this.moduleMetadata != null, that.moduleMetadata != null)) {
            return false;
        }
        List<Reference> lhsLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        List<Reference> rhsLibrary = that.library != null && !that.library.isEmpty() ? that.getLibrary() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"library", lhsLibrary), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"library", rhsLibrary), lhsLibrary, rhsLibrary, this.library != null && !this.library.isEmpty(), that.library != null && !that.library.isEmpty())) {
            return false;
        }
        Markdown lhsDisclaimer = this.getDisclaimer();
        Markdown rhsDisclaimer = that.getDisclaimer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"disclaimer", (Object)lhsDisclaimer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"disclaimer", (Object)rhsDisclaimer), (Object)lhsDisclaimer, (Object)rhsDisclaimer, this.disclaimer != null, that.disclaimer != null)) {
            return false;
        }
        MeasureScoring lhsScoring = this.getScoring();
        MeasureScoring rhsScoring = that.getScoring();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"scoring", (Object)lhsScoring), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"scoring", (Object)rhsScoring), (Object)lhsScoring, (Object)rhsScoring, this.scoring != null, that.scoring != null)) {
            return false;
        }
        List<MeasureType> lhsType = this.type != null && !this.type.isEmpty() ? this.getType() : null;
        List<MeasureType> rhsType = that.type != null && !that.type.isEmpty() ? that.getType() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", rhsType), lhsType, rhsType, this.type != null && !this.type.isEmpty(), that.type != null && !that.type.isEmpty())) {
            return false;
        }
        String lhsRiskAdjustment = this.getRiskAdjustment();
        String rhsRiskAdjustment = that.getRiskAdjustment();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"riskAdjustment", (Object)lhsRiskAdjustment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"riskAdjustment", (Object)rhsRiskAdjustment), (Object)lhsRiskAdjustment, (Object)rhsRiskAdjustment, this.riskAdjustment != null, that.riskAdjustment != null)) {
            return false;
        }
        String lhsRateAggregation = this.getRateAggregation();
        String rhsRateAggregation = that.getRateAggregation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"rateAggregation", (Object)lhsRateAggregation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"rateAggregation", (Object)rhsRateAggregation), (Object)lhsRateAggregation, (Object)rhsRateAggregation, this.rateAggregation != null, that.rateAggregation != null)) {
            return false;
        }
        Markdown lhsRationale = this.getRationale();
        Markdown rhsRationale = that.getRationale();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"rationale", (Object)lhsRationale), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"rationale", (Object)rhsRationale), (Object)lhsRationale, (Object)rhsRationale, this.rationale != null, that.rationale != null)) {
            return false;
        }
        Markdown lhsClinicalRecommendationStatement = this.getClinicalRecommendationStatement();
        Markdown rhsClinicalRecommendationStatement = that.getClinicalRecommendationStatement();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"clinicalRecommendationStatement", (Object)lhsClinicalRecommendationStatement), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"clinicalRecommendationStatement", (Object)rhsClinicalRecommendationStatement), (Object)lhsClinicalRecommendationStatement, (Object)rhsClinicalRecommendationStatement, this.clinicalRecommendationStatement != null, that.clinicalRecommendationStatement != null)) {
            return false;
        }
        String lhsImprovementNotation = this.getImprovementNotation();
        String rhsImprovementNotation = that.getImprovementNotation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"improvementNotation", (Object)lhsImprovementNotation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"improvementNotation", (Object)rhsImprovementNotation), (Object)lhsImprovementNotation, (Object)rhsImprovementNotation, this.improvementNotation != null, that.improvementNotation != null)) {
            return false;
        }
        Markdown lhsDefinition = this.getDefinition();
        Markdown rhsDefinition = that.getDefinition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"definition", (Object)lhsDefinition), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"definition", (Object)rhsDefinition), (Object)lhsDefinition, (Object)rhsDefinition, this.definition != null, that.definition != null)) {
            return false;
        }
        Markdown lhsGuidance = this.getGuidance();
        Markdown rhsGuidance = that.getGuidance();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"guidance", (Object)lhsGuidance), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"guidance", (Object)rhsGuidance), (Object)lhsGuidance, (Object)rhsGuidance, this.guidance != null, that.guidance != null)) {
            return false;
        }
        String lhsSet = this.getSet();
        String rhsSet = that.getSet();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"set", (Object)lhsSet), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"set", (Object)rhsSet), (Object)lhsSet, (Object)rhsSet, this.set != null, that.set != null)) {
            return false;
        }
        List<MeasureGroup> lhsGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        List<MeasureGroup> rhsGroup = that.group != null && !that.group.isEmpty() ? that.getGroup() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"group", lhsGroup), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"group", rhsGroup), lhsGroup, rhsGroup, this.group != null && !this.group.isEmpty(), that.group != null && !that.group.isEmpty())) {
            return false;
        }
        List<MeasureSupplementalData> lhsSupplementalData = this.supplementalData != null && !this.supplementalData.isEmpty() ? this.getSupplementalData() : null;
        List<MeasureSupplementalData> rhsSupplementalData = that.supplementalData != null && !that.supplementalData.isEmpty() ? that.getSupplementalData() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"supplementalData", lhsSupplementalData), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"supplementalData", rhsSupplementalData), lhsSupplementalData, rhsSupplementalData, this.supplementalData != null && !this.supplementalData.isEmpty(), that.supplementalData != null && !that.supplementalData.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        ModuleMetadata theModuleMetadata = this.getModuleMetadata();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"moduleMetadata", (Object)theModuleMetadata), currentHashCode, (Object)theModuleMetadata, this.moduleMetadata != null);
        List<Reference> theLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"library", theLibrary), currentHashCode, theLibrary, this.library != null && !this.library.isEmpty());
        Markdown theDisclaimer = this.getDisclaimer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"disclaimer", (Object)theDisclaimer), currentHashCode, (Object)theDisclaimer, this.disclaimer != null);
        MeasureScoring theScoring = this.getScoring();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"scoring", (Object)theScoring), currentHashCode, (Object)theScoring, this.scoring != null);
        List<MeasureType> theType = this.type != null && !this.type.isEmpty() ? this.getType() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", theType), currentHashCode, theType, this.type != null && !this.type.isEmpty());
        String theRiskAdjustment = this.getRiskAdjustment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"riskAdjustment", (Object)theRiskAdjustment), currentHashCode, (Object)theRiskAdjustment, this.riskAdjustment != null);
        String theRateAggregation = this.getRateAggregation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"rateAggregation", (Object)theRateAggregation), currentHashCode, (Object)theRateAggregation, this.rateAggregation != null);
        Markdown theRationale = this.getRationale();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"rationale", (Object)theRationale), currentHashCode, (Object)theRationale, this.rationale != null);
        Markdown theClinicalRecommendationStatement = this.getClinicalRecommendationStatement();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"clinicalRecommendationStatement", (Object)theClinicalRecommendationStatement), currentHashCode, (Object)theClinicalRecommendationStatement, this.clinicalRecommendationStatement != null);
        String theImprovementNotation = this.getImprovementNotation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"improvementNotation", (Object)theImprovementNotation), currentHashCode, (Object)theImprovementNotation, this.improvementNotation != null);
        Markdown theDefinition = this.getDefinition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"definition", (Object)theDefinition), currentHashCode, (Object)theDefinition, this.definition != null);
        Markdown theGuidance = this.getGuidance();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"guidance", (Object)theGuidance), currentHashCode, (Object)theGuidance, this.guidance != null);
        String theSet = this.getSet();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"set", (Object)theSet), currentHashCode, (Object)theSet, this.set != null);
        List<MeasureGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"group", theGroup), currentHashCode, theGroup, this.group != null && !this.group.isEmpty());
        List<MeasureSupplementalData> theSupplementalData = this.supplementalData != null && !this.supplementalData.isEmpty() ? this.getSupplementalData() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"supplementalData", theSupplementalData), currentHashCode, theSupplementalData, this.supplementalData != null && !this.supplementalData.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        ModuleMetadata theModuleMetadata = this.getModuleMetadata();
        strategy.appendField(locator, (Object)this, "moduleMetadata", buffer, (Object)theModuleMetadata, this.moduleMetadata != null);
        List<Reference> theLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        strategy.appendField(locator, (Object)this, "library", buffer, theLibrary, this.library != null && !this.library.isEmpty());
        Markdown theDisclaimer = this.getDisclaimer();
        strategy.appendField(locator, (Object)this, "disclaimer", buffer, (Object)theDisclaimer, this.disclaimer != null);
        MeasureScoring theScoring = this.getScoring();
        strategy.appendField(locator, (Object)this, "scoring", buffer, (Object)theScoring, this.scoring != null);
        List<MeasureType> theType = this.type != null && !this.type.isEmpty() ? this.getType() : null;
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null && !this.type.isEmpty());
        String theRiskAdjustment = this.getRiskAdjustment();
        strategy.appendField(locator, (Object)this, "riskAdjustment", buffer, (Object)theRiskAdjustment, this.riskAdjustment != null);
        String theRateAggregation = this.getRateAggregation();
        strategy.appendField(locator, (Object)this, "rateAggregation", buffer, (Object)theRateAggregation, this.rateAggregation != null);
        Markdown theRationale = this.getRationale();
        strategy.appendField(locator, (Object)this, "rationale", buffer, (Object)theRationale, this.rationale != null);
        Markdown theClinicalRecommendationStatement = this.getClinicalRecommendationStatement();
        strategy.appendField(locator, (Object)this, "clinicalRecommendationStatement", buffer, (Object)theClinicalRecommendationStatement, this.clinicalRecommendationStatement != null);
        String theImprovementNotation = this.getImprovementNotation();
        strategy.appendField(locator, (Object)this, "improvementNotation", buffer, (Object)theImprovementNotation, this.improvementNotation != null);
        Markdown theDefinition = this.getDefinition();
        strategy.appendField(locator, (Object)this, "definition", buffer, (Object)theDefinition, this.definition != null);
        Markdown theGuidance = this.getGuidance();
        strategy.appendField(locator, (Object)this, "guidance", buffer, (Object)theGuidance, this.guidance != null);
        String theSet = this.getSet();
        strategy.appendField(locator, (Object)this, "set", buffer, (Object)theSet, this.set != null);
        List<MeasureGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        strategy.appendField(locator, (Object)this, "group", buffer, theGroup, this.group != null && !this.group.isEmpty());
        List<MeasureSupplementalData> theSupplementalData = this.supplementalData != null && !this.supplementalData.isEmpty() ? this.getSupplementalData() : null;
        strategy.appendField(locator, (Object)this, "supplementalData", buffer, theSupplementalData, this.supplementalData != null && !this.supplementalData.isEmpty());
        return buffer;
    }
}

