/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.AuditEventAction;
import org.hl7.fhir.AuditEventAgent;
import org.hl7.fhir.AuditEventEntity;
import org.hl7.fhir.AuditEventOutcome;
import org.hl7.fhir.AuditEventSource;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AuditEvent", propOrder={"type", "subtype", "action", "recorded", "outcome", "outcomeDesc", "purposeOfEvent", "agent", "source", "entity"})
public class AuditEvent
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Coding type;
    protected List<Coding> subtype;
    protected AuditEventAction action;
    @XmlElement(required=true)
    protected Instant recorded;
    protected AuditEventOutcome outcome;
    protected String outcomeDesc;
    protected List<Coding> purposeOfEvent;
    @XmlElement(required=true)
    protected List<AuditEventAgent> agent;
    @XmlElement(required=true)
    protected AuditEventSource source;
    protected List<AuditEventEntity> entity;

    public Coding getType() {
        return this.type;
    }

    public void setType(Coding value) {
        this.type = value;
    }

    public List<Coding> getSubtype() {
        if (this.subtype == null) {
            this.subtype = new ArrayList<Coding>();
        }
        return this.subtype;
    }

    public AuditEventAction getAction() {
        return this.action;
    }

    public void setAction(AuditEventAction value) {
        this.action = value;
    }

    public Instant getRecorded() {
        return this.recorded;
    }

    public void setRecorded(Instant value) {
        this.recorded = value;
    }

    public AuditEventOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(AuditEventOutcome value) {
        this.outcome = value;
    }

    public String getOutcomeDesc() {
        return this.outcomeDesc;
    }

    public void setOutcomeDesc(String value) {
        this.outcomeDesc = value;
    }

    public List<Coding> getPurposeOfEvent() {
        if (this.purposeOfEvent == null) {
            this.purposeOfEvent = new ArrayList<Coding>();
        }
        return this.purposeOfEvent;
    }

    public List<AuditEventAgent> getAgent() {
        if (this.agent == null) {
            this.agent = new ArrayList<AuditEventAgent>();
        }
        return this.agent;
    }

    public AuditEventSource getSource() {
        return this.source;
    }

    public void setSource(AuditEventSource value) {
        this.source = value;
    }

    public List<AuditEventEntity> getEntity() {
        if (this.entity == null) {
            this.entity = new ArrayList<AuditEventEntity>();
        }
        return this.entity;
    }

    public AuditEvent withType(Coding value) {
        this.setType(value);
        return this;
    }

    public AuditEvent withSubtype(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getSubtype().add(value);
            }
        }
        return this;
    }

    public AuditEvent withSubtype(Collection<Coding> values) {
        if (values != null) {
            this.getSubtype().addAll(values);
        }
        return this;
    }

    public AuditEvent withAction(AuditEventAction value) {
        this.setAction(value);
        return this;
    }

    public AuditEvent withRecorded(Instant value) {
        this.setRecorded(value);
        return this;
    }

    public AuditEvent withOutcome(AuditEventOutcome value) {
        this.setOutcome(value);
        return this;
    }

    public AuditEvent withOutcomeDesc(String value) {
        this.setOutcomeDesc(value);
        return this;
    }

    public AuditEvent withPurposeOfEvent(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getPurposeOfEvent().add(value);
            }
        }
        return this;
    }

    public AuditEvent withPurposeOfEvent(Collection<Coding> values) {
        if (values != null) {
            this.getPurposeOfEvent().addAll(values);
        }
        return this;
    }

    public AuditEvent withAgent(AuditEventAgent ... values) {
        if (values != null) {
            for (AuditEventAgent value : values) {
                this.getAgent().add(value);
            }
        }
        return this;
    }

    public AuditEvent withAgent(Collection<AuditEventAgent> values) {
        if (values != null) {
            this.getAgent().addAll(values);
        }
        return this;
    }

    public AuditEvent withSource(AuditEventSource value) {
        this.setSource(value);
        return this;
    }

    public AuditEvent withEntity(AuditEventEntity ... values) {
        if (values != null) {
            for (AuditEventEntity value : values) {
                this.getEntity().add(value);
            }
        }
        return this;
    }

    public AuditEvent withEntity(Collection<AuditEventEntity> values) {
        if (values != null) {
            this.getEntity().addAll(values);
        }
        return this;
    }

    @Override
    public AuditEvent withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public AuditEvent withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public AuditEvent withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public AuditEvent withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public AuditEvent withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public AuditEvent withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public AuditEvent withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public AuditEvent withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public AuditEvent withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public AuditEvent withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public AuditEvent withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        AuditEvent that = (AuditEvent)object;
        Coding lhsType = this.getType();
        Coding rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        List<Coding> lhsSubtype = this.subtype != null && !this.subtype.isEmpty() ? this.getSubtype() : null;
        List<Coding> rhsSubtype = that.subtype != null && !that.subtype.isEmpty() ? that.getSubtype() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subtype", lhsSubtype), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subtype", rhsSubtype), lhsSubtype, rhsSubtype, this.subtype != null && !this.subtype.isEmpty(), that.subtype != null && !that.subtype.isEmpty())) {
            return false;
        }
        AuditEventAction lhsAction = this.getAction();
        AuditEventAction rhsAction = that.getAction();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"action", (Object)lhsAction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"action", (Object)rhsAction), (Object)lhsAction, (Object)rhsAction, this.action != null, that.action != null)) {
            return false;
        }
        Instant lhsRecorded = this.getRecorded();
        Instant rhsRecorded = that.getRecorded();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"recorded", (Object)lhsRecorded), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"recorded", (Object)rhsRecorded), (Object)lhsRecorded, (Object)rhsRecorded, this.recorded != null, that.recorded != null)) {
            return false;
        }
        AuditEventOutcome lhsOutcome = this.getOutcome();
        AuditEventOutcome rhsOutcome = that.getOutcome();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"outcome", (Object)lhsOutcome), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"outcome", (Object)rhsOutcome), (Object)lhsOutcome, (Object)rhsOutcome, this.outcome != null, that.outcome != null)) {
            return false;
        }
        String lhsOutcomeDesc = this.getOutcomeDesc();
        String rhsOutcomeDesc = that.getOutcomeDesc();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"outcomeDesc", (Object)lhsOutcomeDesc), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"outcomeDesc", (Object)rhsOutcomeDesc), (Object)lhsOutcomeDesc, (Object)rhsOutcomeDesc, this.outcomeDesc != null, that.outcomeDesc != null)) {
            return false;
        }
        List<Coding> lhsPurposeOfEvent = this.purposeOfEvent != null && !this.purposeOfEvent.isEmpty() ? this.getPurposeOfEvent() : null;
        List<Coding> rhsPurposeOfEvent = that.purposeOfEvent != null && !that.purposeOfEvent.isEmpty() ? that.getPurposeOfEvent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"purposeOfEvent", lhsPurposeOfEvent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"purposeOfEvent", rhsPurposeOfEvent), lhsPurposeOfEvent, rhsPurposeOfEvent, this.purposeOfEvent != null && !this.purposeOfEvent.isEmpty(), that.purposeOfEvent != null && !that.purposeOfEvent.isEmpty())) {
            return false;
        }
        List<AuditEventAgent> lhsAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        List<AuditEventAgent> rhsAgent = that.agent != null && !that.agent.isEmpty() ? that.getAgent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"agent", lhsAgent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"agent", rhsAgent), lhsAgent, rhsAgent, this.agent != null && !this.agent.isEmpty(), that.agent != null && !that.agent.isEmpty())) {
            return false;
        }
        AuditEventSource lhsSource = this.getSource();
        AuditEventSource rhsSource = that.getSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"source", (Object)lhsSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"source", (Object)rhsSource), (Object)lhsSource, (Object)rhsSource, this.source != null, that.source != null)) {
            return false;
        }
        List<AuditEventEntity> lhsEntity = this.entity != null && !this.entity.isEmpty() ? this.getEntity() : null;
        List<AuditEventEntity> rhsEntity = that.entity != null && !that.entity.isEmpty() ? that.getEntity() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"entity", lhsEntity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"entity", rhsEntity), lhsEntity, rhsEntity, this.entity != null && !this.entity.isEmpty(), that.entity != null && !that.entity.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Coding theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        List<Coding> theSubtype = this.subtype != null && !this.subtype.isEmpty() ? this.getSubtype() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subtype", theSubtype), currentHashCode, theSubtype, this.subtype != null && !this.subtype.isEmpty());
        AuditEventAction theAction = this.getAction();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"action", (Object)theAction), currentHashCode, (Object)theAction, this.action != null);
        Instant theRecorded = this.getRecorded();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"recorded", (Object)theRecorded), currentHashCode, (Object)theRecorded, this.recorded != null);
        AuditEventOutcome theOutcome = this.getOutcome();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"outcome", (Object)theOutcome), currentHashCode, (Object)theOutcome, this.outcome != null);
        String theOutcomeDesc = this.getOutcomeDesc();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"outcomeDesc", (Object)theOutcomeDesc), currentHashCode, (Object)theOutcomeDesc, this.outcomeDesc != null);
        List<Coding> thePurposeOfEvent = this.purposeOfEvent != null && !this.purposeOfEvent.isEmpty() ? this.getPurposeOfEvent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"purposeOfEvent", thePurposeOfEvent), currentHashCode, thePurposeOfEvent, this.purposeOfEvent != null && !this.purposeOfEvent.isEmpty());
        List<AuditEventAgent> theAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"agent", theAgent), currentHashCode, theAgent, this.agent != null && !this.agent.isEmpty());
        AuditEventSource theSource = this.getSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"source", (Object)theSource), currentHashCode, (Object)theSource, this.source != null);
        List<AuditEventEntity> theEntity = this.entity != null && !this.entity.isEmpty() ? this.getEntity() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"entity", theEntity), currentHashCode, theEntity, this.entity != null && !this.entity.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Coding theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        List<Coding> theSubtype = this.subtype != null && !this.subtype.isEmpty() ? this.getSubtype() : null;
        strategy.appendField(locator, (Object)this, "subtype", buffer, theSubtype, this.subtype != null && !this.subtype.isEmpty());
        AuditEventAction theAction = this.getAction();
        strategy.appendField(locator, (Object)this, "action", buffer, (Object)theAction, this.action != null);
        Instant theRecorded = this.getRecorded();
        strategy.appendField(locator, (Object)this, "recorded", buffer, (Object)theRecorded, this.recorded != null);
        AuditEventOutcome theOutcome = this.getOutcome();
        strategy.appendField(locator, (Object)this, "outcome", buffer, (Object)theOutcome, this.outcome != null);
        String theOutcomeDesc = this.getOutcomeDesc();
        strategy.appendField(locator, (Object)this, "outcomeDesc", buffer, (Object)theOutcomeDesc, this.outcomeDesc != null);
        List<Coding> thePurposeOfEvent = this.purposeOfEvent != null && !this.purposeOfEvent.isEmpty() ? this.getPurposeOfEvent() : null;
        strategy.appendField(locator, (Object)this, "purposeOfEvent", buffer, thePurposeOfEvent, this.purposeOfEvent != null && !this.purposeOfEvent.isEmpty());
        List<AuditEventAgent> theAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        strategy.appendField(locator, (Object)this, "agent", buffer, theAgent, this.agent != null && !this.agent.isEmpty());
        AuditEventSource theSource = this.getSource();
        strategy.appendField(locator, (Object)this, "source", buffer, (Object)theSource, this.source != null);
        List<AuditEventEntity> theEntity = this.entity != null && !this.entity.isEmpty() ? this.getEntity() : null;
        strategy.appendField(locator, (Object)this, "entity", buffer, theEntity, this.entity != null && !this.entity.isEmpty());
        return buffer;
    }
}

