/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.RemittanceOutcome;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EnrollmentResponse", propOrder={"identifier", "request", "outcome", "disposition", "ruleset", "originalRuleset", "created", "organization", "requestProvider", "requestOrganization"})
public class EnrollmentResponse
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected Reference request;
    protected RemittanceOutcome outcome;
    protected String disposition;
    protected Coding ruleset;
    protected Coding originalRuleset;
    protected DateTime created;
    protected Reference organization;
    protected Reference requestProvider;
    protected Reference requestOrganization;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getRequest() {
        return this.request;
    }

    public void setRequest(Reference value) {
        this.request = value;
    }

    public RemittanceOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(RemittanceOutcome value) {
        this.outcome = value;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String value) {
        this.disposition = value;
    }

    public Coding getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Coding value) {
        this.ruleset = value;
    }

    public Coding getOriginalRuleset() {
        return this.originalRuleset;
    }

    public void setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Reference getOrganization() {
        return this.organization;
    }

    public void setOrganization(Reference value) {
        this.organization = value;
    }

    public Reference getRequestProvider() {
        return this.requestProvider;
    }

    public void setRequestProvider(Reference value) {
        this.requestProvider = value;
    }

    public Reference getRequestOrganization() {
        return this.requestOrganization;
    }

    public void setRequestOrganization(Reference value) {
        this.requestOrganization = value;
    }

    public EnrollmentResponse withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public EnrollmentResponse withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public EnrollmentResponse withRequest(Reference value) {
        this.setRequest(value);
        return this;
    }

    public EnrollmentResponse withOutcome(RemittanceOutcome value) {
        this.setOutcome(value);
        return this;
    }

    public EnrollmentResponse withDisposition(String value) {
        this.setDisposition(value);
        return this;
    }

    public EnrollmentResponse withRuleset(Coding value) {
        this.setRuleset(value);
        return this;
    }

    public EnrollmentResponse withOriginalRuleset(Coding value) {
        this.setOriginalRuleset(value);
        return this;
    }

    public EnrollmentResponse withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public EnrollmentResponse withOrganization(Reference value) {
        this.setOrganization(value);
        return this;
    }

    public EnrollmentResponse withRequestProvider(Reference value) {
        this.setRequestProvider(value);
        return this;
    }

    public EnrollmentResponse withRequestOrganization(Reference value) {
        this.setRequestOrganization(value);
        return this;
    }

    @Override
    public EnrollmentResponse withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public EnrollmentResponse withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public EnrollmentResponse withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public EnrollmentResponse withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EnrollmentResponse withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EnrollmentResponse withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EnrollmentResponse withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EnrollmentResponse withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public EnrollmentResponse withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public EnrollmentResponse withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public EnrollmentResponse withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        EnrollmentResponse that = (EnrollmentResponse)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Reference lhsRequest = this.getRequest();
        Reference rhsRequest = that.getRequest();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"request", (Object)lhsRequest), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"request", (Object)rhsRequest), (Object)lhsRequest, (Object)rhsRequest, this.request != null, that.request != null)) {
            return false;
        }
        RemittanceOutcome lhsOutcome = this.getOutcome();
        RemittanceOutcome rhsOutcome = that.getOutcome();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"outcome", (Object)lhsOutcome), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"outcome", (Object)rhsOutcome), (Object)lhsOutcome, (Object)rhsOutcome, this.outcome != null, that.outcome != null)) {
            return false;
        }
        String lhsDisposition = this.getDisposition();
        String rhsDisposition = that.getDisposition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"disposition", (Object)lhsDisposition), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"disposition", (Object)rhsDisposition), (Object)lhsDisposition, (Object)rhsDisposition, this.disposition != null, that.disposition != null)) {
            return false;
        }
        Coding lhsRuleset = this.getRuleset();
        Coding rhsRuleset = that.getRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"ruleset", (Object)lhsRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"ruleset", (Object)rhsRuleset), (Object)lhsRuleset, (Object)rhsRuleset, this.ruleset != null, that.ruleset != null)) {
            return false;
        }
        Coding lhsOriginalRuleset = this.getOriginalRuleset();
        Coding rhsOriginalRuleset = that.getOriginalRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"originalRuleset", (Object)lhsOriginalRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"originalRuleset", (Object)rhsOriginalRuleset), (Object)lhsOriginalRuleset, (Object)rhsOriginalRuleset, this.originalRuleset != null, that.originalRuleset != null)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"created", (Object)lhsCreated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"created", (Object)rhsCreated), (Object)lhsCreated, (Object)rhsCreated, this.created != null, that.created != null)) {
            return false;
        }
        Reference lhsOrganization = this.getOrganization();
        Reference rhsOrganization = that.getOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"organization", (Object)lhsOrganization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"organization", (Object)rhsOrganization), (Object)lhsOrganization, (Object)rhsOrganization, this.organization != null, that.organization != null)) {
            return false;
        }
        Reference lhsRequestProvider = this.getRequestProvider();
        Reference rhsRequestProvider = that.getRequestProvider();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestProvider", (Object)lhsRequestProvider), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestProvider", (Object)rhsRequestProvider), (Object)lhsRequestProvider, (Object)rhsRequestProvider, this.requestProvider != null, that.requestProvider != null)) {
            return false;
        }
        Reference lhsRequestOrganization = this.getRequestOrganization();
        Reference rhsRequestOrganization = that.getRequestOrganization();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestOrganization", (Object)lhsRequestOrganization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestOrganization", (Object)rhsRequestOrganization), (Object)lhsRequestOrganization, (Object)rhsRequestOrganization, this.requestOrganization != null, that.requestOrganization != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theRequest = this.getRequest();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"request", (Object)theRequest), currentHashCode, (Object)theRequest, this.request != null);
        RemittanceOutcome theOutcome = this.getOutcome();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"outcome", (Object)theOutcome), currentHashCode, (Object)theOutcome, this.outcome != null);
        String theDisposition = this.getDisposition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"disposition", (Object)theDisposition), currentHashCode, (Object)theDisposition, this.disposition != null);
        Coding theRuleset = this.getRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"ruleset", (Object)theRuleset), currentHashCode, (Object)theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"originalRuleset", (Object)theOriginalRuleset), currentHashCode, (Object)theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"created", (Object)theCreated), currentHashCode, (Object)theCreated, this.created != null);
        Reference theOrganization = this.getOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"organization", (Object)theOrganization), currentHashCode, (Object)theOrganization, this.organization != null);
        Reference theRequestProvider = this.getRequestProvider();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestProvider", (Object)theRequestProvider), currentHashCode, (Object)theRequestProvider, this.requestProvider != null);
        Reference theRequestOrganization = this.getRequestOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestOrganization", (Object)theRequestOrganization), currentHashCode, (Object)theRequestOrganization, this.requestOrganization != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theRequest = this.getRequest();
        strategy.appendField(locator, (Object)this, "request", buffer, (Object)theRequest, this.request != null);
        RemittanceOutcome theOutcome = this.getOutcome();
        strategy.appendField(locator, (Object)this, "outcome", buffer, (Object)theOutcome, this.outcome != null);
        String theDisposition = this.getDisposition();
        strategy.appendField(locator, (Object)this, "disposition", buffer, (Object)theDisposition, this.disposition != null);
        Coding theRuleset = this.getRuleset();
        strategy.appendField(locator, (Object)this, "ruleset", buffer, (Object)theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        strategy.appendField(locator, (Object)this, "originalRuleset", buffer, (Object)theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, (Object)theCreated, this.created != null);
        Reference theOrganization = this.getOrganization();
        strategy.appendField(locator, (Object)this, "organization", buffer, (Object)theOrganization, this.organization != null);
        Reference theRequestProvider = this.getRequestProvider();
        strategy.appendField(locator, (Object)this, "requestProvider", buffer, (Object)theRequestProvider, this.requestProvider != null);
        Reference theRequestOrganization = this.getRequestOrganization();
        strategy.appendField(locator, (Object)this, "requestOrganization", buffer, (Object)theRequestOrganization, this.requestOrganization != null);
        return buffer;
    }
}

