/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.MeasureReportGroup;
import org.hl7.fhir.MeasureReportStatus;
import org.hl7.fhir.MeasureReportType;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MeasureReport", propOrder={"measure", "type", "patient", "period", "status", "date", "reportingOrganization", "group", "evaluatedResources"})
public class MeasureReport
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Reference measure;
    @XmlElement(required=true)
    protected MeasureReportType type;
    protected Reference patient;
    @XmlElement(required=true)
    protected Period period;
    @XmlElement(required=true)
    protected MeasureReportStatus status;
    protected DateTime date;
    protected Reference reportingOrganization;
    protected List<MeasureReportGroup> group;
    protected Reference evaluatedResources;

    public Reference getMeasure() {
        return this.measure;
    }

    public void setMeasure(Reference value) {
        this.measure = value;
    }

    public MeasureReportType getType() {
        return this.type;
    }

    public void setType(MeasureReportType value) {
        this.type = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public MeasureReportStatus getStatus() {
        return this.status;
    }

    public void setStatus(MeasureReportStatus value) {
        this.status = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public Reference getReportingOrganization() {
        return this.reportingOrganization;
    }

    public void setReportingOrganization(Reference value) {
        this.reportingOrganization = value;
    }

    public List<MeasureReportGroup> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<MeasureReportGroup>();
        }
        return this.group;
    }

    public Reference getEvaluatedResources() {
        return this.evaluatedResources;
    }

    public void setEvaluatedResources(Reference value) {
        this.evaluatedResources = value;
    }

    public MeasureReport withMeasure(Reference value) {
        this.setMeasure(value);
        return this;
    }

    public MeasureReport withType(MeasureReportType value) {
        this.setType(value);
        return this;
    }

    public MeasureReport withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public MeasureReport withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    public MeasureReport withStatus(MeasureReportStatus value) {
        this.setStatus(value);
        return this;
    }

    public MeasureReport withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public MeasureReport withReportingOrganization(Reference value) {
        this.setReportingOrganization(value);
        return this;
    }

    public MeasureReport withGroup(MeasureReportGroup ... values) {
        if (values != null) {
            for (MeasureReportGroup value : values) {
                this.getGroup().add(value);
            }
        }
        return this;
    }

    public MeasureReport withGroup(Collection<MeasureReportGroup> values) {
        if (values != null) {
            this.getGroup().addAll(values);
        }
        return this;
    }

    public MeasureReport withEvaluatedResources(Reference value) {
        this.setEvaluatedResources(value);
        return this;
    }

    @Override
    public MeasureReport withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public MeasureReport withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public MeasureReport withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public MeasureReport withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MeasureReport withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MeasureReport withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MeasureReport withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MeasureReport withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public MeasureReport withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public MeasureReport withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public MeasureReport withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MeasureReport that = (MeasureReport)object;
        Reference lhsMeasure = this.getMeasure();
        Reference rhsMeasure = that.getMeasure();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"measure", (Object)lhsMeasure), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"measure", (Object)rhsMeasure), (Object)lhsMeasure, (Object)rhsMeasure, this.measure != null, that.measure != null)) {
            return false;
        }
        MeasureReportType lhsType = this.getType();
        MeasureReportType rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"period", (Object)lhsPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"period", (Object)rhsPeriod), (Object)lhsPeriod, (Object)rhsPeriod, this.period != null, that.period != null)) {
            return false;
        }
        MeasureReportStatus lhsStatus = this.getStatus();
        MeasureReportStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        Reference lhsReportingOrganization = this.getReportingOrganization();
        Reference rhsReportingOrganization = that.getReportingOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reportingOrganization", (Object)lhsReportingOrganization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reportingOrganization", (Object)rhsReportingOrganization), (Object)lhsReportingOrganization, (Object)rhsReportingOrganization, this.reportingOrganization != null, that.reportingOrganization != null)) {
            return false;
        }
        List<MeasureReportGroup> lhsGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        List<MeasureReportGroup> rhsGroup = that.group != null && !that.group.isEmpty() ? that.getGroup() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"group", lhsGroup), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"group", rhsGroup), lhsGroup, rhsGroup, this.group != null && !this.group.isEmpty(), that.group != null && !that.group.isEmpty())) {
            return false;
        }
        Reference lhsEvaluatedResources = this.getEvaluatedResources();
        Reference rhsEvaluatedResources = that.getEvaluatedResources();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"evaluatedResources", (Object)lhsEvaluatedResources), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"evaluatedResources", (Object)rhsEvaluatedResources), (Object)lhsEvaluatedResources, (Object)rhsEvaluatedResources, this.evaluatedResources != null, that.evaluatedResources != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Reference theMeasure = this.getMeasure();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"measure", (Object)theMeasure), currentHashCode, (Object)theMeasure, this.measure != null);
        MeasureReportType theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient, this.patient != null);
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"period", (Object)thePeriod), currentHashCode, (Object)thePeriod, this.period != null);
        MeasureReportStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"date", (Object)theDate), currentHashCode, (Object)theDate, this.date != null);
        Reference theReportingOrganization = this.getReportingOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reportingOrganization", (Object)theReportingOrganization), currentHashCode, (Object)theReportingOrganization, this.reportingOrganization != null);
        List<MeasureReportGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"group", theGroup), currentHashCode, theGroup, this.group != null && !this.group.isEmpty());
        Reference theEvaluatedResources = this.getEvaluatedResources();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"evaluatedResources", (Object)theEvaluatedResources), currentHashCode, (Object)theEvaluatedResources, this.evaluatedResources != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Reference theMeasure = this.getMeasure();
        strategy.appendField(locator, (Object)this, "measure", buffer, (Object)theMeasure, this.measure != null);
        MeasureReportType theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient, this.patient != null);
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, (Object)thePeriod, this.period != null);
        MeasureReportStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate, this.date != null);
        Reference theReportingOrganization = this.getReportingOrganization();
        strategy.appendField(locator, (Object)this, "reportingOrganization", buffer, (Object)theReportingOrganization, this.reportingOrganization != null);
        List<MeasureReportGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        strategy.appendField(locator, (Object)this, "group", buffer, theGroup, this.group != null && !this.group.isEmpty());
        Reference theEvaluatedResources = this.getEvaluatedResources();
        strategy.appendField(locator, (Object)this, "evaluatedResources", buffer, (Object)theEvaluatedResources, this.evaluatedResources != null);
        return buffer;
    }
}

