/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Code;
import org.hl7.fhir.Extension;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CodeSystem.Filter", propOrder={"code", "description", "operator", "value"})
public class CodeSystemFilter
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Code code;
    protected String description;
    @XmlElement(required=true)
    protected List<Code> operator;
    @XmlElement(required=true)
    protected String value;

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code value) {
        this.code = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<Code> getOperator() {
        if (this.operator == null) {
            this.operator = new ArrayList<Code>();
        }
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public CodeSystemFilter withCode(Code value) {
        this.setCode(value);
        return this;
    }

    public CodeSystemFilter withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public CodeSystemFilter withOperator(Code ... values) {
        if (values != null) {
            for (Code value : values) {
                this.getOperator().add(value);
            }
        }
        return this;
    }

    public CodeSystemFilter withOperator(Collection<Code> values) {
        if (values != null) {
            this.getOperator().addAll(values);
        }
        return this;
    }

    public CodeSystemFilter withValue(String value) {
        this.setValue(value);
        return this;
    }

    @Override
    public CodeSystemFilter withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CodeSystemFilter withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CodeSystemFilter withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CodeSystemFilter withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CodeSystemFilter withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        CodeSystemFilter that = (CodeSystemFilter)object;
        Code lhsCode = this.getCode();
        Code rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<Code> lhsOperator = this.operator != null && !this.operator.isEmpty() ? this.getOperator() : null;
        List<Code> rhsOperator = that.operator != null && !that.operator.isEmpty() ? that.getOperator() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"operator", lhsOperator), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"operator", rhsOperator), lhsOperator, rhsOperator, this.operator != null && !this.operator.isEmpty(), that.operator != null && !that.operator.isEmpty())) {
            return false;
        }
        String lhsValue = this.getValue();
        String rhsValue = that.getValue();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"value", (Object)lhsValue), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"value", (Object)rhsValue), (Object)lhsValue, (Object)rhsValue, this.value != null, that.value != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Code theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode, this.code != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription, this.description != null);
        List<Code> theOperator = this.operator != null && !this.operator.isEmpty() ? this.getOperator() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"operator", theOperator), currentHashCode, theOperator, this.operator != null && !this.operator.isEmpty());
        String theValue = this.getValue();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"value", (Object)theValue), currentHashCode, (Object)theValue, this.value != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Code theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode, this.code != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription, this.description != null);
        List<Code> theOperator = this.operator != null && !this.operator.isEmpty() ? this.getOperator() : null;
        strategy.appendField(locator, (Object)this, "operator", buffer, theOperator, this.operator != null && !this.operator.isEmpty());
        String theValue = this.getValue();
        strategy.appendField(locator, (Object)this, "value", buffer, (Object)theValue, this.value != null);
        return buffer;
    }
}

