/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.quick;

import java.io.IOException;
import org.cqframework.cql.cql2elm.ModelInfoProvider;
import org.cqframework.cql.cql2elm.NamespaceAware;
import org.cqframework.cql.cql2elm.NamespaceManager;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.elm_modelinfo.r1.serializing.ModelInfoReaderFactory;

public class FhirModelInfoProvider
implements ModelInfoProvider,
NamespaceAware {
    private NamespaceManager namespaceManager;

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    private boolean isFHIRModelIdentifier(VersionedIdentifier modelIdentifier) {
        if (this.namespaceManager != null && this.namespaceManager.hasNamespaces()) {
            return modelIdentifier.getId().equals("FHIR") && (modelIdentifier.getSystem() == null || modelIdentifier.getSystem().equals("http://hl7.org/fhir"));
        }
        return modelIdentifier.getId().equals("FHIR");
    }

    public ModelInfo load(VersionedIdentifier modelIdentifier) {
        if (this.isFHIRModelIdentifier(modelIdentifier)) {
            String localVersion = modelIdentifier.getVersion() == null ? "" : modelIdentifier.getVersion();
            try {
                switch (localVersion) {
                    case "1.0.2": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-1.0.2.xml"));
                    }
                    case "1.4": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-1.4.xml"));
                    }
                    case "1.6": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-1.6.xml"));
                    }
                    case "1.8": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-1.8.xml"));
                    }
                    case "3.0.0": 
                    case "": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-3.0.0.xml"));
                    }
                    case "3.0.1": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-3.0.1.xml"));
                    }
                    case "3.2.0": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-3.2.0.xml"));
                    }
                    case "4.0.0": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-4.0.0.xml"));
                    }
                    case "4.0.1": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(FhirModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/fhir-modelinfo-4.0.1.xml"));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

