/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.NutritionOrderEnteralFormula;
import org.hl7.fhir.NutritionOrderOralDiet;
import org.hl7.fhir.NutritionOrderStatus;
import org.hl7.fhir.NutritionOrderSupplement;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NutritionOrder", propOrder={"identifier", "status", "patient", "encounter", "dateTime", "orderer", "allergyIntolerance", "foodPreferenceModifier", "excludeFoodModifier", "oralDiet", "supplement", "enteralFormula"})
public class NutritionOrder
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected NutritionOrderStatus status;
    @XmlElement(required=true)
    protected Reference patient;
    protected Reference encounter;
    @XmlElement(required=true)
    protected DateTime dateTime;
    protected Reference orderer;
    protected List<Reference> allergyIntolerance;
    protected List<CodeableConcept> foodPreferenceModifier;
    protected List<CodeableConcept> excludeFoodModifier;
    protected NutritionOrderOralDiet oralDiet;
    protected List<NutritionOrderSupplement> supplement;
    protected NutritionOrderEnteralFormula enteralFormula;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public NutritionOrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(NutritionOrderStatus value) {
        this.status = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(DateTime value) {
        this.dateTime = value;
    }

    public Reference getOrderer() {
        return this.orderer;
    }

    public void setOrderer(Reference value) {
        this.orderer = value;
    }

    public List<Reference> getAllergyIntolerance() {
        if (this.allergyIntolerance == null) {
            this.allergyIntolerance = new ArrayList<Reference>();
        }
        return this.allergyIntolerance;
    }

    public List<CodeableConcept> getFoodPreferenceModifier() {
        if (this.foodPreferenceModifier == null) {
            this.foodPreferenceModifier = new ArrayList<CodeableConcept>();
        }
        return this.foodPreferenceModifier;
    }

    public List<CodeableConcept> getExcludeFoodModifier() {
        if (this.excludeFoodModifier == null) {
            this.excludeFoodModifier = new ArrayList<CodeableConcept>();
        }
        return this.excludeFoodModifier;
    }

    public NutritionOrderOralDiet getOralDiet() {
        return this.oralDiet;
    }

    public void setOralDiet(NutritionOrderOralDiet value) {
        this.oralDiet = value;
    }

    public List<NutritionOrderSupplement> getSupplement() {
        if (this.supplement == null) {
            this.supplement = new ArrayList<NutritionOrderSupplement>();
        }
        return this.supplement;
    }

    public NutritionOrderEnteralFormula getEnteralFormula() {
        return this.enteralFormula;
    }

    public void setEnteralFormula(NutritionOrderEnteralFormula value) {
        this.enteralFormula = value;
    }

    public NutritionOrder withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public NutritionOrder withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public NutritionOrder withStatus(NutritionOrderStatus value) {
        this.setStatus(value);
        return this;
    }

    public NutritionOrder withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public NutritionOrder withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public NutritionOrder withDateTime(DateTime value) {
        this.setDateTime(value);
        return this;
    }

    public NutritionOrder withOrderer(Reference value) {
        this.setOrderer(value);
        return this;
    }

    public NutritionOrder withAllergyIntolerance(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAllergyIntolerance().add(value);
            }
        }
        return this;
    }

    public NutritionOrder withAllergyIntolerance(Collection<Reference> values) {
        if (values != null) {
            this.getAllergyIntolerance().addAll(values);
        }
        return this;
    }

    public NutritionOrder withFoodPreferenceModifier(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getFoodPreferenceModifier().add(value);
            }
        }
        return this;
    }

    public NutritionOrder withFoodPreferenceModifier(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getFoodPreferenceModifier().addAll(values);
        }
        return this;
    }

    public NutritionOrder withExcludeFoodModifier(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getExcludeFoodModifier().add(value);
            }
        }
        return this;
    }

    public NutritionOrder withExcludeFoodModifier(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getExcludeFoodModifier().addAll(values);
        }
        return this;
    }

    public NutritionOrder withOralDiet(NutritionOrderOralDiet value) {
        this.setOralDiet(value);
        return this;
    }

    public NutritionOrder withSupplement(NutritionOrderSupplement ... values) {
        if (values != null) {
            for (NutritionOrderSupplement value : values) {
                this.getSupplement().add(value);
            }
        }
        return this;
    }

    public NutritionOrder withSupplement(Collection<NutritionOrderSupplement> values) {
        if (values != null) {
            this.getSupplement().addAll(values);
        }
        return this;
    }

    public NutritionOrder withEnteralFormula(NutritionOrderEnteralFormula value) {
        this.setEnteralFormula(value);
        return this;
    }

    @Override
    public NutritionOrder withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public NutritionOrder withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public NutritionOrder withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public NutritionOrder withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public NutritionOrder withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public NutritionOrder withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public NutritionOrder withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public NutritionOrder withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public NutritionOrder withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public NutritionOrder withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public NutritionOrder withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        NutritionOrder that = (NutritionOrder)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        NutritionOrderStatus lhsStatus = this.getStatus();
        NutritionOrderStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"encounter", (Object)lhsEncounter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"encounter", (Object)rhsEncounter), (Object)lhsEncounter, (Object)rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        DateTime lhsDateTime = this.getDateTime();
        DateTime rhsDateTime = that.getDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dateTime", (Object)lhsDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dateTime", (Object)rhsDateTime), (Object)lhsDateTime, (Object)rhsDateTime, this.dateTime != null, that.dateTime != null)) {
            return false;
        }
        Reference lhsOrderer = this.getOrderer();
        Reference rhsOrderer = that.getOrderer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"orderer", (Object)lhsOrderer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"orderer", (Object)rhsOrderer), (Object)lhsOrderer, (Object)rhsOrderer, this.orderer != null, that.orderer != null)) {
            return false;
        }
        List<Reference> lhsAllergyIntolerance = this.allergyIntolerance != null && !this.allergyIntolerance.isEmpty() ? this.getAllergyIntolerance() : null;
        List<Reference> rhsAllergyIntolerance = that.allergyIntolerance != null && !that.allergyIntolerance.isEmpty() ? that.getAllergyIntolerance() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"allergyIntolerance", lhsAllergyIntolerance), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"allergyIntolerance", rhsAllergyIntolerance), lhsAllergyIntolerance, rhsAllergyIntolerance, this.allergyIntolerance != null && !this.allergyIntolerance.isEmpty(), that.allergyIntolerance != null && !that.allergyIntolerance.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsFoodPreferenceModifier = this.foodPreferenceModifier != null && !this.foodPreferenceModifier.isEmpty() ? this.getFoodPreferenceModifier() : null;
        List<CodeableConcept> rhsFoodPreferenceModifier = that.foodPreferenceModifier != null && !that.foodPreferenceModifier.isEmpty() ? that.getFoodPreferenceModifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"foodPreferenceModifier", lhsFoodPreferenceModifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"foodPreferenceModifier", rhsFoodPreferenceModifier), lhsFoodPreferenceModifier, rhsFoodPreferenceModifier, this.foodPreferenceModifier != null && !this.foodPreferenceModifier.isEmpty(), that.foodPreferenceModifier != null && !that.foodPreferenceModifier.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsExcludeFoodModifier = this.excludeFoodModifier != null && !this.excludeFoodModifier.isEmpty() ? this.getExcludeFoodModifier() : null;
        List<CodeableConcept> rhsExcludeFoodModifier = that.excludeFoodModifier != null && !that.excludeFoodModifier.isEmpty() ? that.getExcludeFoodModifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"excludeFoodModifier", lhsExcludeFoodModifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"excludeFoodModifier", rhsExcludeFoodModifier), lhsExcludeFoodModifier, rhsExcludeFoodModifier, this.excludeFoodModifier != null && !this.excludeFoodModifier.isEmpty(), that.excludeFoodModifier != null && !that.excludeFoodModifier.isEmpty())) {
            return false;
        }
        NutritionOrderOralDiet lhsOralDiet = this.getOralDiet();
        NutritionOrderOralDiet rhsOralDiet = that.getOralDiet();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"oralDiet", (Object)lhsOralDiet), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"oralDiet", (Object)rhsOralDiet), (Object)lhsOralDiet, (Object)rhsOralDiet, this.oralDiet != null, that.oralDiet != null)) {
            return false;
        }
        List<NutritionOrderSupplement> lhsSupplement = this.supplement != null && !this.supplement.isEmpty() ? this.getSupplement() : null;
        List<NutritionOrderSupplement> rhsSupplement = that.supplement != null && !that.supplement.isEmpty() ? that.getSupplement() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"supplement", lhsSupplement), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"supplement", rhsSupplement), lhsSupplement, rhsSupplement, this.supplement != null && !this.supplement.isEmpty(), that.supplement != null && !that.supplement.isEmpty())) {
            return false;
        }
        NutritionOrderEnteralFormula lhsEnteralFormula = this.getEnteralFormula();
        NutritionOrderEnteralFormula rhsEnteralFormula = that.getEnteralFormula();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"enteralFormula", (Object)lhsEnteralFormula), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"enteralFormula", (Object)rhsEnteralFormula), (Object)lhsEnteralFormula, (Object)rhsEnteralFormula, this.enteralFormula != null, that.enteralFormula != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        NutritionOrderStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient, this.patient != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"encounter", (Object)theEncounter), currentHashCode, (Object)theEncounter, this.encounter != null);
        DateTime theDateTime = this.getDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dateTime", (Object)theDateTime), currentHashCode, (Object)theDateTime, this.dateTime != null);
        Reference theOrderer = this.getOrderer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"orderer", (Object)theOrderer), currentHashCode, (Object)theOrderer, this.orderer != null);
        List<Reference> theAllergyIntolerance = this.allergyIntolerance != null && !this.allergyIntolerance.isEmpty() ? this.getAllergyIntolerance() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"allergyIntolerance", theAllergyIntolerance), currentHashCode, theAllergyIntolerance, this.allergyIntolerance != null && !this.allergyIntolerance.isEmpty());
        List<CodeableConcept> theFoodPreferenceModifier = this.foodPreferenceModifier != null && !this.foodPreferenceModifier.isEmpty() ? this.getFoodPreferenceModifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"foodPreferenceModifier", theFoodPreferenceModifier), currentHashCode, theFoodPreferenceModifier, this.foodPreferenceModifier != null && !this.foodPreferenceModifier.isEmpty());
        List<CodeableConcept> theExcludeFoodModifier = this.excludeFoodModifier != null && !this.excludeFoodModifier.isEmpty() ? this.getExcludeFoodModifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"excludeFoodModifier", theExcludeFoodModifier), currentHashCode, theExcludeFoodModifier, this.excludeFoodModifier != null && !this.excludeFoodModifier.isEmpty());
        NutritionOrderOralDiet theOralDiet = this.getOralDiet();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"oralDiet", (Object)theOralDiet), currentHashCode, (Object)theOralDiet, this.oralDiet != null);
        List<NutritionOrderSupplement> theSupplement = this.supplement != null && !this.supplement.isEmpty() ? this.getSupplement() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"supplement", theSupplement), currentHashCode, theSupplement, this.supplement != null && !this.supplement.isEmpty());
        NutritionOrderEnteralFormula theEnteralFormula = this.getEnteralFormula();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"enteralFormula", (Object)theEnteralFormula), currentHashCode, (Object)theEnteralFormula, this.enteralFormula != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        NutritionOrderStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient, this.patient != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, (Object)theEncounter, this.encounter != null);
        DateTime theDateTime = this.getDateTime();
        strategy.appendField(locator, (Object)this, "dateTime", buffer, (Object)theDateTime, this.dateTime != null);
        Reference theOrderer = this.getOrderer();
        strategy.appendField(locator, (Object)this, "orderer", buffer, (Object)theOrderer, this.orderer != null);
        List<Reference> theAllergyIntolerance = this.allergyIntolerance != null && !this.allergyIntolerance.isEmpty() ? this.getAllergyIntolerance() : null;
        strategy.appendField(locator, (Object)this, "allergyIntolerance", buffer, theAllergyIntolerance, this.allergyIntolerance != null && !this.allergyIntolerance.isEmpty());
        List<CodeableConcept> theFoodPreferenceModifier = this.foodPreferenceModifier != null && !this.foodPreferenceModifier.isEmpty() ? this.getFoodPreferenceModifier() : null;
        strategy.appendField(locator, (Object)this, "foodPreferenceModifier", buffer, theFoodPreferenceModifier, this.foodPreferenceModifier != null && !this.foodPreferenceModifier.isEmpty());
        List<CodeableConcept> theExcludeFoodModifier = this.excludeFoodModifier != null && !this.excludeFoodModifier.isEmpty() ? this.getExcludeFoodModifier() : null;
        strategy.appendField(locator, (Object)this, "excludeFoodModifier", buffer, theExcludeFoodModifier, this.excludeFoodModifier != null && !this.excludeFoodModifier.isEmpty());
        NutritionOrderOralDiet theOralDiet = this.getOralDiet();
        strategy.appendField(locator, (Object)this, "oralDiet", buffer, (Object)theOralDiet, this.oralDiet != null);
        List<NutritionOrderSupplement> theSupplement = this.supplement != null && !this.supplement.isEmpty() ? this.getSupplement() : null;
        strategy.appendField(locator, (Object)this, "supplement", buffer, theSupplement, this.supplement != null && !this.supplement.isEmpty());
        NutritionOrderEnteralFormula theEnteralFormula = this.getEnteralFormula();
        strategy.appendField(locator, (Object)this, "enteralFormula", buffer, (Object)theEnteralFormula, this.enteralFormula != null);
        return buffer;
    }
}

