/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DetectedIssueMitigation;
import org.hl7.fhir.DetectedIssueSeverity;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DetectedIssue", propOrder={"patient", "category", "severity", "implicated", "detail", "date", "author", "identifier", "reference", "mitigation"})
public class DetectedIssue
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Reference patient;
    protected CodeableConcept category;
    protected DetectedIssueSeverity severity;
    protected List<Reference> implicated;
    protected String detail;
    protected DateTime date;
    protected Reference author;
    protected Identifier identifier;
    protected Uri reference;
    protected List<DetectedIssueMitigation> mitigation;

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public void setCategory(CodeableConcept value) {
        this.category = value;
    }

    public DetectedIssueSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(DetectedIssueSeverity value) {
        this.severity = value;
    }

    public List<Reference> getImplicated() {
        if (this.implicated == null) {
            this.implicated = new ArrayList<Reference>();
        }
        return this.implicated;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String value) {
        this.detail = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public void setAuthor(Reference value) {
        this.author = value;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public Uri getReference() {
        return this.reference;
    }

    public void setReference(Uri value) {
        this.reference = value;
    }

    public List<DetectedIssueMitigation> getMitigation() {
        if (this.mitigation == null) {
            this.mitigation = new ArrayList<DetectedIssueMitigation>();
        }
        return this.mitigation;
    }

    public DetectedIssue withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public DetectedIssue withCategory(CodeableConcept value) {
        this.setCategory(value);
        return this;
    }

    public DetectedIssue withSeverity(DetectedIssueSeverity value) {
        this.setSeverity(value);
        return this;
    }

    public DetectedIssue withImplicated(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getImplicated().add(value);
            }
        }
        return this;
    }

    public DetectedIssue withImplicated(Collection<Reference> values) {
        if (values != null) {
            this.getImplicated().addAll(values);
        }
        return this;
    }

    public DetectedIssue withDetail(String value) {
        this.setDetail(value);
        return this;
    }

    public DetectedIssue withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public DetectedIssue withAuthor(Reference value) {
        this.setAuthor(value);
        return this;
    }

    public DetectedIssue withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public DetectedIssue withReference(Uri value) {
        this.setReference(value);
        return this;
    }

    public DetectedIssue withMitigation(DetectedIssueMitigation ... values) {
        if (values != null) {
            for (DetectedIssueMitigation value : values) {
                this.getMitigation().add(value);
            }
        }
        return this;
    }

    public DetectedIssue withMitigation(Collection<DetectedIssueMitigation> values) {
        if (values != null) {
            this.getMitigation().addAll(values);
        }
        return this;
    }

    @Override
    public DetectedIssue withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public DetectedIssue withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public DetectedIssue withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public DetectedIssue withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DetectedIssue withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DetectedIssue withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DetectedIssue withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DetectedIssue withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public DetectedIssue withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public DetectedIssue withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public DetectedIssue withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DetectedIssue that = (DetectedIssue)object;
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"patient", (Object)lhsPatient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"patient", (Object)rhsPatient), (Object)lhsPatient, (Object)rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        CodeableConcept lhsCategory = this.getCategory();
        CodeableConcept rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"category", (Object)lhsCategory), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"category", (Object)rhsCategory), (Object)lhsCategory, (Object)rhsCategory, this.category != null, that.category != null)) {
            return false;
        }
        DetectedIssueSeverity lhsSeverity = this.getSeverity();
        DetectedIssueSeverity rhsSeverity = that.getSeverity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"severity", (Object)lhsSeverity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"severity", (Object)rhsSeverity), (Object)lhsSeverity, (Object)rhsSeverity, this.severity != null, that.severity != null)) {
            return false;
        }
        List<Reference> lhsImplicated = this.implicated != null && !this.implicated.isEmpty() ? this.getImplicated() : null;
        List<Reference> rhsImplicated = that.implicated != null && !that.implicated.isEmpty() ? that.getImplicated() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"implicated", lhsImplicated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"implicated", rhsImplicated), lhsImplicated, rhsImplicated, this.implicated != null && !this.implicated.isEmpty(), that.implicated != null && !that.implicated.isEmpty())) {
            return false;
        }
        String lhsDetail = this.getDetail();
        String rhsDetail = that.getDetail();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"detail", (Object)lhsDetail), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"detail", (Object)rhsDetail), (Object)lhsDetail, (Object)rhsDetail, this.detail != null, that.detail != null)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        Reference lhsAuthor = this.getAuthor();
        Reference rhsAuthor = that.getAuthor();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"author", (Object)lhsAuthor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"author", (Object)rhsAuthor), (Object)lhsAuthor, (Object)rhsAuthor, this.author != null, that.author != null)) {
            return false;
        }
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        Uri lhsReference = this.getReference();
        Uri rhsReference = that.getReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"reference", (Object)lhsReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"reference", (Object)rhsReference), (Object)lhsReference, (Object)rhsReference, this.reference != null, that.reference != null)) {
            return false;
        }
        List<DetectedIssueMitigation> lhsMitigation = this.mitigation != null && !this.mitigation.isEmpty() ? this.getMitigation() : null;
        List<DetectedIssueMitigation> rhsMitigation = that.mitigation != null && !that.mitigation.isEmpty() ? that.getMitigation() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"mitigation", lhsMitigation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"mitigation", rhsMitigation), lhsMitigation, rhsMitigation, this.mitigation != null && !this.mitigation.isEmpty(), that.mitigation != null && !that.mitigation.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"patient", (Object)thePatient), currentHashCode, (Object)thePatient, this.patient != null);
        CodeableConcept theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"category", (Object)theCategory), currentHashCode, (Object)theCategory, this.category != null);
        DetectedIssueSeverity theSeverity = this.getSeverity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"severity", (Object)theSeverity), currentHashCode, (Object)theSeverity, this.severity != null);
        List<Reference> theImplicated = this.implicated != null && !this.implicated.isEmpty() ? this.getImplicated() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"implicated", theImplicated), currentHashCode, theImplicated, this.implicated != null && !this.implicated.isEmpty());
        String theDetail = this.getDetail();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"detail", (Object)theDetail), currentHashCode, (Object)theDetail, this.detail != null);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate, this.date != null);
        Reference theAuthor = this.getAuthor();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"author", (Object)theAuthor), currentHashCode, (Object)theAuthor, this.author != null);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier, this.identifier != null);
        Uri theReference = this.getReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"reference", (Object)theReference), currentHashCode, (Object)theReference, this.reference != null);
        List<DetectedIssueMitigation> theMitigation = this.mitigation != null && !this.mitigation.isEmpty() ? this.getMitigation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"mitigation", theMitigation), currentHashCode, theMitigation, this.mitigation != null && !this.mitigation.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, (Object)thePatient, this.patient != null);
        CodeableConcept theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, (Object)theCategory, this.category != null);
        DetectedIssueSeverity theSeverity = this.getSeverity();
        strategy.appendField(locator, (Object)this, "severity", buffer, (Object)theSeverity, this.severity != null);
        List<Reference> theImplicated = this.implicated != null && !this.implicated.isEmpty() ? this.getImplicated() : null;
        strategy.appendField(locator, (Object)this, "implicated", buffer, theImplicated, this.implicated != null && !this.implicated.isEmpty());
        String theDetail = this.getDetail();
        strategy.appendField(locator, (Object)this, "detail", buffer, (Object)theDetail, this.detail != null);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate, this.date != null);
        Reference theAuthor = this.getAuthor();
        strategy.appendField(locator, (Object)this, "author", buffer, (Object)theAuthor, this.author != null);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier, this.identifier != null);
        Uri theReference = this.getReference();
        strategy.appendField(locator, (Object)this, "reference", buffer, (Object)theReference, this.reference != null);
        List<DetectedIssueMitigation> theMitigation = this.mitigation != null && !this.mitigation.isEmpty() ? this.getMitigation() : null;
        strategy.appendField(locator, (Object)this, "mitigation", buffer, theMitigation, this.mitigation != null && !this.mitigation.isEmpty());
        return buffer;
    }
}

