/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.ActionDefinition;
import org.hl7.fhir.Code;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.ModuleMetadata;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OrderSet", propOrder={"moduleMetadata", "library", "action"})
public class OrderSet
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected ModuleMetadata moduleMetadata;
    protected List<Reference> library;
    protected List<ActionDefinition> action;

    public ModuleMetadata getModuleMetadata() {
        return this.moduleMetadata;
    }

    public void setModuleMetadata(ModuleMetadata value) {
        this.moduleMetadata = value;
    }

    public List<Reference> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<Reference>();
        }
        return this.library;
    }

    public List<ActionDefinition> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        return this.action;
    }

    public OrderSet withModuleMetadata(ModuleMetadata value) {
        this.setModuleMetadata(value);
        return this;
    }

    public OrderSet withLibrary(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getLibrary().add(value);
            }
        }
        return this;
    }

    public OrderSet withLibrary(Collection<Reference> values) {
        if (values != null) {
            this.getLibrary().addAll(values);
        }
        return this;
    }

    public OrderSet withAction(ActionDefinition ... values) {
        if (values != null) {
            for (ActionDefinition value : values) {
                this.getAction().add(value);
            }
        }
        return this;
    }

    public OrderSet withAction(Collection<ActionDefinition> values) {
        if (values != null) {
            this.getAction().addAll(values);
        }
        return this;
    }

    @Override
    public OrderSet withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public OrderSet withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public OrderSet withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public OrderSet withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public OrderSet withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public OrderSet withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public OrderSet withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public OrderSet withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public OrderSet withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public OrderSet withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public OrderSet withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        OrderSet that = (OrderSet)object;
        ModuleMetadata lhsModuleMetadata = this.getModuleMetadata();
        ModuleMetadata rhsModuleMetadata = that.getModuleMetadata();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"moduleMetadata", (Object)lhsModuleMetadata), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"moduleMetadata", (Object)rhsModuleMetadata), (Object)lhsModuleMetadata, (Object)rhsModuleMetadata, this.moduleMetadata != null, that.moduleMetadata != null)) {
            return false;
        }
        List<Reference> lhsLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        List<Reference> rhsLibrary = that.library != null && !that.library.isEmpty() ? that.getLibrary() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"library", lhsLibrary), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"library", rhsLibrary), lhsLibrary, rhsLibrary, this.library != null && !this.library.isEmpty(), that.library != null && !that.library.isEmpty())) {
            return false;
        }
        List<ActionDefinition> lhsAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        List<ActionDefinition> rhsAction = that.action != null && !that.action.isEmpty() ? that.getAction() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"action", lhsAction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"action", rhsAction), lhsAction, rhsAction, this.action != null && !this.action.isEmpty(), that.action != null && !that.action.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        ModuleMetadata theModuleMetadata = this.getModuleMetadata();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"moduleMetadata", (Object)theModuleMetadata), currentHashCode, (Object)theModuleMetadata, this.moduleMetadata != null);
        List<Reference> theLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"library", theLibrary), currentHashCode, theLibrary, this.library != null && !this.library.isEmpty());
        List<ActionDefinition> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"action", theAction), currentHashCode, theAction, this.action != null && !this.action.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        ModuleMetadata theModuleMetadata = this.getModuleMetadata();
        strategy.appendField(locator, (Object)this, "moduleMetadata", buffer, (Object)theModuleMetadata, this.moduleMetadata != null);
        List<Reference> theLibrary = this.library != null && !this.library.isEmpty() ? this.getLibrary() : null;
        strategy.appendField(locator, (Object)this, "library", buffer, theLibrary, this.library != null && !this.library.isEmpty());
        List<ActionDefinition> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        strategy.appendField(locator, (Object)this, "action", buffer, theAction, this.action != null && !this.action.isEmpty());
        return buffer;
    }
}

