/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ContactPoint;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.PractitionerRoleAvailableTime;
import org.hl7.fhir.PractitionerRoleNotAvailable;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PractitionerRole", propOrder={"identifier", "active", "practitioner", "organization", "role", "specialty", "location", "healthcareService", "telecom", "period", "availableTime", "notAvailable", "availabilityExceptions"})
public class PractitionerRole
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected Boolean active;
    protected Reference practitioner;
    protected Reference organization;
    protected List<CodeableConcept> role;
    protected List<CodeableConcept> specialty;
    protected List<Reference> location;
    protected List<Reference> healthcareService;
    protected List<ContactPoint> telecom;
    protected Period period;
    protected List<PractitionerRoleAvailableTime> availableTime;
    protected List<PractitionerRoleNotAvailable> notAvailable;
    protected String availabilityExceptions;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean value) {
        this.active = value;
    }

    public Reference getPractitioner() {
        return this.practitioner;
    }

    public void setPractitioner(Reference value) {
        this.practitioner = value;
    }

    public Reference getOrganization() {
        return this.organization;
    }

    public void setOrganization(Reference value) {
        this.organization = value;
    }

    public List<CodeableConcept> getRole() {
        if (this.role == null) {
            this.role = new ArrayList<CodeableConcept>();
        }
        return this.role;
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public List<Reference> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        return this.location;
    }

    public List<Reference> getHealthcareService() {
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        return this.healthcareService;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public List<PractitionerRoleAvailableTime> getAvailableTime() {
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<PractitionerRoleAvailableTime>();
        }
        return this.availableTime;
    }

    public List<PractitionerRoleNotAvailable> getNotAvailable() {
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<PractitionerRoleNotAvailable>();
        }
        return this.notAvailable;
    }

    public String getAvailabilityExceptions() {
        return this.availabilityExceptions;
    }

    public void setAvailabilityExceptions(String value) {
        this.availabilityExceptions = value;
    }

    public PractitionerRole withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public PractitionerRole withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public PractitionerRole withActive(Boolean value) {
        this.setActive(value);
        return this;
    }

    public PractitionerRole withPractitioner(Reference value) {
        this.setPractitioner(value);
        return this;
    }

    public PractitionerRole withOrganization(Reference value) {
        this.setOrganization(value);
        return this;
    }

    public PractitionerRole withRole(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getRole().add(value);
            }
        }
        return this;
    }

    public PractitionerRole withRole(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getRole().addAll(values);
        }
        return this;
    }

    public PractitionerRole withSpecialty(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSpecialty().add(value);
            }
        }
        return this;
    }

    public PractitionerRole withSpecialty(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSpecialty().addAll(values);
        }
        return this;
    }

    public PractitionerRole withLocation(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getLocation().add(value);
            }
        }
        return this;
    }

    public PractitionerRole withLocation(Collection<Reference> values) {
        if (values != null) {
            this.getLocation().addAll(values);
        }
        return this;
    }

    public PractitionerRole withHealthcareService(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getHealthcareService().add(value);
            }
        }
        return this;
    }

    public PractitionerRole withHealthcareService(Collection<Reference> values) {
        if (values != null) {
            this.getHealthcareService().addAll(values);
        }
        return this;
    }

    public PractitionerRole withTelecom(ContactPoint ... values) {
        if (values != null) {
            for (ContactPoint value : values) {
                this.getTelecom().add(value);
            }
        }
        return this;
    }

    public PractitionerRole withTelecom(Collection<ContactPoint> values) {
        if (values != null) {
            this.getTelecom().addAll(values);
        }
        return this;
    }

    public PractitionerRole withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    public PractitionerRole withAvailableTime(PractitionerRoleAvailableTime ... values) {
        if (values != null) {
            for (PractitionerRoleAvailableTime value : values) {
                this.getAvailableTime().add(value);
            }
        }
        return this;
    }

    public PractitionerRole withAvailableTime(Collection<PractitionerRoleAvailableTime> values) {
        if (values != null) {
            this.getAvailableTime().addAll(values);
        }
        return this;
    }

    public PractitionerRole withNotAvailable(PractitionerRoleNotAvailable ... values) {
        if (values != null) {
            for (PractitionerRoleNotAvailable value : values) {
                this.getNotAvailable().add(value);
            }
        }
        return this;
    }

    public PractitionerRole withNotAvailable(Collection<PractitionerRoleNotAvailable> values) {
        if (values != null) {
            this.getNotAvailable().addAll(values);
        }
        return this;
    }

    public PractitionerRole withAvailabilityExceptions(String value) {
        this.setAvailabilityExceptions(value);
        return this;
    }

    @Override
    public PractitionerRole withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public PractitionerRole withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public PractitionerRole withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public PractitionerRole withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public PractitionerRole withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public PractitionerRole withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public PractitionerRole withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public PractitionerRole withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public PractitionerRole withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public PractitionerRole withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public PractitionerRole withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        PractitionerRole that = (PractitionerRole)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Boolean lhsActive = this.getActive();
        Boolean rhsActive = that.getActive();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"active", (Object)lhsActive), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"active", (Object)rhsActive), (Object)lhsActive, (Object)rhsActive, this.active != null, that.active != null)) {
            return false;
        }
        Reference lhsPractitioner = this.getPractitioner();
        Reference rhsPractitioner = that.getPractitioner();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"practitioner", (Object)lhsPractitioner), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"practitioner", (Object)rhsPractitioner), (Object)lhsPractitioner, (Object)rhsPractitioner, this.practitioner != null, that.practitioner != null)) {
            return false;
        }
        Reference lhsOrganization = this.getOrganization();
        Reference rhsOrganization = that.getOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"organization", (Object)lhsOrganization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"organization", (Object)rhsOrganization), (Object)lhsOrganization, (Object)rhsOrganization, this.organization != null, that.organization != null)) {
            return false;
        }
        List<CodeableConcept> lhsRole = this.role != null && !this.role.isEmpty() ? this.getRole() : null;
        List<CodeableConcept> rhsRole = that.role != null && !that.role.isEmpty() ? that.getRole() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"role", lhsRole), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"role", rhsRole), lhsRole, rhsRole, this.role != null && !this.role.isEmpty(), that.role != null && !that.role.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        List<CodeableConcept> rhsSpecialty = that.specialty != null && !that.specialty.isEmpty() ? that.getSpecialty() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"specialty", lhsSpecialty), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"specialty", rhsSpecialty), lhsSpecialty, rhsSpecialty, this.specialty != null && !this.specialty.isEmpty(), that.specialty != null && !that.specialty.isEmpty())) {
            return false;
        }
        List<Reference> lhsLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        List<Reference> rhsLocation = that.location != null && !that.location.isEmpty() ? that.getLocation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"location", lhsLocation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"location", rhsLocation), lhsLocation, rhsLocation, this.location != null && !this.location.isEmpty(), that.location != null && !that.location.isEmpty())) {
            return false;
        }
        List<Reference> lhsHealthcareService = this.healthcareService != null && !this.healthcareService.isEmpty() ? this.getHealthcareService() : null;
        List<Reference> rhsHealthcareService = that.healthcareService != null && !that.healthcareService.isEmpty() ? that.getHealthcareService() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"healthcareService", lhsHealthcareService), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"healthcareService", rhsHealthcareService), lhsHealthcareService, rhsHealthcareService, this.healthcareService != null && !this.healthcareService.isEmpty(), that.healthcareService != null && !that.healthcareService.isEmpty())) {
            return false;
        }
        List<ContactPoint> lhsTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        List<ContactPoint> rhsTelecom = that.telecom != null && !that.telecom.isEmpty() ? that.getTelecom() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"telecom", lhsTelecom), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"telecom", rhsTelecom), lhsTelecom, rhsTelecom, this.telecom != null && !this.telecom.isEmpty(), that.telecom != null && !that.telecom.isEmpty())) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"period", (Object)lhsPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"period", (Object)rhsPeriod), (Object)lhsPeriod, (Object)rhsPeriod, this.period != null, that.period != null)) {
            return false;
        }
        List<PractitionerRoleAvailableTime> lhsAvailableTime = this.availableTime != null && !this.availableTime.isEmpty() ? this.getAvailableTime() : null;
        List<PractitionerRoleAvailableTime> rhsAvailableTime = that.availableTime != null && !that.availableTime.isEmpty() ? that.getAvailableTime() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"availableTime", lhsAvailableTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"availableTime", rhsAvailableTime), lhsAvailableTime, rhsAvailableTime, this.availableTime != null && !this.availableTime.isEmpty(), that.availableTime != null && !that.availableTime.isEmpty())) {
            return false;
        }
        List<PractitionerRoleNotAvailable> lhsNotAvailable = this.notAvailable != null && !this.notAvailable.isEmpty() ? this.getNotAvailable() : null;
        List<PractitionerRoleNotAvailable> rhsNotAvailable = that.notAvailable != null && !that.notAvailable.isEmpty() ? that.getNotAvailable() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"notAvailable", lhsNotAvailable), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"notAvailable", rhsNotAvailable), lhsNotAvailable, rhsNotAvailable, this.notAvailable != null && !this.notAvailable.isEmpty(), that.notAvailable != null && !that.notAvailable.isEmpty())) {
            return false;
        }
        String lhsAvailabilityExceptions = this.getAvailabilityExceptions();
        String rhsAvailabilityExceptions = that.getAvailabilityExceptions();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"availabilityExceptions", (Object)lhsAvailabilityExceptions), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"availabilityExceptions", (Object)rhsAvailabilityExceptions), (Object)lhsAvailabilityExceptions, (Object)rhsAvailabilityExceptions, this.availabilityExceptions != null, that.availabilityExceptions != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Boolean theActive = this.getActive();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"active", (Object)theActive), currentHashCode, (Object)theActive, this.active != null);
        Reference thePractitioner = this.getPractitioner();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"practitioner", (Object)thePractitioner), currentHashCode, (Object)thePractitioner, this.practitioner != null);
        Reference theOrganization = this.getOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"organization", (Object)theOrganization), currentHashCode, (Object)theOrganization, this.organization != null);
        List<CodeableConcept> theRole = this.role != null && !this.role.isEmpty() ? this.getRole() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"role", theRole), currentHashCode, theRole, this.role != null && !this.role.isEmpty());
        List<CodeableConcept> theSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"specialty", theSpecialty), currentHashCode, theSpecialty, this.specialty != null && !this.specialty.isEmpty());
        List<Reference> theLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"location", theLocation), currentHashCode, theLocation, this.location != null && !this.location.isEmpty());
        List<Reference> theHealthcareService = this.healthcareService != null && !this.healthcareService.isEmpty() ? this.getHealthcareService() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"healthcareService", theHealthcareService), currentHashCode, theHealthcareService, this.healthcareService != null && !this.healthcareService.isEmpty());
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"telecom", theTelecom), currentHashCode, theTelecom, this.telecom != null && !this.telecom.isEmpty());
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"period", (Object)thePeriod), currentHashCode, (Object)thePeriod, this.period != null);
        List<PractitionerRoleAvailableTime> theAvailableTime = this.availableTime != null && !this.availableTime.isEmpty() ? this.getAvailableTime() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"availableTime", theAvailableTime), currentHashCode, theAvailableTime, this.availableTime != null && !this.availableTime.isEmpty());
        List<PractitionerRoleNotAvailable> theNotAvailable = this.notAvailable != null && !this.notAvailable.isEmpty() ? this.getNotAvailable() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"notAvailable", theNotAvailable), currentHashCode, theNotAvailable, this.notAvailable != null && !this.notAvailable.isEmpty());
        String theAvailabilityExceptions = this.getAvailabilityExceptions();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"availabilityExceptions", (Object)theAvailabilityExceptions), currentHashCode, (Object)theAvailabilityExceptions, this.availabilityExceptions != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Boolean theActive = this.getActive();
        strategy.appendField(locator, (Object)this, "active", buffer, (Object)theActive, this.active != null);
        Reference thePractitioner = this.getPractitioner();
        strategy.appendField(locator, (Object)this, "practitioner", buffer, (Object)thePractitioner, this.practitioner != null);
        Reference theOrganization = this.getOrganization();
        strategy.appendField(locator, (Object)this, "organization", buffer, (Object)theOrganization, this.organization != null);
        List<CodeableConcept> theRole = this.role != null && !this.role.isEmpty() ? this.getRole() : null;
        strategy.appendField(locator, (Object)this, "role", buffer, theRole, this.role != null && !this.role.isEmpty());
        List<CodeableConcept> theSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        strategy.appendField(locator, (Object)this, "specialty", buffer, theSpecialty, this.specialty != null && !this.specialty.isEmpty());
        List<Reference> theLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        strategy.appendField(locator, (Object)this, "location", buffer, theLocation, this.location != null && !this.location.isEmpty());
        List<Reference> theHealthcareService = this.healthcareService != null && !this.healthcareService.isEmpty() ? this.getHealthcareService() : null;
        strategy.appendField(locator, (Object)this, "healthcareService", buffer, theHealthcareService, this.healthcareService != null && !this.healthcareService.isEmpty());
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        strategy.appendField(locator, (Object)this, "telecom", buffer, theTelecom, this.telecom != null && !this.telecom.isEmpty());
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, (Object)thePeriod, this.period != null);
        List<PractitionerRoleAvailableTime> theAvailableTime = this.availableTime != null && !this.availableTime.isEmpty() ? this.getAvailableTime() : null;
        strategy.appendField(locator, (Object)this, "availableTime", buffer, theAvailableTime, this.availableTime != null && !this.availableTime.isEmpty());
        List<PractitionerRoleNotAvailable> theNotAvailable = this.notAvailable != null && !this.notAvailable.isEmpty() ? this.getNotAvailable() : null;
        strategy.appendField(locator, (Object)this, "notAvailable", buffer, theNotAvailable, this.notAvailable != null && !this.notAvailable.isEmpty());
        String theAvailabilityExceptions = this.getAvailabilityExceptions();
        strategy.appendField(locator, (Object)this, "availabilityExceptions", buffer, (Object)theAvailabilityExceptions, this.availabilityExceptions != null);
        return buffer;
    }
}

