/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Attachment;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.Extension;
import org.hl7.fhir.ObservationReferenceRange;
import org.hl7.fhir.Period;
import org.hl7.fhir.Quantity;
import org.hl7.fhir.Range;
import org.hl7.fhir.Ratio;
import org.hl7.fhir.SampledData;
import org.hl7.fhir.String;
import org.hl7.fhir.Time;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Observation.Component", propOrder={"code", "valueQuantity", "valueCodeableConcept", "valueString", "valueRange", "valueRatio", "valueSampledData", "valueAttachment", "valueTime", "valueDateTime", "valuePeriod", "dataAbsentReason", "referenceRange"})
public class ObservationComponent
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected CodeableConcept code;
    protected Quantity valueQuantity;
    protected CodeableConcept valueCodeableConcept;
    protected String valueString;
    protected Range valueRange;
    protected Ratio valueRatio;
    protected SampledData valueSampledData;
    protected Attachment valueAttachment;
    protected Time valueTime;
    protected DateTime valueDateTime;
    protected Period valuePeriod;
    protected CodeableConcept dataAbsentReason;
    protected List<ObservationReferenceRange> referenceRange;

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public Quantity getValueQuantity() {
        return this.valueQuantity;
    }

    public void setValueQuantity(Quantity value) {
        this.valueQuantity = value;
    }

    public CodeableConcept getValueCodeableConcept() {
        return this.valueCodeableConcept;
    }

    public void setValueCodeableConcept(CodeableConcept value) {
        this.valueCodeableConcept = value;
    }

    public String getValueString() {
        return this.valueString;
    }

    public void setValueString(String value) {
        this.valueString = value;
    }

    public Range getValueRange() {
        return this.valueRange;
    }

    public void setValueRange(Range value) {
        this.valueRange = value;
    }

    public Ratio getValueRatio() {
        return this.valueRatio;
    }

    public void setValueRatio(Ratio value) {
        this.valueRatio = value;
    }

    public SampledData getValueSampledData() {
        return this.valueSampledData;
    }

    public void setValueSampledData(SampledData value) {
        this.valueSampledData = value;
    }

    public Attachment getValueAttachment() {
        return this.valueAttachment;
    }

    public void setValueAttachment(Attachment value) {
        this.valueAttachment = value;
    }

    public Time getValueTime() {
        return this.valueTime;
    }

    public void setValueTime(Time value) {
        this.valueTime = value;
    }

    public DateTime getValueDateTime() {
        return this.valueDateTime;
    }

    public void setValueDateTime(DateTime value) {
        this.valueDateTime = value;
    }

    public Period getValuePeriod() {
        return this.valuePeriod;
    }

    public void setValuePeriod(Period value) {
        this.valuePeriod = value;
    }

    public CodeableConcept getDataAbsentReason() {
        return this.dataAbsentReason;
    }

    public void setDataAbsentReason(CodeableConcept value) {
        this.dataAbsentReason = value;
    }

    public List<ObservationReferenceRange> getReferenceRange() {
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRange>();
        }
        return this.referenceRange;
    }

    public ObservationComponent withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public ObservationComponent withValueQuantity(Quantity value) {
        this.setValueQuantity(value);
        return this;
    }

    public ObservationComponent withValueCodeableConcept(CodeableConcept value) {
        this.setValueCodeableConcept(value);
        return this;
    }

    public ObservationComponent withValueString(String value) {
        this.setValueString(value);
        return this;
    }

    public ObservationComponent withValueRange(Range value) {
        this.setValueRange(value);
        return this;
    }

    public ObservationComponent withValueRatio(Ratio value) {
        this.setValueRatio(value);
        return this;
    }

    public ObservationComponent withValueSampledData(SampledData value) {
        this.setValueSampledData(value);
        return this;
    }

    public ObservationComponent withValueAttachment(Attachment value) {
        this.setValueAttachment(value);
        return this;
    }

    public ObservationComponent withValueTime(Time value) {
        this.setValueTime(value);
        return this;
    }

    public ObservationComponent withValueDateTime(DateTime value) {
        this.setValueDateTime(value);
        return this;
    }

    public ObservationComponent withValuePeriod(Period value) {
        this.setValuePeriod(value);
        return this;
    }

    public ObservationComponent withDataAbsentReason(CodeableConcept value) {
        this.setDataAbsentReason(value);
        return this;
    }

    public ObservationComponent withReferenceRange(ObservationReferenceRange ... values) {
        if (values != null) {
            for (ObservationReferenceRange value : values) {
                this.getReferenceRange().add(value);
            }
        }
        return this;
    }

    public ObservationComponent withReferenceRange(Collection<ObservationReferenceRange> values) {
        if (values != null) {
            this.getReferenceRange().addAll(values);
        }
        return this;
    }

    @Override
    public ObservationComponent withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ObservationComponent withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ObservationComponent withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ObservationComponent withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ObservationComponent withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ObservationComponent that = (ObservationComponent)object;
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"code", (Object)lhsCode), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"code", (Object)rhsCode), (Object)lhsCode, (Object)rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        Quantity lhsValueQuantity = this.getValueQuantity();
        Quantity rhsValueQuantity = that.getValueQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueQuantity", (Object)lhsValueQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueQuantity", (Object)rhsValueQuantity), (Object)lhsValueQuantity, (Object)rhsValueQuantity, this.valueQuantity != null, that.valueQuantity != null)) {
            return false;
        }
        CodeableConcept lhsValueCodeableConcept = this.getValueCodeableConcept();
        CodeableConcept rhsValueCodeableConcept = that.getValueCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueCodeableConcept", (Object)lhsValueCodeableConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueCodeableConcept", (Object)rhsValueCodeableConcept), (Object)lhsValueCodeableConcept, (Object)rhsValueCodeableConcept, this.valueCodeableConcept != null, that.valueCodeableConcept != null)) {
            return false;
        }
        String lhsValueString = this.getValueString();
        String rhsValueString = that.getValueString();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueString", (Object)lhsValueString), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueString", (Object)rhsValueString), (Object)lhsValueString, (Object)rhsValueString, this.valueString != null, that.valueString != null)) {
            return false;
        }
        Range lhsValueRange = this.getValueRange();
        Range rhsValueRange = that.getValueRange();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueRange", (Object)lhsValueRange), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueRange", (Object)rhsValueRange), (Object)lhsValueRange, (Object)rhsValueRange, this.valueRange != null, that.valueRange != null)) {
            return false;
        }
        Ratio lhsValueRatio = this.getValueRatio();
        Ratio rhsValueRatio = that.getValueRatio();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueRatio", (Object)lhsValueRatio), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueRatio", (Object)rhsValueRatio), (Object)lhsValueRatio, (Object)rhsValueRatio, this.valueRatio != null, that.valueRatio != null)) {
            return false;
        }
        SampledData lhsValueSampledData = this.getValueSampledData();
        SampledData rhsValueSampledData = that.getValueSampledData();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueSampledData", (Object)lhsValueSampledData), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueSampledData", (Object)rhsValueSampledData), (Object)lhsValueSampledData, (Object)rhsValueSampledData, this.valueSampledData != null, that.valueSampledData != null)) {
            return false;
        }
        Attachment lhsValueAttachment = this.getValueAttachment();
        Attachment rhsValueAttachment = that.getValueAttachment();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueAttachment", (Object)lhsValueAttachment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueAttachment", (Object)rhsValueAttachment), (Object)lhsValueAttachment, (Object)rhsValueAttachment, this.valueAttachment != null, that.valueAttachment != null)) {
            return false;
        }
        Time lhsValueTime = this.getValueTime();
        Time rhsValueTime = that.getValueTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueTime", (Object)lhsValueTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueTime", (Object)rhsValueTime), (Object)lhsValueTime, (Object)rhsValueTime, this.valueTime != null, that.valueTime != null)) {
            return false;
        }
        DateTime lhsValueDateTime = this.getValueDateTime();
        DateTime rhsValueDateTime = that.getValueDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valueDateTime", (Object)lhsValueDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valueDateTime", (Object)rhsValueDateTime), (Object)lhsValueDateTime, (Object)rhsValueDateTime, this.valueDateTime != null, that.valueDateTime != null)) {
            return false;
        }
        Period lhsValuePeriod = this.getValuePeriod();
        Period rhsValuePeriod = that.getValuePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"valuePeriod", (Object)lhsValuePeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"valuePeriod", (Object)rhsValuePeriod), (Object)lhsValuePeriod, (Object)rhsValuePeriod, this.valuePeriod != null, that.valuePeriod != null)) {
            return false;
        }
        CodeableConcept lhsDataAbsentReason = this.getDataAbsentReason();
        CodeableConcept rhsDataAbsentReason = that.getDataAbsentReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dataAbsentReason", (Object)lhsDataAbsentReason), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dataAbsentReason", (Object)rhsDataAbsentReason), (Object)lhsDataAbsentReason, (Object)rhsDataAbsentReason, this.dataAbsentReason != null, that.dataAbsentReason != null)) {
            return false;
        }
        List<ObservationReferenceRange> lhsReferenceRange = this.referenceRange != null && !this.referenceRange.isEmpty() ? this.getReferenceRange() : null;
        List<ObservationReferenceRange> rhsReferenceRange = that.referenceRange != null && !that.referenceRange.isEmpty() ? that.getReferenceRange() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"referenceRange", lhsReferenceRange), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"referenceRange", rhsReferenceRange), lhsReferenceRange, rhsReferenceRange, this.referenceRange != null && !this.referenceRange.isEmpty(), that.referenceRange != null && !that.referenceRange.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"code", (Object)theCode), currentHashCode, (Object)theCode, this.code != null);
        Quantity theValueQuantity = this.getValueQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueQuantity", (Object)theValueQuantity), currentHashCode, (Object)theValueQuantity, this.valueQuantity != null);
        CodeableConcept theValueCodeableConcept = this.getValueCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueCodeableConcept", (Object)theValueCodeableConcept), currentHashCode, (Object)theValueCodeableConcept, this.valueCodeableConcept != null);
        String theValueString = this.getValueString();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueString", (Object)theValueString), currentHashCode, (Object)theValueString, this.valueString != null);
        Range theValueRange = this.getValueRange();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueRange", (Object)theValueRange), currentHashCode, (Object)theValueRange, this.valueRange != null);
        Ratio theValueRatio = this.getValueRatio();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueRatio", (Object)theValueRatio), currentHashCode, (Object)theValueRatio, this.valueRatio != null);
        SampledData theValueSampledData = this.getValueSampledData();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueSampledData", (Object)theValueSampledData), currentHashCode, (Object)theValueSampledData, this.valueSampledData != null);
        Attachment theValueAttachment = this.getValueAttachment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueAttachment", (Object)theValueAttachment), currentHashCode, (Object)theValueAttachment, this.valueAttachment != null);
        Time theValueTime = this.getValueTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueTime", (Object)theValueTime), currentHashCode, (Object)theValueTime, this.valueTime != null);
        DateTime theValueDateTime = this.getValueDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valueDateTime", (Object)theValueDateTime), currentHashCode, (Object)theValueDateTime, this.valueDateTime != null);
        Period theValuePeriod = this.getValuePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"valuePeriod", (Object)theValuePeriod), currentHashCode, (Object)theValuePeriod, this.valuePeriod != null);
        CodeableConcept theDataAbsentReason = this.getDataAbsentReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dataAbsentReason", (Object)theDataAbsentReason), currentHashCode, (Object)theDataAbsentReason, this.dataAbsentReason != null);
        List<ObservationReferenceRange> theReferenceRange = this.referenceRange != null && !this.referenceRange.isEmpty() ? this.getReferenceRange() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"referenceRange", theReferenceRange), currentHashCode, theReferenceRange, this.referenceRange != null && !this.referenceRange.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, (Object)theCode, this.code != null);
        Quantity theValueQuantity = this.getValueQuantity();
        strategy.appendField(locator, (Object)this, "valueQuantity", buffer, (Object)theValueQuantity, this.valueQuantity != null);
        CodeableConcept theValueCodeableConcept = this.getValueCodeableConcept();
        strategy.appendField(locator, (Object)this, "valueCodeableConcept", buffer, (Object)theValueCodeableConcept, this.valueCodeableConcept != null);
        String theValueString = this.getValueString();
        strategy.appendField(locator, (Object)this, "valueString", buffer, (Object)theValueString, this.valueString != null);
        Range theValueRange = this.getValueRange();
        strategy.appendField(locator, (Object)this, "valueRange", buffer, (Object)theValueRange, this.valueRange != null);
        Ratio theValueRatio = this.getValueRatio();
        strategy.appendField(locator, (Object)this, "valueRatio", buffer, (Object)theValueRatio, this.valueRatio != null);
        SampledData theValueSampledData = this.getValueSampledData();
        strategy.appendField(locator, (Object)this, "valueSampledData", buffer, (Object)theValueSampledData, this.valueSampledData != null);
        Attachment theValueAttachment = this.getValueAttachment();
        strategy.appendField(locator, (Object)this, "valueAttachment", buffer, (Object)theValueAttachment, this.valueAttachment != null);
        Time theValueTime = this.getValueTime();
        strategy.appendField(locator, (Object)this, "valueTime", buffer, (Object)theValueTime, this.valueTime != null);
        DateTime theValueDateTime = this.getValueDateTime();
        strategy.appendField(locator, (Object)this, "valueDateTime", buffer, (Object)theValueDateTime, this.valueDateTime != null);
        Period theValuePeriod = this.getValuePeriod();
        strategy.appendField(locator, (Object)this, "valuePeriod", buffer, (Object)theValuePeriod, this.valuePeriod != null);
        CodeableConcept theDataAbsentReason = this.getDataAbsentReason();
        strategy.appendField(locator, (Object)this, "dataAbsentReason", buffer, (Object)theDataAbsentReason, this.dataAbsentReason != null);
        List<ObservationReferenceRange> theReferenceRange = this.referenceRange != null && !this.referenceRange.isEmpty() ? this.getReferenceRange() : null;
        strategy.appendField(locator, (Object)this, "referenceRange", buffer, theReferenceRange, this.referenceRange != null && !this.referenceRange.isEmpty());
        return buffer;
    }
}

