/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Attachment;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ContractAgent;
import org.hl7.fhir.ContractFriendly;
import org.hl7.fhir.ContractLegal;
import org.hl7.fhir.ContractRule;
import org.hl7.fhir.ContractSigner;
import org.hl7.fhir.ContractTerm;
import org.hl7.fhir.ContractValuedItem;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Contract", propOrder={"identifier", "issued", "applies", "subject", "topic", "authority", "domain", "type", "subType", "action", "actionReason", "agent", "signer", "valuedItem", "term", "bindingAttachment", "bindingReference", "friendly", "legal", "rule"})
public class Contract
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier identifier;
    protected DateTime issued;
    protected Period applies;
    protected List<Reference> subject;
    protected List<Reference> topic;
    protected List<Reference> authority;
    protected List<Reference> domain;
    protected CodeableConcept type;
    protected List<CodeableConcept> subType;
    protected List<CodeableConcept> action;
    protected List<CodeableConcept> actionReason;
    protected List<ContractAgent> agent;
    protected List<ContractSigner> signer;
    protected List<ContractValuedItem> valuedItem;
    protected List<ContractTerm> term;
    protected Attachment bindingAttachment;
    protected Reference bindingReference;
    protected List<ContractFriendly> friendly;
    protected List<ContractLegal> legal;
    protected List<ContractRule> rule;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public DateTime getIssued() {
        return this.issued;
    }

    public void setIssued(DateTime value) {
        this.issued = value;
    }

    public Period getApplies() {
        return this.applies;
    }

    public void setApplies(Period value) {
        this.applies = value;
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public List<Reference> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<Reference>();
        }
        return this.topic;
    }

    public List<Reference> getAuthority() {
        if (this.authority == null) {
            this.authority = new ArrayList<Reference>();
        }
        return this.authority;
    }

    public List<Reference> getDomain() {
        if (this.domain == null) {
            this.domain = new ArrayList<Reference>();
        }
        return this.domain;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public List<CodeableConcept> getSubType() {
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        return this.subType;
    }

    public List<CodeableConcept> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<CodeableConcept>();
        }
        return this.action;
    }

    public List<CodeableConcept> getActionReason() {
        if (this.actionReason == null) {
            this.actionReason = new ArrayList<CodeableConcept>();
        }
        return this.actionReason;
    }

    public List<ContractAgent> getAgent() {
        if (this.agent == null) {
            this.agent = new ArrayList<ContractAgent>();
        }
        return this.agent;
    }

    public List<ContractSigner> getSigner() {
        if (this.signer == null) {
            this.signer = new ArrayList<ContractSigner>();
        }
        return this.signer;
    }

    public List<ContractValuedItem> getValuedItem() {
        if (this.valuedItem == null) {
            this.valuedItem = new ArrayList<ContractValuedItem>();
        }
        return this.valuedItem;
    }

    public List<ContractTerm> getTerm() {
        if (this.term == null) {
            this.term = new ArrayList<ContractTerm>();
        }
        return this.term;
    }

    public Attachment getBindingAttachment() {
        return this.bindingAttachment;
    }

    public void setBindingAttachment(Attachment value) {
        this.bindingAttachment = value;
    }

    public Reference getBindingReference() {
        return this.bindingReference;
    }

    public void setBindingReference(Reference value) {
        this.bindingReference = value;
    }

    public List<ContractFriendly> getFriendly() {
        if (this.friendly == null) {
            this.friendly = new ArrayList<ContractFriendly>();
        }
        return this.friendly;
    }

    public List<ContractLegal> getLegal() {
        if (this.legal == null) {
            this.legal = new ArrayList<ContractLegal>();
        }
        return this.legal;
    }

    public List<ContractRule> getRule() {
        if (this.rule == null) {
            this.rule = new ArrayList<ContractRule>();
        }
        return this.rule;
    }

    public Contract withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public Contract withIssued(DateTime value) {
        this.setIssued(value);
        return this;
    }

    public Contract withApplies(Period value) {
        this.setApplies(value);
        return this;
    }

    public Contract withSubject(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSubject().add(value);
            }
        }
        return this;
    }

    public Contract withSubject(Collection<Reference> values) {
        if (values != null) {
            this.getSubject().addAll(values);
        }
        return this;
    }

    public Contract withTopic(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getTopic().add(value);
            }
        }
        return this;
    }

    public Contract withTopic(Collection<Reference> values) {
        if (values != null) {
            this.getTopic().addAll(values);
        }
        return this;
    }

    public Contract withAuthority(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAuthority().add(value);
            }
        }
        return this;
    }

    public Contract withAuthority(Collection<Reference> values) {
        if (values != null) {
            this.getAuthority().addAll(values);
        }
        return this;
    }

    public Contract withDomain(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getDomain().add(value);
            }
        }
        return this;
    }

    public Contract withDomain(Collection<Reference> values) {
        if (values != null) {
            this.getDomain().addAll(values);
        }
        return this;
    }

    public Contract withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Contract withSubType(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSubType().add(value);
            }
        }
        return this;
    }

    public Contract withSubType(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSubType().addAll(values);
        }
        return this;
    }

    public Contract withAction(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getAction().add(value);
            }
        }
        return this;
    }

    public Contract withAction(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getAction().addAll(values);
        }
        return this;
    }

    public Contract withActionReason(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getActionReason().add(value);
            }
        }
        return this;
    }

    public Contract withActionReason(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getActionReason().addAll(values);
        }
        return this;
    }

    public Contract withAgent(ContractAgent ... values) {
        if (values != null) {
            for (ContractAgent value : values) {
                this.getAgent().add(value);
            }
        }
        return this;
    }

    public Contract withAgent(Collection<ContractAgent> values) {
        if (values != null) {
            this.getAgent().addAll(values);
        }
        return this;
    }

    public Contract withSigner(ContractSigner ... values) {
        if (values != null) {
            for (ContractSigner value : values) {
                this.getSigner().add(value);
            }
        }
        return this;
    }

    public Contract withSigner(Collection<ContractSigner> values) {
        if (values != null) {
            this.getSigner().addAll(values);
        }
        return this;
    }

    public Contract withValuedItem(ContractValuedItem ... values) {
        if (values != null) {
            for (ContractValuedItem value : values) {
                this.getValuedItem().add(value);
            }
        }
        return this;
    }

    public Contract withValuedItem(Collection<ContractValuedItem> values) {
        if (values != null) {
            this.getValuedItem().addAll(values);
        }
        return this;
    }

    public Contract withTerm(ContractTerm ... values) {
        if (values != null) {
            for (ContractTerm value : values) {
                this.getTerm().add(value);
            }
        }
        return this;
    }

    public Contract withTerm(Collection<ContractTerm> values) {
        if (values != null) {
            this.getTerm().addAll(values);
        }
        return this;
    }

    public Contract withBindingAttachment(Attachment value) {
        this.setBindingAttachment(value);
        return this;
    }

    public Contract withBindingReference(Reference value) {
        this.setBindingReference(value);
        return this;
    }

    public Contract withFriendly(ContractFriendly ... values) {
        if (values != null) {
            for (ContractFriendly value : values) {
                this.getFriendly().add(value);
            }
        }
        return this;
    }

    public Contract withFriendly(Collection<ContractFriendly> values) {
        if (values != null) {
            this.getFriendly().addAll(values);
        }
        return this;
    }

    public Contract withLegal(ContractLegal ... values) {
        if (values != null) {
            for (ContractLegal value : values) {
                this.getLegal().add(value);
            }
        }
        return this;
    }

    public Contract withLegal(Collection<ContractLegal> values) {
        if (values != null) {
            this.getLegal().addAll(values);
        }
        return this;
    }

    public Contract withRule(ContractRule ... values) {
        if (values != null) {
            for (ContractRule value : values) {
                this.getRule().add(value);
            }
        }
        return this;
    }

    public Contract withRule(Collection<ContractRule> values) {
        if (values != null) {
            this.getRule().addAll(values);
        }
        return this;
    }

    @Override
    public Contract withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Contract withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Contract withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Contract withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Contract withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Contract withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Contract withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Contract withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Contract withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Contract withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Contract withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Contract that = (Contract)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        DateTime lhsIssued = this.getIssued();
        DateTime rhsIssued = that.getIssued();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"issued", (Object)lhsIssued), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"issued", (Object)rhsIssued), (Object)lhsIssued, (Object)rhsIssued, this.issued != null, that.issued != null)) {
            return false;
        }
        Period lhsApplies = this.getApplies();
        Period rhsApplies = that.getApplies();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"applies", (Object)lhsApplies), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"applies", (Object)rhsApplies), (Object)lhsApplies, (Object)rhsApplies, this.applies != null, that.applies != null)) {
            return false;
        }
        List<Reference> lhsSubject = this.subject != null && !this.subject.isEmpty() ? this.getSubject() : null;
        List<Reference> rhsSubject = that.subject != null && !that.subject.isEmpty() ? that.getSubject() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"subject", lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null && !this.subject.isEmpty(), that.subject != null && !that.subject.isEmpty())) {
            return false;
        }
        List<Reference> lhsTopic = this.topic != null && !this.topic.isEmpty() ? this.getTopic() : null;
        List<Reference> rhsTopic = that.topic != null && !that.topic.isEmpty() ? that.getTopic() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"topic", lhsTopic), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"topic", rhsTopic), lhsTopic, rhsTopic, this.topic != null && !this.topic.isEmpty(), that.topic != null && !that.topic.isEmpty())) {
            return false;
        }
        List<Reference> lhsAuthority = this.authority != null && !this.authority.isEmpty() ? this.getAuthority() : null;
        List<Reference> rhsAuthority = that.authority != null && !that.authority.isEmpty() ? that.getAuthority() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"authority", lhsAuthority), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"authority", rhsAuthority), lhsAuthority, rhsAuthority, this.authority != null && !this.authority.isEmpty(), that.authority != null && !that.authority.isEmpty())) {
            return false;
        }
        List<Reference> lhsDomain = this.domain != null && !this.domain.isEmpty() ? this.getDomain() : null;
        List<Reference> rhsDomain = that.domain != null && !that.domain.isEmpty() ? that.getDomain() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"domain", lhsDomain), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"domain", rhsDomain), lhsDomain, rhsDomain, this.domain != null && !this.domain.isEmpty(), that.domain != null && !that.domain.isEmpty())) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        List<CodeableConcept> lhsSubType = this.subType != null && !this.subType.isEmpty() ? this.getSubType() : null;
        List<CodeableConcept> rhsSubType = that.subType != null && !that.subType.isEmpty() ? that.getSubType() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"subType", lhsSubType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"subType", rhsSubType), lhsSubType, rhsSubType, this.subType != null && !this.subType.isEmpty(), that.subType != null && !that.subType.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        List<CodeableConcept> rhsAction = that.action != null && !that.action.isEmpty() ? that.getAction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"action", lhsAction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"action", rhsAction), lhsAction, rhsAction, this.action != null && !this.action.isEmpty(), that.action != null && !that.action.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsActionReason = this.actionReason != null && !this.actionReason.isEmpty() ? this.getActionReason() : null;
        List<CodeableConcept> rhsActionReason = that.actionReason != null && !that.actionReason.isEmpty() ? that.getActionReason() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"actionReason", lhsActionReason), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"actionReason", rhsActionReason), lhsActionReason, rhsActionReason, this.actionReason != null && !this.actionReason.isEmpty(), that.actionReason != null && !that.actionReason.isEmpty())) {
            return false;
        }
        List<ContractAgent> lhsAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        List<ContractAgent> rhsAgent = that.agent != null && !that.agent.isEmpty() ? that.getAgent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"agent", lhsAgent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"agent", rhsAgent), lhsAgent, rhsAgent, this.agent != null && !this.agent.isEmpty(), that.agent != null && !that.agent.isEmpty())) {
            return false;
        }
        List<ContractSigner> lhsSigner = this.signer != null && !this.signer.isEmpty() ? this.getSigner() : null;
        List<ContractSigner> rhsSigner = that.signer != null && !that.signer.isEmpty() ? that.getSigner() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"signer", lhsSigner), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"signer", rhsSigner), lhsSigner, rhsSigner, this.signer != null && !this.signer.isEmpty(), that.signer != null && !that.signer.isEmpty())) {
            return false;
        }
        List<ContractValuedItem> lhsValuedItem = this.valuedItem != null && !this.valuedItem.isEmpty() ? this.getValuedItem() : null;
        List<ContractValuedItem> rhsValuedItem = that.valuedItem != null && !that.valuedItem.isEmpty() ? that.getValuedItem() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"valuedItem", lhsValuedItem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"valuedItem", rhsValuedItem), lhsValuedItem, rhsValuedItem, this.valuedItem != null && !this.valuedItem.isEmpty(), that.valuedItem != null && !that.valuedItem.isEmpty())) {
            return false;
        }
        List<ContractTerm> lhsTerm = this.term != null && !this.term.isEmpty() ? this.getTerm() : null;
        List<ContractTerm> rhsTerm = that.term != null && !that.term.isEmpty() ? that.getTerm() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"term", lhsTerm), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"term", rhsTerm), lhsTerm, rhsTerm, this.term != null && !this.term.isEmpty(), that.term != null && !that.term.isEmpty())) {
            return false;
        }
        Attachment lhsBindingAttachment = this.getBindingAttachment();
        Attachment rhsBindingAttachment = that.getBindingAttachment();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"bindingAttachment", (Object)lhsBindingAttachment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"bindingAttachment", (Object)rhsBindingAttachment), (Object)lhsBindingAttachment, (Object)rhsBindingAttachment, this.bindingAttachment != null, that.bindingAttachment != null)) {
            return false;
        }
        Reference lhsBindingReference = this.getBindingReference();
        Reference rhsBindingReference = that.getBindingReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"bindingReference", (Object)lhsBindingReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"bindingReference", (Object)rhsBindingReference), (Object)lhsBindingReference, (Object)rhsBindingReference, this.bindingReference != null, that.bindingReference != null)) {
            return false;
        }
        List<ContractFriendly> lhsFriendly = this.friendly != null && !this.friendly.isEmpty() ? this.getFriendly() : null;
        List<ContractFriendly> rhsFriendly = that.friendly != null && !that.friendly.isEmpty() ? that.getFriendly() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"friendly", lhsFriendly), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"friendly", rhsFriendly), lhsFriendly, rhsFriendly, this.friendly != null && !this.friendly.isEmpty(), that.friendly != null && !that.friendly.isEmpty())) {
            return false;
        }
        List<ContractLegal> lhsLegal = this.legal != null && !this.legal.isEmpty() ? this.getLegal() : null;
        List<ContractLegal> rhsLegal = that.legal != null && !that.legal.isEmpty() ? that.getLegal() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"legal", lhsLegal), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"legal", rhsLegal), lhsLegal, rhsLegal, this.legal != null && !this.legal.isEmpty(), that.legal != null && !that.legal.isEmpty())) {
            return false;
        }
        List<ContractRule> lhsRule = this.rule != null && !this.rule.isEmpty() ? this.getRule() : null;
        List<ContractRule> rhsRule = that.rule != null && !that.rule.isEmpty() ? that.getRule() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"rule", lhsRule), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"rule", rhsRule), lhsRule, rhsRule, this.rule != null && !this.rule.isEmpty(), that.rule != null && !that.rule.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier, this.identifier != null);
        DateTime theIssued = this.getIssued();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"issued", (Object)theIssued), currentHashCode, (Object)theIssued, this.issued != null);
        Period theApplies = this.getApplies();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"applies", (Object)theApplies), currentHashCode, (Object)theApplies, this.applies != null);
        List<Reference> theSubject = this.subject != null && !this.subject.isEmpty() ? this.getSubject() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"subject", theSubject), currentHashCode, theSubject, this.subject != null && !this.subject.isEmpty());
        List<Reference> theTopic = this.topic != null && !this.topic.isEmpty() ? this.getTopic() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"topic", theTopic), currentHashCode, theTopic, this.topic != null && !this.topic.isEmpty());
        List<Reference> theAuthority = this.authority != null && !this.authority.isEmpty() ? this.getAuthority() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"authority", theAuthority), currentHashCode, theAuthority, this.authority != null && !this.authority.isEmpty());
        List<Reference> theDomain = this.domain != null && !this.domain.isEmpty() ? this.getDomain() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"domain", theDomain), currentHashCode, theDomain, this.domain != null && !this.domain.isEmpty());
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        List<CodeableConcept> theSubType = this.subType != null && !this.subType.isEmpty() ? this.getSubType() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"subType", theSubType), currentHashCode, theSubType, this.subType != null && !this.subType.isEmpty());
        List<CodeableConcept> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"action", theAction), currentHashCode, theAction, this.action != null && !this.action.isEmpty());
        List<CodeableConcept> theActionReason = this.actionReason != null && !this.actionReason.isEmpty() ? this.getActionReason() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"actionReason", theActionReason), currentHashCode, theActionReason, this.actionReason != null && !this.actionReason.isEmpty());
        List<ContractAgent> theAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"agent", theAgent), currentHashCode, theAgent, this.agent != null && !this.agent.isEmpty());
        List<ContractSigner> theSigner = this.signer != null && !this.signer.isEmpty() ? this.getSigner() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"signer", theSigner), currentHashCode, theSigner, this.signer != null && !this.signer.isEmpty());
        List<ContractValuedItem> theValuedItem = this.valuedItem != null && !this.valuedItem.isEmpty() ? this.getValuedItem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"valuedItem", theValuedItem), currentHashCode, theValuedItem, this.valuedItem != null && !this.valuedItem.isEmpty());
        List<ContractTerm> theTerm = this.term != null && !this.term.isEmpty() ? this.getTerm() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"term", theTerm), currentHashCode, theTerm, this.term != null && !this.term.isEmpty());
        Attachment theBindingAttachment = this.getBindingAttachment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"bindingAttachment", (Object)theBindingAttachment), currentHashCode, (Object)theBindingAttachment, this.bindingAttachment != null);
        Reference theBindingReference = this.getBindingReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"bindingReference", (Object)theBindingReference), currentHashCode, (Object)theBindingReference, this.bindingReference != null);
        List<ContractFriendly> theFriendly = this.friendly != null && !this.friendly.isEmpty() ? this.getFriendly() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"friendly", theFriendly), currentHashCode, theFriendly, this.friendly != null && !this.friendly.isEmpty());
        List<ContractLegal> theLegal = this.legal != null && !this.legal.isEmpty() ? this.getLegal() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"legal", theLegal), currentHashCode, theLegal, this.legal != null && !this.legal.isEmpty());
        List<ContractRule> theRule = this.rule != null && !this.rule.isEmpty() ? this.getRule() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"rule", theRule), currentHashCode, theRule, this.rule != null && !this.rule.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier, this.identifier != null);
        DateTime theIssued = this.getIssued();
        strategy.appendField(locator, (Object)this, "issued", buffer, (Object)theIssued, this.issued != null);
        Period theApplies = this.getApplies();
        strategy.appendField(locator, (Object)this, "applies", buffer, (Object)theApplies, this.applies != null);
        List<Reference> theSubject = this.subject != null && !this.subject.isEmpty() ? this.getSubject() : null;
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null && !this.subject.isEmpty());
        List<Reference> theTopic = this.topic != null && !this.topic.isEmpty() ? this.getTopic() : null;
        strategy.appendField(locator, (Object)this, "topic", buffer, theTopic, this.topic != null && !this.topic.isEmpty());
        List<Reference> theAuthority = this.authority != null && !this.authority.isEmpty() ? this.getAuthority() : null;
        strategy.appendField(locator, (Object)this, "authority", buffer, theAuthority, this.authority != null && !this.authority.isEmpty());
        List<Reference> theDomain = this.domain != null && !this.domain.isEmpty() ? this.getDomain() : null;
        strategy.appendField(locator, (Object)this, "domain", buffer, theDomain, this.domain != null && !this.domain.isEmpty());
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        List<CodeableConcept> theSubType = this.subType != null && !this.subType.isEmpty() ? this.getSubType() : null;
        strategy.appendField(locator, (Object)this, "subType", buffer, theSubType, this.subType != null && !this.subType.isEmpty());
        List<CodeableConcept> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        strategy.appendField(locator, (Object)this, "action", buffer, theAction, this.action != null && !this.action.isEmpty());
        List<CodeableConcept> theActionReason = this.actionReason != null && !this.actionReason.isEmpty() ? this.getActionReason() : null;
        strategy.appendField(locator, (Object)this, "actionReason", buffer, theActionReason, this.actionReason != null && !this.actionReason.isEmpty());
        List<ContractAgent> theAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        strategy.appendField(locator, (Object)this, "agent", buffer, theAgent, this.agent != null && !this.agent.isEmpty());
        List<ContractSigner> theSigner = this.signer != null && !this.signer.isEmpty() ? this.getSigner() : null;
        strategy.appendField(locator, (Object)this, "signer", buffer, theSigner, this.signer != null && !this.signer.isEmpty());
        List<ContractValuedItem> theValuedItem = this.valuedItem != null && !this.valuedItem.isEmpty() ? this.getValuedItem() : null;
        strategy.appendField(locator, (Object)this, "valuedItem", buffer, theValuedItem, this.valuedItem != null && !this.valuedItem.isEmpty());
        List<ContractTerm> theTerm = this.term != null && !this.term.isEmpty() ? this.getTerm() : null;
        strategy.appendField(locator, (Object)this, "term", buffer, theTerm, this.term != null && !this.term.isEmpty());
        Attachment theBindingAttachment = this.getBindingAttachment();
        strategy.appendField(locator, (Object)this, "bindingAttachment", buffer, (Object)theBindingAttachment, this.bindingAttachment != null);
        Reference theBindingReference = this.getBindingReference();
        strategy.appendField(locator, (Object)this, "bindingReference", buffer, (Object)theBindingReference, this.bindingReference != null);
        List<ContractFriendly> theFriendly = this.friendly != null && !this.friendly.isEmpty() ? this.getFriendly() : null;
        strategy.appendField(locator, (Object)this, "friendly", buffer, theFriendly, this.friendly != null && !this.friendly.isEmpty());
        List<ContractLegal> theLegal = this.legal != null && !this.legal.isEmpty() ? this.getLegal() : null;
        strategy.appendField(locator, (Object)this, "legal", buffer, theLegal, this.legal != null && !this.legal.isEmpty());
        List<ContractRule> theRule = this.rule != null && !this.rule.isEmpty() ? this.getRule() : null;
        strategy.appendField(locator, (Object)this, "rule", buffer, theRule, this.rule != null && !this.rule.isEmpty());
        return buffer;
    }
}

