/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Address;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ContactPoint;
import org.hl7.fhir.Extension;
import org.hl7.fhir.HumanName;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Organization.Contact", propOrder={"purpose", "name", "telecom", "address"})
public class OrganizationContact
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected CodeableConcept purpose;
    protected HumanName name;
    protected List<ContactPoint> telecom;
    protected Address address;

    public CodeableConcept getPurpose() {
        return this.purpose;
    }

    public void setPurpose(CodeableConcept value) {
        this.purpose = value;
    }

    public HumanName getName() {
        return this.name;
    }

    public void setName(HumanName value) {
        this.name = value;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address value) {
        this.address = value;
    }

    public OrganizationContact withPurpose(CodeableConcept value) {
        this.setPurpose(value);
        return this;
    }

    public OrganizationContact withName(HumanName value) {
        this.setName(value);
        return this;
    }

    public OrganizationContact withTelecom(ContactPoint ... values) {
        if (values != null) {
            for (ContactPoint value : values) {
                this.getTelecom().add(value);
            }
        }
        return this;
    }

    public OrganizationContact withTelecom(Collection<ContactPoint> values) {
        if (values != null) {
            this.getTelecom().addAll(values);
        }
        return this;
    }

    public OrganizationContact withAddress(Address value) {
        this.setAddress(value);
        return this;
    }

    @Override
    public OrganizationContact withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public OrganizationContact withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public OrganizationContact withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public OrganizationContact withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public OrganizationContact withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        OrganizationContact that = (OrganizationContact)object;
        CodeableConcept lhsPurpose = this.getPurpose();
        CodeableConcept rhsPurpose = that.getPurpose();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"purpose", (Object)lhsPurpose), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"purpose", (Object)rhsPurpose), (Object)lhsPurpose, (Object)rhsPurpose, this.purpose != null, that.purpose != null)) {
            return false;
        }
        HumanName lhsName = this.getName();
        HumanName rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName, this.name != null, that.name != null)) {
            return false;
        }
        List<ContactPoint> lhsTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        List<ContactPoint> rhsTelecom = that.telecom != null && !that.telecom.isEmpty() ? that.getTelecom() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"telecom", lhsTelecom), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"telecom", rhsTelecom), lhsTelecom, rhsTelecom, this.telecom != null && !this.telecom.isEmpty(), that.telecom != null && !that.telecom.isEmpty())) {
            return false;
        }
        Address lhsAddress = this.getAddress();
        Address rhsAddress = that.getAddress();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"address", (Object)lhsAddress), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"address", (Object)rhsAddress), (Object)lhsAddress, (Object)rhsAddress, this.address != null, that.address != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept thePurpose = this.getPurpose();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"purpose", (Object)thePurpose), currentHashCode, (Object)thePurpose, this.purpose != null);
        HumanName theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"name", (Object)theName), currentHashCode, (Object)theName, this.name != null);
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"telecom", theTelecom), currentHashCode, theTelecom, this.telecom != null && !this.telecom.isEmpty());
        Address theAddress = this.getAddress();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"address", (Object)theAddress), currentHashCode, (Object)theAddress, this.address != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept thePurpose = this.getPurpose();
        strategy.appendField(locator, (Object)this, "purpose", buffer, (Object)thePurpose, this.purpose != null);
        HumanName theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName, this.name != null);
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        strategy.appendField(locator, (Object)this, "telecom", buffer, theTelecom, this.telecom != null && !this.telecom.isEmpty());
        Address theAddress = this.getAddress();
        strategy.appendField(locator, (Object)this, "address", buffer, (Object)theAddress, this.address != null);
        return buffer;
    }
}

