/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.DataRequirement;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.GuidanceResponseAction;
import org.hl7.fhir.GuidanceResponseStatus;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="GuidanceResponse", propOrder={"requestId", "module", "status", "evaluationMessage", "outputParameters", "action", "dataRequirement"})
public class GuidanceResponse
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected String requestId;
    @XmlElement(required=true)
    protected Reference module;
    @XmlElement(required=true)
    protected GuidanceResponseStatus status;
    protected List<Reference> evaluationMessage;
    protected Reference outputParameters;
    protected List<GuidanceResponseAction> action;
    protected List<DataRequirement> dataRequirement;

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String value) {
        this.requestId = value;
    }

    public Reference getModule() {
        return this.module;
    }

    public void setModule(Reference value) {
        this.module = value;
    }

    public GuidanceResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(GuidanceResponseStatus value) {
        this.status = value;
    }

    public List<Reference> getEvaluationMessage() {
        if (this.evaluationMessage == null) {
            this.evaluationMessage = new ArrayList<Reference>();
        }
        return this.evaluationMessage;
    }

    public Reference getOutputParameters() {
        return this.outputParameters;
    }

    public void setOutputParameters(Reference value) {
        this.outputParameters = value;
    }

    public List<GuidanceResponseAction> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<GuidanceResponseAction>();
        }
        return this.action;
    }

    public List<DataRequirement> getDataRequirement() {
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        return this.dataRequirement;
    }

    public GuidanceResponse withRequestId(String value) {
        this.setRequestId(value);
        return this;
    }

    public GuidanceResponse withModule(Reference value) {
        this.setModule(value);
        return this;
    }

    public GuidanceResponse withStatus(GuidanceResponseStatus value) {
        this.setStatus(value);
        return this;
    }

    public GuidanceResponse withEvaluationMessage(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getEvaluationMessage().add(value);
            }
        }
        return this;
    }

    public GuidanceResponse withEvaluationMessage(Collection<Reference> values) {
        if (values != null) {
            this.getEvaluationMessage().addAll(values);
        }
        return this;
    }

    public GuidanceResponse withOutputParameters(Reference value) {
        this.setOutputParameters(value);
        return this;
    }

    public GuidanceResponse withAction(GuidanceResponseAction ... values) {
        if (values != null) {
            for (GuidanceResponseAction value : values) {
                this.getAction().add(value);
            }
        }
        return this;
    }

    public GuidanceResponse withAction(Collection<GuidanceResponseAction> values) {
        if (values != null) {
            this.getAction().addAll(values);
        }
        return this;
    }

    public GuidanceResponse withDataRequirement(DataRequirement ... values) {
        if (values != null) {
            for (DataRequirement value : values) {
                this.getDataRequirement().add(value);
            }
        }
        return this;
    }

    public GuidanceResponse withDataRequirement(Collection<DataRequirement> values) {
        if (values != null) {
            this.getDataRequirement().addAll(values);
        }
        return this;
    }

    @Override
    public GuidanceResponse withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public GuidanceResponse withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public GuidanceResponse withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public GuidanceResponse withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public GuidanceResponse withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public GuidanceResponse withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public GuidanceResponse withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public GuidanceResponse withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public GuidanceResponse withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public GuidanceResponse withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public GuidanceResponse withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        GuidanceResponse that = (GuidanceResponse)object;
        String lhsRequestId = this.getRequestId();
        String rhsRequestId = that.getRequestId();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requestId", (Object)lhsRequestId), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requestId", (Object)rhsRequestId), (Object)lhsRequestId, (Object)rhsRequestId, this.requestId != null, that.requestId != null)) {
            return false;
        }
        Reference lhsModule = this.getModule();
        Reference rhsModule = that.getModule();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"module", (Object)lhsModule), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"module", (Object)rhsModule), (Object)lhsModule, (Object)rhsModule, this.module != null, that.module != null)) {
            return false;
        }
        GuidanceResponseStatus lhsStatus = this.getStatus();
        GuidanceResponseStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        List<Reference> lhsEvaluationMessage = this.evaluationMessage != null && !this.evaluationMessage.isEmpty() ? this.getEvaluationMessage() : null;
        List<Reference> rhsEvaluationMessage = that.evaluationMessage != null && !that.evaluationMessage.isEmpty() ? that.getEvaluationMessage() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"evaluationMessage", lhsEvaluationMessage), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"evaluationMessage", rhsEvaluationMessage), lhsEvaluationMessage, rhsEvaluationMessage, this.evaluationMessage != null && !this.evaluationMessage.isEmpty(), that.evaluationMessage != null && !that.evaluationMessage.isEmpty())) {
            return false;
        }
        Reference lhsOutputParameters = this.getOutputParameters();
        Reference rhsOutputParameters = that.getOutputParameters();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"outputParameters", (Object)lhsOutputParameters), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"outputParameters", (Object)rhsOutputParameters), (Object)lhsOutputParameters, (Object)rhsOutputParameters, this.outputParameters != null, that.outputParameters != null)) {
            return false;
        }
        List<GuidanceResponseAction> lhsAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        List<GuidanceResponseAction> rhsAction = that.action != null && !that.action.isEmpty() ? that.getAction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"action", lhsAction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"action", rhsAction), lhsAction, rhsAction, this.action != null && !this.action.isEmpty(), that.action != null && !that.action.isEmpty())) {
            return false;
        }
        List<DataRequirement> lhsDataRequirement = this.dataRequirement != null && !this.dataRequirement.isEmpty() ? this.getDataRequirement() : null;
        List<DataRequirement> rhsDataRequirement = that.dataRequirement != null && !that.dataRequirement.isEmpty() ? that.getDataRequirement() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"dataRequirement", lhsDataRequirement), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"dataRequirement", rhsDataRequirement), lhsDataRequirement, rhsDataRequirement, this.dataRequirement != null && !this.dataRequirement.isEmpty(), that.dataRequirement != null && !that.dataRequirement.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        String theRequestId = this.getRequestId();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requestId", (Object)theRequestId), currentHashCode, (Object)theRequestId, this.requestId != null);
        Reference theModule = this.getModule();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"module", (Object)theModule), currentHashCode, (Object)theModule, this.module != null);
        GuidanceResponseStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        List<Reference> theEvaluationMessage = this.evaluationMessage != null && !this.evaluationMessage.isEmpty() ? this.getEvaluationMessage() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"evaluationMessage", theEvaluationMessage), currentHashCode, theEvaluationMessage, this.evaluationMessage != null && !this.evaluationMessage.isEmpty());
        Reference theOutputParameters = this.getOutputParameters();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"outputParameters", (Object)theOutputParameters), currentHashCode, (Object)theOutputParameters, this.outputParameters != null);
        List<GuidanceResponseAction> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"action", theAction), currentHashCode, theAction, this.action != null && !this.action.isEmpty());
        List<DataRequirement> theDataRequirement = this.dataRequirement != null && !this.dataRequirement.isEmpty() ? this.getDataRequirement() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"dataRequirement", theDataRequirement), currentHashCode, theDataRequirement, this.dataRequirement != null && !this.dataRequirement.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        String theRequestId = this.getRequestId();
        strategy.appendField(locator, (Object)this, "requestId", buffer, (Object)theRequestId, this.requestId != null);
        Reference theModule = this.getModule();
        strategy.appendField(locator, (Object)this, "module", buffer, (Object)theModule, this.module != null);
        GuidanceResponseStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        List<Reference> theEvaluationMessage = this.evaluationMessage != null && !this.evaluationMessage.isEmpty() ? this.getEvaluationMessage() : null;
        strategy.appendField(locator, (Object)this, "evaluationMessage", buffer, theEvaluationMessage, this.evaluationMessage != null && !this.evaluationMessage.isEmpty());
        Reference theOutputParameters = this.getOutputParameters();
        strategy.appendField(locator, (Object)this, "outputParameters", buffer, (Object)theOutputParameters, this.outputParameters != null);
        List<GuidanceResponseAction> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        strategy.appendField(locator, (Object)this, "action", buffer, theAction, this.action != null && !this.action.isEmpty());
        List<DataRequirement> theDataRequirement = this.dataRequirement != null && !this.dataRequirement.isEmpty() ? this.getDataRequirement() : null;
        strategy.appendField(locator, (Object)this, "dataRequirement", buffer, theDataRequirement, this.dataRequirement != null && !this.dataRequirement.isEmpty());
        return buffer;
    }
}

