/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.TestScriptContact;
import org.hl7.fhir.TestScriptDestination;
import org.hl7.fhir.TestScriptFixture;
import org.hl7.fhir.TestScriptMetadata;
import org.hl7.fhir.TestScriptOrigin;
import org.hl7.fhir.TestScriptRule;
import org.hl7.fhir.TestScriptRuleset;
import org.hl7.fhir.TestScriptSetup;
import org.hl7.fhir.TestScriptTeardown;
import org.hl7.fhir.TestScriptTest;
import org.hl7.fhir.TestScriptVariable;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TestScript", propOrder={"url", "version", "name", "status", "identifier", "experimental", "publisher", "contact", "date", "description", "useContext", "requirements", "copyright", "origin", "destination", "metadata", "fixture", "profile", "variable", "rule", "ruleset", "setup", "test", "teardown"})
public class TestScript
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Uri url;
    protected String version;
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Identifier identifier;
    protected Boolean experimental;
    protected String publisher;
    protected List<TestScriptContact> contact;
    protected DateTime date;
    protected String description;
    protected List<CodeableConcept> useContext;
    protected String requirements;
    protected String copyright;
    protected List<TestScriptOrigin> origin;
    protected List<TestScriptDestination> destination;
    protected TestScriptMetadata metadata;
    protected List<TestScriptFixture> fixture;
    protected List<Reference> profile;
    protected List<TestScriptVariable> variable;
    protected List<TestScriptRule> rule;
    protected List<TestScriptRuleset> ruleset;
    protected TestScriptSetup setup;
    protected List<TestScriptTest> test;
    protected TestScriptTeardown teardown;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<TestScriptContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<TestScriptContact>();
        }
        return this.contact;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public List<TestScriptOrigin> getOrigin() {
        if (this.origin == null) {
            this.origin = new ArrayList<TestScriptOrigin>();
        }
        return this.origin;
    }

    public List<TestScriptDestination> getDestination() {
        if (this.destination == null) {
            this.destination = new ArrayList<TestScriptDestination>();
        }
        return this.destination;
    }

    public TestScriptMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(TestScriptMetadata value) {
        this.metadata = value;
    }

    public List<TestScriptFixture> getFixture() {
        if (this.fixture == null) {
            this.fixture = new ArrayList<TestScriptFixture>();
        }
        return this.fixture;
    }

    public List<Reference> getProfile() {
        if (this.profile == null) {
            this.profile = new ArrayList<Reference>();
        }
        return this.profile;
    }

    public List<TestScriptVariable> getVariable() {
        if (this.variable == null) {
            this.variable = new ArrayList<TestScriptVariable>();
        }
        return this.variable;
    }

    public List<TestScriptRule> getRule() {
        if (this.rule == null) {
            this.rule = new ArrayList<TestScriptRule>();
        }
        return this.rule;
    }

    public List<TestScriptRuleset> getRuleset() {
        if (this.ruleset == null) {
            this.ruleset = new ArrayList<TestScriptRuleset>();
        }
        return this.ruleset;
    }

    public TestScriptSetup getSetup() {
        return this.setup;
    }

    public void setSetup(TestScriptSetup value) {
        this.setup = value;
    }

    public List<TestScriptTest> getTest() {
        if (this.test == null) {
            this.test = new ArrayList<TestScriptTest>();
        }
        return this.test;
    }

    public TestScriptTeardown getTeardown() {
        return this.teardown;
    }

    public void setTeardown(TestScriptTeardown value) {
        this.teardown = value;
    }

    public TestScript withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public TestScript withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public TestScript withName(String value) {
        this.setName(value);
        return this;
    }

    public TestScript withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public TestScript withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public TestScript withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public TestScript withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public TestScript withContact(TestScriptContact ... values) {
        if (values != null) {
            for (TestScriptContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public TestScript withContact(Collection<TestScriptContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public TestScript withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public TestScript withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public TestScript withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public TestScript withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public TestScript withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public TestScript withCopyright(String value) {
        this.setCopyright(value);
        return this;
    }

    public TestScript withOrigin(TestScriptOrigin ... values) {
        if (values != null) {
            for (TestScriptOrigin value : values) {
                this.getOrigin().add(value);
            }
        }
        return this;
    }

    public TestScript withOrigin(Collection<TestScriptOrigin> values) {
        if (values != null) {
            this.getOrigin().addAll(values);
        }
        return this;
    }

    public TestScript withDestination(TestScriptDestination ... values) {
        if (values != null) {
            for (TestScriptDestination value : values) {
                this.getDestination().add(value);
            }
        }
        return this;
    }

    public TestScript withDestination(Collection<TestScriptDestination> values) {
        if (values != null) {
            this.getDestination().addAll(values);
        }
        return this;
    }

    public TestScript withMetadata(TestScriptMetadata value) {
        this.setMetadata(value);
        return this;
    }

    public TestScript withFixture(TestScriptFixture ... values) {
        if (values != null) {
            for (TestScriptFixture value : values) {
                this.getFixture().add(value);
            }
        }
        return this;
    }

    public TestScript withFixture(Collection<TestScriptFixture> values) {
        if (values != null) {
            this.getFixture().addAll(values);
        }
        return this;
    }

    public TestScript withProfile(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getProfile().add(value);
            }
        }
        return this;
    }

    public TestScript withProfile(Collection<Reference> values) {
        if (values != null) {
            this.getProfile().addAll(values);
        }
        return this;
    }

    public TestScript withVariable(TestScriptVariable ... values) {
        if (values != null) {
            for (TestScriptVariable value : values) {
                this.getVariable().add(value);
            }
        }
        return this;
    }

    public TestScript withVariable(Collection<TestScriptVariable> values) {
        if (values != null) {
            this.getVariable().addAll(values);
        }
        return this;
    }

    public TestScript withRule(TestScriptRule ... values) {
        if (values != null) {
            for (TestScriptRule value : values) {
                this.getRule().add(value);
            }
        }
        return this;
    }

    public TestScript withRule(Collection<TestScriptRule> values) {
        if (values != null) {
            this.getRule().addAll(values);
        }
        return this;
    }

    public TestScript withRuleset(TestScriptRuleset ... values) {
        if (values != null) {
            for (TestScriptRuleset value : values) {
                this.getRuleset().add(value);
            }
        }
        return this;
    }

    public TestScript withRuleset(Collection<TestScriptRuleset> values) {
        if (values != null) {
            this.getRuleset().addAll(values);
        }
        return this;
    }

    public TestScript withSetup(TestScriptSetup value) {
        this.setSetup(value);
        return this;
    }

    public TestScript withTest(TestScriptTest ... values) {
        if (values != null) {
            for (TestScriptTest value : values) {
                this.getTest().add(value);
            }
        }
        return this;
    }

    public TestScript withTest(Collection<TestScriptTest> values) {
        if (values != null) {
            this.getTest().addAll(values);
        }
        return this;
    }

    public TestScript withTeardown(TestScriptTeardown value) {
        this.setTeardown(value);
        return this;
    }

    @Override
    public TestScript withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public TestScript withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public TestScript withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public TestScript withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public TestScript withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public TestScript withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public TestScript withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public TestScript withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public TestScript withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public TestScript withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public TestScript withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        TestScript that = (TestScript)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"url", (Object)lhsUrl), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"url", (Object)rhsUrl), (Object)lhsUrl, (Object)rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion, this.version != null, that.version != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName, this.name != null, that.name != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", (Object)lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", (Object)rhsIdentifier), (Object)lhsIdentifier, (Object)rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"experimental", (Object)lhsExperimental), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"experimental", (Object)rhsExperimental), (Object)lhsExperimental, (Object)rhsExperimental, this.experimental != null, that.experimental != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"publisher", (Object)lhsPublisher), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"publisher", (Object)rhsPublisher), (Object)lhsPublisher, (Object)rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<TestScriptContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<TestScriptContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contact", lhsContact), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"useContext", rhsUseContext), lhsUseContext, rhsUseContext, this.useContext != null && !this.useContext.isEmpty(), that.useContext != null && !that.useContext.isEmpty())) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requirements", (Object)lhsRequirements), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requirements", (Object)rhsRequirements), (Object)lhsRequirements, (Object)rhsRequirements, this.requirements != null, that.requirements != null)) {
            return false;
        }
        String lhsCopyright = this.getCopyright();
        String rhsCopyright = that.getCopyright();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"copyright", (Object)lhsCopyright), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"copyright", (Object)rhsCopyright), (Object)lhsCopyright, (Object)rhsCopyright, this.copyright != null, that.copyright != null)) {
            return false;
        }
        List<TestScriptOrigin> lhsOrigin = this.origin != null && !this.origin.isEmpty() ? this.getOrigin() : null;
        List<TestScriptOrigin> rhsOrigin = that.origin != null && !that.origin.isEmpty() ? that.getOrigin() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"origin", lhsOrigin), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"origin", rhsOrigin), lhsOrigin, rhsOrigin, this.origin != null && !this.origin.isEmpty(), that.origin != null && !that.origin.isEmpty())) {
            return false;
        }
        List<TestScriptDestination> lhsDestination = this.destination != null && !this.destination.isEmpty() ? this.getDestination() : null;
        List<TestScriptDestination> rhsDestination = that.destination != null && !that.destination.isEmpty() ? that.getDestination() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"destination", lhsDestination), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"destination", rhsDestination), lhsDestination, rhsDestination, this.destination != null && !this.destination.isEmpty(), that.destination != null && !that.destination.isEmpty())) {
            return false;
        }
        TestScriptMetadata lhsMetadata = this.getMetadata();
        TestScriptMetadata rhsMetadata = that.getMetadata();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"metadata", (Object)lhsMetadata), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"metadata", (Object)rhsMetadata), (Object)lhsMetadata, (Object)rhsMetadata, this.metadata != null, that.metadata != null)) {
            return false;
        }
        List<TestScriptFixture> lhsFixture = this.fixture != null && !this.fixture.isEmpty() ? this.getFixture() : null;
        List<TestScriptFixture> rhsFixture = that.fixture != null && !that.fixture.isEmpty() ? that.getFixture() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"fixture", lhsFixture), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"fixture", rhsFixture), lhsFixture, rhsFixture, this.fixture != null && !this.fixture.isEmpty(), that.fixture != null && !that.fixture.isEmpty())) {
            return false;
        }
        List<Reference> lhsProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        List<Reference> rhsProfile = that.profile != null && !that.profile.isEmpty() ? that.getProfile() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"profile", lhsProfile), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"profile", rhsProfile), lhsProfile, rhsProfile, this.profile != null && !this.profile.isEmpty(), that.profile != null && !that.profile.isEmpty())) {
            return false;
        }
        List<TestScriptVariable> lhsVariable = this.variable != null && !this.variable.isEmpty() ? this.getVariable() : null;
        List<TestScriptVariable> rhsVariable = that.variable != null && !that.variable.isEmpty() ? that.getVariable() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"variable", lhsVariable), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"variable", rhsVariable), lhsVariable, rhsVariable, this.variable != null && !this.variable.isEmpty(), that.variable != null && !that.variable.isEmpty())) {
            return false;
        }
        List<TestScriptRule> lhsRule = this.rule != null && !this.rule.isEmpty() ? this.getRule() : null;
        List<TestScriptRule> rhsRule = that.rule != null && !that.rule.isEmpty() ? that.getRule() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"rule", lhsRule), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"rule", rhsRule), lhsRule, rhsRule, this.rule != null && !this.rule.isEmpty(), that.rule != null && !that.rule.isEmpty())) {
            return false;
        }
        List<TestScriptRuleset> lhsRuleset = this.ruleset != null && !this.ruleset.isEmpty() ? this.getRuleset() : null;
        List<TestScriptRuleset> rhsRuleset = that.ruleset != null && !that.ruleset.isEmpty() ? that.getRuleset() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"ruleset", lhsRuleset), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"ruleset", rhsRuleset), lhsRuleset, rhsRuleset, this.ruleset != null && !this.ruleset.isEmpty(), that.ruleset != null && !that.ruleset.isEmpty())) {
            return false;
        }
        TestScriptSetup lhsSetup = this.getSetup();
        TestScriptSetup rhsSetup = that.getSetup();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"setup", (Object)lhsSetup), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"setup", (Object)rhsSetup), (Object)lhsSetup, (Object)rhsSetup, this.setup != null, that.setup != null)) {
            return false;
        }
        List<TestScriptTest> lhsTest = this.test != null && !this.test.isEmpty() ? this.getTest() : null;
        List<TestScriptTest> rhsTest = that.test != null && !that.test.isEmpty() ? that.getTest() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"test", lhsTest), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"test", rhsTest), lhsTest, rhsTest, this.test != null && !this.test.isEmpty(), that.test != null && !that.test.isEmpty())) {
            return false;
        }
        TestScriptTeardown lhsTeardown = this.getTeardown();
        TestScriptTeardown rhsTeardown = that.getTeardown();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"teardown", (Object)lhsTeardown), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"teardown", (Object)rhsTeardown), (Object)lhsTeardown, (Object)rhsTeardown, this.teardown != null, that.teardown != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"url", (Object)theUrl), currentHashCode, (Object)theUrl, this.url != null);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"version", (Object)theVersion), currentHashCode, (Object)theVersion, this.version != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", (Object)theIdentifier), currentHashCode, (Object)theIdentifier, this.identifier != null);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"experimental", (Object)theExperimental), currentHashCode, (Object)theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"publisher", (Object)thePublisher), currentHashCode, (Object)thePublisher, this.publisher != null);
        List<TestScriptContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate, this.date != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"useContext", theUseContext), currentHashCode, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requirements", (Object)theRequirements), currentHashCode, (Object)theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"copyright", (Object)theCopyright), currentHashCode, (Object)theCopyright, this.copyright != null);
        List<TestScriptOrigin> theOrigin = this.origin != null && !this.origin.isEmpty() ? this.getOrigin() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"origin", theOrigin), currentHashCode, theOrigin, this.origin != null && !this.origin.isEmpty());
        List<TestScriptDestination> theDestination = this.destination != null && !this.destination.isEmpty() ? this.getDestination() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"destination", theDestination), currentHashCode, theDestination, this.destination != null && !this.destination.isEmpty());
        TestScriptMetadata theMetadata = this.getMetadata();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"metadata", (Object)theMetadata), currentHashCode, (Object)theMetadata, this.metadata != null);
        List<TestScriptFixture> theFixture = this.fixture != null && !this.fixture.isEmpty() ? this.getFixture() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"fixture", theFixture), currentHashCode, theFixture, this.fixture != null && !this.fixture.isEmpty());
        List<Reference> theProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"profile", theProfile), currentHashCode, theProfile, this.profile != null && !this.profile.isEmpty());
        List<TestScriptVariable> theVariable = this.variable != null && !this.variable.isEmpty() ? this.getVariable() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"variable", theVariable), currentHashCode, theVariable, this.variable != null && !this.variable.isEmpty());
        List<TestScriptRule> theRule = this.rule != null && !this.rule.isEmpty() ? this.getRule() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"rule", theRule), currentHashCode, theRule, this.rule != null && !this.rule.isEmpty());
        List<TestScriptRuleset> theRuleset = this.ruleset != null && !this.ruleset.isEmpty() ? this.getRuleset() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"ruleset", theRuleset), currentHashCode, theRuleset, this.ruleset != null && !this.ruleset.isEmpty());
        TestScriptSetup theSetup = this.getSetup();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"setup", (Object)theSetup), currentHashCode, (Object)theSetup, this.setup != null);
        List<TestScriptTest> theTest = this.test != null && !this.test.isEmpty() ? this.getTest() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"test", theTest), currentHashCode, theTest, this.test != null && !this.test.isEmpty());
        TestScriptTeardown theTeardown = this.getTeardown();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"teardown", (Object)theTeardown), currentHashCode, (Object)theTeardown, this.teardown != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, (Object)theUrl, this.url != null);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion, this.version != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, (Object)theIdentifier, this.identifier != null);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, (Object)theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, (Object)thePublisher, this.publisher != null);
        List<TestScriptContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate, this.date != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, (Object)theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        strategy.appendField(locator, (Object)this, "copyright", buffer, (Object)theCopyright, this.copyright != null);
        List<TestScriptOrigin> theOrigin = this.origin != null && !this.origin.isEmpty() ? this.getOrigin() : null;
        strategy.appendField(locator, (Object)this, "origin", buffer, theOrigin, this.origin != null && !this.origin.isEmpty());
        List<TestScriptDestination> theDestination = this.destination != null && !this.destination.isEmpty() ? this.getDestination() : null;
        strategy.appendField(locator, (Object)this, "destination", buffer, theDestination, this.destination != null && !this.destination.isEmpty());
        TestScriptMetadata theMetadata = this.getMetadata();
        strategy.appendField(locator, (Object)this, "metadata", buffer, (Object)theMetadata, this.metadata != null);
        List<TestScriptFixture> theFixture = this.fixture != null && !this.fixture.isEmpty() ? this.getFixture() : null;
        strategy.appendField(locator, (Object)this, "fixture", buffer, theFixture, this.fixture != null && !this.fixture.isEmpty());
        List<Reference> theProfile = this.profile != null && !this.profile.isEmpty() ? this.getProfile() : null;
        strategy.appendField(locator, (Object)this, "profile", buffer, theProfile, this.profile != null && !this.profile.isEmpty());
        List<TestScriptVariable> theVariable = this.variable != null && !this.variable.isEmpty() ? this.getVariable() : null;
        strategy.appendField(locator, (Object)this, "variable", buffer, theVariable, this.variable != null && !this.variable.isEmpty());
        List<TestScriptRule> theRule = this.rule != null && !this.rule.isEmpty() ? this.getRule() : null;
        strategy.appendField(locator, (Object)this, "rule", buffer, theRule, this.rule != null && !this.rule.isEmpty());
        List<TestScriptRuleset> theRuleset = this.ruleset != null && !this.ruleset.isEmpty() ? this.getRuleset() : null;
        strategy.appendField(locator, (Object)this, "ruleset", buffer, theRuleset, this.ruleset != null && !this.ruleset.isEmpty());
        TestScriptSetup theSetup = this.getSetup();
        strategy.appendField(locator, (Object)this, "setup", buffer, (Object)theSetup, this.setup != null);
        List<TestScriptTest> theTest = this.test != null && !this.test.isEmpty() ? this.getTest() : null;
        strategy.appendField(locator, (Object)this, "test", buffer, theTest, this.test != null && !this.test.isEmpty());
        TestScriptTeardown theTeardown = this.getTeardown();
        strategy.appendField(locator, (Object)this, "teardown", buffer, (Object)theTeardown, this.teardown != null);
        return buffer;
    }
}

