/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BundleEntry;
import org.hl7.fhir.BundleLink;
import org.hl7.fhir.BundleType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Id;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Resource;
import org.hl7.fhir.Signature;
import org.hl7.fhir.UnsignedInt;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Bundle", propOrder={"type", "total", "link", "entry", "signature"})
public class Bundle
extends Resource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected BundleType type;
    protected UnsignedInt total;
    protected List<BundleLink> link;
    protected List<BundleEntry> entry;
    protected Signature signature;

    public BundleType getType() {
        return this.type;
    }

    public void setType(BundleType value) {
        this.type = value;
    }

    public UnsignedInt getTotal() {
        return this.total;
    }

    public void setTotal(UnsignedInt value) {
        this.total = value;
    }

    public List<BundleLink> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<BundleLink>();
        }
        return this.link;
    }

    public List<BundleEntry> getEntry() {
        if (this.entry == null) {
            this.entry = new ArrayList<BundleEntry>();
        }
        return this.entry;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature value) {
        this.signature = value;
    }

    public Bundle withType(BundleType value) {
        this.setType(value);
        return this;
    }

    public Bundle withTotal(UnsignedInt value) {
        this.setTotal(value);
        return this;
    }

    public Bundle withLink(BundleLink ... values) {
        if (values != null) {
            for (BundleLink value : values) {
                this.getLink().add(value);
            }
        }
        return this;
    }

    public Bundle withLink(Collection<BundleLink> values) {
        if (values != null) {
            this.getLink().addAll(values);
        }
        return this;
    }

    public Bundle withEntry(BundleEntry ... values) {
        if (values != null) {
            for (BundleEntry value : values) {
                this.getEntry().add(value);
            }
        }
        return this;
    }

    public Bundle withEntry(Collection<BundleEntry> values) {
        if (values != null) {
            this.getEntry().addAll(values);
        }
        return this;
    }

    public Bundle withSignature(Signature value) {
        this.setSignature(value);
        return this;
    }

    @Override
    public Bundle withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Bundle withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Bundle withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Bundle withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Bundle that = (Bundle)object;
        BundleType lhsType = this.getType();
        BundleType rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        UnsignedInt lhsTotal = this.getTotal();
        UnsignedInt rhsTotal = that.getTotal();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"total", (Object)lhsTotal), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"total", (Object)rhsTotal), (Object)lhsTotal, (Object)rhsTotal, this.total != null, that.total != null)) {
            return false;
        }
        List<BundleLink> lhsLink = this.link != null && !this.link.isEmpty() ? this.getLink() : null;
        List<BundleLink> rhsLink = that.link != null && !that.link.isEmpty() ? that.getLink() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"link", lhsLink), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"link", rhsLink), lhsLink, rhsLink, this.link != null && !this.link.isEmpty(), that.link != null && !that.link.isEmpty())) {
            return false;
        }
        List<BundleEntry> lhsEntry = this.entry != null && !this.entry.isEmpty() ? this.getEntry() : null;
        List<BundleEntry> rhsEntry = that.entry != null && !that.entry.isEmpty() ? that.getEntry() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"entry", lhsEntry), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"entry", rhsEntry), lhsEntry, rhsEntry, this.entry != null && !this.entry.isEmpty(), that.entry != null && !that.entry.isEmpty())) {
            return false;
        }
        Signature lhsSignature = this.getSignature();
        Signature rhsSignature = that.getSignature();
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"signature", (Object)lhsSignature), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"signature", (Object)rhsSignature), (Object)lhsSignature, (Object)rhsSignature, this.signature != null, that.signature != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        BundleType theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        UnsignedInt theTotal = this.getTotal();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"total", (Object)theTotal), currentHashCode, (Object)theTotal, this.total != null);
        List<BundleLink> theLink = this.link != null && !this.link.isEmpty() ? this.getLink() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"link", theLink), currentHashCode, theLink, this.link != null && !this.link.isEmpty());
        List<BundleEntry> theEntry = this.entry != null && !this.entry.isEmpty() ? this.getEntry() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"entry", theEntry), currentHashCode, theEntry, this.entry != null && !this.entry.isEmpty());
        Signature theSignature = this.getSignature();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"signature", (Object)theSignature), currentHashCode, (Object)theSignature, this.signature != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        BundleType theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        UnsignedInt theTotal = this.getTotal();
        strategy.appendField(locator, (Object)this, "total", buffer, (Object)theTotal, this.total != null);
        List<BundleLink> theLink = this.link != null && !this.link.isEmpty() ? this.getLink() : null;
        strategy.appendField(locator, (Object)this, "link", buffer, theLink, this.link != null && !this.link.isEmpty());
        List<BundleEntry> theEntry = this.entry != null && !this.entry.isEmpty() ? this.getEntry() : null;
        strategy.appendField(locator, (Object)this, "entry", buffer, theEntry, this.entry != null && !this.entry.isEmpty());
        Signature theSignature = this.getSignature();
        strategy.appendField(locator, (Object)this, "signature", buffer, (Object)theSignature, this.signature != null);
        return buffer;
    }
}

