/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm.quick;

import java.io.IOException;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.cql.model.ModelInfoProvider;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.elm_modelinfo.r1.serializing.ModelInfoReaderFactory;

public class QuickModelInfoProvider
implements ModelInfoProvider {
    private NamespaceManager namespaceManager;

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    private boolean isQuickModelIdentifier(ModelIdentifier modelIdentifier) {
        if (this.namespaceManager != null && this.namespaceManager.hasNamespaces()) {
            return modelIdentifier.getId().equals("QUICK") && (modelIdentifier.getSystem() == null || modelIdentifier.getSystem().equals("http://hl7.org/fhir/us/qicore"));
        }
        return modelIdentifier.getId().equals("QUICK");
    }

    public ModelInfo load(ModelIdentifier modelIdentifier) {
        if (this.isQuickModelIdentifier(modelIdentifier)) {
            String localVersion = modelIdentifier.getVersion() == null ? "" : modelIdentifier.getVersion();
            try {
                switch (localVersion) {
                    case "3.3.0": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(QuickModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/quick-modelinfo-3.3.0.xml"));
                    }
                    case "3.0.0": {
                        return ModelInfoReaderFactory.getReader((String)"application/xml").read(QuickModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/quick-modelinfo-3.0.0.xml"));
                    }
                }
                return ModelInfoReaderFactory.getReader((String)"application/xml").read(QuickModelInfoProvider.class.getResourceAsStream("/org/hl7/fhir/quick-modelinfo.xml"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

