/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DocumentManifestContent;
import org.hl7.fhir.DocumentManifestRelated;
import org.hl7.fhir.DocumentReferenceStatus;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DocumentManifest", propOrder={"masterIdentifier", "identifier", "subject", "recipient", "type", "author", "created", "source", "status", "description", "content", "related"})
public class DocumentManifest
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier masterIdentifier;
    protected List<Identifier> identifier;
    protected Reference subject;
    protected List<Reference> recipient;
    protected CodeableConcept type;
    protected List<Reference> author;
    protected DateTime created;
    protected Uri source;
    @XmlElement(required=true)
    protected DocumentReferenceStatus status;
    protected String description;
    @XmlElement(required=true)
    protected List<DocumentManifestContent> content;
    protected List<DocumentManifestRelated> related;

    public Identifier getMasterIdentifier() {
        return this.masterIdentifier;
    }

    public void setMasterIdentifier(Identifier value) {
        this.masterIdentifier = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Uri getSource() {
        return this.source;
    }

    public void setSource(Uri value) {
        this.source = value;
    }

    public DocumentReferenceStatus getStatus() {
        return this.status;
    }

    public void setStatus(DocumentReferenceStatus value) {
        this.status = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<DocumentManifestContent> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<DocumentManifestContent>();
        }
        return this.content;
    }

    public List<DocumentManifestRelated> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<DocumentManifestRelated>();
        }
        return this.related;
    }

    public DocumentManifest withMasterIdentifier(Identifier value) {
        this.setMasterIdentifier(value);
        return this;
    }

    public DocumentManifest withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public DocumentManifest withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public DocumentManifest withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public DocumentManifest withRecipient(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getRecipient().add(value);
            }
        }
        return this;
    }

    public DocumentManifest withRecipient(Collection<Reference> values) {
        if (values != null) {
            this.getRecipient().addAll(values);
        }
        return this;
    }

    public DocumentManifest withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public DocumentManifest withAuthor(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAuthor().add(value);
            }
        }
        return this;
    }

    public DocumentManifest withAuthor(Collection<Reference> values) {
        if (values != null) {
            this.getAuthor().addAll(values);
        }
        return this;
    }

    public DocumentManifest withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public DocumentManifest withSource(Uri value) {
        this.setSource(value);
        return this;
    }

    public DocumentManifest withStatus(DocumentReferenceStatus value) {
        this.setStatus(value);
        return this;
    }

    public DocumentManifest withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public DocumentManifest withContent(DocumentManifestContent ... values) {
        if (values != null) {
            for (DocumentManifestContent value : values) {
                this.getContent().add(value);
            }
        }
        return this;
    }

    public DocumentManifest withContent(Collection<DocumentManifestContent> values) {
        if (values != null) {
            this.getContent().addAll(values);
        }
        return this;
    }

    public DocumentManifest withRelated(DocumentManifestRelated ... values) {
        if (values != null) {
            for (DocumentManifestRelated value : values) {
                this.getRelated().add(value);
            }
        }
        return this;
    }

    public DocumentManifest withRelated(Collection<DocumentManifestRelated> values) {
        if (values != null) {
            this.getRelated().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentManifest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public DocumentManifest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public DocumentManifest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentManifest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DocumentManifest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentManifest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DocumentManifest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DocumentManifest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public DocumentManifest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public DocumentManifest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public DocumentManifest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DocumentManifest that = (DocumentManifest)object;
        Identifier lhsMasterIdentifier = this.getMasterIdentifier();
        Identifier rhsMasterIdentifier = that.getMasterIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"masterIdentifier", (Object)lhsMasterIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"masterIdentifier", (Object)rhsMasterIdentifier), (Object)lhsMasterIdentifier, (Object)rhsMasterIdentifier, this.masterIdentifier != null, that.masterIdentifier != null)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"subject", (Object)lhsSubject), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"subject", (Object)rhsSubject), (Object)lhsSubject, (Object)rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        List<Reference> lhsRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        List<Reference> rhsRecipient = that.recipient != null && !that.recipient.isEmpty() ? that.getRecipient() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"recipient", lhsRecipient), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"recipient", rhsRecipient), lhsRecipient, rhsRecipient, this.recipient != null && !this.recipient.isEmpty(), that.recipient != null && !that.recipient.isEmpty())) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        List<Reference> lhsAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        List<Reference> rhsAuthor = that.author != null && !that.author.isEmpty() ? that.getAuthor() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"author", lhsAuthor), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"author", rhsAuthor), lhsAuthor, rhsAuthor, this.author != null && !this.author.isEmpty(), that.author != null && !that.author.isEmpty())) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"created", (Object)lhsCreated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"created", (Object)rhsCreated), (Object)lhsCreated, (Object)rhsCreated, this.created != null, that.created != null)) {
            return false;
        }
        Uri lhsSource = this.getSource();
        Uri rhsSource = that.getSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"source", (Object)lhsSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"source", (Object)rhsSource), (Object)lhsSource, (Object)rhsSource, this.source != null, that.source != null)) {
            return false;
        }
        DocumentReferenceStatus lhsStatus = this.getStatus();
        DocumentReferenceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<DocumentManifestContent> lhsContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        List<DocumentManifestContent> rhsContent = that.content != null && !that.content.isEmpty() ? that.getContent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"content", lhsContent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"content", rhsContent), lhsContent, rhsContent, this.content != null && !this.content.isEmpty(), that.content != null && !that.content.isEmpty())) {
            return false;
        }
        List<DocumentManifestRelated> lhsRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        List<DocumentManifestRelated> rhsRelated = that.related != null && !that.related.isEmpty() ? that.getRelated() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"related", lhsRelated), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"related", rhsRelated), lhsRelated, rhsRelated, this.related != null && !this.related.isEmpty(), that.related != null && !that.related.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theMasterIdentifier = this.getMasterIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"masterIdentifier", (Object)theMasterIdentifier), currentHashCode, (Object)theMasterIdentifier, this.masterIdentifier != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"subject", (Object)theSubject), currentHashCode, (Object)theSubject, this.subject != null);
        List<Reference> theRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"recipient", theRecipient), currentHashCode, theRecipient, this.recipient != null && !this.recipient.isEmpty());
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"author", theAuthor), currentHashCode, theAuthor, this.author != null && !this.author.isEmpty());
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"created", (Object)theCreated), currentHashCode, (Object)theCreated, this.created != null);
        Uri theSource = this.getSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"source", (Object)theSource), currentHashCode, (Object)theSource, this.source != null);
        DocumentReferenceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription, this.description != null);
        List<DocumentManifestContent> theContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"content", theContent), currentHashCode, theContent, this.content != null && !this.content.isEmpty());
        List<DocumentManifestRelated> theRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"related", theRelated), currentHashCode, theRelated, this.related != null && !this.related.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theMasterIdentifier = this.getMasterIdentifier();
        strategy.appendField(locator, (Object)this, "masterIdentifier", buffer, (Object)theMasterIdentifier, this.masterIdentifier != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, (Object)theSubject, this.subject != null);
        List<Reference> theRecipient = this.recipient != null && !this.recipient.isEmpty() ? this.getRecipient() : null;
        strategy.appendField(locator, (Object)this, "recipient", buffer, theRecipient, this.recipient != null && !this.recipient.isEmpty());
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        strategy.appendField(locator, (Object)this, "author", buffer, theAuthor, this.author != null && !this.author.isEmpty());
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, (Object)theCreated, this.created != null);
        Uri theSource = this.getSource();
        strategy.appendField(locator, (Object)this, "source", buffer, (Object)theSource, this.source != null);
        DocumentReferenceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription, this.description != null);
        List<DocumentManifestContent> theContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        strategy.appendField(locator, (Object)this, "content", buffer, theContent, this.content != null && !this.content.isEmpty());
        List<DocumentManifestRelated> theRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        strategy.appendField(locator, (Object)this, "related", buffer, theRelated, this.related != null && !this.related.isEmpty());
        return buffer;
    }
}

