/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.StructureMapContact;
import org.hl7.fhir.StructureMapGroup;
import org.hl7.fhir.StructureMapStructure;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="StructureMap", propOrder={"url", "identifier", "version", "name", "status", "experimental", "publisher", "contact", "date", "description", "useContext", "requirements", "copyright", "structure", "_import", "group"})
public class StructureMap
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Uri url;
    protected List<Identifier> identifier;
    protected String version;
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected String publisher;
    protected List<StructureMapContact> contact;
    protected DateTime date;
    protected String description;
    protected List<CodeableConcept> useContext;
    protected String requirements;
    protected String copyright;
    protected List<StructureMapStructure> structure;
    @XmlElement(name="import")
    protected List<Uri> _import;
    @XmlElement(required=true)
    protected List<StructureMapGroup> group;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<StructureMapContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<StructureMapContact>();
        }
        return this.contact;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<CodeableConcept> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<CodeableConcept>();
        }
        return this.useContext;
    }

    public String getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String value) {
        this.requirements = value;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String value) {
        this.copyright = value;
    }

    public List<StructureMapStructure> getStructure() {
        if (this.structure == null) {
            this.structure = new ArrayList<StructureMapStructure>();
        }
        return this.structure;
    }

    public List<Uri> getImport() {
        if (this._import == null) {
            this._import = new ArrayList<Uri>();
        }
        return this._import;
    }

    public List<StructureMapGroup> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<StructureMapGroup>();
        }
        return this.group;
    }

    public StructureMap withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public StructureMap withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public StructureMap withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public StructureMap withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public StructureMap withName(String value) {
        this.setName(value);
        return this;
    }

    public StructureMap withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public StructureMap withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public StructureMap withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public StructureMap withContact(StructureMapContact ... values) {
        if (values != null) {
            for (StructureMapContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public StructureMap withContact(Collection<StructureMapContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public StructureMap withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public StructureMap withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public StructureMap withUseContext(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getUseContext().add(value);
            }
        }
        return this;
    }

    public StructureMap withUseContext(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getUseContext().addAll(values);
        }
        return this;
    }

    public StructureMap withRequirements(String value) {
        this.setRequirements(value);
        return this;
    }

    public StructureMap withCopyright(String value) {
        this.setCopyright(value);
        return this;
    }

    public StructureMap withStructure(StructureMapStructure ... values) {
        if (values != null) {
            for (StructureMapStructure value : values) {
                this.getStructure().add(value);
            }
        }
        return this;
    }

    public StructureMap withStructure(Collection<StructureMapStructure> values) {
        if (values != null) {
            this.getStructure().addAll(values);
        }
        return this;
    }

    public StructureMap withImport(Uri ... values) {
        if (values != null) {
            for (Uri value : values) {
                this.getImport().add(value);
            }
        }
        return this;
    }

    public StructureMap withImport(Collection<Uri> values) {
        if (values != null) {
            this.getImport().addAll(values);
        }
        return this;
    }

    public StructureMap withGroup(StructureMapGroup ... values) {
        if (values != null) {
            for (StructureMapGroup value : values) {
                this.getGroup().add(value);
            }
        }
        return this;
    }

    public StructureMap withGroup(Collection<StructureMapGroup> values) {
        if (values != null) {
            this.getGroup().addAll(values);
        }
        return this;
    }

    @Override
    public StructureMap withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public StructureMap withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureMap withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public StructureMap withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureMap withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public StructureMap withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public StructureMap withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public StructureMap withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public StructureMap withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public StructureMap withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public StructureMap withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        StructureMap that = (StructureMap)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"url", (Object)lhsUrl), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"url", (Object)rhsUrl), (Object)lhsUrl, (Object)rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion, this.version != null, that.version != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"name", (Object)lhsName), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"name", (Object)rhsName), (Object)lhsName, (Object)rhsName, this.name != null, that.name != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"status", (Object)lhsStatus), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"status", (Object)rhsStatus), (Object)lhsStatus, (Object)rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"experimental", (Object)lhsExperimental), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"experimental", (Object)rhsExperimental), (Object)lhsExperimental, (Object)rhsExperimental, this.experimental != null, that.experimental != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"publisher", (Object)lhsPublisher), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"publisher", (Object)rhsPublisher), (Object)lhsPublisher, (Object)rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<StructureMapContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<StructureMapContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"contact", lhsContact), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"date", (Object)lhsDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"date", (Object)rhsDate), (Object)lhsDate, (Object)rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<CodeableConcept> lhsUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        List<CodeableConcept> rhsUseContext = that.useContext != null && !that.useContext.isEmpty() ? that.getUseContext() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"useContext", lhsUseContext), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"useContext", rhsUseContext), lhsUseContext, rhsUseContext, this.useContext != null && !this.useContext.isEmpty(), that.useContext != null && !that.useContext.isEmpty())) {
            return false;
        }
        String lhsRequirements = this.getRequirements();
        String rhsRequirements = that.getRequirements();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"requirements", (Object)lhsRequirements), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"requirements", (Object)rhsRequirements), (Object)lhsRequirements, (Object)rhsRequirements, this.requirements != null, that.requirements != null)) {
            return false;
        }
        String lhsCopyright = this.getCopyright();
        String rhsCopyright = that.getCopyright();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"copyright", (Object)lhsCopyright), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"copyright", (Object)rhsCopyright), (Object)lhsCopyright, (Object)rhsCopyright, this.copyright != null, that.copyright != null)) {
            return false;
        }
        List<StructureMapStructure> lhsStructure = this.structure != null && !this.structure.isEmpty() ? this.getStructure() : null;
        List<StructureMapStructure> rhsStructure = that.structure != null && !that.structure.isEmpty() ? that.getStructure() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"structure", lhsStructure), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"structure", rhsStructure), lhsStructure, rhsStructure, this.structure != null && !this.structure.isEmpty(), that.structure != null && !that.structure.isEmpty())) {
            return false;
        }
        List<Uri> lhsImport = this._import != null && !this._import.isEmpty() ? this.getImport() : null;
        List<Uri> rhsImport = that._import != null && !that._import.isEmpty() ? that.getImport() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"_import", lhsImport), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"_import", rhsImport), lhsImport, rhsImport, this._import != null && !this._import.isEmpty(), that._import != null && !that._import.isEmpty())) {
            return false;
        }
        List<StructureMapGroup> lhsGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        List<StructureMapGroup> rhsGroup = that.group != null && !that.group.isEmpty() ? that.getGroup() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"group", lhsGroup), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"group", rhsGroup), lhsGroup, rhsGroup, this.group != null && !this.group.isEmpty(), that.group != null && !that.group.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"url", (Object)theUrl), currentHashCode, (Object)theUrl, this.url != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"version", (Object)theVersion), currentHashCode, (Object)theVersion, this.version != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"name", (Object)theName), currentHashCode, (Object)theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"status", (Object)theStatus), currentHashCode, (Object)theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"experimental", (Object)theExperimental), currentHashCode, (Object)theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"publisher", (Object)thePublisher), currentHashCode, (Object)thePublisher, this.publisher != null);
        List<StructureMapContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"date", (Object)theDate), currentHashCode, (Object)theDate, this.date != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"useContext", theUseContext), currentHashCode, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"requirements", (Object)theRequirements), currentHashCode, (Object)theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"copyright", (Object)theCopyright), currentHashCode, (Object)theCopyright, this.copyright != null);
        List<StructureMapStructure> theStructure = this.structure != null && !this.structure.isEmpty() ? this.getStructure() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"structure", theStructure), currentHashCode, theStructure, this.structure != null && !this.structure.isEmpty());
        List<Uri> theImport = this._import != null && !this._import.isEmpty() ? this.getImport() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"_import", theImport), currentHashCode, theImport, this._import != null && !this._import.isEmpty());
        List<StructureMapGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"group", theGroup), currentHashCode, theGroup, this.group != null && !this.group.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, (Object)theUrl, this.url != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion, this.version != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, (Object)theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, (Object)theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, (Object)theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, (Object)thePublisher, this.publisher != null);
        List<StructureMapContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, (Object)theDate, this.date != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription, this.description != null);
        List<CodeableConcept> theUseContext = this.useContext != null && !this.useContext.isEmpty() ? this.getUseContext() : null;
        strategy.appendField(locator, (Object)this, "useContext", buffer, theUseContext, this.useContext != null && !this.useContext.isEmpty());
        String theRequirements = this.getRequirements();
        strategy.appendField(locator, (Object)this, "requirements", buffer, (Object)theRequirements, this.requirements != null);
        String theCopyright = this.getCopyright();
        strategy.appendField(locator, (Object)this, "copyright", buffer, (Object)theCopyright, this.copyright != null);
        List<StructureMapStructure> theStructure = this.structure != null && !this.structure.isEmpty() ? this.getStructure() : null;
        strategy.appendField(locator, (Object)this, "structure", buffer, theStructure, this.structure != null && !this.structure.isEmpty());
        List<Uri> theImport = this._import != null && !this._import.isEmpty() ? this.getImport() : null;
        strategy.appendField(locator, (Object)this, "_import", buffer, theImport, this._import != null && !this._import.isEmpty());
        List<StructureMapGroup> theGroup = this.group != null && !this.group.isEmpty() ? this.getGroup() : null;
        strategy.appendField(locator, (Object)this, "group", buffer, theGroup, this.group != null && !this.group.isEmpty());
        return buffer;
    }
}

