/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Encounter.Hospitalization", propOrder={"preAdmissionIdentifier", "origin", "admitSource", "admittingDiagnosis", "reAdmission", "dietPreference", "specialCourtesy", "specialArrangement", "destination", "dischargeDisposition", "dischargeDiagnosis"})
public class EncounterHospitalization
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier preAdmissionIdentifier;
    protected Reference origin;
    protected CodeableConcept admitSource;
    protected List<Reference> admittingDiagnosis;
    protected CodeableConcept reAdmission;
    protected List<CodeableConcept> dietPreference;
    protected List<CodeableConcept> specialCourtesy;
    protected List<CodeableConcept> specialArrangement;
    protected Reference destination;
    protected CodeableConcept dischargeDisposition;
    protected List<Reference> dischargeDiagnosis;

    public Identifier getPreAdmissionIdentifier() {
        return this.preAdmissionIdentifier;
    }

    public void setPreAdmissionIdentifier(Identifier value) {
        this.preAdmissionIdentifier = value;
    }

    public Reference getOrigin() {
        return this.origin;
    }

    public void setOrigin(Reference value) {
        this.origin = value;
    }

    public CodeableConcept getAdmitSource() {
        return this.admitSource;
    }

    public void setAdmitSource(CodeableConcept value) {
        this.admitSource = value;
    }

    public List<Reference> getAdmittingDiagnosis() {
        if (this.admittingDiagnosis == null) {
            this.admittingDiagnosis = new ArrayList<Reference>();
        }
        return this.admittingDiagnosis;
    }

    public CodeableConcept getReAdmission() {
        return this.reAdmission;
    }

    public void setReAdmission(CodeableConcept value) {
        this.reAdmission = value;
    }

    public List<CodeableConcept> getDietPreference() {
        if (this.dietPreference == null) {
            this.dietPreference = new ArrayList<CodeableConcept>();
        }
        return this.dietPreference;
    }

    public List<CodeableConcept> getSpecialCourtesy() {
        if (this.specialCourtesy == null) {
            this.specialCourtesy = new ArrayList<CodeableConcept>();
        }
        return this.specialCourtesy;
    }

    public List<CodeableConcept> getSpecialArrangement() {
        if (this.specialArrangement == null) {
            this.specialArrangement = new ArrayList<CodeableConcept>();
        }
        return this.specialArrangement;
    }

    public Reference getDestination() {
        return this.destination;
    }

    public void setDestination(Reference value) {
        this.destination = value;
    }

    public CodeableConcept getDischargeDisposition() {
        return this.dischargeDisposition;
    }

    public void setDischargeDisposition(CodeableConcept value) {
        this.dischargeDisposition = value;
    }

    public List<Reference> getDischargeDiagnosis() {
        if (this.dischargeDiagnosis == null) {
            this.dischargeDiagnosis = new ArrayList<Reference>();
        }
        return this.dischargeDiagnosis;
    }

    public EncounterHospitalization withPreAdmissionIdentifier(Identifier value) {
        this.setPreAdmissionIdentifier(value);
        return this;
    }

    public EncounterHospitalization withOrigin(Reference value) {
        this.setOrigin(value);
        return this;
    }

    public EncounterHospitalization withAdmitSource(CodeableConcept value) {
        this.setAdmitSource(value);
        return this;
    }

    public EncounterHospitalization withAdmittingDiagnosis(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAdmittingDiagnosis().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withAdmittingDiagnosis(Collection<Reference> values) {
        if (values != null) {
            this.getAdmittingDiagnosis().addAll(values);
        }
        return this;
    }

    public EncounterHospitalization withReAdmission(CodeableConcept value) {
        this.setReAdmission(value);
        return this;
    }

    public EncounterHospitalization withDietPreference(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getDietPreference().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withDietPreference(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getDietPreference().addAll(values);
        }
        return this;
    }

    public EncounterHospitalization withSpecialCourtesy(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSpecialCourtesy().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withSpecialCourtesy(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSpecialCourtesy().addAll(values);
        }
        return this;
    }

    public EncounterHospitalization withSpecialArrangement(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSpecialArrangement().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withSpecialArrangement(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSpecialArrangement().addAll(values);
        }
        return this;
    }

    public EncounterHospitalization withDestination(Reference value) {
        this.setDestination(value);
        return this;
    }

    public EncounterHospitalization withDischargeDisposition(CodeableConcept value) {
        this.setDischargeDisposition(value);
        return this;
    }

    public EncounterHospitalization withDischargeDiagnosis(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getDischargeDiagnosis().add(value);
            }
        }
        return this;
    }

    public EncounterHospitalization withDischargeDiagnosis(Collection<Reference> values) {
        if (values != null) {
            this.getDischargeDiagnosis().addAll(values);
        }
        return this;
    }

    @Override
    public EncounterHospitalization withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EncounterHospitalization withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EncounterHospitalization withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EncounterHospitalization withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EncounterHospitalization withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        EncounterHospitalization that = (EncounterHospitalization)object;
        Identifier lhsPreAdmissionIdentifier = this.getPreAdmissionIdentifier();
        Identifier rhsPreAdmissionIdentifier = that.getPreAdmissionIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"preAdmissionIdentifier", (Object)lhsPreAdmissionIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"preAdmissionIdentifier", (Object)rhsPreAdmissionIdentifier), (Object)lhsPreAdmissionIdentifier, (Object)rhsPreAdmissionIdentifier, this.preAdmissionIdentifier != null, that.preAdmissionIdentifier != null)) {
            return false;
        }
        Reference lhsOrigin = this.getOrigin();
        Reference rhsOrigin = that.getOrigin();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"origin", (Object)lhsOrigin), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"origin", (Object)rhsOrigin), (Object)lhsOrigin, (Object)rhsOrigin, this.origin != null, that.origin != null)) {
            return false;
        }
        CodeableConcept lhsAdmitSource = this.getAdmitSource();
        CodeableConcept rhsAdmitSource = that.getAdmitSource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"admitSource", (Object)lhsAdmitSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"admitSource", (Object)rhsAdmitSource), (Object)lhsAdmitSource, (Object)rhsAdmitSource, this.admitSource != null, that.admitSource != null)) {
            return false;
        }
        List<Reference> lhsAdmittingDiagnosis = this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty() ? this.getAdmittingDiagnosis() : null;
        List<Reference> rhsAdmittingDiagnosis = that.admittingDiagnosis != null && !that.admittingDiagnosis.isEmpty() ? that.getAdmittingDiagnosis() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"admittingDiagnosis", lhsAdmittingDiagnosis), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"admittingDiagnosis", rhsAdmittingDiagnosis), lhsAdmittingDiagnosis, rhsAdmittingDiagnosis, this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty(), that.admittingDiagnosis != null && !that.admittingDiagnosis.isEmpty())) {
            return false;
        }
        CodeableConcept lhsReAdmission = this.getReAdmission();
        CodeableConcept rhsReAdmission = that.getReAdmission();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"reAdmission", (Object)lhsReAdmission), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"reAdmission", (Object)rhsReAdmission), (Object)lhsReAdmission, (Object)rhsReAdmission, this.reAdmission != null, that.reAdmission != null)) {
            return false;
        }
        List<CodeableConcept> lhsDietPreference = this.dietPreference != null && !this.dietPreference.isEmpty() ? this.getDietPreference() : null;
        List<CodeableConcept> rhsDietPreference = that.dietPreference != null && !that.dietPreference.isEmpty() ? that.getDietPreference() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dietPreference", lhsDietPreference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dietPreference", rhsDietPreference), lhsDietPreference, rhsDietPreference, this.dietPreference != null && !this.dietPreference.isEmpty(), that.dietPreference != null && !that.dietPreference.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsSpecialCourtesy = this.specialCourtesy != null && !this.specialCourtesy.isEmpty() ? this.getSpecialCourtesy() : null;
        List<CodeableConcept> rhsSpecialCourtesy = that.specialCourtesy != null && !that.specialCourtesy.isEmpty() ? that.getSpecialCourtesy() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"specialCourtesy", lhsSpecialCourtesy), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"specialCourtesy", rhsSpecialCourtesy), lhsSpecialCourtesy, rhsSpecialCourtesy, this.specialCourtesy != null && !this.specialCourtesy.isEmpty(), that.specialCourtesy != null && !that.specialCourtesy.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsSpecialArrangement = this.specialArrangement != null && !this.specialArrangement.isEmpty() ? this.getSpecialArrangement() : null;
        List<CodeableConcept> rhsSpecialArrangement = that.specialArrangement != null && !that.specialArrangement.isEmpty() ? that.getSpecialArrangement() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"specialArrangement", lhsSpecialArrangement), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"specialArrangement", rhsSpecialArrangement), lhsSpecialArrangement, rhsSpecialArrangement, this.specialArrangement != null && !this.specialArrangement.isEmpty(), that.specialArrangement != null && !that.specialArrangement.isEmpty())) {
            return false;
        }
        Reference lhsDestination = this.getDestination();
        Reference rhsDestination = that.getDestination();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"destination", (Object)lhsDestination), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"destination", (Object)rhsDestination), (Object)lhsDestination, (Object)rhsDestination, this.destination != null, that.destination != null)) {
            return false;
        }
        CodeableConcept lhsDischargeDisposition = this.getDischargeDisposition();
        CodeableConcept rhsDischargeDisposition = that.getDischargeDisposition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dischargeDisposition", (Object)lhsDischargeDisposition), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dischargeDisposition", (Object)rhsDischargeDisposition), (Object)lhsDischargeDisposition, (Object)rhsDischargeDisposition, this.dischargeDisposition != null, that.dischargeDisposition != null)) {
            return false;
        }
        List<Reference> lhsDischargeDiagnosis = this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty() ? this.getDischargeDiagnosis() : null;
        List<Reference> rhsDischargeDiagnosis = that.dischargeDiagnosis != null && !that.dischargeDiagnosis.isEmpty() ? that.getDischargeDiagnosis() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"dischargeDiagnosis", lhsDischargeDiagnosis), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"dischargeDiagnosis", rhsDischargeDiagnosis), lhsDischargeDiagnosis, rhsDischargeDiagnosis, this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty(), that.dischargeDiagnosis != null && !that.dischargeDiagnosis.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier thePreAdmissionIdentifier = this.getPreAdmissionIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"preAdmissionIdentifier", (Object)thePreAdmissionIdentifier), currentHashCode, (Object)thePreAdmissionIdentifier, this.preAdmissionIdentifier != null);
        Reference theOrigin = this.getOrigin();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"origin", (Object)theOrigin), currentHashCode, (Object)theOrigin, this.origin != null);
        CodeableConcept theAdmitSource = this.getAdmitSource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"admitSource", (Object)theAdmitSource), currentHashCode, (Object)theAdmitSource, this.admitSource != null);
        List<Reference> theAdmittingDiagnosis = this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty() ? this.getAdmittingDiagnosis() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"admittingDiagnosis", theAdmittingDiagnosis), currentHashCode, theAdmittingDiagnosis, this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty());
        CodeableConcept theReAdmission = this.getReAdmission();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"reAdmission", (Object)theReAdmission), currentHashCode, (Object)theReAdmission, this.reAdmission != null);
        List<CodeableConcept> theDietPreference = this.dietPreference != null && !this.dietPreference.isEmpty() ? this.getDietPreference() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dietPreference", theDietPreference), currentHashCode, theDietPreference, this.dietPreference != null && !this.dietPreference.isEmpty());
        List<CodeableConcept> theSpecialCourtesy = this.specialCourtesy != null && !this.specialCourtesy.isEmpty() ? this.getSpecialCourtesy() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"specialCourtesy", theSpecialCourtesy), currentHashCode, theSpecialCourtesy, this.specialCourtesy != null && !this.specialCourtesy.isEmpty());
        List<CodeableConcept> theSpecialArrangement = this.specialArrangement != null && !this.specialArrangement.isEmpty() ? this.getSpecialArrangement() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"specialArrangement", theSpecialArrangement), currentHashCode, theSpecialArrangement, this.specialArrangement != null && !this.specialArrangement.isEmpty());
        Reference theDestination = this.getDestination();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"destination", (Object)theDestination), currentHashCode, (Object)theDestination, this.destination != null);
        CodeableConcept theDischargeDisposition = this.getDischargeDisposition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dischargeDisposition", (Object)theDischargeDisposition), currentHashCode, (Object)theDischargeDisposition, this.dischargeDisposition != null);
        List<Reference> theDischargeDiagnosis = this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty() ? this.getDischargeDiagnosis() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"dischargeDiagnosis", theDischargeDiagnosis), currentHashCode, theDischargeDiagnosis, this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier thePreAdmissionIdentifier = this.getPreAdmissionIdentifier();
        strategy.appendField(locator, (Object)this, "preAdmissionIdentifier", buffer, (Object)thePreAdmissionIdentifier, this.preAdmissionIdentifier != null);
        Reference theOrigin = this.getOrigin();
        strategy.appendField(locator, (Object)this, "origin", buffer, (Object)theOrigin, this.origin != null);
        CodeableConcept theAdmitSource = this.getAdmitSource();
        strategy.appendField(locator, (Object)this, "admitSource", buffer, (Object)theAdmitSource, this.admitSource != null);
        List<Reference> theAdmittingDiagnosis = this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty() ? this.getAdmittingDiagnosis() : null;
        strategy.appendField(locator, (Object)this, "admittingDiagnosis", buffer, theAdmittingDiagnosis, this.admittingDiagnosis != null && !this.admittingDiagnosis.isEmpty());
        CodeableConcept theReAdmission = this.getReAdmission();
        strategy.appendField(locator, (Object)this, "reAdmission", buffer, (Object)theReAdmission, this.reAdmission != null);
        List<CodeableConcept> theDietPreference = this.dietPreference != null && !this.dietPreference.isEmpty() ? this.getDietPreference() : null;
        strategy.appendField(locator, (Object)this, "dietPreference", buffer, theDietPreference, this.dietPreference != null && !this.dietPreference.isEmpty());
        List<CodeableConcept> theSpecialCourtesy = this.specialCourtesy != null && !this.specialCourtesy.isEmpty() ? this.getSpecialCourtesy() : null;
        strategy.appendField(locator, (Object)this, "specialCourtesy", buffer, theSpecialCourtesy, this.specialCourtesy != null && !this.specialCourtesy.isEmpty());
        List<CodeableConcept> theSpecialArrangement = this.specialArrangement != null && !this.specialArrangement.isEmpty() ? this.getSpecialArrangement() : null;
        strategy.appendField(locator, (Object)this, "specialArrangement", buffer, theSpecialArrangement, this.specialArrangement != null && !this.specialArrangement.isEmpty());
        Reference theDestination = this.getDestination();
        strategy.appendField(locator, (Object)this, "destination", buffer, (Object)theDestination, this.destination != null);
        CodeableConcept theDischargeDisposition = this.getDischargeDisposition();
        strategy.appendField(locator, (Object)this, "dischargeDisposition", buffer, (Object)theDischargeDisposition, this.dischargeDisposition != null);
        List<Reference> theDischargeDiagnosis = this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty() ? this.getDischargeDiagnosis() : null;
        strategy.appendField(locator, (Object)this, "dischargeDiagnosis", buffer, theDischargeDiagnosis, this.dischargeDiagnosis != null && !this.dischargeDiagnosis.isEmpty());
        return buffer;
    }

    public void setAdmittingDiagnosis(List<Reference> value) {
        this.admittingDiagnosis = value;
    }

    public void setDietPreference(List<CodeableConcept> value) {
        this.dietPreference = value;
    }

    public void setSpecialCourtesy(List<CodeableConcept> value) {
        this.specialCourtesy = value;
    }

    public void setSpecialArrangement(List<CodeableConcept> value) {
        this.specialArrangement = value;
    }

    public void setDischargeDiagnosis(List<Reference> value) {
        this.dischargeDiagnosis = value;
    }
}

