/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.Attachment;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Coding;
import org.hl7.fhir.Date;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.Decimal;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Integer;
import org.hl7.fhir.Quantity;
import org.hl7.fhir.QuestionnaireEnableWhen;
import org.hl7.fhir.QuestionnaireItemType;
import org.hl7.fhir.QuestionnaireOption;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.hl7.fhir.Time;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Questionnaire.Item", propOrder={"linkId", "concept", "prefix", "text", "type", "enableWhen", "required", "repeats", "readOnly", "maxLength", "options", "option", "initialBoolean", "initialDecimal", "initialInteger", "initialDate", "initialDateTime", "initialInstant", "initialTime", "initialString", "initialUri", "initialAttachment", "initialCoding", "initialQuantity", "initialReference", "item"})
public class QuestionnaireItem
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected String linkId;
    protected List<Coding> concept;
    protected String prefix;
    protected String text;
    @XmlElement(required=true)
    protected QuestionnaireItemType type;
    protected List<QuestionnaireEnableWhen> enableWhen;
    protected Boolean required;
    protected Boolean repeats;
    protected Boolean readOnly;
    protected Integer maxLength;
    protected Reference options;
    protected List<QuestionnaireOption> option;
    protected Boolean initialBoolean;
    protected Decimal initialDecimal;
    protected Integer initialInteger;
    protected Date initialDate;
    protected DateTime initialDateTime;
    protected Instant initialInstant;
    protected Time initialTime;
    protected String initialString;
    protected Uri initialUri;
    protected Attachment initialAttachment;
    protected Coding initialCoding;
    protected Quantity initialQuantity;
    protected Reference initialReference;
    protected List<QuestionnaireItem> item;

    public String getLinkId() {
        return this.linkId;
    }

    public void setLinkId(String value) {
        this.linkId = value;
    }

    public List<Coding> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<Coding>();
        }
        return this.concept;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String value) {
        this.prefix = value;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
    }

    public QuestionnaireItemType getType() {
        return this.type;
    }

    public void setType(QuestionnaireItemType value) {
        this.type = value;
    }

    public List<QuestionnaireEnableWhen> getEnableWhen() {
        if (this.enableWhen == null) {
            this.enableWhen = new ArrayList<QuestionnaireEnableWhen>();
        }
        return this.enableWhen;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean value) {
        this.required = value;
    }

    public Boolean getRepeats() {
        return this.repeats;
    }

    public void setRepeats(Boolean value) {
        this.repeats = value;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean value) {
        this.readOnly = value;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer value) {
        this.maxLength = value;
    }

    public Reference getOptions() {
        return this.options;
    }

    public void setOptions(Reference value) {
        this.options = value;
    }

    public List<QuestionnaireOption> getOption() {
        if (this.option == null) {
            this.option = new ArrayList<QuestionnaireOption>();
        }
        return this.option;
    }

    public Boolean getInitialBoolean() {
        return this.initialBoolean;
    }

    public void setInitialBoolean(Boolean value) {
        this.initialBoolean = value;
    }

    public Decimal getInitialDecimal() {
        return this.initialDecimal;
    }

    public void setInitialDecimal(Decimal value) {
        this.initialDecimal = value;
    }

    public Integer getInitialInteger() {
        return this.initialInteger;
    }

    public void setInitialInteger(Integer value) {
        this.initialInteger = value;
    }

    public Date getInitialDate() {
        return this.initialDate;
    }

    public void setInitialDate(Date value) {
        this.initialDate = value;
    }

    public DateTime getInitialDateTime() {
        return this.initialDateTime;
    }

    public void setInitialDateTime(DateTime value) {
        this.initialDateTime = value;
    }

    public Instant getInitialInstant() {
        return this.initialInstant;
    }

    public void setInitialInstant(Instant value) {
        this.initialInstant = value;
    }

    public Time getInitialTime() {
        return this.initialTime;
    }

    public void setInitialTime(Time value) {
        this.initialTime = value;
    }

    public String getInitialString() {
        return this.initialString;
    }

    public void setInitialString(String value) {
        this.initialString = value;
    }

    public Uri getInitialUri() {
        return this.initialUri;
    }

    public void setInitialUri(Uri value) {
        this.initialUri = value;
    }

    public Attachment getInitialAttachment() {
        return this.initialAttachment;
    }

    public void setInitialAttachment(Attachment value) {
        this.initialAttachment = value;
    }

    public Coding getInitialCoding() {
        return this.initialCoding;
    }

    public void setInitialCoding(Coding value) {
        this.initialCoding = value;
    }

    public Quantity getInitialQuantity() {
        return this.initialQuantity;
    }

    public void setInitialQuantity(Quantity value) {
        this.initialQuantity = value;
    }

    public Reference getInitialReference() {
        return this.initialReference;
    }

    public void setInitialReference(Reference value) {
        this.initialReference = value;
    }

    public List<QuestionnaireItem> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireItem>();
        }
        return this.item;
    }

    public QuestionnaireItem withLinkId(String value) {
        this.setLinkId(value);
        return this;
    }

    public QuestionnaireItem withConcept(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getConcept().add(value);
            }
        }
        return this;
    }

    public QuestionnaireItem withConcept(Collection<Coding> values) {
        if (values != null) {
            this.getConcept().addAll(values);
        }
        return this;
    }

    public QuestionnaireItem withPrefix(String value) {
        this.setPrefix(value);
        return this;
    }

    public QuestionnaireItem withText(String value) {
        this.setText(value);
        return this;
    }

    public QuestionnaireItem withType(QuestionnaireItemType value) {
        this.setType(value);
        return this;
    }

    public QuestionnaireItem withEnableWhen(QuestionnaireEnableWhen ... values) {
        if (values != null) {
            for (QuestionnaireEnableWhen value : values) {
                this.getEnableWhen().add(value);
            }
        }
        return this;
    }

    public QuestionnaireItem withEnableWhen(Collection<QuestionnaireEnableWhen> values) {
        if (values != null) {
            this.getEnableWhen().addAll(values);
        }
        return this;
    }

    public QuestionnaireItem withRequired(Boolean value) {
        this.setRequired(value);
        return this;
    }

    public QuestionnaireItem withRepeats(Boolean value) {
        this.setRepeats(value);
        return this;
    }

    public QuestionnaireItem withReadOnly(Boolean value) {
        this.setReadOnly(value);
        return this;
    }

    public QuestionnaireItem withMaxLength(Integer value) {
        this.setMaxLength(value);
        return this;
    }

    public QuestionnaireItem withOptions(Reference value) {
        this.setOptions(value);
        return this;
    }

    public QuestionnaireItem withOption(QuestionnaireOption ... values) {
        if (values != null) {
            for (QuestionnaireOption value : values) {
                this.getOption().add(value);
            }
        }
        return this;
    }

    public QuestionnaireItem withOption(Collection<QuestionnaireOption> values) {
        if (values != null) {
            this.getOption().addAll(values);
        }
        return this;
    }

    public QuestionnaireItem withInitialBoolean(Boolean value) {
        this.setInitialBoolean(value);
        return this;
    }

    public QuestionnaireItem withInitialDecimal(Decimal value) {
        this.setInitialDecimal(value);
        return this;
    }

    public QuestionnaireItem withInitialInteger(Integer value) {
        this.setInitialInteger(value);
        return this;
    }

    public QuestionnaireItem withInitialDate(Date value) {
        this.setInitialDate(value);
        return this;
    }

    public QuestionnaireItem withInitialDateTime(DateTime value) {
        this.setInitialDateTime(value);
        return this;
    }

    public QuestionnaireItem withInitialInstant(Instant value) {
        this.setInitialInstant(value);
        return this;
    }

    public QuestionnaireItem withInitialTime(Time value) {
        this.setInitialTime(value);
        return this;
    }

    public QuestionnaireItem withInitialString(String value) {
        this.setInitialString(value);
        return this;
    }

    public QuestionnaireItem withInitialUri(Uri value) {
        this.setInitialUri(value);
        return this;
    }

    public QuestionnaireItem withInitialAttachment(Attachment value) {
        this.setInitialAttachment(value);
        return this;
    }

    public QuestionnaireItem withInitialCoding(Coding value) {
        this.setInitialCoding(value);
        return this;
    }

    public QuestionnaireItem withInitialQuantity(Quantity value) {
        this.setInitialQuantity(value);
        return this;
    }

    public QuestionnaireItem withInitialReference(Reference value) {
        this.setInitialReference(value);
        return this;
    }

    public QuestionnaireItem withItem(QuestionnaireItem ... values) {
        if (values != null) {
            for (QuestionnaireItem value : values) {
                this.getItem().add(value);
            }
        }
        return this;
    }

    public QuestionnaireItem withItem(Collection<QuestionnaireItem> values) {
        if (values != null) {
            this.getItem().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireItem withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public QuestionnaireItem withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireItem withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public QuestionnaireItem withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireItem withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        QuestionnaireItem that = (QuestionnaireItem)object;
        String lhsLinkId = this.getLinkId();
        String rhsLinkId = that.getLinkId();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"linkId", (Object)lhsLinkId), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"linkId", (Object)rhsLinkId), (Object)lhsLinkId, (Object)rhsLinkId, this.linkId != null, that.linkId != null)) {
            return false;
        }
        List<Coding> lhsConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        List<Coding> rhsConcept = that.concept != null && !that.concept.isEmpty() ? that.getConcept() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"concept", lhsConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"concept", rhsConcept), lhsConcept, rhsConcept, this.concept != null && !this.concept.isEmpty(), that.concept != null && !that.concept.isEmpty())) {
            return false;
        }
        String lhsPrefix = this.getPrefix();
        String rhsPrefix = that.getPrefix();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"prefix", (Object)lhsPrefix), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"prefix", (Object)rhsPrefix), (Object)lhsPrefix, (Object)rhsPrefix, this.prefix != null, that.prefix != null)) {
            return false;
        }
        String lhsText = this.getText();
        String rhsText = that.getText();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"text", (Object)lhsText), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"text", (Object)rhsText), (Object)lhsText, (Object)rhsText, this.text != null, that.text != null)) {
            return false;
        }
        QuestionnaireItemType lhsType = this.getType();
        QuestionnaireItemType rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        List<QuestionnaireEnableWhen> lhsEnableWhen = this.enableWhen != null && !this.enableWhen.isEmpty() ? this.getEnableWhen() : null;
        List<QuestionnaireEnableWhen> rhsEnableWhen = that.enableWhen != null && !that.enableWhen.isEmpty() ? that.getEnableWhen() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"enableWhen", lhsEnableWhen), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"enableWhen", rhsEnableWhen), lhsEnableWhen, rhsEnableWhen, this.enableWhen != null && !this.enableWhen.isEmpty(), that.enableWhen != null && !that.enableWhen.isEmpty())) {
            return false;
        }
        Boolean lhsRequired = this.getRequired();
        Boolean rhsRequired = that.getRequired();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"required", (Object)lhsRequired), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"required", (Object)rhsRequired), (Object)lhsRequired, (Object)rhsRequired, this.required != null, that.required != null)) {
            return false;
        }
        Boolean lhsRepeats = this.getRepeats();
        Boolean rhsRepeats = that.getRepeats();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"repeats", (Object)lhsRepeats), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"repeats", (Object)rhsRepeats), (Object)lhsRepeats, (Object)rhsRepeats, this.repeats != null, that.repeats != null)) {
            return false;
        }
        Boolean lhsReadOnly = this.getReadOnly();
        Boolean rhsReadOnly = that.getReadOnly();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"readOnly", (Object)lhsReadOnly), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"readOnly", (Object)rhsReadOnly), (Object)lhsReadOnly, (Object)rhsReadOnly, this.readOnly != null, that.readOnly != null)) {
            return false;
        }
        Integer lhsMaxLength = this.getMaxLength();
        Integer rhsMaxLength = that.getMaxLength();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"maxLength", (Object)lhsMaxLength), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"maxLength", (Object)rhsMaxLength), (Object)lhsMaxLength, (Object)rhsMaxLength, this.maxLength != null, that.maxLength != null)) {
            return false;
        }
        Reference lhsOptions = this.getOptions();
        Reference rhsOptions = that.getOptions();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"options", (Object)lhsOptions), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"options", (Object)rhsOptions), (Object)lhsOptions, (Object)rhsOptions, this.options != null, that.options != null)) {
            return false;
        }
        List<QuestionnaireOption> lhsOption = this.option != null && !this.option.isEmpty() ? this.getOption() : null;
        List<QuestionnaireOption> rhsOption = that.option != null && !that.option.isEmpty() ? that.getOption() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"option", lhsOption), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"option", rhsOption), lhsOption, rhsOption, this.option != null && !this.option.isEmpty(), that.option != null && !that.option.isEmpty())) {
            return false;
        }
        Boolean lhsInitialBoolean = this.getInitialBoolean();
        Boolean rhsInitialBoolean = that.getInitialBoolean();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialBoolean", (Object)lhsInitialBoolean), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialBoolean", (Object)rhsInitialBoolean), (Object)lhsInitialBoolean, (Object)rhsInitialBoolean, this.initialBoolean != null, that.initialBoolean != null)) {
            return false;
        }
        Decimal lhsInitialDecimal = this.getInitialDecimal();
        Decimal rhsInitialDecimal = that.getInitialDecimal();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialDecimal", (Object)lhsInitialDecimal), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialDecimal", (Object)rhsInitialDecimal), (Object)lhsInitialDecimal, (Object)rhsInitialDecimal, this.initialDecimal != null, that.initialDecimal != null)) {
            return false;
        }
        Integer lhsInitialInteger = this.getInitialInteger();
        Integer rhsInitialInteger = that.getInitialInteger();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialInteger", (Object)lhsInitialInteger), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialInteger", (Object)rhsInitialInteger), (Object)lhsInitialInteger, (Object)rhsInitialInteger, this.initialInteger != null, that.initialInteger != null)) {
            return false;
        }
        Date lhsInitialDate = this.getInitialDate();
        Date rhsInitialDate = that.getInitialDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialDate", (Object)lhsInitialDate), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialDate", (Object)rhsInitialDate), (Object)lhsInitialDate, (Object)rhsInitialDate, this.initialDate != null, that.initialDate != null)) {
            return false;
        }
        DateTime lhsInitialDateTime = this.getInitialDateTime();
        DateTime rhsInitialDateTime = that.getInitialDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialDateTime", (Object)lhsInitialDateTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialDateTime", (Object)rhsInitialDateTime), (Object)lhsInitialDateTime, (Object)rhsInitialDateTime, this.initialDateTime != null, that.initialDateTime != null)) {
            return false;
        }
        Instant lhsInitialInstant = this.getInitialInstant();
        Instant rhsInitialInstant = that.getInitialInstant();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialInstant", (Object)lhsInitialInstant), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialInstant", (Object)rhsInitialInstant), (Object)lhsInitialInstant, (Object)rhsInitialInstant, this.initialInstant != null, that.initialInstant != null)) {
            return false;
        }
        Time lhsInitialTime = this.getInitialTime();
        Time rhsInitialTime = that.getInitialTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialTime", (Object)lhsInitialTime), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialTime", (Object)rhsInitialTime), (Object)lhsInitialTime, (Object)rhsInitialTime, this.initialTime != null, that.initialTime != null)) {
            return false;
        }
        String lhsInitialString = this.getInitialString();
        String rhsInitialString = that.getInitialString();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialString", (Object)lhsInitialString), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialString", (Object)rhsInitialString), (Object)lhsInitialString, (Object)rhsInitialString, this.initialString != null, that.initialString != null)) {
            return false;
        }
        Uri lhsInitialUri = this.getInitialUri();
        Uri rhsInitialUri = that.getInitialUri();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialUri", (Object)lhsInitialUri), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialUri", (Object)rhsInitialUri), (Object)lhsInitialUri, (Object)rhsInitialUri, this.initialUri != null, that.initialUri != null)) {
            return false;
        }
        Attachment lhsInitialAttachment = this.getInitialAttachment();
        Attachment rhsInitialAttachment = that.getInitialAttachment();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialAttachment", (Object)lhsInitialAttachment), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialAttachment", (Object)rhsInitialAttachment), (Object)lhsInitialAttachment, (Object)rhsInitialAttachment, this.initialAttachment != null, that.initialAttachment != null)) {
            return false;
        }
        Coding lhsInitialCoding = this.getInitialCoding();
        Coding rhsInitialCoding = that.getInitialCoding();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialCoding", (Object)lhsInitialCoding), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialCoding", (Object)rhsInitialCoding), (Object)lhsInitialCoding, (Object)rhsInitialCoding, this.initialCoding != null, that.initialCoding != null)) {
            return false;
        }
        Quantity lhsInitialQuantity = this.getInitialQuantity();
        Quantity rhsInitialQuantity = that.getInitialQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialQuantity", (Object)lhsInitialQuantity), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialQuantity", (Object)rhsInitialQuantity), (Object)lhsInitialQuantity, (Object)rhsInitialQuantity, this.initialQuantity != null, that.initialQuantity != null)) {
            return false;
        }
        Reference lhsInitialReference = this.getInitialReference();
        Reference rhsInitialReference = that.getInitialReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"initialReference", (Object)lhsInitialReference), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"initialReference", (Object)rhsInitialReference), (Object)lhsInitialReference, (Object)rhsInitialReference, this.initialReference != null, that.initialReference != null)) {
            return false;
        }
        List<QuestionnaireItem> lhsItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        List<QuestionnaireItem> rhsItem = that.item != null && !that.item.isEmpty() ? that.getItem() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"item", lhsItem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"item", rhsItem), lhsItem, rhsItem, this.item != null && !this.item.isEmpty(), that.item != null && !that.item.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        String theLinkId = this.getLinkId();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"linkId", (Object)theLinkId), currentHashCode, (Object)theLinkId, this.linkId != null);
        List<Coding> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"concept", theConcept), currentHashCode, theConcept, this.concept != null && !this.concept.isEmpty());
        String thePrefix = this.getPrefix();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"prefix", (Object)thePrefix), currentHashCode, (Object)thePrefix, this.prefix != null);
        String theText = this.getText();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"text", (Object)theText), currentHashCode, (Object)theText, this.text != null);
        QuestionnaireItemType theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        List<QuestionnaireEnableWhen> theEnableWhen = this.enableWhen != null && !this.enableWhen.isEmpty() ? this.getEnableWhen() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"enableWhen", theEnableWhen), currentHashCode, theEnableWhen, this.enableWhen != null && !this.enableWhen.isEmpty());
        Boolean theRequired = this.getRequired();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"required", (Object)theRequired), currentHashCode, (Object)theRequired, this.required != null);
        Boolean theRepeats = this.getRepeats();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"repeats", (Object)theRepeats), currentHashCode, (Object)theRepeats, this.repeats != null);
        Boolean theReadOnly = this.getReadOnly();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"readOnly", (Object)theReadOnly), currentHashCode, (Object)theReadOnly, this.readOnly != null);
        Integer theMaxLength = this.getMaxLength();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"maxLength", (Object)theMaxLength), currentHashCode, (Object)theMaxLength, this.maxLength != null);
        Reference theOptions = this.getOptions();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"options", (Object)theOptions), currentHashCode, (Object)theOptions, this.options != null);
        List<QuestionnaireOption> theOption = this.option != null && !this.option.isEmpty() ? this.getOption() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"option", theOption), currentHashCode, theOption, this.option != null && !this.option.isEmpty());
        Boolean theInitialBoolean = this.getInitialBoolean();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialBoolean", (Object)theInitialBoolean), currentHashCode, (Object)theInitialBoolean, this.initialBoolean != null);
        Decimal theInitialDecimal = this.getInitialDecimal();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialDecimal", (Object)theInitialDecimal), currentHashCode, (Object)theInitialDecimal, this.initialDecimal != null);
        Integer theInitialInteger = this.getInitialInteger();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialInteger", (Object)theInitialInteger), currentHashCode, (Object)theInitialInteger, this.initialInteger != null);
        Date theInitialDate = this.getInitialDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialDate", (Object)theInitialDate), currentHashCode, (Object)theInitialDate, this.initialDate != null);
        DateTime theInitialDateTime = this.getInitialDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialDateTime", (Object)theInitialDateTime), currentHashCode, (Object)theInitialDateTime, this.initialDateTime != null);
        Instant theInitialInstant = this.getInitialInstant();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialInstant", (Object)theInitialInstant), currentHashCode, (Object)theInitialInstant, this.initialInstant != null);
        Time theInitialTime = this.getInitialTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialTime", (Object)theInitialTime), currentHashCode, (Object)theInitialTime, this.initialTime != null);
        String theInitialString = this.getInitialString();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialString", (Object)theInitialString), currentHashCode, (Object)theInitialString, this.initialString != null);
        Uri theInitialUri = this.getInitialUri();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialUri", (Object)theInitialUri), currentHashCode, (Object)theInitialUri, this.initialUri != null);
        Attachment theInitialAttachment = this.getInitialAttachment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialAttachment", (Object)theInitialAttachment), currentHashCode, (Object)theInitialAttachment, this.initialAttachment != null);
        Coding theInitialCoding = this.getInitialCoding();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialCoding", (Object)theInitialCoding), currentHashCode, (Object)theInitialCoding, this.initialCoding != null);
        Quantity theInitialQuantity = this.getInitialQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialQuantity", (Object)theInitialQuantity), currentHashCode, (Object)theInitialQuantity, this.initialQuantity != null);
        Reference theInitialReference = this.getInitialReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"initialReference", (Object)theInitialReference), currentHashCode, (Object)theInitialReference, this.initialReference != null);
        List<QuestionnaireItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"item", theItem), currentHashCode, theItem, this.item != null && !this.item.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        String theLinkId = this.getLinkId();
        strategy.appendField(locator, (Object)this, "linkId", buffer, (Object)theLinkId, this.linkId != null);
        List<Coding> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        strategy.appendField(locator, (Object)this, "concept", buffer, theConcept, this.concept != null && !this.concept.isEmpty());
        String thePrefix = this.getPrefix();
        strategy.appendField(locator, (Object)this, "prefix", buffer, (Object)thePrefix, this.prefix != null);
        String theText = this.getText();
        strategy.appendField(locator, (Object)this, "text", buffer, (Object)theText, this.text != null);
        QuestionnaireItemType theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        List<QuestionnaireEnableWhen> theEnableWhen = this.enableWhen != null && !this.enableWhen.isEmpty() ? this.getEnableWhen() : null;
        strategy.appendField(locator, (Object)this, "enableWhen", buffer, theEnableWhen, this.enableWhen != null && !this.enableWhen.isEmpty());
        Boolean theRequired = this.getRequired();
        strategy.appendField(locator, (Object)this, "required", buffer, (Object)theRequired, this.required != null);
        Boolean theRepeats = this.getRepeats();
        strategy.appendField(locator, (Object)this, "repeats", buffer, (Object)theRepeats, this.repeats != null);
        Boolean theReadOnly = this.getReadOnly();
        strategy.appendField(locator, (Object)this, "readOnly", buffer, (Object)theReadOnly, this.readOnly != null);
        Integer theMaxLength = this.getMaxLength();
        strategy.appendField(locator, (Object)this, "maxLength", buffer, (Object)theMaxLength, this.maxLength != null);
        Reference theOptions = this.getOptions();
        strategy.appendField(locator, (Object)this, "options", buffer, (Object)theOptions, this.options != null);
        List<QuestionnaireOption> theOption = this.option != null && !this.option.isEmpty() ? this.getOption() : null;
        strategy.appendField(locator, (Object)this, "option", buffer, theOption, this.option != null && !this.option.isEmpty());
        Boolean theInitialBoolean = this.getInitialBoolean();
        strategy.appendField(locator, (Object)this, "initialBoolean", buffer, (Object)theInitialBoolean, this.initialBoolean != null);
        Decimal theInitialDecimal = this.getInitialDecimal();
        strategy.appendField(locator, (Object)this, "initialDecimal", buffer, (Object)theInitialDecimal, this.initialDecimal != null);
        Integer theInitialInteger = this.getInitialInteger();
        strategy.appendField(locator, (Object)this, "initialInteger", buffer, (Object)theInitialInteger, this.initialInteger != null);
        Date theInitialDate = this.getInitialDate();
        strategy.appendField(locator, (Object)this, "initialDate", buffer, (Object)theInitialDate, this.initialDate != null);
        DateTime theInitialDateTime = this.getInitialDateTime();
        strategy.appendField(locator, (Object)this, "initialDateTime", buffer, (Object)theInitialDateTime, this.initialDateTime != null);
        Instant theInitialInstant = this.getInitialInstant();
        strategy.appendField(locator, (Object)this, "initialInstant", buffer, (Object)theInitialInstant, this.initialInstant != null);
        Time theInitialTime = this.getInitialTime();
        strategy.appendField(locator, (Object)this, "initialTime", buffer, (Object)theInitialTime, this.initialTime != null);
        String theInitialString = this.getInitialString();
        strategy.appendField(locator, (Object)this, "initialString", buffer, (Object)theInitialString, this.initialString != null);
        Uri theInitialUri = this.getInitialUri();
        strategy.appendField(locator, (Object)this, "initialUri", buffer, (Object)theInitialUri, this.initialUri != null);
        Attachment theInitialAttachment = this.getInitialAttachment();
        strategy.appendField(locator, (Object)this, "initialAttachment", buffer, (Object)theInitialAttachment, this.initialAttachment != null);
        Coding theInitialCoding = this.getInitialCoding();
        strategy.appendField(locator, (Object)this, "initialCoding", buffer, (Object)theInitialCoding, this.initialCoding != null);
        Quantity theInitialQuantity = this.getInitialQuantity();
        strategy.appendField(locator, (Object)this, "initialQuantity", buffer, (Object)theInitialQuantity, this.initialQuantity != null);
        Reference theInitialReference = this.getInitialReference();
        strategy.appendField(locator, (Object)this, "initialReference", buffer, (Object)theInitialReference, this.initialReference != null);
        List<QuestionnaireItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        strategy.appendField(locator, (Object)this, "item", buffer, theItem, this.item != null && !this.item.isEmpty());
        return buffer;
    }

    public void setConcept(List<Coding> value) {
        this.concept = value;
    }

    public void setEnableWhen(List<QuestionnaireEnableWhen> value) {
        this.enableWhen = value;
    }

    public void setOption(List<QuestionnaireOption> value) {
        this.option = value;
    }

    public void setItem(List<QuestionnaireItem> value) {
        this.item = value;
    }
}

