/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Extension;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.hl7.fhir.ValueSetConcept;
import org.hl7.fhir.ValueSetFilter;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ValueSet.Include", propOrder={"system", "version", "concept", "filter"})
public class ValueSetInclude
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Uri system;
    protected String version;
    protected List<ValueSetConcept> concept;
    protected List<ValueSetFilter> filter;

    public Uri getSystem() {
        return this.system;
    }

    public void setSystem(Uri value) {
        this.system = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public List<ValueSetConcept> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<ValueSetConcept>();
        }
        return this.concept;
    }

    public List<ValueSetFilter> getFilter() {
        if (this.filter == null) {
            this.filter = new ArrayList<ValueSetFilter>();
        }
        return this.filter;
    }

    public ValueSetInclude withSystem(Uri value) {
        this.setSystem(value);
        return this;
    }

    public ValueSetInclude withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public ValueSetInclude withConcept(ValueSetConcept ... values) {
        if (values != null) {
            for (ValueSetConcept value : values) {
                this.getConcept().add(value);
            }
        }
        return this;
    }

    public ValueSetInclude withConcept(Collection<ValueSetConcept> values) {
        if (values != null) {
            this.getConcept().addAll(values);
        }
        return this;
    }

    public ValueSetInclude withFilter(ValueSetFilter ... values) {
        if (values != null) {
            for (ValueSetFilter value : values) {
                this.getFilter().add(value);
            }
        }
        return this;
    }

    public ValueSetInclude withFilter(Collection<ValueSetFilter> values) {
        if (values != null) {
            this.getFilter().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetInclude withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ValueSetInclude withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetInclude withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ValueSetInclude withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ValueSetInclude withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ValueSetInclude that = (ValueSetInclude)object;
        Uri lhsSystem = this.getSystem();
        Uri rhsSystem = that.getSystem();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"system", (Object)lhsSystem), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"system", (Object)rhsSystem), (Object)lhsSystem, (Object)rhsSystem, this.system != null, that.system != null)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"version", (Object)lhsVersion), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"version", (Object)rhsVersion), (Object)lhsVersion, (Object)rhsVersion, this.version != null, that.version != null)) {
            return false;
        }
        List<ValueSetConcept> lhsConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        List<ValueSetConcept> rhsConcept = that.concept != null && !that.concept.isEmpty() ? that.getConcept() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"concept", lhsConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"concept", rhsConcept), lhsConcept, rhsConcept, this.concept != null && !this.concept.isEmpty(), that.concept != null && !that.concept.isEmpty())) {
            return false;
        }
        List<ValueSetFilter> lhsFilter = this.filter != null && !this.filter.isEmpty() ? this.getFilter() : null;
        List<ValueSetFilter> rhsFilter = that.filter != null && !that.filter.isEmpty() ? that.getFilter() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"filter", lhsFilter), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"filter", rhsFilter), lhsFilter, rhsFilter, this.filter != null && !this.filter.isEmpty(), that.filter != null && !that.filter.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theSystem = this.getSystem();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"system", (Object)theSystem), currentHashCode, (Object)theSystem, this.system != null);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"version", (Object)theVersion), currentHashCode, (Object)theVersion, this.version != null);
        List<ValueSetConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"concept", theConcept), currentHashCode, theConcept, this.concept != null && !this.concept.isEmpty());
        List<ValueSetFilter> theFilter = this.filter != null && !this.filter.isEmpty() ? this.getFilter() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"filter", theFilter), currentHashCode, theFilter, this.filter != null && !this.filter.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theSystem = this.getSystem();
        strategy.appendField(locator, (Object)this, "system", buffer, (Object)theSystem, this.system != null);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, (Object)theVersion, this.version != null);
        List<ValueSetConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        strategy.appendField(locator, (Object)this, "concept", buffer, theConcept, this.concept != null && !this.concept.isEmpty());
        List<ValueSetFilter> theFilter = this.filter != null && !this.filter.isEmpty() ? this.getFilter() : null;
        strategy.appendField(locator, (Object)this, "filter", buffer, theFilter, this.filter != null && !this.filter.isEmpty());
        return buffer;
    }

    public void setConcept(List<ValueSetConcept> value) {
        this.concept = value;
    }

    public void setFilter(List<ValueSetFilter> value) {
        this.filter = value;
    }
}

